package cn.gtmap.estateplat.config.service.ztxx;
/*
 * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
 * @version 1.0, 2017/12/11
 * @description 不动产证书证明状态查询服务
 */

import cn.gtmap.estateplat.config.core.model.IdModel;
import cn.gtmap.estateplat.model.server.core.BdcCxZszmZt;
import cn.gtmap.estateplat.model.server.core.BdcZs;

import java.util.List;
import java.util.Map;

public interface BdcCxZszmZtService {

    /**
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @version
     * @return
     * @description 保存证书证明查询表
     */

    void saveBdcCxZszmZt(BdcCxZszmZt bdcCxZszmZt);

    /**
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @param cqzh:产权证号
     * @return
     * @description 根据产权证号查询证书证明
     */

    BdcCxZszmZt getBdcCxZszmZtByCqzh(String cqzh);

    /**
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @param bdcCxZszmZt
     * @return
     * @description 根据产权证号和项目来源更新证书证明状态
     */

    Boolean updateZszmZtByCqzh(BdcCxZszmZt bdcCxZszmZt);

    /**
     * @return 返回信息
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @version
     * @description 初始化不动产的证书数据
     */
    void initBdcZs( List<BdcZs> bdcZsList );

    /**
     * @return 返回信息
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @version
     * @description 初始化过渡证书数据
     */
    void initGdZs(List<Map> gdZsList);

    /**
     * @Author:<a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @param:bdcdyh 不动产单元号
     * @param:bdclx 不动产类型
     * @Description:更新证书证明权属状态为不动产权证书和证明设计
     * @Date 15:46 2017/11/23
     */
    Boolean updateZszmQsztForBdc(BdcCxZszmZt bdcCxZszmZt);

    /**
     * @Author:<a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @param:bdcdyh 不动产单元号
     * @param:bdclx 不动产类型
     * @Description:更新证书证明权属状态为过渡证书和证明设计
     * @Date 15:46 2017/11/23
     */
    Boolean updateZszmQsztForGd(BdcCxZszmZt bdcCxZszmZt);

    /**
     * @Author:<a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @param:bdcdyh 不动产单元号
     * @param:bdclx 不动产类型
     * @Description:更新证书证明权利状态为不动产权证书设计
     * @Date 15:46 2017/11/23
     */
    Boolean updateZszmQlztForBdcqz(BdcCxZszmZt bdcCxZszmZt);

    /**
     * @Author:<a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @param:bdcdyh 不动产单元号
     * @param:bdclx 不动产类型
     * @Description:更新证书证明权利状态为过渡土地证设计
     * @Date 15:46 2017/11/23
     */
    Boolean updateZszmQlztForGdTdz(BdcCxZszmZt bdcCxZszmZt);

    /**
     * @Author:<a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @param:bdcdyh 不动产单元号
     * @param:bdclx 不动产类型
     * @Description:更新证书证明权利状态为过渡房产证设计
     * @Date 15:46 2017/11/23
     */
    Boolean updateZszmQlztForGdFcz(BdcCxZszmZt bdcCxZszmZt);

    /**
    *@Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
    *@param:bdczslist
    *@Description:
    *@Date 10:35 2018/1/2
    */
    Boolean deleteZszmZtByBdcqz(List<BdcZs> bdcZsList);
}
