package cn.gtmap.estateplat.config.service.ztxx.impl;

import cn.gtmap.estateplat.config.core.mapper.config.BdcDbqyMapper;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.model.config.BdcCxBdcdyZt;
import cn.gtmap.estateplat.model.server.core.*;
import com.alibaba.fastjson.JSONObject;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.*;

/**
 * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
 * @version 1.0  2018-06-01.
 * @description
 */
@Service
public class BdcCxBdcdyQlxxDbqyServiceImpl extends BdcCxBdcdyQlxxServiceImpl{

    private static final Logger LOGGER = LoggerFactory.getLogger(BdcCxBdcdyQlxxDbqyServiceImpl.class);

    @Autowired
    private BdcDbqyMapper bdcDbqyMapper;
    @Autowired
    RestTemplate restTemplate;

    static {
        gdQllxList = new ArrayList<String>();
        gdQllxList.add(QLLX_DYA);
        gdQllxList.add(QLLX_CF);
        gdQllxList.add(QLLX_YCF);
        gdQllxList.add(QLLX_YG);
        gdQllxList.add(QLLX_YY);

        bdcQllxList = new ArrayList<String>();
        bdcQllxList.addAll(gdQllxList);
        bdcQllxList.add(QLLX_YDYA);
        bdcQllxList.add(QLLX_DYI);
        bdcQllxList.add(QLLX_SCDJ);
        bdcQllxList.add(QLLX_ZJJZW);
        bdcQllxList.add(QLLX_JZ);
    }

    /**
     * 根据TDID查询 GD_TD
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    private Map<String,Object> queryGdTdByTdid(String tdid){
        Map<String,Object> gdTdMap = null;
        if(StringUtils.isNotBlank(tdid)){
            Map<String,Object> paramMap = new HashMap<String, Object>();
            paramMap.put("tdid",tdid);
            List<Map<String,Object>> gdTdList = bdcDbqyMapper.queryGdTd(paramMap);
            if(CollectionUtils.isNotEmpty(gdTdList)){
                gdTdMap = gdTdList.get(0);
            }
        }
        return gdTdMap;
    }

    /**
     * 东北地区 特殊版本  暂不处理 土地证权利绑定房屋的逻辑
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    @Override
    public void dealGdTdidsBdclxTdfw(String tdid, List<String> bdcdyhList, List<String> tdisList) {}

    /**
     * 根据GDID查询GD_DYH_REL
     * 由于GD_DYH_REL表的地区差异，所以独立这个查询方法
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    @Override
    public List<BdcGdDyhRel> getGdDyhRelListByGdid(String gdid) {
        List<BdcGdDyhRel> bdcGdDyhRelList = new ArrayList<BdcGdDyhRel>();
        if(StringUtils.isNotBlank(gdid)){
            Map<String,Object> paramMap = new HashMap<String, Object>();
            paramMap.put("gdid",gdid);
            bdcGdDyhRelList = bdcDbqyMapper.queryGdDyhRel(paramMap);
        }
        return bdcGdDyhRelList;
    }


    /**
     * 根据BDCDYH 查询 GD_DYH_REL
     * 由于GD_DYH_REL表的地区差异，所以独立这个查询方法
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    @Override
    public List<BdcGdDyhRel> listGdDyhRelByDyh(String bdcdyh) {
        List<BdcGdDyhRel> bdcGdDyhRelList = new ArrayList<BdcGdDyhRel>();
        if(StringUtils.isNotBlank(bdcdyh)){
            Map<String,Object> paramMap = new HashMap<String, Object>();
            paramMap.put("bdcdyh",bdcdyh);
            bdcGdDyhRelList = bdcDbqyMapper.queryGdDyhRel(paramMap);
        }
        return bdcGdDyhRelList;
    }

    /**
     * 转换MAP to 实体
     * 只支持属性全小写的 实体
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    private static <T> T parseMapToObject(Map<String,Object> map, Class<T> clazz){
        Map<String,Object> lowerCaseMap = new HashMap<String, Object>();
        if(MapUtils.isNotEmpty(map)){
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()){
                Map.Entry entry = (Map.Entry) iterator.next();
                lowerCaseMap.put(entry.getKey().toString().toLowerCase(),entry.getValue());
            }
        }
        if(MapUtils.isNotEmpty(lowerCaseMap)){
            String json = JSONObject.toJSONString(lowerCaseMap);
            if(StringUtils.isNotBlank(json)){
                return JSONObject.parseObject(json,clazz);
            }
        }
        return null;
    }


    /**
     * 根据BDCDYH 查询 BDCDY
     * @param
     * @return Map<String,Object> bdcdyMap
     * @throws
     * @author 2018-06-02 lyq
     */
    private Map<String,Object> queryBdcdyByBdcdyh(String bdcdyh){
        Map<String,Object> bdcdyMap = null;
        if(StringUtils.isNotBlank(bdcdyh)){
            Map<String,Object> paramMap = new HashMap<String,Object>();
            paramMap.put("bdcdyh",bdcdyh);
            List<Map<String, Object>> bdcdyList = bdcDbqyMapper.queryBdcdy(paramMap);
            if(CollectionUtils.isNotEmpty(bdcdyList)){
                bdcdyMap = bdcdyList.get(0);
            }
        }
        return bdcdyMap;
    }

    /**
     * 根据Proid 查询 BDC_SPXX实体
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    private Map<String,Object> queryBdcSpxxByProid(String proid){
        Map<String,Object> bdcSpxxMap = null;
        if(StringUtils.isNotBlank(proid)){
            Map<String,Object> paramMap = new HashMap<String,Object>();
            paramMap.put("proid",proid);
            List<Map<String, Object>> bdcSpxxList = bdcDbqyMapper.queryBdcSpxx(paramMap);
            if(CollectionUtils.isNotEmpty(bdcSpxxList)){
                bdcSpxxMap = bdcSpxxList.get(0);
            }
        }
        return bdcSpxxMap;
    }

    /**
     * 根据不动产单元号获取有效的不动产产权证
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    @Override
    public List<Map> getFwSyqByBdcdyh(String bdcdyh) {
        List<Map> mapList = new LinkedList<Map>();
        // 根据BDCDYH 获取 BDCDYID
        Map<String,Object> bdcdyMap = queryBdcdyByBdcdyh(bdcdyh);
        String bdcdyid = MapUtils.getString(bdcdyMap,"BDCDYID");
        if(StringUtils.isNotBlank(bdcdyid)) {
            List<BdcFdcq> bdcFdcqList = bdcFdcqService.getBdcFdcqListByBdcdyid(bdcdyid);
            if (CollectionUtils.isNotEmpty(bdcFdcqList)) {
                for (BdcFdcq bdcFdcq : bdcFdcqList) {
                    Map hashMap = new HashMap();
                    List<BdcQlr> bdcQlrList = bdcQlrService.getBdcQlrListByProidAndQlrlx(bdcFdcq.getProid(), Constants.QLRLX_QLR);
                    String qlrmc = bdcQlrService.combinationQlr(bdcQlrList);
                    Map<String, Object> bdcSpxxMap = queryBdcSpxxByProid(bdcFdcq.getProid());
                    hashMap.put(QLXX_YT, bdcFdcq.getGhyt());
                    hashMap.put(QLXX_MJ, bdcFdcq.getJzmj());
                    hashMap.put(QLXX_SPZL, MapUtils.getString(bdcSpxxMap, "ZL"));
                    hashMap.put(QLXX_XMZL, MapUtils.getString(bdcdyMap, "ZL"));
                    hashMap.put(QLXX_QLR, qlrmc);
                    mapList.add(hashMap);
                }
            } else {
                //如果是多幢
                List<BdcFdcqDz> bdcFdcqDzList = bdcFdcqDzService.getBdcFdcqDzByBdcdyid(bdcdyid);
                if (CollectionUtils.isNotEmpty(bdcFdcqDzList)) {
                    for (BdcFdcqDz bdcFdcqDz : bdcFdcqDzList) {
                        Map hashMap = new HashMap();
                        List<BdcQlr> bdcQlrList = bdcQlrService.getBdcQlrListByProidAndQlrlx(bdcFdcqDz.getProid(), Constants.QLRLX_QLR);
                        String qlrmc = bdcQlrService.combinationQlr(bdcQlrList);
                        Map<String, Object> bdcSpxxMap = queryBdcSpxxByProid(bdcFdcqDz.getProid());
                        hashMap.put(QLXX_YT, MapUtils.getString(bdcSpxxMap, "YT"));
                        hashMap.put(QLXX_MJ, bdcFdcqDz.getFtjzmj());
                        hashMap.put(QLXX_SPZL, MapUtils.getString(bdcSpxxMap, "ZL"));
                        hashMap.put(QLXX_XMZL, MapUtils.getString(bdcdyMap, "ZL"));
                        hashMap.put(QLXX_QLR, qlrmc);
                        mapList.add(hashMap);
                    }
                }
            }
        }
        return mapList;
    }

    /**
     * 根据BDCDYH 查询过度FWSYQ 返回 List<Map>
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    @Override
    public List<Map> getGdFwSyqByBdcdyh(String bdcdyh) {
        List<Map> mapList = new LinkedList<Map>();
        //确认该不动产单元是匹配还是未匹配
        List<BdcGdDyhRel> gdDyhRelList = listGdDyhRelByDyh(bdcdyh);
        if (CollectionUtils.isNotEmpty(gdDyhRelList)) {
            for (BdcGdDyhRel gdDyhRel : gdDyhRelList) {
                if (StringUtils.isNotBlank(gdDyhRel.getGdid())){
                    List<String> gdFwsyqQlidList = getGdFwsyqQlidListByGdid(gdDyhRel.getGdid());
                    if (CollectionUtils.isNotEmpty(gdFwsyqQlidList)) {
                        for (String qlid : gdFwsyqQlidList) {
                            Map hashMap = new HashMap();
                            List<GdQlr> gdQlrList = gdQlrService.getGdQlrListByqlidAndQlrlx(qlid, Constants.QLRLX_QLR);
                            String qlrmc = gdQlrService.combinationQlr(gdQlrList);
                            GdFw gdFw = gdFwService.getGdFwByFwid(gdDyhRel.getGdid());
                            hashMap.put(QLXX_YT, gdFw.getGhyt());
                            hashMap.put(QLXX_MJ, gdFw.getJzmj());
                            hashMap.put(QLXX_SPZL, gdFw.getFwzl());
                            hashMap.put(QLXX_XMZL, gdFw.getFwzl());
                            hashMap.put(QLXX_QLR, qlrmc);
                            mapList.add(hashMap);
                        }
                    }
                }
            }
        } else {
            //未匹配通过fcdah获取相关所有权信息
            // TODO 需要 GD_FW 与  DJSJ_FWHS 的 fcdah dah一致
            List<GdFw> gdFws = gdFwService.getGdFwBybdcdyh(bdcdyh);
            if (CollectionUtils.isNotEmpty(gdFws)) {
                for (GdFw gdFw : gdFws) {
                    List<GdFwsyq> gdFwsyqList = queryFwsyqByFwid(gdFw.getFwid());
                    if (CollectionUtils.isNotEmpty(gdFwsyqList)) {
                        for (GdFwsyq gdfwsyq : gdFwsyqList) {
                            Map hashMap = new HashMap();
                            List<GdQlr> gdQlrList = gdQlrService.getGdQlrListByqlidAndQlrlx(gdfwsyq.getQlid(), Constants.QLRLX_QLR);
                            String qlrmc = gdQlrService.combinationQlr(gdQlrList);
                            hashMap.put(QLXX_YT, gdFw.getGhyt());
                            hashMap.put(QLXX_MJ, gdFw.getJzmj());
                            hashMap.put(QLXX_SPZL, gdFw.getFwzl());
                            hashMap.put(QLXX_XMZL, gdFw.getFwzl());
                            hashMap.put(QLXX_QLR, qlrmc);
                            mapList.add(hashMap);
                        }
                    }
                }
            }
        }
        return mapList;
    }


    /**
     * 根据不动产单元号获取有效的过渡土地产权证
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    @Override
    public List<Map> getGdTdSyqByBdcdyh(String bdcdyh) {
        List<Map> mapList = new LinkedList<Map>();
        //确认该不动产单元是匹配还是未匹配
        List<BdcGdDyhRel> gdDyhRelList = listGdDyhRelByDyh(bdcdyh);
        if (CollectionUtils.isNotEmpty(gdDyhRelList)) {
            for (BdcGdDyhRel gdDyhRel : gdDyhRelList) {
                List<GdTdsyq> gdTdsyqList = queryTdsyqByTdid(gdDyhRel.getGdid());
                //过滤取有效的过渡土地所有权的qlid
                List<String> qlidList = new LinkedList<String>();
                if (CollectionUtils.isNotEmpty(gdTdsyqList)) {
                    for (GdTdsyq gdTdsyq : gdTdsyqList) {
                        if (StringUtils.isNotBlank(gdTdsyq.getIszx().toString()) && gdTdsyq.getIszx() != 1) {
                            qlidList.add(gdTdsyq.getQlid());
                        }
                    }
                }

                if (CollectionUtils.isNotEmpty(qlidList)) {
                    for (String qlid : qlidList) {
                        Map hashMap = new HashMap();
                        List<GdQlr> gdQlrList = gdQlrService.getGdQlrListByqlidAndQlrlx(qlid, Constants.QLRLX_QLR);
                        String qlrmc = gdQlrService.combinationQlr(gdQlrList);
                        Map<String,Object> gdTdMap = queryGdTdByTdid(gdDyhRel.getGdid());
                        hashMap.put(QLXX_YT, MapUtils.getString(gdTdMap,"YT"));
                        hashMap.put(QLXX_MJ, MapUtils.getString(gdTdMap,"JZMJ"));
                        hashMap.put(QLXX_SPZL, MapUtils.getString(gdTdMap,"ZL"));
                        hashMap.put(QLXX_XMZL, MapUtils.getString(gdTdMap,"ZL"));
                        hashMap.put(QLXX_QLR, qlrmc);
                        mapList.add(hashMap);
                    }
                }
            }
        }
        return mapList;
    }

    /**
     * 根据不动产单元号获取有效的不动产土地产权证
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    @Override
    public List<Map> getTdSyqByBdcdyh(String bdcdyh) {
        List<Map> mapList = new LinkedList<Map>();
        // 根据BDCDYH 获取 BDCDYID
        Map<String,Object> bdcdyMap = queryBdcdyByBdcdyh(bdcdyh);
        String bdcdyid = MapUtils.getString(bdcdyMap,"BDCDYID");
        if (StringUtils.isNotBlank(bdcdyid)) {
            List<String> proidList = bdcTdService.getProidListByBdcdyid(bdcdyid);
            if (CollectionUtils.isNotEmpty(proidList)) {
                for (String proid : proidList) {
                    Map hashMap = new HashMap();
                    List<BdcQlr> bdcQlrList = bdcQlrService.getBdcQlrListByProidAndQlrlx(proid, Constants.QLRLX_QLR);
                    String qlrmc = bdcQlrService.combinationQlr(bdcQlrList);
                    BdcSpxx bdcSpxx = bdcSpxxService.getBdcSpxxByProid(proid);
                    hashMap.put(QLXX_YT, bdcSpxx.getZdzhyt());
                    hashMap.put(QLXX_MJ, bdcSpxx.getZdzhmj());
                    hashMap.put(QLXX_SPZL, bdcSpxx.getZl());
                    hashMap.put(QLXX_XMZL, MapUtils.getString(bdcdyMap,"ZL"));
                    hashMap.put(QLXX_QLR, qlrmc);
                    mapList.add(hashMap);
                }
            }
        }
        return mapList;
    }


    /**
     * 根据BDCDYH查BDC权利  或者 根据BDCID查询GD权利，计算权利数量，保存进qlslMap
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    @Override
    public void putQlslMap(String bdcdyh,String bdcid,Map<String,Integer> qlslMap){
        for(String key : qlslMap.keySet()){
            // 预告
            if(StringUtils.equals(QLLX_YG,key)){
                if(StringUtils.isNotBlank(bdcdyh)){
                    qlslMap.put(key, qlslMap.get(key) + bdcCxBdcdyZtMapper.getBdcYgQlByBdcdyh(bdcdyh));
                }else if(StringUtils.isNotBlank(bdcid)){
                    qlslMap.put(key,qlslMap.get(key) + getGdYgQlByBdcid(bdcid));
                }
            }
            // 抵押
            if(StringUtils.equals(QLLX_DYA,key)){
                if(StringUtils.isNotBlank(bdcdyh)){
                    qlslMap.put(key, qlslMap.get(key) + bdcCxBdcdyZtMapper.getBdcDyaQlByBdcdyh(bdcdyh));
                }else if(StringUtils.isNotBlank(bdcid)){
                    qlslMap.put(key, qlslMap.get(key) + getGdDyaQlByBdcid(bdcid));
                }
            }
            // 异议
            if(StringUtils.equals(QLLX_YY,key)){
                if(StringUtils.isNotBlank(bdcdyh)){
                    qlslMap.put(key, qlslMap.get(key) + bdcCxBdcdyZtMapper.getBdcYyQlByBdcdyh(bdcdyh));
                }else if(StringUtils.isNotBlank(bdcid)){
                    qlslMap.put(key,qlslMap.get(key) + getGdYyQlByBdcid(bdcid));
                }
            }
            // 查封
            if(StringUtils.equals(QLLX_CF,key)){
                if(StringUtils.isNotBlank(bdcdyh)){
                    qlslMap.put(key, qlslMap.get(key) + bdcCxBdcdyZtMapper.getBdcCfQlBybdcdyh(bdcdyh));
                }else if(StringUtils.isNotBlank(bdcid)){
                    qlslMap.put(key,qlslMap.get(key) + getGdCfQlByBdcid(bdcid));
                }
            }
            // 预查封
            if(StringUtils.equals(QLLX_YCF,key)){
                if(StringUtils.isNotBlank(bdcdyh)){
                    qlslMap.put(key, qlslMap.get(key) + bdcCxBdcdyZtMapper.getBdcYcfQlByBdcdyh(bdcdyh));
                }else if(StringUtils.isNotBlank(bdcid)){
                    qlslMap.put(key,qlslMap.get(key) + getGdYCfQlByBdcid(bdcid));
                }
            }
            // 锁定
            if(StringUtils.equals(QLLX_SD,key) && StringUtils.isNotBlank(bdcdyh)){
                qlslMap.put(key, qlslMap.get(key) + bdcCxBdcdyZtMapper.getBdcSdQlByBdcdyh(bdcdyh));
            }
            // 预抵押
            if(StringUtils.equals(QLLX_YDYA,key) && StringUtils.isNotBlank(bdcdyh)){
                qlslMap.put(key, qlslMap.get(key) + bdcCxBdcdyZtMapper.getBdcYdyaQlByBdcdyh(bdcdyh));
            }
            // 在建建筑物
            if(StringUtils.equals(QLLX_ZJJZW,key) && StringUtils.isNotBlank(bdcdyh)){
                qlslMap.put(key, qlslMap.get(key) + bdcCxBdcdyZtMapper.getBdcZjjzwQlByBdcdyh(bdcdyh));
            }
            // 地役
            if(StringUtils.equals(QLLX_DYI,key) && StringUtils.isNotBlank(bdcdyh)){
                qlslMap.put(key, qlslMap.get(key) + bdcCxBdcdyZtMapper.getBdcDyQlByBdcdyh(bdcdyh));
            }
        }
    }

    /**
     * 根据BDCDYH 截取 DJH 查询 GD_TD
     * @param changeNew true 重新查询一下新DJH（原有逻辑） 东北地区没有此逻辑
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    @Override
    public GdTd queryGdTdByBdcdyh(String bdcdyh,boolean changeNew) {
        GdTd gdTd = null;
        String djh = StringUtils.substring(bdcdyh, 0, 19);
        Map<String,Object> gdTdMap;
        if(StringUtils.isNotBlank(djh)){
            Map<String,Object> paramMap = new HashMap<String, Object>();
            paramMap.put("djh",djh);
            List<Map<String,Object>> gdTdList = bdcDbqyMapper.queryGdTd(paramMap);
            if(CollectionUtils.isNotEmpty(gdTdList)){
                gdTdMap = gdTdList.get(0);
                if(MapUtils.isNotEmpty(gdTdMap)){
                    gdTd = parseMapToObject(gdTdMap,GdTd.class);
                }
            }
        }
        return gdTd;
    }

    /**
     * 更新BDCDY ZT
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    @Override
    public void updateBdcdyZt(Map map) {
        try {
            if (null != map && null != map.get("BDCDYH")) {
                String bdcdyh = map.get("BDCDYH").toString();
                String bdclx = map.get("BDCLX").toString();
                BdcCxBdcdyZt bdcCxBdcdyZt = new BdcCxBdcdyZt();
                bdcCxBdcdyZt.setBdcdyh(bdcdyh);
                bdcCxBdcdyZt.setBdclx(bdclx);
                bdcCxBdcdyZt.setBdcdyzt("1");
                bdcCxBdcdyZt.setDjzt("1");
                bdcCxBdcdyZt.setLy("xs");
                // set 权利数量
                this.initQlslToBdcdyzt(map, bdcCxBdcdyZt);
                //set 现势权利信息
                initSyqToBdcdyzt(bdcdyh,bdclx,bdcCxBdcdyZt);

                // 判断更新还是插入操作
                BdcCxBdcdyZt newBdcCxBdcdyZt = bdcCxBdcdyZtMapper.getBdcCxBdcdyZtByBdcdy(bdcdyh);
                BdcCxBdcdyZt bdcCxBdcdyZttemp = djsjCxBdcdyZtMapper.getXsZtByBdcdyh(bdcdyh);
                LOGGER.info("更新前S_SJ_BDCDYHXSZT表数据：{}，请求时间：{}", newBdcCxBdcdyZt, new Date());
                if (null == newBdcCxBdcdyZt) {
                    if (null == bdcCxBdcdyZttemp){
                        djsjCxBdcdyZtMapper.insertXsZt(bdcCxBdcdyZt);
                    }else {
                        djsjCxBdcdyZtMapper.updateXsZt(bdcCxBdcdyZt);
                    }
                    LOGGER.info("更新后S_SJ_BDCDYHXSZT表数据：{}，请求时间：{}", bdcCxBdcdyZt, new Date());
                } else {
                    BeanUtils.copyProperties(bdcCxBdcdyZt,newBdcCxBdcdyZt);
                    djsjCxBdcdyZtMapper.updateXsZt(newBdcCxBdcdyZt);
                    LOGGER.info("更新后S_SJ_BDCDYHXSZT表数据：{}，请求时间：{}", newBdcCxBdcdyZt, new Date());
                }
            }
        } catch (Exception e) {
            LOGGER.error(Constants.ERROR_IN_FUNCTION, e);
        }
    }

    /**
     * 查询所有权信息（权利人、面积、用途等） 保存进 BdcCxBdcdyZt 实体
     *
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    protected void initSyqToBdcdyzt(String bdcdyh, String bdclx, BdcCxBdcdyZt bdcCxBdcdyZt) {
        // 使用bdcdyh 和 BDCLX 查询所有权信息
        Map syqMap = getBdcdySyq(bdcdyh, bdclx);
        if (MapUtils.isNotEmpty(syqMap)) {
            bdcCxBdcdyZt.setQlr(MapUtils.getString(syqMap, QLXX_QLR));
            bdcCxBdcdyZt.setYt(MapUtils.getString(syqMap, QLXX_YT));
            bdcCxBdcdyZt.setMj(MapUtils.getDouble(syqMap, QLXX_MJ));
            bdcCxBdcdyZt.setZl(MapUtils.getString(syqMap, QLXX_SPZL));
            if (StringUtils.isBlank(bdcCxBdcdyZt.getZl())) {
                bdcCxBdcdyZt.setZl(MapUtils.getString(syqMap, QLXX_XMZL));
            }
        }
    }

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param: * @param bdcdyh bdclx
     * @Description:通过不动产单元获取现势所有权信息
     * @Date 9:46 2017/11/30
     */
    private Map getBdcdySyq(String bdcdyh, String bdclx) {
        Map mapSyq = new HashMap();
        try {
            if (StringUtils.isNotBlank(bdcdyh) && StringUtils.isNotBlank(bdclx)) {
                if (bdclx.equals("TDFW")) {
                    List<Map> mapSyqList = getFwSyqByBdcdyh(bdcdyh);
                    //取不动产现势房屋所有权
                    if (CollectionUtils.isNotEmpty(mapSyqList)) {
                        mapSyq = mapSyqList.get(0);
                    } else {
                        //取过渡现势房屋所有权
                        mapSyqList = getGdFwSyqByBdcdyh(bdcdyh);
                    }
                    if (CollectionUtils.isNotEmpty(mapSyqList)) {
                        mapSyq = mapSyqList.get(0);
                    }
                }
                if (bdclx.equals("TD")) {
                    List<Map> mapSyqList = getTdSyqByBdcdyh(bdcdyh);
                    //取不动产现势土地所有权
                    if (CollectionUtils.isNotEmpty(mapSyqList)) {
                        mapSyq = mapSyqList.get(0);
                    } else {
                        //取过渡现势土地所有权
                        mapSyqList = getGdTdSyqByBdcdyh(bdcdyh);
                    }
                    if (CollectionUtils.isNotEmpty(mapSyqList)) {
                        mapSyq = mapSyqList.get(0);
                    }
                }
                //..待加入草权、林权等类型获取所有权
            }
        } catch (Exception e) {
            LoggerFactory.getLogger(getClass()).error(Constants.ERROR_IN_FUNCTION, e);
        }
        return mapSyq;
    }


    /**
     * 将查询后的权利数量 保存进 BdcCxBdcdyZt 实体
     *
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    protected void initQlslToBdcdyzt(Map qlslMap, BdcCxBdcdyZt bdcCxBdcdyZt) {
        String bdcdjUrl = AppConfig.getProperty("bdcdj.url");
        if (StringUtils.isNoneBlank(bdcdjUrl, MapUtils.getString(qlslMap, "BDCDYH"))) {
            String bdcdyh = MapUtils.getString(qlslMap, "BDCDYH");
            try {
                JSONObject resultObj = restTemplate.getForObject(bdcdjUrl + "/rest/bdcdyXzql/" + bdcdyh + "?queryZdxx=false", JSONObject.class);
                if (resultObj != null) {
                    int ygcs = 0, dyacs = 0, cfcs = 0, yycs = 0, zjgcdycs = 0, ydyacs = 0, ycfcs = 0, sdcs = 0, dyics = 0;
                    if (CollectionUtils.isNotEmpty(resultObj.getJSONArray("bdcCfList"))) {
                        cfcs = cfcs + resultObj.getJSONArray("bdcCfList").size();
                    }
                    if (CollectionUtils.isNotEmpty(resultObj.getJSONArray("gdCfList"))) {
                        cfcs = cfcs + resultObj.getJSONArray("gdCfList").size();
                    }
                    if (CollectionUtils.isNotEmpty(resultObj.getJSONArray("bdcDyaqList"))) {
                        dyacs = dyacs + resultObj.getJSONArray("bdcDyaqList").size();
                        for (Object obj : resultObj.getJSONArray("bdcDyaqList")) {
                            if (obj != null && ((JSONObject) obj).get("sfzjgcdy") != null
                                    && StringUtils.equals(((JSONObject) obj).get("sfzjgcdy").toString(), "true")) {
                                zjgcdycs = zjgcdycs + 1;
                            }
                        }
                    }
                    if (CollectionUtils.isNotEmpty(resultObj.getJSONArray("gdDyList"))) {
                        dyacs = dyacs + resultObj.getJSONArray("gdDyList").size();
                    }
                    if (CollectionUtils.isNotEmpty(resultObj.getJSONArray("bdcYyList"))) {
                        yycs = yycs + resultObj.getJSONArray("bdcYyList").size();
                    }
                    if (CollectionUtils.isNotEmpty(resultObj.getJSONArray("gdYyList"))) {
                        yycs = yycs + resultObj.getJSONArray("gdYyList").size();
                    }
                    if (CollectionUtils.isNotEmpty(resultObj.getJSONArray("bdcYgList"))) {
                        for (Object obj : resultObj.getJSONArray("bdcYgList")) {
                            JSONObject bdcyg = (JSONObject) obj;
                            if (bdcyg != null && ArrayUtils.contains(new String[]{"3", "4"}, MapUtils.getString(bdcyg, "ygdjzl"))) {
                                ydyacs = ydyacs + 1;
                            }
                            ygcs = ygcs + 1;
                        }
                    }
                    if (CollectionUtils.isNotEmpty(resultObj.getJSONArray("gdYgList"))) {
                        for (Object obj : resultObj.getJSONArray("gdYgList")) {
                            JSONObject bdcyg = (JSONObject) obj;
                            if (bdcyg != null && ArrayUtils.contains(new String[]{"3", "4"}, MapUtils.getString(bdcyg, "ygdjzl"))) {
                                ydyacs = ydyacs + 1;
                            } else {
                                ygcs = ygcs + 1;
                            }
                        }
                    }
                    if (CollectionUtils.isNotEmpty(resultObj.getJSONArray("bdcDyiList"))) {
                        dyics = dyics + resultObj.getJSONArray("bdcDyiList").size();
                    }
                    if (CollectionUtils.isNotEmpty(resultObj.getJSONArray("bdcDjList"))) {
                        sdcs = sdcs + resultObj.getJSONArray("bdcDjList").size();
                    }
                    bdcCxBdcdyZt.setXsygcs(ygcs);
                    bdcCxBdcdyZt.setXsdyacs(dyacs);
                    bdcCxBdcdyZt.setXscfcs(cfcs);
                    bdcCxBdcdyZt.setXsyycs(yycs);
                    bdcCxBdcdyZt.setXszjgcdycs(zjgcdycs);
                    bdcCxBdcdyZt.setXsydyacs(ydyacs);
                    bdcCxBdcdyZt.setXsycfcs(ycfcs);
                    bdcCxBdcdyZt.setXssdcs(sdcs);
                    bdcCxBdcdyZt.setXsdyics(dyics);
                }
            } catch (Exception e) {
                LoggerFactory.getLogger(getClass()).error(Constants.ERROR_IN_FUNCTION, e);
            }
        }
    }

    /**
     * 根据BDCID 查询GD_YG 权利数量
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    private Integer getGdYgQlByBdcid(String bdcid){
        if(StringUtils.isNotBlank(bdcid)){
            return bdcDbqyMapper.getGdYgQlByBdcid(bdcid);
        }
        return 0;
    }

    /**
     * 根据BDCID 查询GD_DY 权利数量
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    private Integer getGdDyaQlByBdcid(String bdcid){
        if(StringUtils.isNotBlank(bdcid)){
            return bdcDbqyMapper.getGdDyaQlByBdcid(bdcid);
        }
        return 0;
    }

    /**
     * 根据BDCID 查询GD_YY 权利数量
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    private Integer getGdYyQlByBdcid(String bdcid){
        if(StringUtils.isNotBlank(bdcid)){
            return bdcDbqyMapper.getGdYyQlByBdcid(bdcid);
        }
        return 0;
    }

    /**
     * 根据BDCID 查询GD_CF 权利数量
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    private Integer getGdCfQlByBdcid(String bdcid){
        if(StringUtils.isNotBlank(bdcid)){
            return bdcDbqyMapper.getGdCfQlByBdcid(bdcid);
        }
        return 0;
    }

    /**
     * 根据BDCID 查询GD_YCF 权利数量
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    private Integer getGdYCfQlByBdcid(String bdcid){
        if(StringUtils.isNotBlank(bdcid)){
            return bdcDbqyMapper.getGdYCfQlByBdcid(bdcid);
        }
        return 0;
    }


    /**
     * 根据TDID 查询GDTDSYQ
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    private List<GdTdsyq> queryTdsyqByTdid(String tdid){
        List<GdTdsyq> gdTdsyqList = null;
        if (StringUtils.isNotBlank(tdid)) {
            HashMap hashMap = new HashMap();
            hashMap.put("tdid", tdid);
            gdTdsyqList = bdcDbqyMapper.queryGdTdsyq(hashMap);
        }
        return gdTdsyqList;
    }

    /**
     * 根据FWID 查询GDFWSYQ
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    private List<GdFwsyq> queryFwsyqByFwid(String fwid) {
        List<GdFwsyq> gdFwsyqList = null;
        if (StringUtils.isNotBlank(fwid)) {
            HashMap hashMap = new HashMap();
            hashMap.put("fwid", fwid);
            gdFwsyqList = bdcDbqyMapper.queryGdFwsyq(hashMap);
        }
        return gdFwsyqList;
    }

    /**
     * 根据GDID 查询 GD_FWSYQ  的QLID LIST
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    private List<String> getGdFwsyqQlidListByGdid(String gdid) {
        return bdcDbqyMapper.getGdFwsyqQlidListByGdid(gdid);
    }
}