package cn.gtmap.estateplat.config.service.ztxx.impl;

import cn.gtmap.estateplat.config.core.mapper.config.BdcCxBdcdyZtMapper;
import cn.gtmap.estateplat.config.core.mapper.sjgl.DjsjCxBdcdyZtMapper;
import cn.gtmap.estateplat.config.core.service.*;
import cn.gtmap.estateplat.config.service.ztxx.BdcCxBdcdyQlxxService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.config.utils.SysVersions;
import cn.gtmap.estateplat.model.config.BdcCxBdcdyZt;
import cn.gtmap.estateplat.model.server.core.*;
import com.alibaba.fastjson.JSON;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
 * @version 1.0  2018-06-01.
 * @description
 */
@Service
public class BdcCxBdcdyQlxxServiceImpl implements BdcCxBdcdyQlxxService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private GdTdService gdTdService;
    @Autowired
    private BdcGdDyhRelService bdcGdDyhRelService;
    @Autowired
    BdcCxBdcdyZtMapper bdcCxBdcdyZtMapper;
    @Autowired
    DjsjCxBdcdyZtMapper djsjCxBdcdyZtMapper;
    @Autowired
    BdcdyService bdcdyService;
    @Autowired
    BdcFdcqService bdcFdcqService;
    @Autowired
    BdcSpxxService bdcSpxxService;
    @Autowired
    BdcFdcqDzService bdcFdcqDzService;
    @Autowired
    BdcQlrService bdcQlrService;
    @Autowired
    BdcXmService bdcXmService;
    @Autowired
    BdcTdService bdcTdService;
    @Autowired
    GdFwService gdFwService;
    @Autowired
    GdQlrService gdQlrService;
    @Autowired
    BdcZsService bdcZsService;
    protected static final String QLLX_DYA = "DYA";
    protected static final String QLLX_CF = "CF";
    protected static final String QLLX_YCF = "YCF";
    protected static final String QLLX_YG = "YG";
    protected static final String QLLX_YY = "YY";
    protected static final String QLLX_SD = "SD";
    protected static final String QLLX_JZ= "JZ";
    protected static final String QLLX_YDYA = "YDYA";
    protected static final String QLLX_ZJJZW = "ZJJZW";
    protected static final String QLLX_DYI = "DYI";
    protected static final String QLLX_SCDJ = "SCDJ";
    protected static final String QLXX_QLR = "qlr";
    protected static final String QLXX_YT = "yt";
    protected static final String QLXX_MJ = "mj";
    protected static final String QLXX_SPZL = "spzl";
    protected static final String QLXX_XMZL = "xmzl";
    protected static final String QLXX_BDCQZH = "bdcqzh";
    protected static final String QLXX_DJZT = "djzt";
    protected static List<String> bdcQllxList;
    protected static List<String> gdQllxList;

    static {
        gdQllxList = new ArrayList<String>();
        gdQllxList.add(QLLX_DYA);
        gdQllxList.add(QLLX_CF);
        gdQllxList.add(QLLX_YCF);
        gdQllxList.add(QLLX_YG);
        gdQllxList.add(QLLX_YY);
        gdQllxList.add(QLLX_SD);

        bdcQllxList = new ArrayList<String>();
        bdcQllxList.addAll(gdQllxList);
        bdcQllxList.add(QLLX_YDYA);
        bdcQllxList.add(QLLX_ZJJZW);
        bdcQllxList.add(QLLX_SCDJ);
        bdcQllxList.add(QLLX_DYI);
        bdcQllxList.add(QLLX_JZ);
    }

    /**
     * 根据BDCDYH 截取 DJH 查询 GD_TD
     *
     * @param changeNew true 重新查询一下新DJH（原有逻辑）
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    @Override
    public GdTd queryGdTdByBdcdyh(String bdcdyh, boolean changeNew) {
        String djh = StringUtils.substring(bdcdyh, 0, 19);
        /*if(changeNew){
            String newDjh = dhDzhMapper.getNewDhByOldDh(djh);
            if (StringUtils.isNotBlank(newDjh)) {
                djh = newDjh;
            }
        }*/
        return gdTdService.getGdTdByDjh(djh);
    }


    /**
     * 不动产类型为TDFW 时 如果配置需要将土地证状态匹配在房屋上，则处理过度土地数据
     *
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    @Override
    public void dealGdTdidsBdclxTdfw(String tdid, List<String> bdcdyhList, List<String> tdisList) {
        String bdcdyh = "";
        if (CollectionUtils.isNotEmpty(bdcdyhList)) {
            bdcdyh = bdcdyhList.get(0);
        }
        //jyl土地证的权利要关联在房屋上
        if (StringUtils.isBlank(tdid) && StringUtils.isNotBlank(bdcdyh)) {
            GdTd gdTd = queryGdTdByBdcdyh(bdcdyh, true);
            if (gdTd != null && StringUtils.isNotBlank(gdTd.getTdid())) {
                tdid = gdTd.getTdid();
            }
        }
        if (StringUtils.isNotBlank(tdid)) {
            List<GdTdsyq> gdTdsyqList = gdTdService.queryTdsyqByTdid(tdid);
            if (CollectionUtils.isNotEmpty(gdTdsyqList)) {
                // 大证的权利是否要关联到房屋上
                boolean dtdzOnFwFlag = AppConfig.getBooleanProperty("dtdzOnFw", false);
                // 是否分割完,0不是,1是
                boolean sffgw = !StringUtils.equals(gdTdsyqList.get(0).getSffgw(), "0");
                // 如果 大土地证需要关联房屋 或者 已经分割完
                // 获取土地匹配的BDCDYH set BdcdyhList
                // 将tdid  set tdisList
                if (dtdzOnFwFlag || sffgw) {
                    listBdcdyhByTdid(bdcdyhList, tdid);
                    if (!tdisList.contains(tdid)) {
                        tdisList.add(tdid);
                    }
                }
            }
        }
    }

    /**
     * 根据TDID 查询 匹配的BDCDYH 存入 bdcdyhList
     *
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    private void listBdcdyhByTdid(List<String> bdcdyhList, String tdid) {
        //jyl 找到所匹配的土地还要考虑他是不是存在不动产的权利，所以还要找到他匹配的不动产单元号
        List<BdcGdDyhRel> tdGdDyhRels = getGdDyhRelListByGdid(tdid);
        if (CollectionUtils.isNotEmpty(tdGdDyhRels)) {
            for (BdcGdDyhRel tdGdDyhRel : tdGdDyhRels) {
                if (StringUtils.isNotBlank(tdGdDyhRel.getBdcdyh()) && !bdcdyhList.contains(tdGdDyhRel.getBdcdyh())) {
                    //jyl 相关bdcdyh归类
                    bdcdyhList.add(tdGdDyhRel.getBdcdyh());
                }
            }
        }
    }

    /**
     * 根据BDCDYH 查询 GD_DYH_REL
     * 由于GD_DYH_REL表的地区差异，所以独立这个查询方法
     *
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    @Override
    public List<BdcGdDyhRel> listGdDyhRelByDyh(String bdcdyh) {
        return bdcGdDyhRelService.listGdDyhRelByDyh(bdcdyh);
    }

    /**
     * 根据GDID查询GD_DYH_REL
     * 由于GD_DYH_REL表的地区差异，所以独立这个查询方法
     *
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    @Override
    public List<BdcGdDyhRel> getGdDyhRelListByGdid(String gdid) {
        return bdcGdDyhRelService.getGdDyhRelListByGdid(gdid);
    }


    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param:fwidList
     * @Description:根据fwidList或tdidList查找过渡库各现势权利
     * @Date 8:59 2017/12/6
     */
    @Override
    public Map queryGdQlByBdcid(List<String> bdcidList) {
        Map<String, Integer> qlslMap = createEmptyQlMap(true);
        try {
            if (CollectionUtils.isNotEmpty(bdcidList)) {
                for (String bdcid : bdcidList) {
                    putQlslMap("", bdcid, qlslMap);
                }
            }
        } catch (Exception e) {
            LoggerFactory.getLogger(getClass()).error(Constants.ERROR_IN_FUNCTION, e);
        }
        return qlslMap;
    }

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param:map
     * @Description:插入不动产单元状态表
     * @Date 16:42 2017/11/29
     */
    @Override
    public void updateBdcdyZt(Map map) {
        try {
            if (null != map && null != map.get("BDCDYH")) {
                String bdcdyh = map.get("BDCDYH").toString();
                String bdclx = map.get("BDCLX").toString();
                BdcCxBdcdyZt bdcCxBdcdyZt = bdcCxBdcdyZtMapper.getBdcCxBdcdyZtByBdcdy(bdcdyh);
                //hzj 考虑新增数据处理
                if (null == bdcCxBdcdyZt) {
                    bdcCxBdcdyZt = new BdcCxBdcdyZt();
                }
                bdcCxBdcdyZt.setBdcdyh(bdcdyh);
                bdcCxBdcdyZt.setBdclx(bdclx);
                bdcCxBdcdyZt.setLy("xs");
                bdcCxBdcdyZt.setBdcdyzt("1");
                bdcCxBdcdyZt.setDjzt("1");
                // set 权利数量
                initQlslToBdcdyzt(map, bdcCxBdcdyZt);
                //set 现势权利信息
                initSyqToBdcdyzt(bdcdyh, bdclx, bdcCxBdcdyZt);

                // 判断数据是哪张表并更新
                if (StringUtils.equals(bdcCxBdcdyZt.getLy(), "xs")) {
                    BdcCxBdcdyZt newBdcCxBdcdyZt = bdcCxBdcdyZtMapper.getBdcCxBdcdyZtByBdcdy(bdcdyh);
                    BdcCxBdcdyZt bdcCxBdcdyZttemp = djsjCxBdcdyZtMapper.getXsZtByBdcdyh(bdcdyh);
                    logger.info("更新前S_SJ_BDCDYHXSZT表数据：{}，请求时间：{}", newBdcCxBdcdyZt, new Date());
                    if (null == newBdcCxBdcdyZt) {
                        if (null == bdcCxBdcdyZttemp) {
                            djsjCxBdcdyZtMapper.insertXsZt(bdcCxBdcdyZt);
                        } else {
                            djsjCxBdcdyZtMapper.updateXsZt(bdcCxBdcdyZt);
                        }
                        logger.info("更新后S_SJ_BDCDYHXSZT表数据：{}，请求时间：{}", bdcCxBdcdyZt, new Date());
                    } else {
                        BeanUtils.copyProperties(bdcCxBdcdyZt, newBdcCxBdcdyZt);
                        djsjCxBdcdyZtMapper.updateXsZt(newBdcCxBdcdyZt);
                        logger.info("更新后S_SJ_BDCDYHXSZT表数据：{}，请求时间：{}", newBdcCxBdcdyZt, new Date());
                    }
                } else {
                    djsjCxBdcdyZtMapper.updateLsZt(bdcCxBdcdyZt);
                    logger.info("更新后S_SJ_BDCDYHLSZT表数据：{}，请求时间：{}", bdcCxBdcdyZt, new Date());
                }
            }
        } catch (Exception e) {
            LoggerFactory.getLogger(getClass()).error(Constants.ERROR_IN_FUNCTION, e);
        }
    }


    /**
     * 将查询后的权利数量 保存进 BdcCxBdcdyZt 实体
     *
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    protected void initQlslToBdcdyzt(Map qlslMap, BdcCxBdcdyZt bdcCxBdcdyZt) {
        bdcCxBdcdyZt.setScdjzt(MapUtils.getInteger(qlslMap, QLLX_SCDJ));
        bdcCxBdcdyZt.setXsygcs(MapUtils.getInteger(qlslMap, QLLX_YG));
        bdcCxBdcdyZt.setXsdyacs(MapUtils.getInteger(qlslMap, QLLX_DYA));
        bdcCxBdcdyZt.setXscfcs(MapUtils.getInteger(qlslMap, QLLX_CF));
        bdcCxBdcdyZt.setXsyycs(MapUtils.getInteger(qlslMap, QLLX_YY));
        bdcCxBdcdyZt.setXszjgcdycs(MapUtils.getInteger(qlslMap, QLLX_ZJJZW));
        bdcCxBdcdyZt.setXsydyacs(MapUtils.getInteger(qlslMap, QLLX_YDYA));
        bdcCxBdcdyZt.setXsycfcs(MapUtils.getInteger(qlslMap, QLLX_YCF));
        bdcCxBdcdyZt.setXssdcs(MapUtils.getInteger(qlslMap, QLLX_SD));
        bdcCxBdcdyZt.setXsdyics(MapUtils.getInteger(qlslMap, QLLX_DYI));
        bdcCxBdcdyZt.setXsjzcs(MapUtils.getInteger(qlslMap, QLLX_JZ));
    }

    /**
     * 查询所有权信息（权利人、面积、用途等） 保存进 BdcCxBdcdyZt 实体
     *
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    protected void initSyqToBdcdyzt(String bdcdyh, String bdclx, BdcCxBdcdyZt bdcCxBdcdyZt) {
        // 使用bdcdyh 和 BDCLX 查询所有权信息
        Map syqMap = getBdcdySyq(bdcdyh, bdclx);
        if (MapUtils.isNotEmpty(syqMap)) {
            bdcCxBdcdyZt.setQlr(MapUtils.getString(syqMap, QLXX_QLR));
            bdcCxBdcdyZt.setYt(MapUtils.getString(syqMap, QLXX_YT));
            bdcCxBdcdyZt.setMj(MapUtils.getDouble(syqMap, QLXX_MJ));
            bdcCxBdcdyZt.setZl(MapUtils.getString(syqMap, QLXX_SPZL));
            if (StringUtils.isBlank(bdcCxBdcdyZt.getZl())) {
                bdcCxBdcdyZt.setZl(MapUtils.getString(syqMap, QLXX_XMZL));
            }
            bdcCxBdcdyZt.setBdcqzh(MapUtils.getString(syqMap, QLXX_BDCQZH));
            if(SysVersions.isKuandian()){
                bdcCxBdcdyZt.setDjzt(MapUtils.getString(syqMap, QLXX_DJZT));
            }
        }
    }

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param: * @param bdcdyh bdclx
     * @Description:通过不动产单元获取现势所有权信息
     * @Date 9:46 2017/11/30
     */
    private Map getBdcdySyq(String bdcdyh, String bdclx) {
        Map mapSyq = new HashMap();
        try {
            if (StringUtils.isNotBlank(bdcdyh) && StringUtils.isNotBlank(bdclx)) {
                if (bdclx.equals("TDFW")) {
                    List<Map> mapSyqList = getFwSyqByBdcdyh(bdcdyh);
                    //取不动产现势房屋所有权
                    if (CollectionUtils.isNotEmpty(mapSyqList)) {
                        mapSyq = mapSyqList.get(0);
                    } else {
                        //取过渡现势房屋所有权
                        mapSyqList = getGdFwSyqByBdcdyh(bdcdyh);
                    }
                    if (CollectionUtils.isNotEmpty(mapSyqList)) {
                        mapSyq = mapSyqList.get(0);
                    }
                }
                if (bdclx.equals("TD")) {
                    List<Map> mapSyqList = getTdSyqByBdcdyh(bdcdyh);
                    //取不动产现势土地所有权
                    if (CollectionUtils.isNotEmpty(mapSyqList)) {
                        mapSyq = mapSyqList.get(0);
                    } else {
                        //取过渡现势土地所有权
                        mapSyqList = getGdTdSyqByBdcdyh(bdcdyh);
                    }
                    if (CollectionUtils.isNotEmpty(mapSyqList)) {
                        mapSyq = mapSyqList.get(0);
                    }
                }
                //..待加入草权、林权等类型获取所有权
            }
        } catch (Exception e) {
            LoggerFactory.getLogger(getClass()).error(Constants.ERROR_IN_FUNCTION, e);
        }
        return mapSyq;
    }

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param: * @param bdcdyh
     * @Description:根据不动产单元号获取有效的过渡土地产权证
     * @Date 9:43 2017/12/21
     */
    @Override
    public List<Map> getGdTdSyqByBdcdyh(String bdcdyh) {
        List<Map> mapList = new LinkedList<Map>();
        //确认该不动产单元是匹配还是未匹配
        List<BdcGdDyhRel> gdDyhRelList = listGdDyhRelByDyh(bdcdyh);
        if (CollectionUtils.isNotEmpty(gdDyhRelList)) {
            for (BdcGdDyhRel gdDyhRel : gdDyhRelList) {
                List<GdTdsyq> gdTdsyqList = gdTdService.queryTdsyqByTdid(gdDyhRel.getGdid());
                //过滤取有效的过渡土地所有权的qlid
                List<String> qlidList = new LinkedList<String>();
                if (CollectionUtils.isNotEmpty(gdTdsyqList)) {
                    for (GdTdsyq gdTdsyq : gdTdsyqList) {
                        if (StringUtils.isNotBlank(gdTdsyq.getIszx().toString()) && gdTdsyq.getIszx() != 1) {
                            qlidList.add(gdTdsyq.getQlid());
                        }
                    }
                }

                if (null != qlidList && CollectionUtils.isNotEmpty(qlidList)) {
                    for (String qlid : qlidList) {
                        Map hashMap = new HashMap();
                        List<GdQlr> gdQlrList = gdQlrService.getGdQlrListByqlidAndQlrlx(qlid, Constants.QLRLX_QLR);
                        String qlrmc = gdQlrService.combinationQlr(gdQlrList);
                        GdTd gdTd = gdTdService.getGdTdByTdid(gdDyhRel.getGdid());
                        GdTdsyq gdTdsyq = gdTdService.queryGdTdsyqByQlid(qlid);
                        hashMap.put(QLXX_YT, gdTd.getYt());
                        hashMap.put(QLXX_MJ, gdTd.getZdmj());
                        hashMap.put(QLXX_SPZL, gdTd.getZl());
                        hashMap.put(QLXX_XMZL, gdTd.getZl());
                        hashMap.put(QLXX_QLR, qlrmc);
                        hashMap.put(QLXX_BDCQZH, gdTdsyq.getTdzh());
                        mapList.add(hashMap);
                    }
                }
            }
        }
        return mapList;
    }

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param: * @param bdcdyh
     * @Description:根据不动产单元号获取有效的不动产土地产权证
     * @Date 9:43 2017/12/21
     */
    @Override
    public List<Map> getTdSyqByBdcdyh(String bdcdyh) {
        List<Map> mapList = new LinkedList<Map>();
        //获取proid
        BdcBdcdy bdcBdcdy = bdcdyService.getBdcdyByBdcdyh(bdcdyh);
        if (null != bdcBdcdy && StringUtils.isNotBlank(bdcBdcdy.getBdcdyid())) {
            List<String> proidList = bdcTdService.getProidListByBdcdyid(bdcBdcdy.getBdcdyid());
            if (null != proidList && CollectionUtils.isNotEmpty(proidList)) {
                for (String proid : proidList) {
                    Map hashMap = new HashMap();
                    List<BdcQlr> bdcQlrList = bdcQlrService.getBdcQlrListByProidAndQlrlx(proid, Constants.QLRLX_QLR);
                    String qlrmc = bdcQlrService.combinationQlr(bdcQlrList);
                    BdcXm bdcXm = bdcXmService.getBdcXmByProid(proid);
                    BdcSpxx bdcSpxx = bdcSpxxService.getBdcSpxxByProid(proid);
                    List<BdcZs> bdcZsList = bdcZsService.queryBdcZsByProid(proid);
                    hashMap.put(QLXX_YT, bdcSpxx.getZdzhyt());
                    hashMap.put(QLXX_MJ, bdcSpxx.getZdzhmj());
                    hashMap.put(QLXX_SPZL, bdcSpxx.getZl());
                    hashMap.put(QLXX_XMZL, bdcXm.getZl());
                    hashMap.put(QLXX_QLR, qlrmc);
                    hashMap.put(QLXX_BDCQZH, CollectionUtils.isNotEmpty(bdcZsList) ? bdcZsList.get(0).getBdcqzh() : "");
                    mapList.add(hashMap);
                }
            }
        }
        return mapList;
    }

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param: bdcdyh
     * @Description:通过不动产单元号获取过渡房产证号
     * @Date 11:18 2017/12/21
     */
    @Override
    public List<Map> getGdFwSyqByBdcdyh(String bdcdyh) {
        List<Map> mapList = new LinkedList<Map>();
        //确认该不动产单元是匹配还是未匹配
        List<BdcGdDyhRel> gdDyhRelList = listGdDyhRelByDyh(bdcdyh);
        if (CollectionUtils.isNotEmpty(gdDyhRelList)) {
            for (BdcGdDyhRel gdDyhRel : gdDyhRelList) {
                List<String> gdFwsyqQlidList = gdFwService.getGdFwsyqQlidListByGdid(gdDyhRel.getGdid());
                if (CollectionUtils.isNotEmpty(gdFwsyqQlidList)) {
                    for (String qlid : gdFwsyqQlidList) {
                        Map hashMap = new HashMap();
                        List<GdQlr> gdQlrList = gdQlrService.getGdQlrListByqlidAndQlrlx(qlid, Constants.QLRLX_QLR);
                        String qlrmc = gdQlrService.combinationQlr(gdQlrList);
                        GdFw gdFw = gdFwService.getGdFwByFwid(gdDyhRel.getGdid());
                        GdFwsyq gdFwsyq = gdFwService.queryGdFwsyqByQlid(qlid);
                        hashMap.put(QLXX_YT, gdFw.getGhyt());
                        hashMap.put(QLXX_MJ, gdFw.getJzmj());
                        hashMap.put(QLXX_SPZL, gdFw.getFwzl());
                        hashMap.put(QLXX_XMZL, gdFw.getFwzl());
                        hashMap.put(QLXX_QLR, qlrmc);
                        hashMap.put(QLXX_BDCQZH, gdFwsyq.getFczh());
                        mapList.add(hashMap);
                    }
                }
            }
        } else {
            //未匹配通过fcdah获取相关所有权信息
            List<GdFw> gdFws = gdFwService.getGdFwBybdcdyh(bdcdyh);
            if (CollectionUtils.isNotEmpty(gdFws)) {
                for (GdFw gdFw : gdFws) {
                    List<GdFwsyq> gdFwsyqList = gdFwService.queryFwsyqByFwid(gdFw.getFwid());
                    if (CollectionUtils.isNotEmpty(gdFwsyqList)) {
                        for (GdFwsyq gdfwsyq : gdFwsyqList) {
                            Map hashMap = new HashMap();
                            List<GdQlr> gdQlrList = gdQlrService.getGdQlrListByqlidAndQlrlx(gdfwsyq.getQlid(), Constants.QLRLX_QLR);
                            String qlrmc = gdQlrService.combinationQlr(gdQlrList);
                            hashMap.put(QLXX_YT, gdFw.getGhyt());
                            hashMap.put(QLXX_MJ, gdFw.getJzmj());
                            hashMap.put(QLXX_SPZL, gdFw.getFwzl());
                            hashMap.put(QLXX_XMZL, gdFw.getFwzl());
                            hashMap.put(QLXX_QLR, qlrmc);
                            hashMap.put(QLXX_BDCQZH, gdfwsyq.getFczh());
                            mapList.add(hashMap);
                        }
                    }
                }
            }
        }
        if (SysVersions.isKuandian() && CollectionUtils.isEmpty(mapList)) {
            Map hashMap = new HashMap();
            hashMap.put(QLXX_DJZT, "");
            mapList.add(hashMap);
        }
        return mapList;
    }

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param: * @param bdcdyh
     * @Description:根据不动产单元号获取有效的不动产产权证
     * @Date 9:43 2017/12/21
     */
    @Override
    public List<Map> getFwSyqByBdcdyh(String bdcdyh) {
        List<Map> mapList = new LinkedList<Map>();
        //获取bdcdyid
        BdcBdcdy bdcBdcdy = bdcdyService.getBdcdyByBdcdyh(bdcdyh);
        if (null != bdcBdcdy && StringUtils.isNotBlank(bdcBdcdy.getBdcdyid())) {
            //确认该不动产单元是房地产权还是房地产权多幢
            List<BdcFdcq> bdcFdcqList = bdcFdcqService.getBdcFdcqListByBdcdyid(bdcBdcdy.getBdcdyid());
            if (CollectionUtils.isNotEmpty(bdcFdcqList)) {
                for (BdcFdcq bdcFdcq : bdcFdcqList) {
                    Map hashMap = new HashMap();
                    List<BdcQlr> bdcQlrList = bdcQlrService.getBdcQlrListByProidAndQlrlx(bdcFdcq.getProid(), Constants.QLRLX_QLR);
                    String qlrmc = bdcQlrService.combinationQlr(bdcQlrList);
                    BdcXm bdcXm = bdcXmService.getBdcXmByProid(bdcFdcq.getProid());
                    BdcSpxx bdcSpxx = bdcSpxxService.getBdcSpxxByProid(bdcFdcq.getProid());
                    List<BdcZs> bdcZsList = bdcZsService.queryBdcZsByProid(bdcFdcq.getProid());
                    hashMap.put(QLXX_YT, bdcFdcq.getGhyt());
                    hashMap.put(QLXX_MJ, bdcFdcq.getJzmj());
                    hashMap.put(QLXX_SPZL, bdcSpxx.getZl());
                    hashMap.put(QLXX_XMZL, bdcXm.getZl());
                    hashMap.put(QLXX_QLR, qlrmc);
                    hashMap.put(QLXX_BDCQZH, CollectionUtils.isNotEmpty(bdcZsList) ? bdcZsList.get(0).getBdcqzh() : "");
                    if (SysVersions.isKuandian()) {
                        if (bdcXm != null && StringUtils.equals(bdcXm.getSqlx(),"199")) {
                            hashMap.put(QLXX_DJZT, "");
                        }
                    }
                    mapList.add(hashMap);
                }
            } else {
                //如果是多幢
                List<BdcFdcqDz> bdcFdcqDzList = bdcFdcqDzService.getBdcFdcqDzByBdcdyid(bdcBdcdy.getBdcdyid());
                if (CollectionUtils.isNotEmpty(bdcFdcqDzList)) {
                    for (BdcFdcqDz bdcFdcqDz : bdcFdcqDzList) {
                        Map hashMap = new HashMap();
                        List<BdcQlr> bdcQlrList = bdcQlrService.getBdcQlrListByProidAndQlrlx(bdcFdcqDz.getProid(), Constants.QLRLX_QLR);
                        String qlrmc = bdcQlrService.combinationQlr(bdcQlrList);
                        BdcXm bdcXm = bdcXmService.getBdcXmByProid(bdcFdcqDz.getProid());
                        BdcSpxx bdcSpxx = bdcSpxxService.getBdcSpxxByProid(bdcFdcqDz.getProid());
                        List<BdcZs> bdcZsList = bdcZsService.queryBdcZsByProid(bdcFdcqDz.getProid());
                        hashMap.put(QLXX_YT, bdcSpxx.getYt());
                        hashMap.put(QLXX_MJ, bdcFdcqDz.getFtjzmj());
                        hashMap.put(QLXX_SPZL, bdcSpxx.getZl());
                        hashMap.put(QLXX_XMZL, bdcXm.getZl());
                        hashMap.put(QLXX_QLR, qlrmc);
                        hashMap.put(QLXX_BDCQZH, CollectionUtils.isNotEmpty(bdcZsList) ? bdcZsList.get(0).getBdcqzh() : "");
                        if (SysVersions.isKuandian()) {
                            if (bdcXm != null && StringUtils.equals(bdcXm.getSqlx(),"199")) {
                                hashMap.put(QLXX_DJZT, "");
                            }
                        }
                        mapList.add(hashMap);
                    }
                }
            }
        }
        return mapList;
    }


    /**
     * 根据获取的不动产单元号得到与之相关的所有不动产权利
     *
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    @Override
    public Map<String, Integer> queryBdcQlByBdcdyh(List<String> bdcdyhList) {
        // 初始化一个带有权利数量为0 的Map
        Map<String, Integer> qlslMap = createEmptyQlMap(false);
        try {
            if (CollectionUtils.isNotEmpty(bdcdyhList) && StringUtils.isNotBlank(bdcdyhList.get(0))) {
                for (String bdcdyh : bdcdyhList) {
                    putQlslMap(bdcdyh, "", qlslMap);
                }
            }
        } catch (Exception e) {
            LoggerFactory.getLogger(getClass()).error(Constants.ERROR_IN_FUNCTION, e);
        }
        return qlslMap;
    }


    /**
     * 根据BDCDYH查BDC权利  或者 根据BDCID查询GD权利，计算权利数量，保存进qlslMap
     *
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    @Override
    public void putQlslMap(String bdcdyh, String bdcid, Map<String, Integer> qlslMap) {
        for (String key : qlslMap.keySet()) {
            // 预告
            if (StringUtils.equals(QLLX_YG, key)) {
                if (StringUtils.isNotBlank(bdcdyh)) {
                    qlslMap.put(key, qlslMap.get(key) + bdcCxBdcdyZtMapper.getBdcYgQlByBdcdyh(bdcdyh));
                } else if (StringUtils.isNotBlank(bdcid)) {
                    qlslMap.put(key, qlslMap.get(key) + bdcCxBdcdyZtMapper.getGdYgQlByBdcid(bdcid));
                }
            }
            // 抵押
            if (StringUtils.equals(QLLX_DYA, key)) {
                if (StringUtils.isNotBlank(bdcdyh)) {
                    String zjgcdysfdy = AppConfig.getProperty("zjgcdysfdy");
                    if (StringUtils.equals(zjgcdysfdy, "true")) {
                        qlslMap.put(key, qlslMap.get(key) + bdcCxBdcdyZtMapper.getBdcDyaQlByBdcdyhLyg(bdcdyh));
                    } else {
                        qlslMap.put(key, qlslMap.get(key) + bdcCxBdcdyZtMapper.getBdcDyaQlByBdcdyh(bdcdyh));
                    }
                } else if (StringUtils.isNotBlank(bdcid)) {
                    qlslMap.put(key, qlslMap.get(key) + bdcCxBdcdyZtMapper.getGdDyaQlByBdcid(bdcid));
                }
            }
            // 异议
            if (StringUtils.equals(QLLX_YY, key)) {
                if (StringUtils.isNotBlank(bdcdyh)) {
                    qlslMap.put(key, qlslMap.get(key) + bdcCxBdcdyZtMapper.getBdcYyQlByBdcdyh(bdcdyh));
                } else if (StringUtils.isNotBlank(bdcid)) {
                    qlslMap.put(key, qlslMap.get(key) + bdcCxBdcdyZtMapper.getGdYyQlByBdcid(bdcid));
                }
            }
            // 查封
            if (StringUtils.equals(QLLX_CF, key)) {
                if (StringUtils.isNotBlank(bdcdyh)) {
                    qlslMap.put(key, qlslMap.get(key) + bdcCxBdcdyZtMapper.getBdcCfQlBybdcdyh(bdcdyh));
                } else if (StringUtils.isNotBlank(bdcid)) {
                    qlslMap.put(key, qlslMap.get(key) + bdcCxBdcdyZtMapper.getGdCfQlByBdcid(bdcid));
                }
            }
            // 预查封
            if (StringUtils.equals(QLLX_YCF, key)) {
                if (StringUtils.isNotBlank(bdcdyh)) {
                    qlslMap.put(key, qlslMap.get(key) + bdcCxBdcdyZtMapper.getBdcYcfQlByBdcdyh(bdcdyh));
                } else if (StringUtils.isNotBlank(bdcid)) {
                    qlslMap.put(key, qlslMap.get(key) + bdcCxBdcdyZtMapper.getGdYCfQlByBdcid(bdcid));
                }
            }
            // 锁定
            if (StringUtils.equals(QLLX_SD, key)) {
                if (StringUtils.isNotBlank(bdcdyh)) {
                    qlslMap.put(key, qlslMap.get(key) + bdcCxBdcdyZtMapper.getBdcSdQlByBdcdyh(bdcdyh));
                } else if (StringUtils.isNotBlank(bdcid)) {
                    qlslMap.put(key, qlslMap.get(key) + bdcCxBdcdyZtMapper.getGdSdQlByBdcid(bdcid));
                }
            }
            // 居住权
            if (StringUtils.equals(QLLX_JZ, key) && StringUtils.isNotBlank(bdcdyh)) {
                qlslMap.put(key, qlslMap.get(key) + bdcCxBdcdyZtMapper.getBdcJzQlByBdcdyh(bdcdyh));
            }
            // 预抵押
            if (StringUtils.equals(QLLX_YDYA, key) && StringUtils.isNotBlank(bdcdyh)) {
                qlslMap.put(key, qlslMap.get(key) + bdcCxBdcdyZtMapper.getBdcYdyaQlByBdcdyh(bdcdyh));
            }
            // 在建建筑物
            if (StringUtils.equals(QLLX_ZJJZW, key) && StringUtils.isNotBlank(bdcdyh)) {
                qlslMap.put(key, qlslMap.get(key) + bdcCxBdcdyZtMapper.getBdcZjjzwQlByBdcdyh(bdcdyh));
            }
            // 地役
            if (StringUtils.equals(QLLX_DYI, key) && StringUtils.isNotBlank(bdcdyh)) {
                qlslMap.put(key, qlslMap.get(key) + bdcCxBdcdyZtMapper.getBdcDyQlByBdcdyh(bdcdyh));
            }
            // 首次登记
            if (StringUtils.equals(QLLX_SCDJ, key) && StringUtils.isNotBlank(bdcdyh)) {
                qlslMap.put(key, qlslMap.get(key) + bdcCxBdcdyZtMapper.getScdjztByBdcdyh(bdcdyh));
            }
        }
    }


    /**
     * 循环处理 MAP中的 权利数量，相加
     *
     * @param
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    @Override
    public void countByMap(Map<String, Integer> fromMap, Map<String, Integer> toMap) {
        if (MapUtils.isNotEmpty(fromMap) && MapUtils.isNotEmpty(toMap)) {
            Iterator iter = fromMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry) iter.next();
                Integer oldInt = toMap.get(entry.getKey());
                if (oldInt != null) {
                    Integer newInt = 0;
                    if (entry.getValue() != null && StringUtils.isNotBlank(entry.getValue().toString())) {
                        newInt = Integer.parseInt(entry.getValue().toString());
                    }
                    toMap.put(entry.getKey().toString(), oldInt + newInt);
                }
            }
        }
    }

    /**
     * 创建一个空的Map,MAP中初始各种权利数量为0
     *
     * @param isGd 过度数据部分权利不需要计算，所以初始化时区分是否是用于处理过度数据
     * @return
     * @throws
     * @author 2018-06-02 lyq
     */
    @Override
    public Map<String, Integer> createEmptyQlMap(boolean isGd) {
        Map<String, Integer> newmap = new HashMap<String, Integer>();
        if (isGd) {
            for (String qllx : gdQllxList) {
                newmap.put(qllx, 0);
            }
        } else {
            for (String qllx : bdcQllxList) {
                newmap.put(qllx, 0);
            }
        }
        return newmap;
    }
}