package cn.gtmap.estateplat.config.service.ztxx.impl;/*
 * @author <a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
 * @version 1.0, 2017/11/22
 * @description
 */

import cn.gtmap.estateplat.config.core.mapper.config.BdcCxBdcdyZtMapper;
import cn.gtmap.estateplat.config.core.mapper.config.DhDzhMapper;
import cn.gtmap.estateplat.config.core.mapper.sjgl.DjsjCxBdcdyZtMapper;
import cn.gtmap.estateplat.config.core.model.IdModel;
import cn.gtmap.estateplat.config.core.service.*;
import cn.gtmap.estateplat.config.service.ztxx.BdcCxBdcdyQlxxService;
import cn.gtmap.estateplat.config.service.ztxx.BdcCxBdcdyZtService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.model.config.BdcCxBdcdyZt;
import cn.gtmap.estateplat.model.server.core.BdcGdDyhRel;
import cn.gtmap.estateplat.model.server.core.GdFw;
import cn.gtmap.estateplat.model.server.core.GdTd;
import cn.gtmap.estateplat.model.server.core.GdTdsyq;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class BdcCxBdcdyZtServiceImpl implements BdcCxBdcdyZtService {
    @Autowired
    private BdcCxBdcdyZtMapper bdcCxBdcdyZtMapper;
    @Autowired
    private DjsjCxBdcdyZtMapper djsjCxBdcdyZtMapper;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private BdcGdDyhRelService bdcGdDyhRelService;
    @Autowired
    private GdTdService gdTdService;
    @Autowired
    private BdcdyService bdcdyService;
    @Autowired
    private BdcFdcqService bdcFdcqService;
    @Autowired
    private BdcFdcqDzService bdcFdcqDzService;
    @Autowired
    private BdcQlrService bdcQlrService;
    @Autowired
    private BdcXmService bdcXmService;
    @Autowired
    private BdcSpxxService bdcSpxxService;
    @Autowired
    private GdFwService gdFwService;
    @Autowired
    private GdQlrService gdQlrService;
    @Autowired
    private BdcTdService bdcTdService;
    @Autowired
    private DhDzhMapper dhDzhMapper;

    @Autowired
    private BdcCxBdcdyQlxxService bdcCxBdcdyQlxxService;

    @Override
    public BdcCxBdcdyZt getBdcdyZtByZtid(String ztid) {
        return null;
    }

    @Override
    public BdcCxBdcdyZt getBdcdyZtByBdcdyh(String bdcdyh) {
        return null;
    }

    @Override
    public BdcCxBdcdyZt getBdcdyZtByBdcdybh(String bdcdybh) {
        return null;
    }

    @Override
    public String initBdcCxBdcdyZt(String bdcdyh, String bdcdybh) {
        return null;
    }

    @Override
    public String setBdcdyZt(String bdcdyh, String bdcdybh) {
        return null;
    }

    @Override
    public String delBdcCxBdcdyZt(String bdcdyh, String bdcdybh) {
        return null;
    }

    @Override
    public String setBdcdyDjzt(String bdcdyh, String bdcdybh) {
        return null;
    }

    @Override
    public String setBdcdyQlzt(String bdcdyh, String bdcdybh) {
        return null;
    }

    @Override
    public List<BdcCxBdcdyZt> getBdcCxBdcdyZtList(Map map) {
        return bdcCxBdcdyZtMapper.getBdcCxBdcdyZt(map);
    }

    @Override
    public List<String> getBdcdyh(Map map) {
        return bdcCxBdcdyZtMapper.getBdcdyhByBdclx(map);
    }

    @Override
    public Integer getBdcdyhCount(String bdclx) {
        return bdcCxBdcdyZtMapper.getBdcdyhNum(bdclx);
    }

    @Override
    public String updateBdcdyZtByBdcdyh(List<String> bdcdyhList, String bdclx) {
        String result = "fail";
        try {
            if (CollectionUtils.isNotEmpty(bdcdyhList)) {
                for (int i = 0; i < bdcdyhList.size(); i++) {
                    Map newmap = null;
                    String bdcdyh = bdcdyhList.get(i);
                    System.out.println("第" + i + "条数据------->bdcdyh:" + bdcdyh + "开始转换");
                    if (StringUtils.contains(AppConfig.getProperty("config.serviceVersion"), "dbqy")) {
                        newmap = new HashMap();
                        newmap.put("BDCDYH", bdcdyh);
                        newmap.put("BDCLX", bdclx);
                    } else {
                        IdModel idModelFw = getXgIdModelForBdcdy(bdcdyh, bdclx);
                        newmap = queryQLsl(idModelFw);
                        newmap.put("BDCDYH", bdcdyh);
                        newmap.put("BDCLX", bdclx);
                    }
                    bdcCxBdcdyQlxxService.updateBdcdyZt(newmap);
                }
                result = "success";
            }
        } catch (Exception e) {
            LoggerFactory.getLogger(getClass()).error(Constants.ERROR_IN_FUNCTION, e);
        }
        return result;
    }

    /**
     * @Author:<a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @param:bdcdyh 不动产单元号
     * @param:bdclx 不动产类型
     * @Description:为不动产单元的权利状态设计，根据不动产单元号找到对应的房屋和土地，房屋和土地的过渡权利和不动产单元的不动产权利的集合就是该不动产单元所有权利
     * @Date 15:46 2017/11/23
     */
    @Override
    public IdModel getXgIdModelForBdcdy(String bdcdyh, String bdclx) {
        IdModel idModel = new IdModel();
        List<String> bdcdyhList = new LinkedList<String>();
        List<String> fwidList = new LinkedList<String>();
        List<String> tdisList = new LinkedList<String>();
        try {
            if (StringUtils.isNotBlank(bdcdyh) && StringUtils.isNotBlank(bdclx)) {
                bdcdyhList.add(bdcdyh);
                if (StringUtils.equals(Constants.BDCLX_TDFW, bdclx)) {
                    // 获取 fwidList
                    // 如果带土地证状态 获取 tdisList
                    // 如果带大土地证状态 获取 bdcdyhList
                    listGdidsBdclxTdfw(bdcdyhList, fwidList, tdisList);
                } else if (StringUtils.equals(Constants.BDCLX_TD, bdclx)) {
                    // 获取 tdisList
                    listTdidsBdclxTd(bdcdyh, tdisList);
                }
            }
            idModel.setBdcdyhs(bdcdyhList);
            idModel.setFwids(fwidList);
            idModel.setTdids(tdisList);
        } catch (Exception e) {
            LoggerFactory.getLogger(getClass()).error(Constants.ERROR_IN_FUNCTION, e);
        }
        return idModel;
    }


    /**
     * 获取 fwidList 如果带土地证状态 获取 tdisList 如果带大土地证状态 获取 bdcdyhList 和tdisList
     *
     * @param
     * @return
     * @throws
     * @author 2018-06-03 lyq
     */
    private void listGdidsBdclxTdfw(List<String> bdcdyhList, List<String> fwidList, List<String> tdisList) {
        String bdcdyh = "";
        if (CollectionUtils.isEmpty(bdcdyhList)) {
            return;
        }
        bdcdyh = bdcdyhList.get(0);
        //jyl  大土地证的权利状态是否归在匹配的房屋上
        boolean dtdzOnFw = AppConfig.getBooleanProperty("dtdzOnFw", false);
        //jyl理论上一个不动产单元号只有一个匹配关系，但是总有错误数据，所以要当成多条处理
        List<BdcGdDyhRel> gdDyhRelList = bdcCxBdcdyQlxxService.listGdDyhRelByDyh(bdcdyh);
        //jyl 不为空则表示匹配，房屋和不动产单元关系以匹配为准。为空则表示没匹配，通过房屋档案号关联
        if (CollectionUtils.isNotEmpty(gdDyhRelList)) {
            for (BdcGdDyhRel bdcGdDyhRel : gdDyhRelList) {
                if (StringUtils.isNotBlank(bdcGdDyhRel.getGdid())) {
                    //jyl 相关fwid归类
                    if (!fwidList.contains(bdcGdDyhRel.getGdid())) {
                        fwidList.add(bdcGdDyhRel.getGdid());
                    }
                }
                //jyl土地证的权利要关联在房屋上
                if (dtdzOnFw) {
                    bdcCxBdcdyQlxxService.dealGdTdidsBdclxTdfw(bdcGdDyhRel.getTdid(), bdcdyhList, tdisList);
                }
            }
        } else {
            List<GdFw> gdFwList = gdFwService.getGdFwBybdcdyh(bdcdyh);
            if (CollectionUtils.isNotEmpty(gdFwList)) {
                for (GdFw gdFw : gdFwList) {
                    //jyl 相关fwid归类
                    if (!fwidList.contains(gdFw.getFwid())) {
                        fwidList.add(gdFw.getFwid());
                    }
                }
            }
            //jyl土地证的权利要关联在房屋上
            if (dtdzOnFw) {
                bdcCxBdcdyQlxxService.dealGdTdidsBdclxTdfw("", bdcdyhList, tdisList);
            }
        }
    }

    /**
     * 不动产类型为TD时 获取 tdids
     *
     * @param
     * @return
     * @throws
     * @author 2018-06-03 lyq
     */
    private void listTdidsBdclxTd(String bdcdyh, List<String> tdisList) {
        List<BdcGdDyhRel> gdDyhRelList = bdcCxBdcdyQlxxService.listGdDyhRelByDyh(bdcdyh);
        //jyl 不为空则表示匹配，土地和不动产单元关系以匹配为准。为空则表示没匹配，通过地籍号来关联
        if (CollectionUtils.isNotEmpty(gdDyhRelList)) {
            for (BdcGdDyhRel bdcGdDyhRel : gdDyhRelList) {
                if (StringUtils.isNotBlank(bdcGdDyhRel.getGdid())) {
                    //jyl 相关tdid归类
                    if (!tdisList.contains(bdcGdDyhRel.getGdid())) {
                        tdisList.add(bdcGdDyhRel.getGdid());
                    }
                }
            }
        } else {
            GdTd gdTd = bdcCxBdcdyQlxxService.queryGdTdByBdcdyh(bdcdyh, false);
            if (gdTd != null) {
                //jyl 相关tdid归类
                if (!tdisList.contains(gdTd.getTdid())) {
                    tdisList.add(gdTd.getTdid());
                }
            }
        }
    }

    private List<String> listBdcdyhByTdid(List<String> bdcdyhList, String tdid) {
        //jyl 找到所匹配的土地还要考虑他是不是存在不动产的权利，所以还要找到他匹配的不动产单元号
        List<BdcGdDyhRel> tdGdDyhRels = bdcGdDyhRelService.getGdDyhRelListByGdid(tdid);
        if (CollectionUtils.isNotEmpty(tdGdDyhRels)) {
            for (BdcGdDyhRel tdGdDyhRel : tdGdDyhRels) {
                if (StringUtils.isNotBlank(tdGdDyhRel.getBdcdyh())) {
                    //jyl 相关bdcdyh归类
                    if (!bdcdyhList.contains(tdGdDyhRel.getBdcdyh())) {
                        bdcdyhList.add(tdGdDyhRel.getBdcdyh());
                    }
                }
            }
        }
        return bdcdyhList;
    }

    @Override
    public IdModel getXgIdModelByFwidForSyq(String fwid) {
        IdModel idModel = new IdModel();
        List<String> bdcdyhList = new LinkedList<String>();
        List<String> fwidList = new LinkedList<String>();
        List<String> tdisList = new LinkedList<String>();
        try {
            if (StringUtils.isNotBlank(fwid)) {
                GdFw gdFw = entityMapper.selectByPrimaryKey(GdFw.class, fwid);
                if (gdFw != null) {
                    //jyl 相关fwid归类
                    if (!fwidList.contains(fwid)) {
                        fwidList.add(fwid);
                    }
                    List<BdcGdDyhRel> gdDyhRels = bdcGdDyhRelService.getGdDyhRelListByGdid(gdFw.getFwid());
                    //jyl 房屋匹配了以匹配的为准
                    if (CollectionUtils.isNotEmpty(gdDyhRels)) {
                        for (BdcGdDyhRel gdDyhRel : gdDyhRels) {
                            if (StringUtils.isNotBlank(gdDyhRel.getBdcdyh())) {
                                //jyl 相关bdcdyh归类
                                if (!bdcdyhList.contains(gdDyhRel.getBdcdyh())) {
                                    bdcdyhList.add(gdDyhRel.getBdcdyh());
                                }
                                //jyl 土地匹配了以匹配的为准,没有匹配就要以不动产单元号前面19为的地籍号去匹配所在宗地
                                if (StringUtils.isNotBlank(gdDyhRel.getTdid())) {
                                    //jyl 找到所匹配的土地还要考虑他是不是存在不动产的权利，所以还要找到他匹配的不动产单元号
                                    //jyl 相关bdcdyh归类
                                    bdcdyhList = listBdcdyhByTdid(bdcdyhList, gdDyhRel.getTdid());
                                    //jyl 相关tdid归类
                                    if (!tdisList.contains(gdDyhRel.getTdid())) {
                                        tdisList.add(gdDyhRel.getTdid());
                                    }
                                } else {
                                    String djh = StringUtils.substring(gdDyhRel.getBdcdyh(), 0, 19);
                                   /* String newDjh = dhDzhMapper.getNewDhByOldDh(djh);
                                    if (StringUtils.isBlank(newDjh)) {
                                        newDjh = djh;
                                    }*/
                                    GdTd gdTd = gdTdService.getGdTdByDjh(djh);
                                    if (gdTd != null) {
                                        //jyl 相关bdcdyh归类
                                        bdcdyhList = listBdcdyhByTdid(bdcdyhList, gdTd.getTdid());
                                        //jyl 相关tdid归类
                                        if (!tdisList.contains(gdTd.getTdid())) {
                                            tdisList.add(gdTd.getTdid());
                                        }
                                    }
                                }
                            }
                        }
                    } else if (StringUtils.isNotBlank(gdFw.getDah())) {
                        //jyl没匹配的房屋要通过档案号找到对应的不动产单元号
                        HashMap parmMap = new HashMap();
                        parmMap.put("fcdah", gdFw.getDah());
                        List<String> fwBdcdyhs = bdcdyService.queryBdcdyhByDah(parmMap);
                        if (CollectionUtils.isNotEmpty(fwBdcdyhs) && StringUtils.isNotBlank(fwBdcdyhs.get(0))) {
                            for (String fwBdcdyh : fwBdcdyhs) {
                                //jyl 相关bdcdyh归类
                                if (!bdcdyhList.contains(fwBdcdyh)) {
                                    bdcdyhList.add(fwBdcdyh);
                                }
                                String djh = StringUtils.substring(fwBdcdyh, 0, 19);
                                /*String newDjh = dhDzhMapper.getNewDhByOldDh(djh);
                                if (StringUtils.isBlank(newDjh)) {
                                    newDjh = djh;
                                }*/
                                GdTd gdTd = gdTdService.getGdTdByDjh(djh);
                                if (gdTd != null) {
                                    //jyl 相关bdcdyh归类
                                    bdcdyhList = listBdcdyhByTdid(bdcdyhList, gdTd.getTdid());
                                    //jyl 相关tdid归类
                                    if (!tdisList.contains(gdTd.getTdid())) {
                                        tdisList.add(gdTd.getTdid());
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception e) {
            LoggerFactory.getLogger(getClass()).error(Constants.ERROR_IN_FUNCTION, e);
        }
        idModel.setBdcdyhs(bdcdyhList);
        idModel.setFwids(fwidList);
        idModel.setTdids(tdisList);
        return idModel;
    }

    @Override
    public IdModel getXgIdModelByTdidForSyq(String tdid) {
        IdModel idModel = new IdModel();
        List<String> bdcdyhList = new LinkedList<String>();
        List<String> fwidList = new LinkedList<String>();
        List<String> tdisList = new LinkedList<String>();
        try {
            if (StringUtils.isNotBlank(tdid)) {
                GdTd gdTd = entityMapper.selectByPrimaryKey(GdTd.class, tdid);
                if (gdTd != null) {
                    //jyl土地证的匹配关系有两种一种是纯土地的匹配另一种是房地一体的匹配
                    List<BdcGdDyhRel> gdDyhRelList = new ArrayList<BdcGdDyhRel>();
                    //jyl纯土地的匹配
                    List<BdcGdDyhRel> tdGdDyhRelList = bdcGdDyhRelService.getGdDyhRelListByGdid(tdid);
                    if (CollectionUtils.isNotEmpty(tdGdDyhRelList)) {
                        gdDyhRelList.addAll(tdGdDyhRelList);
                        for (BdcGdDyhRel bdcGdDyhRel : tdGdDyhRelList) {
                            //jyl 相关tdid归类
                            if (!tdisList.contains(bdcGdDyhRel.getGdid())) {
                                tdisList.add(bdcGdDyhRel.getGdid());
                            }
                        }
                    }
                    //jyl房地一体的匹配
                    List<BdcGdDyhRel> tdFwGdDyhRelList = bdcGdDyhRelService.listGdDyhRelByTdid(tdid);
                    //jyl  大土地证的权利状态是否归在匹配的房屋上
                    String dtdzOnFw = AppConfig.getProperty("dtdzOnFw");
                    //jyl  土地证的权利状态是否归在匹配的房屋上
                    String tdzOnFw = AppConfig.getProperty("tdzOnFw");
                    //jyl土地证的权利要关联在房屋上
                    if (StringUtils.isNotBlank(tdzOnFw) && StringUtils.equals("true", tdzOnFw)) {
                        //大证的权利要关联到房屋上
                        if (StringUtils.isNotBlank(dtdzOnFw) && StringUtils.equals("true", dtdzOnFw)) {
                            if (CollectionUtils.isNotEmpty(tdFwGdDyhRelList)) {
                                gdDyhRelList.addAll(tdFwGdDyhRelList);
                                for (BdcGdDyhRel bdcGdDyhRel : tdFwGdDyhRelList) {
                                    //jyl 相关tdid归类
                                    if (!tdisList.contains(bdcGdDyhRel.getTdid())) {
                                        tdisList.add(bdcGdDyhRel.getTdid());
                                    }
                                }
                            }
                        } else {
                            List<GdTdsyq> gdTdsyqList = gdTdService.queryTdsyqByTdid(tdid);
                            if (CollectionUtils.isNotEmpty(gdTdsyqList) && !StringUtils.equals(gdTdsyqList.get(0).getSffgw(), "0")) {
                                //hzj 判断tdid找到的土地证是否分割证
                                if (CollectionUtils.isNotEmpty(tdFwGdDyhRelList)) {
                                    gdDyhRelList.addAll(tdFwGdDyhRelList);
                                    for (BdcGdDyhRel bdcGdDyhRel : tdFwGdDyhRelList) {
                                        //jyl 相关tdid归类
                                        if (!tdisList.contains(bdcGdDyhRel.getTdid())) {
                                            tdisList.add(bdcGdDyhRel.getTdid());
                                        }
                                    }
                                }
                            }
                        }
                    }
                    //jyl 不为空则表示匹配，土地和不动产单元关系以匹配为准。为空则表示没匹配，通过地籍号来关联
                    if (CollectionUtils.isNotEmpty(gdDyhRelList)) {
                        for (BdcGdDyhRel bdcGdDyhRel : gdDyhRelList) {
                            if (StringUtils.isNotBlank(bdcGdDyhRel.getGdid())) {
                                //jyl 相关bdcdyh归类
                                if (!bdcdyhList.contains(bdcGdDyhRel.getBdcdyh())) {
                                    bdcdyhList.add(bdcGdDyhRel.getBdcdyh());
                                    //jyl 当土地匹配的是房屋不动产单元号，土地的权利要考虑房屋上的权利
                                    if (StringUtils.indexOf(bdcGdDyhRel.getBdcdyh(), "F") > 0) {
                                        List<BdcGdDyhRel> fwGdDyhRelList = bdcGdDyhRelService.listGdDyhRelByDyh(bdcGdDyhRel.getBdcdyh());
                                        //jyl 不为空则表示匹配，房屋和不动产单元关系以匹配为准。为空则表示没匹配，通过房屋档案号关联
                                        if (CollectionUtils.isNotEmpty(fwGdDyhRelList)) {
                                            for (BdcGdDyhRel fwBdcGdDyhRel : fwGdDyhRelList) {
                                                if (StringUtils.isNotBlank(fwBdcGdDyhRel.getGdid())) {
                                                    GdFw gdFw = gdFwService.getGdFwByFwid(fwBdcGdDyhRel.getGdid());
                                                    if (gdFw != null) {
                                                        if (!fwidList.contains(gdFw.getFwid())) {
                                                            fwidList.add(gdFw.getFwid());
                                                        }
                                                    }
                                                }
                                            }
                                        } else {
                                            List<GdFw> gdFwList = gdFwService.getGdFwBybdcdyh(bdcGdDyhRel.getBdcdyh());
                                            if (CollectionUtils.isNotEmpty(gdFwList)) {
                                                for (GdFw gdFw : gdFwList) {
                                                    if (!fwidList.contains(gdFw.getFwid())) {
                                                        fwidList.add(gdFw.getFwid());
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        String djh = gdTd.getDjh();
                        if (StringUtils.isNotBlank(djh)) {
                            String bdcdyh = djh + "W00000000";
                            //jyl 相关bdcdyh归类
                            if (!bdcdyhList.contains(bdcdyh)) {
                                bdcdyhList.add(bdcdyh);
                            }
                            //jyl 相关tdid归类
                            if (!tdisList.contains(gdTd.getTdid())) {
                                tdisList.add(gdTd.getTdid());
                            }
                        }
                    }
                }
            }
        } catch (Exception e) {
            LoggerFactory.getLogger(getClass()).error(Constants.ERROR_IN_FUNCTION, e);
        }
        idModel.setBdcdyhs(bdcdyhList);
        idModel.setTdids(tdisList);
        idModel.setFwids(fwidList);
        return idModel;
    }

    @Override
    public Map queryQLsl(IdModel idModel) {
        Map newmap = bdcCxBdcdyQlxxService.createEmptyQlMap(false);
        if (null != idModel) {
            if (CollectionUtils.isNotEmpty(idModel.getBdcdyhs())) {
                List<String> lsBdcdyhList = idModel.getBdcdyhs();
                // 根据bdcdyhList 查询 不动产各项权利数量
                Map<String, Integer> bdcQL = bdcCxBdcdyQlxxService.queryBdcQlByBdcdyh(lsBdcdyhList);
                if (null != bdcQL) {
                    bdcCxBdcdyQlxxService.countByMap(bdcQL, newmap);
                }

                // 根据gd_fw fwids 查询 过度房屋相关 各项权利数量
                List<String> lsFwidList = idModel.getFwids();
                Map gdFwQl = bdcCxBdcdyQlxxService.queryGdQlByBdcid(lsFwidList);
                if (null != gdFwQl) {
                    bdcCxBdcdyQlxxService.countByMap(gdFwQl, newmap);
                }

                // 根据gd_td tdids 查询 过度土地相关 各项权利数量
                List<String> lsTdidList = idModel.getTdids();
                Map gdTdQl = bdcCxBdcdyQlxxService.queryGdQlByBdcid(lsTdidList);
                if (null != gdTdQl) {
                    bdcCxBdcdyQlxxService.countByMap(gdTdQl, newmap);
                }
            }
        }
        return newmap;
    }

    @Override
    public String updateKsYsByBdcdyh(String bdcdyh, Integer ks, Integer ys) {
        String result = "fail";
        try {
            BdcCxBdcdyZt bdcCxBdcdyZt = bdcCxBdcdyZtMapper.getBdcCxBdcdyZtByBdcdy(bdcdyh);
            if (bdcCxBdcdyZt != null) {
                bdcCxBdcdyZt.setKs(ks);
                bdcCxBdcdyZt.setYs(ys);
                if (StringUtils.equals(bdcCxBdcdyZt.getLy(), "xs")) {
                    djsjCxBdcdyZtMapper.updateXsZt(bdcCxBdcdyZt);
                } else {
                    djsjCxBdcdyZtMapper.updateLsZt(bdcCxBdcdyZt);
                }
                result = "success";
            }
        } catch (Exception e) {
            LoggerFactory.getLogger(getClass()).error(Constants.ERROR_IN_FUNCTION, e);
        }
        return result;
    }

    @Override
    public String updateSdByBdcdyh(List<String> bdcdyhList, Integer o) {
        String result = "fail";
        try {
            if (CollectionUtils.isNotEmpty(bdcdyhList)) {
                for (String bdcdyh : bdcdyhList) {
                    BdcCxBdcdyZt bdcCxBdcdyZt = bdcCxBdcdyZtMapper.getBdcCxBdcdyZtByBdcdy(bdcdyh);
                    if (bdcCxBdcdyZt != null) {
                        if (bdcCxBdcdyZt.getXssdcs() != null) {
                            if (bdcCxBdcdyZt.getXssdcs() > 0) {
                                bdcCxBdcdyZt.setXssdcs(bdcCxBdcdyZt.getXssdcs() + o);
                            } else {
                                if (o != -1) {
                                    bdcCxBdcdyZt.setXssdcs(bdcCxBdcdyZt.getXssdcs() + o);
                                }
                            }
                        } else {
                            if (o != -1) {
                                bdcCxBdcdyZt.setXssdcs(o);
                            }
                        }
                        if (StringUtils.equals(bdcCxBdcdyZt.getLy(), "xs")) {
                            djsjCxBdcdyZtMapper.updateXsZt(bdcCxBdcdyZt);
                        } else {
                            djsjCxBdcdyZtMapper.updateLsZt(bdcCxBdcdyZt);
                        }
                        result = "success";
                    }
                }
            }
        } catch (Exception e) {
            LoggerFactory.getLogger(getClass()).error(Constants.ERROR_IN_FUNCTION, e);
        }
        return result;
    }

    @Override
    public String updateSfbaByBdcdyh(String bdcdyh, String sfba) {
        String result = "fail";
        try {
            BdcCxBdcdyZt bdcCxBdcdyZt = bdcCxBdcdyZtMapper.getBdcCxBdcdyZtByBdcdy(bdcdyh);
            if (bdcCxBdcdyZt != null) {
                bdcCxBdcdyZt.setSfba(sfba);
                djsjCxBdcdyZtMapper.updateXsZt(bdcCxBdcdyZt);
                result = "success";
            }
        } catch (Exception e) {
            LoggerFactory.getLogger(getClass()).error(Constants.ERROR_IN_FUNCTION, e);
        }
        return result;
    }
}
