package cn.gtmap.estateplat.config.service.ztxx.impl;

import cn.gtmap.estateplat.config.core.mapper.config.BdcCxZszmZtMapper;
import cn.gtmap.estateplat.config.core.mapper.config.GdFwMapper;
import cn.gtmap.estateplat.config.core.mapper.config.GdTdMapper;
import cn.gtmap.estateplat.config.core.mapper.config.GdXmMapper;
import cn.gtmap.estateplat.config.core.model.IdModel;
import cn.gtmap.estateplat.config.core.service.*;
import cn.gtmap.estateplat.config.service.ztxx.BdcCxBdcdyZtService;
import cn.gtmap.estateplat.config.service.ztxx.BdcCxZszmZtService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.*;
import cn.gtmap.estateplat.utils.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/*
 * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
 * @version 1.0, 2017/12/11
 * @description 不动产证书证明状态查询服务
 */
@Service
public class BdcCxZszmZtServiceImpl implements BdcCxZszmZtService {

    @Autowired
    BdcCxZszmZtMapper bdcCxZszmZtMapper;
    @Autowired
    BdcZsService bdcZsService;
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    GdXmMapper gdXmMapper;
    @Autowired
    BdcdyService bdcdyService;
    @Autowired
    BdcCxBdcdyZtService bdcCxBdcdyZtService;
    @Autowired
    GdTdMapper gdTdMapper;
    @Autowired
    GdFwMapper gdFwMapper;
    @Autowired
    QllxService qllxService;
    @Autowired
    BdcXmService bdcXmService;
    @Autowired
    private GdFwService gdFwService;
    @Autowired
    private GdQlrService gdQlrService;
    @Autowired
    private GdTdService gdTdService;

    @Override
    public void saveBdcCxZszmZt(BdcCxZszmZt bdcCxZszmZt) {
        if (bdcCxZszmZt != null && StringUtils.isNoneBlank(bdcCxZszmZt.getZtid())) {
            entityMapper.saveOrUpdate(bdcCxZszmZt, bdcCxZszmZt.getZtid());
        }
    }

    @Override
    public BdcCxZszmZt getBdcCxZszmZtByCqzh(String cqzh) {
        BdcCxZszmZt BdcCxZszmZt = null;
        if (StringUtils.isNoneBlank(cqzh)) {
            Example example = new Example(BdcCxZszmZt.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("cqzh", cqzh);
            List<BdcCxZszmZt> bdcCxZszmZtList = entityMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(bdcCxZszmZtList)) {
                BdcCxZszmZt = bdcCxZszmZtList.get(0);
            }
        }
        return BdcCxZszmZt;
    }

    @Override
    public Boolean updateZszmZtByCqzh(BdcCxZszmZt bdcCxZszmZt) {
        Boolean bool = false;
        String syqZslx = AppConfig.getProperty("syqZslx");
        String[] syqZslxArr = null;
        if (StringUtils.isNoneBlank(syqZslx)) {
            syqZslxArr = syqZslx.split(",");
        }
        if (StringUtils.equals(Constants.XMLY_BDC, bdcCxZszmZt.getSjly()) && StringUtils.isNotBlank(bdcCxZszmZt.getBdclx())) {
            //jyl 更新不动产证书的权属状态
            bool = updateZszmQsztForBdc(bdcCxZszmZt);
            //jyl 使用权才要更新权利状态
            if (syqZslxArr == null || (StringUtils.isNotBlank(bdcCxZszmZt.getZslx()) && CommonUtil.indexOfStrs(syqZslxArr, bdcCxZszmZt.getZslx()))) {
                //jyl 更新不动产证书的权利状态
                bool = updateZszmQlztForBdcqz(bdcCxZszmZt);
            }
        } else if (StringUtils.equals(Constants.XMLY_TDSP, bdcCxZszmZt.getSjly())) {
            //jyl 更新过渡证书的权属状态
            bool = updateZszmQsztForGd(bdcCxZszmZt);
            //jyl 使用权才要更新权利状态
            if (syqZslxArr == null || (StringUtils.isNotBlank(bdcCxZszmZt.getZslx()) && CommonUtil.indexOfStrs(syqZslxArr, bdcCxZszmZt.getZslx()))) {
                //jyl 更新过渡土地证书的权利状态
                bool = updateZszmQlztForGdTdz(bdcCxZszmZt);
            }
        } else if (StringUtils.equals(Constants.XMLY_FWSP, bdcCxZszmZt.getSjly())) {
            //jyl 更新过渡证书的权属状态
            bool = updateZszmQsztForGd(bdcCxZszmZt);
            //jyl 使用权才要更新权利状态
            if (syqZslxArr == null || (StringUtils.isNotBlank(bdcCxZszmZt.getZslx()) && CommonUtil.indexOfStrs(syqZslxArr, bdcCxZszmZt.getZslx()))) {
                //jyl 更新过渡房产证书的权利状态
                bool = updateZszmQlztForGdFcz(bdcCxZszmZt);
            }
        }
        return bool;
    }

    @Override
    public void initBdcZs(List<BdcZs> bdcZsList) {
        if (CollectionUtils.isNotEmpty(bdcZsList)) {
            for (BdcZs bdcZs : bdcZsList) {
                updateBdczsZtByBdczs(bdcZs);
            }
        }
    }

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param:bdczs
     * @Description:更新不动产证书状态方法（为了日志aop截取抽出该方法）
     * @Date 15:10 2018/2/27
     */
    public void updateBdczsZtByBdczs(BdcZs bdcZs) {
        if (StringUtils.isNotBlank(bdcZs.getBdcqzh())) {
            //jyl 辣鸡数据烦恼，如果进入初始方法还有存在相同证号的数据，删掉
            List<String> cqzhList = new LinkedList<String>();
            cqzhList.add(bdcZs.getBdcqzh());
            Map map = new HashMap();
            map.put("cqzhList", cqzhList);
            bdcCxZszmZtMapper.deleteZszmZtBycqzh(map);
            //根据zs中的不动产单元获取bdclx并赋值
            String bdclx = "";
            String bdcdyh = "";
            if (StringUtils.isNotBlank(bdcZs.getBdcdyh())) {
                bdcdyh = bdcZs.getBdcdyh();
            } else {
                //hzj 考虑部分地区bdczs中没有bdcdyh，只能从xm中取
                BdcXm bdcXm = bdcZsService.getBdcXmByBdcqzh(bdcZs.getBdcqzh());
                BdcBdcdy xmBdcdyh = bdcdyService.queryBdcdyById(bdcXm.getBdcdyid());
                if (null != xmBdcdyh && StringUtils.isNotBlank(xmBdcdyh.getBdcdyh())) {
                    bdcdyh = xmBdcdyh.getBdcdyh();
                }
            }
            if (StringUtils.isNotBlank(bdcdyh)) {
                BdcBdcdy bdcBdcdy = bdcdyService.getBdcdyByBdcdyh(bdcdyh);
                if (null != bdcBdcdy && StringUtils.isNotBlank(bdcBdcdy.getBdclx())) {
                    bdclx = bdcBdcdy.getBdclx();
                }
            }
            BdcCxZszmZt bdcCxZszmZt = new BdcCxZszmZt();
            if (StringUtils.isNotBlank(bdclx)) {
                bdcCxZszmZt.setBdclx(bdclx);
            }
            bdcCxZszmZt.setZtid(UUIDGenerator.generate18());
            bdcCxZszmZt.setZsbh(bdcZs.getBh());
            bdcCxZszmZt.setCqzh(bdcZs.getBdcqzh());
            bdcCxZszmZt.setZslx(bdcZs.getZstype());
            bdcCxZszmZt.setSjly(Constants.XMLY_BDC);
            saveBdcCxZszmZt(bdcCxZszmZt);
        }
    }

    @Override
    public void initGdZs(List<Map> gdZsList) {
        if (CollectionUtils.isNotEmpty(gdZsList)) {
            for (Map gdZsMap : gdZsList) {
                if (StringUtils.isNotBlank(CommonUtil.formatEmptyValue(gdZsMap.get("CQZH")))) {
                    //hzj 判断过渡房屋所有权中有分别持证的情况
                    if (CommonUtil.formatEmptyValue(gdZsMap.get("CQZH")).indexOf(",") > -1) {
                        List<String> cqzhList = new LinkedList<String>();
                        String[] gdcqzh = CommonUtil.formatEmptyValue(gdZsMap.get("CQZH")).split(",");
                        cqzhList.addAll(Arrays.asList(gdcqzh));
                        if (null != cqzhList && CollectionUtils.isNotEmpty(cqzhList)) {
                            for (String cqzh : cqzhList) {
                                List<Map> gyZsList = new LinkedList<Map>();
                                gdZsMap.put("CQZH", cqzh);
                                gyZsList.add(gdZsMap);
                                initGdZs(gyZsList);
                            }
                        }
                    } else {
                        //jyl 辣鸡数据烦恼，如果进入初始方法还有存在相同证号的数据，删掉
                        List<String> cqzhList = new LinkedList<String>();
                        cqzhList.add(CommonUtil.formatEmptyValue(gdZsMap.get("CQZH")));
                        Map map = new HashMap();
                        map.put("cqzhList", cqzhList);
                        bdcCxZszmZtMapper.deleteZszmZtBycqzh(map);
                        BdcCxZszmZt bdcCxZszmZt = new BdcCxZszmZt();
                        bdcCxZszmZt.setZtid(UUIDGenerator.generate18());
                        bdcCxZszmZt.setCqzh(CommonUtil.formatEmptyValue(gdZsMap.get("CQZH")));
                        if (StringUtils.isNotBlank(CommonUtil.formatEmptyValue(gdZsMap.get("BDCLX")))) {
                            bdcCxZszmZt.setBdclx(CommonUtil.formatEmptyValue(gdZsMap.get("BDCLX")));
                            if (StringUtils.equals(Constants.BDCLX_TDFW, CommonUtil.formatEmptyValue(gdZsMap.get("BDCLX")))) {
                                bdcCxZszmZt.setSjly(Constants.XMLY_FWSP);
                            } else if (StringUtils.equals(Constants.BDCLX_TD, CommonUtil.formatEmptyValue(gdZsMap.get("BDCLX")))) {
                                bdcCxZszmZt.setSjly(Constants.XMLY_TDSP);
                            }
                        }
                        if (StringUtils.isNotBlank(CommonUtil.formatEmptyValue(gdZsMap.get("ZSLX")))) {
                            bdcCxZszmZt.setZslx(CommonUtil.formatEmptyValue(gdZsMap.get("ZSLX")));
                        }
                        if (StringUtils.isNotBlank(CommonUtil.formatEmptyValue(gdZsMap.get("ISZX"))) && StringUtils.equals("1", CommonUtil.formatEmptyValue(gdZsMap.get("ISZX")))) {
                            bdcCxZszmZt.setZsqszt(Constants.QLLX_QSZT_HR.toString());
                        } else {
                            bdcCxZszmZt.setZsqszt(Constants.QLLX_QSZT_XS.toString());
                        }
                        entityMapper.saveOrUpdate(bdcCxZszmZt, bdcCxZszmZt.getZtid());
                    }
                }
            }
        }
    }

    /**
     * @Author:<a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @param:bdcdyh 不动产单元号
     * @param:bdclx 不动产类型
     * @Description:更新证书证明权属状态为不动产权证书设计
     * @Date 15:46 2017/11/23
     */
    @Override
    public Boolean updateZszmQsztForBdc(BdcCxZszmZt bdcCxZszmZt) {
        Boolean bool = false;
        if (bdcCxZszmZt != null && StringUtils.isNotBlank(bdcCxZszmZt.getCqzh())) {
            //jyl 初始化现势等状态
            String proid = bdcZsService.getProidByBdcqzh(bdcCxZszmZt.getCqzh());
            if (StringUtils.isNotBlank(proid)) {
                QllxVo qllxVo = qllxService.getQllxVoByProid(proid);
                QllxVo xqllxVo = qllxService.queryQllxVo(qllxVo, proid);
                if (xqllxVo != null && xqllxVo.getQszt() != null) {
                    bdcCxZszmZt.setZsqszt(xqllxVo.getQszt().toString());
                } else {
                    bdcCxZszmZt.setZsqszt(Constants.QLLX_QSZT_HR.toString());
                }
                saveBdcCxZszmZt(bdcCxZszmZt);
                bool = true;
            }
        }
        return bool;
    }

    /**
     * @Author:<a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @param:bdcdyh 不动产单元号
     * @param:bdclx 不动产类型
     * @Description:更新证书证明权属状态为过渡证书和证明设计
     * @Date 15:46 2017/11/23
     */
    @Override
    public Boolean updateZszmQsztForGd(BdcCxZszmZt bdcCxZszmZt) {
        Boolean bool = false;
        if (bdcCxZszmZt != null && StringUtils.isNotBlank(bdcCxZszmZt.getCqzh())) {
            String qlCqzh = "";
            if (StringUtils.indexOf(bdcCxZszmZt.getCqzh(), ",") == -1) {
                List<GdFwsyq> gdFwsyqList = gdFwService.getGdFwsyqListByFczh(bdcCxZszmZt.getCqzh());
                if (CollectionUtils.isEmpty(gdFwsyqList)) {
                    List<GdTdsyq> gdTdsyqList = gdTdService.getGdTdsyqListByTdzh(bdcCxZszmZt.getCqzh());
                    if (CollectionUtils.isEmpty(gdTdsyqList)) {
                        List<GdQlr> gdQlrList = gdQlrService.getGdQlrListByCqzh(bdcCxZszmZt.getCqzh());
                        if (CollectionUtils.isNotEmpty(gdQlrList)) {
                            GdFwsyq gdFwsyq = gdFwService.queryGdFwsyqByQlid(gdQlrList.get(0).getQlid());
                            if (gdFwsyq != null) {
                                qlCqzh = gdFwsyq.getFczh();
                            } else {
                                GdTdsyq gdTdsyq = gdTdService.queryGdTdsyqByQlid(gdQlrList.get(0).getQlid());
                                if (gdTdsyq != null) {
                                    qlCqzh = gdTdsyq.getTdzh();
                                }
                            }
                        }
                    }
                }
            }
            if (StringUtils.isBlank(qlCqzh)) {
                qlCqzh = bdcCxZszmZt.getCqzh();
            }
            HashMap param = new HashMap();
            param.put("cqzh", qlCqzh);
            List<Map> gdZsList = gdXmMapper.listGdZsxx(param);
            //jyl 准确的证书list，like查的不准确。有特殊辣鸡数据包含（房产证是某个房产证的一部分，日）
            List<Map> zqZsList = new LinkedList<Map>();
            if (CollectionUtils.isNotEmpty(gdZsList)) {
                for (Map gdZsMap : gdZsList) {
                    if (StringUtils.isNotBlank(CommonUtil.formatEmptyValue(gdZsMap.get("CQZH")))) {
                        //hzj 判断过渡房屋所有权中有分别持证的情况
                        if (CommonUtil.formatEmptyValue(gdZsMap.get("CQZH")).indexOf(",") > -1) {
                            List<String> cqzhList = new LinkedList<String>();
                            String[] gdcqzh = CommonUtil.formatEmptyValue(gdZsMap.get("CQZH")).split(",");
                            cqzhList.addAll(Arrays.asList(gdcqzh));
                            if (null != cqzhList && CollectionUtils.isNotEmpty(cqzhList)) {
                                for (String cqzh : cqzhList) {
                                    if (StringUtils.equals(bdcCxZszmZt.getCqzh(), cqzh)) {
                                        zqZsList.add(gdZsMap);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(zqZsList)) {
                Map gdZsMap = zqZsList.get(0);
                if (gdZsMap != null && StringUtils.isNotBlank(CommonUtil.formatEmptyValue(gdZsMap.get("ISZX"))) && StringUtils.equals("1", CommonUtil.formatEmptyValue(gdZsMap.get("ISZX")))) {
                    bdcCxZszmZt.setZsqszt(Constants.QLLX_QSZT_HR.toString());
                } else {
                    bdcCxZszmZt.setZsqszt(Constants.QLLX_QSZT_XS.toString());
                }
                saveBdcCxZszmZt(bdcCxZszmZt);
                bool = true;
            }
        }
        return bool;
    }

    /**
     * @Author:<a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @param:bdcdyh 不动产单元号
     * @param:bdclx 不动产类型
     * @Description:更新证书证明状态为不动产权证书设计
     * @Date 15:46 2017/11/23
     */
    @Override
    public Boolean updateZszmQlztForBdcqz(BdcCxZszmZt bdcCxZszmZt) {
        Boolean bool = false;
        if (bdcCxZszmZt != null && StringUtils.isNotBlank(bdcCxZszmZt.getCqzh())) {
            //jyl 考虑不动产的附属设施和主房的关系（以后可能出现的一证多房），都存在一本证书对应多个不动产单元
            List<String> bdcdyhs = bdcZsService.getBdcdyhByBdcqzh(bdcCxZszmZt.getCqzh());
            if (CollectionUtils.isNotEmpty(bdcdyhs)) {
                IdModel idModel = getXgIdModelForBdcqz(bdcdyhs, bdcCxZszmZt.getBdclx());
                if (null != idModel) {
                    Map qlslMap = bdcCxBdcdyZtService.queryQLsl(idModel);
                    updateQlzt(bdcCxZszmZt, qlslMap);
                    bool = true;
                }
            }
        }
        return bool;
    }

    /**
     * @Author:<a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @param:bdcdyh 不动产单元号
     * @param:bdclx 不动产类型
     * @Description:为过渡房产证设计
     * @Date 15:46 2017/11/23
     */
    @Override
    public Boolean updateZszmQlztForGdTdz(BdcCxZszmZt bdcCxZszmZt) {
        Boolean bool = false;
        if (bdcCxZszmZt != null && StringUtils.isNotBlank(bdcCxZszmZt.getCqzh())) {
            //jyl 过渡土地证获取相关IdModel
            List<String> tdids = gdTdMapper.listTdidByTdzh(bdcCxZszmZt.getCqzh());
            if (CollectionUtils.isNotEmpty(tdids)) {
                IdModel idModel = getXgIdModelForGdTdz(tdids, bdcCxZszmZt.getBdclx());
                if (null != idModel) {
                    Map qlslMap = bdcCxBdcdyZtService.queryQLsl(idModel);
                    updateQlzt(bdcCxZszmZt, qlslMap);
                    bool = true;
                }
            }

        }
        return bool;
    }

    /**
     * @Author:<a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @param:bdcdyh 不动产单元号
     * @param:bdclx 不动产类型
     * @Description:为过渡房产证设计
     * @Date 15:46 2017/11/23
     */
    @Override
    public Boolean updateZszmQlztForGdFcz(BdcCxZszmZt bdcCxZszmZt) {
        Boolean bool = false;
        if (bdcCxZszmZt != null && StringUtils.isNotBlank(bdcCxZszmZt.getCqzh())) {
            String qlCqzh = "";
            if (StringUtils.indexOf(bdcCxZszmZt.getCqzh(), ",") == -1) {
                List<GdFwsyq> gdFwsyqList = gdFwService.getGdFwsyqListByFczh(bdcCxZszmZt.getCqzh());
                if (CollectionUtils.isEmpty(gdFwsyqList)) {
                    List<GdTdsyq> gdTdsyqList = gdTdService.getGdTdsyqListByTdzh(bdcCxZszmZt.getCqzh());
                    if (CollectionUtils.isEmpty(gdTdsyqList)) {
                        List<GdQlr> gdQlrList = gdQlrService.getGdQlrListByCqzh(bdcCxZszmZt.getCqzh());
                        if (CollectionUtils.isNotEmpty(gdQlrList)) {
                            GdFwsyq gdFwsyq = gdFwService.queryGdFwsyqByQlid(gdQlrList.get(0).getQlid());
                            if (gdFwsyq != null) {
                                qlCqzh = gdFwsyq.getFczh();
                            } else {
                                GdTdsyq gdTdsyq = gdTdService.queryGdTdsyqByQlid(gdQlrList.get(0).getQlid());
                                if (gdTdsyq != null) {
                                    qlCqzh = gdTdsyq.getTdzh();
                                }
                            }
                        }
                    }
                }
            }
            if (StringUtils.isBlank(qlCqzh)) {
                qlCqzh = bdcCxZszmZt.getCqzh();
            }
            //jyl 过渡房屋证获取相关IdModel
            List<String> fwids = gdFwMapper.listFwidByFczh(qlCqzh);
            if (CollectionUtils.isNotEmpty(fwids)) {
                IdModel idModel = getXgIdModelForGdFcz(fwids, bdcCxZszmZt.getBdclx());
                if (null != idModel) {
                    Map qlslMap = bdcCxBdcdyZtService.queryQLsl(idModel);
                    updateQlzt(bdcCxZszmZt, qlslMap);
                    bool = true;
                }
            }
        }
        return bool;
    }

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param:bdczslist
     * @Description:
     * @Date 10:35 2018/1/2
     */
    @Override
    public Boolean deleteZszmZtByBdcqz(List<BdcZs> bdcZsList) {
        Boolean msg = false;
        List<String> cqzhList = new LinkedList<String>();
        if (null != bdcZsList && CollectionUtils.isNotEmpty(bdcZsList)) {
            for (BdcZs bdcZs : bdcZsList) {
                if (StringUtils.isNotBlank(bdcZs.getBdcqzh())) {
                    cqzhList.add(bdcZs.getBdcqzh());
                }
            }
        }
        if (CollectionUtils.isNotEmpty(cqzhList)) {
            Map map = new HashMap();
            map.put("cqzhList", cqzhList);
            bdcCxZszmZtMapper.deleteZszmZtBycqzh(map);
            msg = true;
        }
        return msg;
    }

    /**
     * @param fwids       过渡房产证对应的所有房屋id
     * @param bdclx:不动产类型
     * @return
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 获取过渡房产证相关的不动产单元号，房屋和土地的集合
     */
    private IdModel getXgIdModelForGdFcz(List<String> fwids, String bdclx) {
        IdModel idModelAll = new IdModel();
        List<String> bdcdyhList = new LinkedList<String>();
        List<String> fwidList = new LinkedList<String>();
        List<String> tdisList = new LinkedList<String>();
        if (CollectionUtils.isNotEmpty(fwids) && StringUtils.isNotBlank(bdclx)) {
            for (String fwid : fwids) {
                IdModel idModel = bdcCxBdcdyZtService.getXgIdModelByFwidForSyq(fwid);
                if (idModel != null) {
                    List<String> bdcdyhsTemp = idModel.getBdcdyhs();
                    List<String> fwidsTemp = idModel.getFwids();
                    List<String> tdidsTemp = idModel.getTdids();
                    bdcdyhList = qczhList(bdcdyhList, bdcdyhsTemp);
                    fwidList = qczhList(fwidList, fwidsTemp);
                    tdisList = qczhList(tdisList, tdidsTemp);
                }
            }
        }
        idModelAll.setBdcdyhs(bdcdyhList);
        idModelAll.setFwids(fwidList);
        idModelAll.setTdids(tdisList);
        return idModelAll;
    }

    /**
     * @param tdids       过渡土地证对应的所有土地id
     * @param bdclx:不动产类型
     * @return
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 获取过渡土地证相关的不动产单元号，房屋和土地的集合
     */
    private IdModel getXgIdModelForGdTdz(List<String> tdids, String bdclx) {
        IdModel idModelAll = new IdModel();
        List<String> bdcdyhList = new LinkedList<String>();
        List<String> fwidList = new LinkedList<String>();
        List<String> tdisList = new LinkedList<String>();
        if (CollectionUtils.isNotEmpty(tdids) && StringUtils.isNotBlank(bdclx)) {
            for (String tdid : tdids) {
                IdModel idModel = bdcCxBdcdyZtService.getXgIdModelByTdidForSyq(tdid);
                if (idModel != null) {
                    List<String> bdcdyhsTemp = idModel.getBdcdyhs();
                    List<String> fwidsTemp = idModel.getFwids();
                    List<String> tdidsTemp = idModel.getTdids();
                    bdcdyhList = qczhList(bdcdyhList, bdcdyhsTemp);
                    fwidList = qczhList(fwidList, fwidsTemp);
                    tdisList = qczhList(tdisList, tdidsTemp);
                }
            }
        }
        idModelAll.setBdcdyhs(bdcdyhList);
        idModelAll.setFwids(fwidList);
        idModelAll.setTdids(tdisList);
        return idModelAll;
    }

    /**
     * @param bdcdyhs     不动产证书对应的所有不动产单元号
     * @param bdclx:不动产类型
     * @return
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 获取不动产权证相关的不动产单元号，房屋和土地的集合
     */
    private IdModel getXgIdModelForBdcqz(List<String> bdcdyhs, String bdclx) {
        IdModel idModelAll = new IdModel();
        List<String> bdcdyhList = new LinkedList<String>();
        List<String> fwidList = new LinkedList<String>();
        List<String> tdisList = new LinkedList<String>();
        if (CollectionUtils.isNotEmpty(bdcdyhs) && StringUtils.isNotBlank(bdclx)) {
            for (String bdcdyh : bdcdyhs) {
                IdModel idModel = bdcCxBdcdyZtService.getXgIdModelForBdcdy(bdcdyh, bdclx);
                if (idModel != null) {
                    List<String> bdcdyhsTemp = idModel.getBdcdyhs();
                    List<String> fwidsTemp = idModel.getFwids();
                    List<String> tdidsTemp = idModel.getTdids();
                    bdcdyhList = qczhList(bdcdyhList, bdcdyhsTemp);
                    fwidList = qczhList(fwidList, fwidsTemp);
                    tdisList = qczhList(tdisList, tdidsTemp);
                }
            }
        }
        idModelAll.setBdcdyhs(bdcdyhList);
        idModelAll.setFwids(fwidList);
        idModelAll.setTdids(tdisList);
        return idModelAll;
    }

    /**
     * @param zList       主list
     * @param fList:辅list
     * @return
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 两个list去重并集
     */
    private List<String> qczhList(List<String> zList, List<String> fList) {
        if (CollectionUtils.isNotEmpty(fList)) {
            if (CollectionUtils.isEmpty(zList)) {
                zList.addAll(fList);
            } else {
                fList.removeAll(zList);
                zList.addAll(fList);
            }
        }
        return zList;
    }


    /**
     * @param bdcCxZszmZt
     * @param map:现势权利状态容器
     * @return
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 更新权利状态
     */
    private void updateQlzt(BdcCxZszmZt bdcCxZszmZt, Map map) {
        if (null != map.get("YG")) {
            bdcCxZszmZt.setXsygcs(Integer.valueOf(map.get("YG").toString()));
        }
        if (null != map.get("DYA")) {
            bdcCxZszmZt.setXsdyacs(Integer.valueOf(map.get("DYA").toString()));
        }
        if (null != map.get("CF")) {
            bdcCxZszmZt.setXscfcs(Integer.valueOf(map.get("CF").toString()));
        }
        if (null != map.get("YY")) {
            bdcCxZszmZt.setXsyycs(Integer.valueOf(map.get("YY").toString()));
        }
        if (null != map.get("YDYA")) {
            bdcCxZszmZt.setXsydyacs(Integer.valueOf(map.get("YDYA").toString()));
        }
        if (null != map.get("SCDJ")) {
            bdcCxZszmZt.setScdjzt(Integer.valueOf(map.get("SCDJ").toString()));
        }
        if (null != map.get("JJ")) {
            bdcCxZszmZt.setXsjzcs(Integer.valueOf(map.get("JZ").toString()));
        }
        if (null != map.get("YCF")) {
            bdcCxZszmZt.setXsycfcs(Integer.valueOf(map.get("YCF").toString()));
        }
        if (null != map.get("SD")) {
            bdcCxZszmZt.setXssdcs(Integer.valueOf(map.get("SD").toString()));
        }
        if (null != map.get("DYI")) {
            bdcCxZszmZt.setXsdyics(Integer.valueOf(map.get("DYI").toString()));
        }
        saveBdcCxZszmZt(bdcCxZszmZt);
    }

}
