package cn.gtmap.estateplat.config.service.ztxx.impl;/*
 * @author <a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
 * @version 1.0, 2018/1/4
 * @description
 */

import cn.gtmap.estateplat.config.core.model.IdModel;
import cn.gtmap.estateplat.config.core.service.*;
import cn.gtmap.estateplat.config.service.ztxx.BdcCxBdcdyZtService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.exchange.national.QlfQlZxdj;
import cn.gtmap.estateplat.model.server.core.*;
import cn.gtmap.estateplat.service.config.GxztService;
import cn.gtmap.estateplat.service.config.QlztService;
import cn.gtmap.estateplat.service.exchange.share.RealEstateShareService;
import cn.gtmap.estateplat.utils.CalendarUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class GxztServiceImpl implements GxztService {
    @Autowired
    BdcCxBdcdyZtService bdcCxBdcdyZtService;
    @Autowired
    BdcZsService bdcZsService;
    @Autowired
    BdcXmService bdcXmService;
    @Autowired
    BdcXmRelService bdcXmRelService;
    @Autowired
    GdXmService gdXmService;
    @Autowired
    BdcdyService bdcdyService;
    @Autowired
    QllxService qllxService;
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    BdcFdcqDzService bdcFdcqDzService;
    @Autowired
    QlztService qlztService;
    @Autowired
    BdcGdDyhRelService gdDyhRelService;
    @Autowired
    RealEstateShareService realEstateShareService;

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param:wiid
     * @Description:通过proid获取共享更新需要的list
     * @Date 16:06 2018/1/3
     */
    @Override
    public List<QlfQlZxdj> getGxListByWiid(String wiid) {
        List<QlfQlZxdj> qlfQlZxdjList = new LinkedList<QlfQlZxdj>();
        List<Map<String, Object>> mapList = getFzParasByWiidForGx(wiid);
        for (Map map : mapList) {
            if (map.containsKey("proid") && null != map.get("proid") && null != map.get("yproidList")) {
                String proid = map.get("proid").toString();
                List<String> yproidList = (List<String>) map.get("yproidList");
                //调gx的接口返回List<Map<String, String>>
                yproidList = glYproidList(yproidList);
                if (null != yproidList && yproidList.size() > 0) {
                    for (String yproid : yproidList) {
                        QlfQlZxdj qlfQlZxdj = getQlfQlZxdj(proid, yproid);
                        if (null != qlfQlZxdj) {
                            qlfQlZxdjList.add(qlfQlZxdj);
                        }
                    }
                }
            }
        }
        return qlfQlZxdjList;
    }

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param:wiid
     * @Description:通过wiid获取原项目yproidList
     * @Date 16:08 2018/1/3
     */
    @Override
    public Map getGxYproidsByWiid(String wiid, String isCompara) {
        Map map = new HashMap();
        List<String> proidList = new LinkedList<String>();
        List<String> yproidList = new LinkedList<String>();
        List<String> bdcqzList = new LinkedList<String>();
        List<String> gdcqzList = new LinkedList<String>();
//        List<String> newBdcqzList = new LinkedList<String>();
        if (StringUtils.isNotBlank(wiid)) {
            //hzj 获取当前流程wiid的proids和所有当前流程产生的zszmList
            List<BdcXm> bdcXmList = bdcXmService.getBdcXmListByWiid(wiid);
            if (null != bdcXmList && CollectionUtils.isNotEmpty(bdcXmList)) {
                for (BdcXm bdcXm : bdcXmList) {
                    if (!proidList.contains(bdcXm.getProid())) {
                        proidList.add(bdcXm.getProid());
                    }
                }
            }
//            List<String> zszmList=bdcZsService.listPlZsZmhByWiid(wiid);
            //hzj 获取当前流程所有当前和相关联的产权证号集合
            List<Map<String, Object>> cqzhList = qlztService.listCqzt(wiid);
            if (null != cqzhList && CollectionUtils.isNotEmpty(cqzhList)) {
                for (Map<String, Object> result : cqzhList) {
                    if (result.containsKey("cqzh") && result.get("cqzh") != null && result.containsKey("bdclx") && result.get("bdclx") != null) {
                        if (StringUtils.equals(Constants.XMLY_BDC, result.get("bdclx").toString())) {
                            if (!bdcqzList.contains(result.get("cqzh").toString())) {
                                bdcqzList.add(result.get("cqzh").toString());
                            }
                        } else {
                            if (!gdcqzList.contains(result.get("cqzh").toString())) {
                                gdcqzList.add(result.get("cqzh").toString());
                            }
                        }
                    }
                }
            }
            //不动产权找不动产项目
            if (null != bdcqzList && CollectionUtils.isNotEmpty(bdcqzList)) {
                List<BdcXm> bdcXms = bdcZsService.getBdcXmByBdcqzh(bdcqzList);
                if (CollectionUtils.isNotEmpty(bdcXms)) {
                    for (BdcXm bdcxm1 : bdcXms) {
                        if (bdcxm1 != null && StringUtils.isNotBlank(bdcxm1.getProid())) {
                            if (!yproidList.contains(bdcxm1.getProid())) {
                                yproidList.add(bdcxm1.getProid());
                            }
                        }
                    }
                }
            }
            //过渡产权找过渡项目
            if (null != gdcqzList && CollectionUtils.isNotEmpty(gdcqzList)) {
                for (String gdcqzh : gdcqzList) {
                    List<String> gdproids = gdXmService.getGdproidByCqzh(gdcqzh);
                    if (null != gdproids && CollectionUtils.isNotEmpty(gdproids)) {
                        for (String gdproid : gdproids) {
                            if (StringUtils.isNotBlank(gdproid) && !yproidList.contains(gdproid)) {
                                yproidList.add(gdproid);
                            }
                        }
                    }
                }
            }
            //过滤当前项目proids
            if (null != yproidList && CollectionUtils.isNotEmpty(yproidList)) {
                yproidList.removeAll(proidList);
            }
        }
        //hzj 判断调用者是否需要对比过滤 yproidList
        if (isCompara != "" && StringUtils.isNotBlank(isCompara) && StringUtils.equals(isCompara, "true")) {
            yproidList = glYproidList(yproidList);
        }
        map.put("proidList", proidList);
        map.put("yproidList", yproidList);
        return map;
    }

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param: yproidList
     * @Description:与共享对比进行yproidList过滤
     * @Date 14:28 2018/1/9
     */
    @Override
    public List<String> glYproidList(List<String> yproidList) {
        List<String> yproids = new LinkedList<String>();
        if (null != yproidList && CollectionUtils.isNotEmpty(yproidList)) {
            //调gx的接口返回List<Map<String, String>>
            List<Map<String, String>> mapList = new LinkedList<Map<String, String>>();
            mapList = realEstateShareService.queryQsztByYwh(yproidList);
            //用List<Map> 去再一次过滤yproidList
            yproids = filterYproids(mapList);
        }
//        List<Map<String, Object>> mapList=getFzParasByWiidForGx("21A922522GWLT702");
        return yproids;

    }

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param:List<map>
     * @Description:通过gx接口返回的值进行权属状态对比过滤不同的记录
     * @Date 10:45 2018/1/4
     */
    private List<String> filterYproids(List<Map<String, String>> mapList) {
        List<String> yproidList = new LinkedList<String>();
        if (null != mapList && CollectionUtils.isNotEmpty(mapList)) {
            for (Map<String, String> map : mapList) {
                //hzj 和登记库中找到的权属状态对比
                for (String key : new ArrayList<String>(map.keySet())) {
                    String qszt = map.get(key);
                    if (null != key && StringUtils.isNotBlank(qszt)) {
                        BdcXm bdcXm = bdcXmService.getBdcXmByProid(key);
                        if (null != bdcXm) {
                            QllxVo qllxVo = qllxService.queryQllxVo(bdcXm);
                            if (null != qllxVo && StringUtils.isNotBlank(qllxVo.getQszt().toString())) {
                                if (!StringUtils.equals(qszt, qllxVo.getQszt().toString())) {
                                    yproidList.add(key);
                                }
                            }
                        } else {
                            //找不到不动产的bdcxm则去找过渡库qszt
                            String gdqszt = gdXmService.getGdQsztByGdProid(key);
                            if (StringUtils.isNotBlank(gdqszt) && !StringUtils.equals(qszt, gdqszt)) {
                                yproidList.add(key);
                            }
                        }
                    }
                }
            }
        }
        return yproidList;
    }


    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param:proid、yproid
     * @Description:QlfQlZxdj
     * @Date 17:23 2018/1/4
     */
    private QlfQlZxdj getQlfQlZxdj(String proid, String yproid) {
        QlfQlZxdj qlfQlZxdj = new QlfQlZxdj();
        if (StringUtils.isNotBlank(proid) && StringUtils.isNotBlank(yproid)) {
            qlfQlZxdj.setYwh(proid);
            qlfQlZxdj.setZxywh(yproid);
            QllxVo qllxVo = qllxService.getQllxVoByProid(yproid);
            BdcXm dqBdcxm = bdcXmService.getBdcXmByProid(proid);
            if (null != qllxVo) {
                qlfQlZxdj = setBdcQlfQlZxdjByQllxVo(qllxVo, yproid, qlfQlZxdj);
                List<BdcZs> bdcZs = bdcZsService.getBdcZsByProid(yproid);
                if (CollectionUtils.isNotEmpty(bdcZs)) {
                    qlfQlZxdj.setBdcdyh(bdcZs.get(0).getBdcdyh());
                    qlfQlZxdj.setBdcqzh(bdcZs.get(0).getBdcqzh());
                }
                BdcXm bdcXm = bdcXmService.getBdcXmByProid(yproid);
                if (null != bdcXm) {
                    //处理不动产的数据
                    qlfQlZxdj.setQxdm(bdcXm.getDwdm());
                    qlfQlZxdj.setDjjg(bdcXm.getDjjg());
                    qlfQlZxdj.setZxsj(bdcXm.getBjsj());
                }
            } else {
                if (null != dqBdcxm) {
                    qlfQlZxdj.setQxdm(dqBdcxm.getDwdm());
                    qlfQlZxdj.setZxsj(dqBdcxm.getBjsj());
                    qlfQlZxdj.setDjjg(dqBdcxm.getDjjg());
                }
                //处理过渡的数据
                List<String> bdcdyhList = new LinkedList<String>();
                List<BdcGdDyhRel> bdcGdDyhRelList = gdDyhRelService.getGdDyhRelByGdproid(yproid);
                if (null != bdcGdDyhRelList && CollectionUtils.isNotEmpty(bdcGdDyhRelList)) {
                    for (BdcGdDyhRel bdcGdDyhRel : bdcGdDyhRelList) {
                        if (StringUtils.isNotBlank(bdcGdDyhRel.getBdcdyh())) {
                            bdcdyhList.add(bdcGdDyhRel.getBdcdyh());
                        }
                    }
                }
                if (CollectionUtils.isNotEmpty(bdcdyhList)) {
                    qlfQlZxdj.setBdcdyh(bdcdyhList.get(0));
                }
                String gdcqzh = gdXmService.getCqzhByGdproid(yproid);
                if (StringUtils.isNotBlank(gdcqzh)) {
                    qlfQlZxdj.setBdcqzh(gdcqzh);
                }
                Map gdCqzhMap = gdXmService.getGxObjectByGdproid(yproid);
                if (null != gdCqzhMap) {
                    if (null != gdCqzhMap.get("dbr")) {
                        qlfQlZxdj.setDbr(gdCqzhMap.get("dbr").toString());
                    }
                    if (null != gdCqzhMap.get("djsj")) {
                        qlfQlZxdj.setDjsj(CalendarUtil.formatDate(gdCqzhMap.get("djsj").toString()));
                    }
                    if (null != gdCqzhMap.get("fj")) {
                        qlfQlZxdj.setBz(gdCqzhMap.get("fj").toString());
                    }
                }
            }
        }
        return qlfQlZxdj;
    }

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param:qllxVo、yproid、qlfQlZxdj
     * @Description:从不动产库中找相应的权利赋值QlfQlZxdj
     * @Date 20:26 2018/1/4
     */
    private QlfQlZxdj setBdcQlfQlZxdjByQllxVo(QllxVo qllxVo, String yproid, QlfQlZxdj qlfQlZxdj) {
        if (qllxVo instanceof BdcCf) {
            BdcCf bdcCf = new BdcCf();
            Example example = new Example(BdcCf.class);
            example.createCriteria().andEqualTo("proid", yproid);
            List<BdcCf> cfList = entityMapper.selectByExample(example);
            if (cfList != null && cfList.size() > 0) {
                bdcCf = cfList.get(0);
            }
            if (null != bdcCf && null != bdcCf.getJfdjsj()) {
                qlfQlZxdj.setDbr(bdcCf.getJfdbr());
                qlfQlZxdj.setDjsj(bdcCf.getDjsj());
                qlfQlZxdj.setBz(bdcCf.getFj());
            }
        }
        if (qllxVo instanceof BdcDyaq) {
            BdcDyaq bdcDyaq = new BdcDyaq();
            Example example = new Example(BdcDyaq.class);
            example.createCriteria().andEqualTo("proid", yproid);
            List<BdcDyaq> bdcDyaqList = entityMapper.selectByExample(example);
            if (bdcDyaqList != null && bdcDyaqList.size() > 0) {
                bdcDyaq = bdcDyaqList.get(0);
            }
            if (null != bdcDyaq && null != bdcDyaq.getDbr()) {
                qlfQlZxdj.setDbr(bdcDyaq.getDbr());
                qlfQlZxdj.setDjsj(bdcDyaq.getDjsj());
                qlfQlZxdj.setBz(bdcDyaq.getFj());
            }
        }
        if (qllxVo instanceof BdcDyq) {
            BdcDyq bdcDyq = new BdcDyq();
            Example example = new Example(BdcDyq.class);
            example.createCriteria().andEqualTo("proid", yproid);
            List<BdcDyq> bdcDyqList = entityMapper.selectByExample(example);
            if (bdcDyqList != null && bdcDyqList.size() > 0) {
                bdcDyq = bdcDyqList.get(0);
            }
            if (null != bdcDyq && null != bdcDyq.getDbr()) {
                qlfQlZxdj.setDbr(bdcDyq.getDbr());
                qlfQlZxdj.setDjsj(bdcDyq.getDjsj());
                qlfQlZxdj.setBz(bdcDyq.getFj());
            }
        }
        if (qllxVo instanceof BdcFdcq) {
            BdcFdcq bdcFdcq = new BdcFdcq();
            Example example = new Example(BdcFdcq.class);
            example.createCriteria().andEqualTo("proid", yproid);
            List<BdcFdcq> bdcFdcqList = entityMapper.selectByExample(example);
            if (bdcFdcqList != null && bdcFdcqList.size() > 0) {
                bdcFdcq = bdcFdcqList.get(0);
            }
            if (null != bdcFdcq && null != bdcFdcq.getDbr()) {
                qlfQlZxdj.setDbr(bdcFdcq.getDbr());
                qlfQlZxdj.setDjsj(bdcFdcq.getDjsj());
                qlfQlZxdj.setBz(bdcFdcq.getFj());
            }
        }
        if (qllxVo instanceof BdcFdcq) {
            BdcFdcqDz bdcFdcqDz = new BdcFdcqDz();
            bdcFdcqDz = bdcFdcqDzService.getBdcFdcqDzByProid(yproid);
            if (null != bdcFdcqDz && null != bdcFdcqDz.getDbr()) {
                qlfQlZxdj.setDbr(bdcFdcqDz.getDbr());
                qlfQlZxdj.setDjsj(bdcFdcqDz.getDjsj());
                qlfQlZxdj.setBz(bdcFdcqDz.getFj());
            }
        }
        if (qllxVo instanceof BdcHysyq) {
            BdcHysyq bdcHysyq = new BdcHysyq();
            Example example = new Example(BdcHysyq.class);
            example.createCriteria().andEqualTo("proid", yproid);
            List<BdcHysyq> bdcHysyqList = entityMapper.selectByExample(example);
            if (bdcHysyqList != null && bdcHysyqList.size() > 0) {
                bdcHysyq = bdcHysyqList.get(0);
            }
            if (null != bdcHysyq && null != bdcHysyq.getDbr()) {
                qlfQlZxdj.setDbr(bdcHysyq.getDbr());
                qlfQlZxdj.setDjsj(bdcHysyq.getDjsj());
                qlfQlZxdj.setBz(bdcHysyq.getFj());
            }
        }
        if (qllxVo instanceof BdcJsydzjdsyq) {
            BdcJsydzjdsyq bdcJsydzjdsyq = new BdcJsydzjdsyq();
            Example example = new Example(BdcJsydzjdsyq.class);
            example.createCriteria().andEqualTo("proid", yproid);
            List<BdcJsydzjdsyq> bdcJsydzjdsyqList = entityMapper.selectByExample(example);
            if (bdcJsydzjdsyqList != null && bdcJsydzjdsyqList.size() > 0) {
                bdcJsydzjdsyq = bdcJsydzjdsyqList.get(0);
            }
            if (null != bdcJsydzjdsyq && null != bdcJsydzjdsyq.getDbr()) {
                qlfQlZxdj.setDbr(bdcJsydzjdsyq.getDbr());
                qlfQlZxdj.setDjsj(bdcJsydzjdsyq.getDjsj());
                qlfQlZxdj.setBz(bdcJsydzjdsyq.getFj());
            }
        }
        if (qllxVo instanceof BdcJzwgy) {
            BdcJzwgy bdcJzwgy = new BdcJzwgy();
            Example example = new Example(BdcJzwgy.class);
            example.createCriteria().andEqualTo("proid", yproid);
            List<BdcJzwgy> bdcJzwgyList = entityMapper.selectByExample(example);
            if (bdcJzwgyList != null && bdcJzwgyList.size() > 0) {
                bdcJzwgy = bdcJzwgyList.get(0);
            }
            if (null != bdcJzwgy && null != bdcJzwgy.getDbr()) {
                qlfQlZxdj.setDbr(bdcJzwgy.getDbr());
                qlfQlZxdj.setDjsj(bdcJzwgy.getDjsj());
                qlfQlZxdj.setBz(bdcJzwgy.getFj());
            }
        }
        if (qllxVo instanceof BdcJzwsyq) {
            BdcJzwsyq bdcJzwsyq = new BdcJzwsyq();
            Example example = new Example(BdcJzwsyq.class);
            example.createCriteria().andEqualTo("proid", yproid);
            List<BdcJzwsyq> bdcJzwsyqList = entityMapper.selectByExample(example);
            if (bdcJzwsyqList != null && bdcJzwsyqList.size() > 0) {
                bdcJzwsyq = bdcJzwsyqList.get(0);
            }
            if (null != bdcJzwsyq && null != bdcJzwsyq.getDbr()) {
                qlfQlZxdj.setDbr(bdcJzwsyq.getDbr());
                qlfQlZxdj.setDjsj(bdcJzwsyq.getDjsj());
                qlfQlZxdj.setBz(bdcJzwsyq.getFj());
            }
        }
        if (qllxVo instanceof BdcLq) {
            BdcLq bdcLq = new BdcLq();
            Example example = new Example(BdcLq.class);
            example.createCriteria().andEqualTo("proid", yproid);
            List<BdcLq> bdcLqList = entityMapper.selectByExample(example);
            if (bdcLqList != null && bdcLqList.size() > 0) {
                bdcLq = bdcLqList.get(0);
            }
            if (null != bdcLq && null != bdcLq.getDbr()) {
                qlfQlZxdj.setDbr(bdcLq.getDbr());
                qlfQlZxdj.setDjsj(bdcLq.getDjsj());
                qlfQlZxdj.setBz(bdcLq.getFj());
            }
        }
        if (qllxVo instanceof BdcQsq) {
            BdcQsq bdcQsq = new BdcQsq();
            Example example = new Example(BdcQsq.class);
            example.createCriteria().andEqualTo("proid", yproid);
            List<BdcQsq> bdcQsqList = entityMapper.selectByExample(example);
            if (bdcQsqList != null && bdcQsqList.size() > 0) {
                bdcQsq = bdcQsqList.get(0);
            }
            if (null != bdcQsq && null != bdcQsq.getDbr()) {
                qlfQlZxdj.setDbr(bdcQsq.getDbr());
                qlfQlZxdj.setDjsj(bdcQsq.getDjsj());
                qlfQlZxdj.setBz(bdcQsq.getFj());
            }
        }
        if (qllxVo instanceof BdcTdcbnydsyq) {
            BdcTdcbnydsyq bdcTdcbnydsyq = new BdcTdcbnydsyq();
            Example example = new Example(BdcTdcbnydsyq.class);
            example.createCriteria().andEqualTo("proid", yproid);
            List<BdcTdcbnydsyq> bdcTdcbnydsyqList = entityMapper.selectByExample(example);
            if (bdcTdcbnydsyqList != null && bdcTdcbnydsyqList.size() > 0) {
                bdcTdcbnydsyq = bdcTdcbnydsyqList.get(0);
            }
            if (null != bdcTdcbnydsyq && null != bdcTdcbnydsyq.getDbr()) {
                qlfQlZxdj.setDbr(bdcTdcbnydsyq.getDbr());
                qlfQlZxdj.setDjsj(bdcTdcbnydsyq.getDjsj());
                qlfQlZxdj.setBz(bdcTdcbnydsyq.getFj());
            }
        }
        if (qllxVo instanceof BdcTdsyq) {
            BdcTdsyq bdcTdsyq = new BdcTdsyq();
            Example example = new Example(BdcTdsyq.class);
            example.createCriteria().andEqualTo("proid", yproid);
            List<BdcTdsyq> bdcTdsyqList = entityMapper.selectByExample(example);
            if (bdcTdsyqList != null && bdcTdsyqList.size() > 0) {
                bdcTdsyq = bdcTdsyqList.get(0);
            }
            if (null != bdcTdsyq && null != bdcTdsyq.getDbr()) {
                qlfQlZxdj.setDbr(bdcTdsyq.getDbr());
                qlfQlZxdj.setDjsj(bdcTdsyq.getDjsj());
                qlfQlZxdj.setBz(bdcTdsyq.getFj());
            }
        }
        if (qllxVo instanceof BdcYg) {
            BdcYg bdcYg = new BdcYg();
            Example example = new Example(BdcYg.class);
            example.createCriteria().andEqualTo("proid", yproid);
            List<BdcYg> bdcYgList = entityMapper.selectByExample(example);
            if (bdcYgList != null && bdcYgList.size() > 0) {
                bdcYg = bdcYgList.get(0);
            }
            if (null != bdcYg && null != bdcYg.getDbr()) {
                qlfQlZxdj.setDbr(bdcYg.getDbr());
                qlfQlZxdj.setDjsj(bdcYg.getDjsj());
                qlfQlZxdj.setBz(bdcYg.getFj());
            }
        }
        if (qllxVo instanceof BdcYy) {
            BdcYy bdcYy = new BdcYy();
            Example example = new Example(BdcYy.class);
            example.createCriteria().andEqualTo("proid", yproid);
            List<BdcYy> bdcYyList = entityMapper.selectByExample(example);
            if (bdcYyList != null && bdcYyList.size() > 0) {
                bdcYy = bdcYyList.get(0);
            }
            if (null != bdcYy && null != bdcYy.getDbr()) {
                qlfQlZxdj.setDbr(bdcYy.getDbr());
                qlfQlZxdj.setDjsj(bdcYy.getDjsj());
                qlfQlZxdj.setBz(bdcYy.getFj());
            }
        }
        return qlfQlZxdj;
    }

    //hzj  为了gx的分组产权证证号
    private List<Map<String, Object>> getFzParasByWiidForGx(String wiid) {
        List<Map<String, Object>> mapList = new LinkedList<Map<String, Object>>();
        List<Map> lsMaps = new LinkedList<Map>();
        List<Map> xmgxMaps = new LinkedList<Map>();
        List<Map> qcMapList = new LinkedList<Map>();
        List<Map> bdcdyMaps = new LinkedList<Map>();
        if (StringUtils.isNotBlank(wiid)) {
            //jyl 获取当前流程的原权利证书证明号，然后更新证书证明表的状态
            List<BdcXmRel> bdcXmRelList = bdcXmRelService.listBdcXmRelByWiid(wiid);
            if (CollectionUtils.isNotEmpty(bdcXmRelList)) {
                for (BdcXmRel bdcXmRel : bdcXmRelList) {
                    Map map = new HashMap();
                    List<String> zsZmhs = new LinkedList<String>();
                    List<String> gdZsZmhs = new LinkedList<String>();
                    String xmly = "";
                    if (StringUtils.isNotBlank(bdcXmRel.getYdjxmly())) {
                        xmly = bdcXmRel.getYdjxmly();
                    } else if (StringUtils.isNotBlank(bdcXmRel.getYqlid())) {
                        xmly = Constants.XMLY_FWSP;
                    } else {
                        xmly = Constants.XMLY_BDC;
                    }
                    //jyl 获取当前流程的新生成的证书证明号,然后更新证书证明表的状态
                    zsZmhs = bdcZsService.listPlZsZmhByProid(bdcXmRel.getProid());
                    if (null == zsZmhs) {
                        zsZmhs = new LinkedList<String>();
                    }
                    //jyl 查询原权利来不动产数据
                    if (StringUtils.equals(xmly, Constants.XMLY_BDC) && StringUtils.isNotBlank(bdcXmRel.getYproid())) {
                        List<String> zsZmhList = bdcZsService.listPlZsZmhByProid(bdcXmRel.getYproid());
                        if (null != zsZmhList) {
                            zsZmhs.addAll(zsZmhList);
                        }
                    } else if (!StringUtils.equals(xmly, Constants.XMLY_BDC) && StringUtils.isNotBlank(bdcXmRel.getYqlid())) {
                        //jyl 查询原权利来过渡数据
                        gdZsZmhs = gdXmService.listPlCqzhByQlid(bdcXmRel.getYqlid());
                    }
                    map.put("proid", bdcXmRel.getProid());
                    map.put("bdcqzList", zsZmhs);
                    map.put("gdcqzList", gdZsZmhs);
                    xmgxMaps.add(map);
                }
                //hzj 处理xmrel表中重复proid情况
                List<BdcXm> bdcXmList = bdcXmService.getBdcXmListByWiid(wiid);
                if (null != xmgxMaps && CollectionUtils.isNotEmpty(xmgxMaps)) {
                    for (BdcXm bdcXm : bdcXmList) {
                        Map qcMap = new ExtendedProperties();
                        List<String> zsZmhs = new LinkedList<String>();
                        List<String> gdZsZmhs = new LinkedList<String>();
                        String proid = bdcXm.getProid();
                        for (Map map : xmgxMaps) {
                            if (StringUtils.equals((String) map.get("proid"), proid)) {
                                List<String> lsZsZmhs = (List<String>) map.get("bdcqzList");
                                List<String> lsGdZmhs = (List<String>) map.get("gdcqzList");
                                if (null != lsZsZmhs) {
                                    for (String zszmh : lsZsZmhs) {
                                        if (!zsZmhs.contains(zszmh)) {
                                            zsZmhs.add(zszmh);
                                        }
                                    }
                                }
                                if (null != lsGdZmhs) {
                                    for (String gdzszmh : lsGdZmhs) {
                                        if (!gdZsZmhs.contains(gdzszmh)) {
                                            gdZsZmhs.add(gdzszmh);
                                        }
                                    }
                                }
                            }
                        }
                        qcMap.put("proid", proid);
                        qcMap.put("bdcqzList", zsZmhs);
                        qcMap.put("gdcqzList", gdZsZmhs);
                        qcMapList.add(qcMap);
                    }
                }
            }
            //jyl上面是根据当前流程找，上下手所有证号，下面 根据物的关系再找所有相关证号。为了防止特殊情况如外联证书，不匹配不动产流程等
            List<BdcXm> bdcXmList = bdcXmService.getBdcXmListByWiid(wiid);
            for (BdcXm bdcXm : bdcXmList) {
                Map map = new HashMap();
                List<String> zsZmhs = new LinkedList<String>();
                List<String> gdZsZmhs = new LinkedList<String>();
                List<String> fwidList = new LinkedList<String>();
                List<String> tdisList = new LinkedList<String>();
                BdcBdcdy bdcBdcdy = bdcdyService.queryBdcBdcdyByProid(bdcXm.getProid());
                if (null != bdcBdcdy) {
                    if (StringUtils.isNotBlank(bdcBdcdy.getBdcdyid()) && StringUtils.isNotBlank(bdcBdcdy.getBdcdyh()) && StringUtils.isNotBlank(bdcBdcdy.getBdclx())) {
                        //jyl 整理该不动产单元做过的产生证书或证明的流程
                        List<String> proidList = bdcXmService.listZsZmProidByBdcdyid(bdcBdcdy.getBdcdyid());
                        if (CollectionUtils.isNotEmpty(proidList)) {
                            zsZmhs = bdcZsService.listPlZsZmhByProids(proidList);
                        }
                        //jyl整理出所有的房屋和土地，更新他们身上的所有证书证明的状态
                        IdModel idModel = bdcCxBdcdyZtService.getXgIdModelForBdcdy(bdcBdcdy.getBdcdyh(), bdcBdcdy.getBdclx());
                        if (idModel != null) {
                            List<String> fwidsTemp = idModel.getFwids();
                            List<String> tdidsTemp = idModel.getTdids();
                            fwidList = qczhList(fwidList, fwidsTemp);
                            tdisList = qczhList(tdisList, tdidsTemp);
                        }
                        if (CollectionUtils.isNotEmpty(fwidList)) {
                            for (String fwid : fwidList) {
                                if (StringUtils.isNotBlank(fwid)) {
                                    List<String> fwzhList = gdXmService.listCqzhByFwid(fwid);
                                    if (null != fwzhList) {
                                        gdZsZmhs.addAll(fwzhList);
                                    }
                                }
                            }
                        }
                        if (CollectionUtils.isNotEmpty(tdisList)) {
                            for (String tdid : tdisList) {
                                if (StringUtils.isNotBlank(tdid)) {
                                    List<String> tdzhList = gdXmService.listCqzhByTdid(tdid);
                                    if (null != tdzhList) {
                                        gdZsZmhs.addAll(tdzhList);
                                    }
                                }
                            }
                        }
                    }
                }
                map.put("proid", bdcXm.getProid());
                map.put("bdcqzList", zsZmhs);
                map.put("gdcqzList", gdZsZmhs);
                bdcdyMaps.add(map);
            }
            if (null != qcMapList && qcMapList.size() > 0) {
                for (Map map : qcMapList) {
                    Map lsMap = new HashMap();
                    String proid = "";
                    if (null != map.get("proid")) {
                        proid = map.get("proid").toString();
                    }
                    List<String> bdcqzList = (List<String>) map.get("bdcqzList");
                    List<String> gdcqzList = (List<String>) map.get("gdcqzList");
                    if (null != bdcdyMaps && bdcdyMaps.size() > 0) {
                        for (Map bdcMap : bdcdyMaps) {
                            String oneProid = "";
                            if (null != map.get("proid")) {
                                oneProid = map.get("proid").toString();
                            }
                            if (StringUtils.equals(proid, oneProid)) {
                                if (null != bdcMap.get("bdcqzList")) {
                                    if (bdcMap.get("bdcqzList").toString().length() > 2) {
                                        List<String> lsBdcqzList = (List<String>) bdcMap.get("bdcqzList");
                                        if (null != lsBdcqzList) {
                                            for (String isBdcqz : lsBdcqzList) {
                                                if (!bdcqzList.contains(isBdcqz)) {
                                                    bdcqzList.add(isBdcqz);
                                                }
                                            }
                                        }
                                    }
                                }
                                if (null != bdcMap.get("gdcqzList")) {
                                    if (bdcMap.get("gdcqzList").toString().length() > 2) {
                                        List<String> lsGdqzList = (List<String>) bdcMap.get("gdcqzList");
                                        if (null != lsGdqzList) {
                                            for (String isGdcqz : lsGdqzList) {
                                                if (!gdcqzList.contains(isGdcqz)) {
                                                    gdcqzList.add(isGdcqz);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    lsMap.put("proid", proid);
                    lsMap.put("bdcqzList", bdcqzList);
                    lsMap.put("gdcqzList", gdcqzList);
                    lsMaps.add(lsMap);
                }
            }
            if (null != lsMaps && lsMaps.size() > 0) {
                for (Map map : lsMaps) {
                    Map<String, Object> zzMap = new ExtendedProperties();
                    String proid = map.get("proid").toString();
                    List<String> yproidList = new LinkedList<String>();
                    List<String> bdcqzList = new LinkedList<String>();
                    if (map.get("bdcqzList").toString().length() > 2) {
                        bdcqzList = (List<String>) map.get("bdcqzList");
                    }
                    //不动产权找不动产项目
                    if (null != bdcqzList && CollectionUtils.isNotEmpty(bdcqzList)) {
                        List<BdcXm> bdcXms = bdcZsService.getBdcXmByBdcqzh(bdcqzList);
                        if (CollectionUtils.isNotEmpty(bdcXms)) {
                            for (BdcXm bdcxm1 : bdcXms) {
                                if (bdcxm1 != null && StringUtils.isNotBlank(bdcxm1.getProid())) {
                                    if (!yproidList.contains(bdcxm1.getProid())) {
                                        yproidList.add(bdcxm1.getProid());
                                    }
                                }
                            }
                        }
                    }
                    //去掉当前不动产的proid
                    yproidList.remove(proid);
                    List<String> gdcqzList = new LinkedList<String>();
                    if (map.get("gdcqzList").toString().length() > 2) {
                        gdcqzList = (List<String>) map.get("gdcqzList");
                    }
                    //过渡产权找过渡项目
                    if (null != gdcqzList && CollectionUtils.isNotEmpty(gdcqzList)) {
                        for (String gdcqzh : gdcqzList) {
                            List<String> gdproids = gdXmService.getGdproidByCqzh(gdcqzh);
                            if (null != gdproids && CollectionUtils.isNotEmpty(gdproids)) {
                                for (String newGdProid : gdproids) {
                                    if (StringUtils.isNotBlank(newGdProid) && !yproidList.contains(newGdProid)) {
                                        yproidList.add(newGdProid);
                                    }
                                }
                            }
                        }
                    }
                    zzMap.put("proid", proid);
                    zzMap.put("yproidList", yproidList);
                    mapList.add(zzMap);
                }
            }
        }
        return mapList;
    }

    /**
     * @param zList       主list
     * @param fList:辅list
     * @return
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 两个list去重并集
     */
    private List<String> qczhList(List<String> zList, List<String> fList) {
        if (CollectionUtils.isNotEmpty(fList)) {
            if (CollectionUtils.isEmpty(zList)) {
                zList.addAll(fList);
            } else {
                fList.removeAll(zList);
                zList.addAll(fList);
            }
        }
        return zList;
    }
}
