package cn.gtmap.estateplat.config.service.ztxx.impl;
/*
 * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
 * @version 1.0, 2017/12/11
 * @description 权利状态服务
 */

import cn.gtmap.estateplat.config.core.mapper.config.BdcCxBdcdyZtMapper;
import cn.gtmap.estateplat.config.core.mapper.config.BdcCxZszmZtMapper;
import cn.gtmap.estateplat.config.core.mapper.config.GdXmMapper;
import cn.gtmap.estateplat.config.core.mapper.sjgl.DjsjCxBdcdyZtMapper;
import cn.gtmap.estateplat.config.core.model.IdModel;
import cn.gtmap.estateplat.config.core.service.*;
import cn.gtmap.estateplat.config.service.ztxx.BdcCxBdcdyZtService;
import cn.gtmap.estateplat.config.service.ztxx.BdcCxZszmZtService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.model.config.BdcCxBdcdyZt;
import cn.gtmap.estateplat.model.server.core.*;
import cn.gtmap.estateplat.service.config.QlztService;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.util.ThreadPool;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class QlztServiceImpl implements QlztService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    BdcCxZszmZtService bdcCxZszmZtService;
    @Autowired
    BdcCxBdcdyZtService bdcCxBdcdyZtService;
    @Autowired
    BdcZsService bdcZsService;
    @Autowired
    GdXmMapper gdXmMapper;
    @Autowired
    BdcXmService bdcXmService;
    @Autowired
    BdcXmRelService bdcXmRelService;
    @Autowired
    GdXmService gdXmService;
    @Autowired
    BdcdyService bdcdyService;
    @Autowired
    BdcCxZszmZtMapper bdcCxZszmZtMapper;
    @Autowired
    BdcCxBdcdyZtMapper bdcCxBdcdyZtMapper;
    @Autowired
    DjsjCxBdcdyZtMapper djsjCxBdcdyZtMapper;
    @Autowired
    private GdFwService gdFwService;
    @Autowired
    private GdQlrService gdQlrService;
    @Autowired
    private GdTdService gdTdService;

    /**
     * @param cqzh(不动产权证号，房产证号，土地证号)；xmly：数据来源
     * @return 返回信息
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 更新证书证明查询表权利状态
     */
    @Override
    public Boolean updateZszmZtByCqzh(String cqzh, String xmly) {
        Boolean bool = false;
        //jyl 如果证书证明状态表存在该证号的信息更新，否则新增插入
        BdcCxZszmZt bdcCxZszmZt = bdcCxZszmZtService.getBdcCxZszmZtByCqzh(cqzh);
        if (bdcCxZszmZt != null) {
            bdcCxZszmZtService.updateZszmZtByCqzh(bdcCxZszmZt);
        } else if (StringUtils.isNotBlank(xmly)) {
            if (StringUtils.equals(Constants.XMLY_BDC, xmly)) {
                HashMap param = new HashMap();
                param.put("bdcqzh", cqzh);
                List<BdcZs> bdcZsList = bdcZsService.getBdcZsList(param);
                if (CollectionUtils.isNotEmpty(bdcZsList)) {
                    bdcCxZszmZtService.initBdcZs(bdcZsList);
                    bdcCxZszmZt = bdcCxZszmZtService.getBdcCxZszmZtByCqzh(cqzh);
                    if (bdcCxZszmZt != null) {
                        bdcCxZszmZtService.updateZszmZtByCqzh(bdcCxZszmZt);
                    }
                }
            } else {
                String qlCqzh = "";
                if (StringUtils.indexOf(cqzh, ",") == -1) {
                    List<GdFwsyq> gdFwsyqList = gdFwService.getGdFwsyqListByFczh(cqzh);
                    if (CollectionUtils.isEmpty(gdFwsyqList)) {
                        List<GdTdsyq> gdTdsyqList = gdTdService.getGdTdsyqListByTdzh(cqzh);
                        if (CollectionUtils.isEmpty(gdTdsyqList)) {
                            List<GdQlr> gdQlrList = gdQlrService.getGdQlrListByCqzh(cqzh);
                            if (CollectionUtils.isNotEmpty(gdQlrList)) {
                                GdFwsyq gdFwsyq = gdFwService.queryGdFwsyqByQlid(gdQlrList.get(0).getQlid());
                                if (gdFwsyq != null) {
                                    qlCqzh = gdFwsyq.getFczh();
                                } else {
                                    GdTdsyq gdTdsyq = gdTdService.queryGdTdsyqByQlid(gdQlrList.get(0).getQlid());
                                    if (gdTdsyq != null) {
                                        qlCqzh = gdTdsyq.getTdzh();
                                    }
                                }
                            }
                        }
                    }
                }
                if (StringUtils.isBlank(qlCqzh)) {
                    qlCqzh = cqzh;
                }
                HashMap param = new HashMap();
                param.put("cqzh", qlCqzh);
                List<Map> gdZsList = gdXmMapper.listGdZsxx(param);
                //hzj 考虑分别持证证号
                if (cqzh.indexOf(",") > 0) {
                    List<String> cqzhList = new LinkedList<String>();
                    String[] gdcqzh = cqzh.split(",");
                    cqzhList.addAll(Arrays.asList(gdcqzh));
                    for (String newCqzh : cqzhList) {
                        bdcCxZszmZt = bdcCxZszmZtService.getBdcCxZszmZtByCqzh(newCqzh);
                        if (bdcCxZszmZt != null) {
                            bdcCxZszmZtService.updateZszmZtByCqzh(bdcCxZszmZt);
                        } else {
                            if (CollectionUtils.isNotEmpty(gdZsList)) {
                                bdcCxZszmZtService.initGdZs(gdZsList);
                                bdcCxZszmZt = bdcCxZszmZtService.getBdcCxZszmZtByCqzh(newCqzh);
                                if (bdcCxZszmZt != null) {
                                    bdcCxZszmZtService.updateZszmZtByCqzh(bdcCxZszmZt);
                                }
                            }
                        }
                    }
                } else {
                    if (CollectionUtils.isNotEmpty(gdZsList)) {
                        bdcCxZszmZtService.initGdZs(gdZsList);
                        bdcCxZszmZt = bdcCxZszmZtService.getBdcCxZszmZtByCqzh(cqzh);
                        if (bdcCxZszmZt != null) {
                            bdcCxZszmZtService.updateZszmZtByCqzh(bdcCxZszmZt);
                        }
                    }
                }
            }
        } else {
            //jyl 抛出项目来源为空的异常
            throw new AppException(1001);
        }
        return bool;
    }

    /**
     * @param proid 项目主键
     * @return 返回信息
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 更新证书证明查询表权利状态, 权利发生改变，该不动产单元所有证号都要更新
     */
    @Override
    public Boolean updateZszmZtByProid(String proid) {
        Boolean bool = false;
        if (StringUtils.isNotBlank(proid)) {
            List<String> bdcqzList = new LinkedList<String>();
            List<String> gdcqzList = new LinkedList<String>();
            BdcXm bdcXm = bdcXmService.getBdcXmByProid(proid);
            String hqYzh = AppConfig.getProperty("hqYzh");
            String[] hqYzhArr = null;
            if (StringUtils.isNoneBlank(hqYzh)) {
                hqYzhArr = hqYzh.split(",");
            }
            if (hqYzhArr != null && bdcXm != null) {
                for (String hqYzhCode : hqYzhArr) {
                    if (StringUtils.isNotBlank(hqYzhCode)) {
                        switch (Integer.parseInt(hqYzhCode)) {
                            case 1:
                                List<Map<String, Object>> resultList = listCqztByWiid(bdcXm.getWiid());
                                if (CollectionUtils.isNotEmpty(resultList)) {
                                    for (Map<String, Object> result : resultList) {
                                        if (result.containsKey("cqzh") && result.get("cqzh") != null && result.containsKey("bdclx") && result.get("bdclx") != null) {
                                            if (StringUtils.equals(Constants.XMLY_BDC, result.get("bdclx").toString())) {
                                                if (!bdcqzList.contains(result.get("cqzh").toString())) {
                                                    bdcqzList.add(result.get("cqzh").toString());
                                                }
                                            } else {
                                                if (!gdcqzList.contains(result.get("cqzh").toString())) {
                                                    gdcqzList.add(result.get("cqzh").toString());
                                                }
                                            }
                                        }
                                    }
                                }
                                break;
                            default:
                        }
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(bdcqzList)) {
                for (String bdcqz : bdcqzList) {
                    updateZszmZtByCqzh(bdcqz, Constants.XMLY_BDC);
                }
            }
            if (CollectionUtils.isNotEmpty(gdcqzList)) {
                for (String gdcqz : gdcqzList) {
                    updateZszmZtByCqzh(gdcqz, Constants.XMLY_FWSP);
                }
            }
        }
        return bool;
    }

    /**
     * @param wiid 流程id
     * @return 返回信息
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 获取流程所有相关证号
     */
    @Override
    public List<Map<String, Object>> listCqzt(String wiid) {

        List<Map<String, Object>> cqztList = Lists.newArrayList();
        if (StringUtils.isNotBlank(wiid)) {
            String hqYzh = AppConfig.getProperty("hqYzh");
            String[] hqYzhArr = null;
            if (StringUtils.isNoneBlank(hqYzh)) {
                hqYzhArr = hqYzh.split(",");
            }
            if (hqYzhArr != null) {
                for (String hqYzhCode : hqYzhArr) {
                    if (StringUtils.isNotBlank(hqYzhCode)) {
                        switch (Integer.parseInt(hqYzhCode)) {
                            case 1:
                                List<Map<String, Object>> resultList = listCqztByWiid(wiid);
                                if (CollectionUtils.isNotEmpty(resultList)) {
                                    cqztList.addAll(resultList);
                                }
                                break;
                            default:
                        }
                    }
                }
            }
        }
        return cqztList;
    }

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param:常州云平台管理调用的获取状态方法
     * @Description:
     * @Date 8:58 2018/1/17
     */
    @Override
    public BdcCxZszmZt getZsZmztByCqzh(String cqzh) {
        BdcCxZszmZt bdcCxZszmZt = null;
        if (StringUtils.isNotBlank(cqzh)) {
            bdcCxZszmZt = bdcCxZszmZtService.getBdcCxZszmZtByCqzh(cqzh);
            //HZJ 如果证书证明状态表中没有 则初始化
            if (null == bdcCxZszmZt) {
                //先到不动产库中去找当前的cqzh
                Map map = new HashMap();
                map.put("bdcqzh", cqzh);
                List<BdcZs> bdcZsList = bdcZsService.getBdcZsList(map);
                if (CollectionUtils.isNotEmpty(bdcZsList)) {
                    bdcCxZszmZtService.initBdcZs(bdcZsList);
                } else {
                    String qlCqzh = "";
                    if (StringUtils.indexOf(bdcCxZszmZt.getCqzh(), ",") == -1) {
                        List<GdFwsyq> gdFwsyqList = gdFwService.getGdFwsyqListByFczh(cqzh);
                        if (CollectionUtils.isEmpty(gdFwsyqList)) {
                            List<GdTdsyq> gdTdsyqList = gdTdService.getGdTdsyqListByTdzh(cqzh);
                            if (CollectionUtils.isEmpty(gdTdsyqList)) {
                                List<GdQlr> gdQlrList = gdQlrService.getGdQlrListByCqzh(cqzh);
                                if (CollectionUtils.isNotEmpty(gdQlrList)) {
                                    GdFwsyq gdFwsyq = gdFwService.queryGdFwsyqByQlid(gdQlrList.get(0).getQlid());
                                    if (gdFwsyq != null) {
                                        qlCqzh = gdFwsyq.getFczh();
                                    } else {
                                        GdTdsyq gdTdsyq = gdTdService.queryGdTdsyqByQlid(gdQlrList.get(0).getQlid());
                                        if (gdTdsyq != null) {
                                            qlCqzh = gdTdsyq.getTdzh();
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (StringUtils.isBlank(qlCqzh)) {
                        qlCqzh = cqzh;
                    }
                    //hzj  在过渡库中找该cqzh
                    map.put("cqzh", qlCqzh);
                    List<Map> gdZsList = gdXmMapper.listGdZsxx(map);
                    if (null != gdZsList && CollectionUtils.isNotEmpty(gdZsList)) {
                        bdcCxZszmZtService.initGdZs(gdZsList);
                    }
                }
                //hzj 初始化后再去找该记录
                bdcCxZszmZt = bdcCxZszmZtService.getBdcCxZszmZtByCqzh(cqzh);
            }
            // 初始化权利状态
            //hzj xszt为true就要更新权利信息
            if (StringUtils.equals(AppConfig.getProperty("xszt"), "true") && null != bdcCxZszmZt) {
                if (StringUtils.isNotBlank(bdcCxZszmZt.getCqzh()) && StringUtils.isNotBlank(bdcCxZszmZt.getSjly())) {
                    bdcCxZszmZtService.updateZszmZtByCqzh(bdcCxZszmZt);
                    //最后找到最终的初始化后的记录
                    bdcCxZszmZt = bdcCxZszmZtService.getBdcCxZszmZtByCqzh(cqzh);
                }
            }
        }
        return bdcCxZszmZt;
    }

    @Override
    public String bdcdySd(String json) {
        List<String> bdcdyhList = JSON.parseArray(json, String.class);
        String result = bdcCxBdcdyZtService.updateSdByBdcdyh(bdcdyhList, 1);
        return result;
    }

    @Override
    public String bdcdyJs(String json) {
        List<String> bdcdyhList = JSON.parseArray(json, String.class);
        String result = bdcCxBdcdyZtService.updateSdByBdcdyh(bdcdyhList, -1);
        return result;
    }

    @Override
    public List<BdcCxBdcdyZt> getBdcCxBdcdyZtList(Map map) {
        List<BdcCxBdcdyZt> bdcCxBdcdyZtList = bdcCxBdcdyZtService.getBdcCxBdcdyZtList(map);
        return bdcCxBdcdyZtList;
    }

    private List<Map<String, Object>> listCqztByWiid(String wiid) {
        List<String> bdcqzList = new LinkedList<String>();
        List<String> gdcqzList = new LinkedList<String>();
        List<String> fwidList = new LinkedList<String>();
        List<String> tdisList = new LinkedList<String>();
        List<Map<String, Object>> resultList = Lists.newArrayList();
        if (StringUtils.isNotBlank(wiid)) {
            //jyl 获取当前流程的新生成的证书证明号,然后更新证书证明表的状态
            List<String> zsZmhList = bdcZsService.listPlZsZmhByWiid(wiid);
            if (CollectionUtils.isNotEmpty(zsZmhList)) {
                bdcqzList = qczhList(bdcqzList, zsZmhList);
            }
            //jyl 获取当前流程的原权利证书证明号，然后更新证书证明表的状态
            List<BdcXmRel> bdcXmRelList = bdcXmRelService.listBdcXmRelByWiid(wiid);
            if (CollectionUtils.isNotEmpty(bdcXmRelList)) {
                for (BdcXmRel bdcXmRel : bdcXmRelList) {
                    String xmly = "";
                    if (StringUtils.isNotBlank(bdcXmRel.getYdjxmly())) {
                        xmly = bdcXmRel.getYdjxmly();
                    } else if (StringUtils.isNotBlank(bdcXmRel.getYqlid())) {
                        xmly = Constants.XMLY_FWSP;
                    } else {
                        xmly = Constants.XMLY_BDC;
                    }
                    //jyl 查询原权利来不动产数据
                    if (StringUtils.equals(xmly, Constants.XMLY_BDC) && StringUtils.isNotBlank(bdcXmRel.getYproid())) {
                        List<String> zsZmhs = bdcZsService.listPlZsZmhByProid(bdcXmRel.getYproid());
                        if (CollectionUtils.isNotEmpty(zsZmhs)) {
                            bdcqzList = qczhList(bdcqzList, zsZmhs);
                        }
                    } else if (!StringUtils.equals(xmly, Constants.XMLY_BDC) && StringUtils.isNotBlank(bdcXmRel.getYqlid())) {
                        //jyl 查询原权利来过渡数据
                        List<String> gdZsZmhs = gdXmService.listPlCqzhByQlid(bdcXmRel.getYqlid());
                        if (CollectionUtils.isNotEmpty(gdZsZmhs)) {
                            gdcqzList = qczhList(gdcqzList, gdZsZmhs);
                        }
                    }
                }
            }
            //jyl上面是根据当前流程找，上下手所有证号，下面 根据物的关系再找所有相关证号。为了防止特殊情况如外联证书，不匹配不动产流程等
            List<BdcBdcdy> bdcBdcdyList = bdcdyService.listBdcBdcdy(wiid);
            if (CollectionUtils.isNotEmpty(bdcBdcdyList)) {
                for (BdcBdcdy bdcBdcdy : bdcBdcdyList) {
                    if (StringUtils.isNotBlank(bdcBdcdy.getBdcdyid()) && StringUtils.isNotBlank(bdcBdcdy.getBdcdyh()) && StringUtils.isNotBlank(bdcBdcdy.getBdclx())) {
                        //jyl 整理该不动产单元做过的产生证书或证明的流程
                        List<String> proidList = bdcXmService.listZsZmProidByBdcdyid(bdcBdcdy.getBdcdyid());
                        if (CollectionUtils.isNotEmpty(proidList)) {
                            List<String> zsZmhs = bdcZsService.listPlZsZmhByProids(proidList);
                            bdcqzList = qczhList(bdcqzList, zsZmhs);
                        }
                        //jyl整理出所有的房屋和土地，更新他们身上的所有证书证明的状态
                        IdModel idModel = bdcCxBdcdyZtService.getXgIdModelForBdcdy(bdcBdcdy.getBdcdyh(), bdcBdcdy.getBdclx());
                        if (idModel != null) {
                            List<String> fwidsTemp = idModel.getFwids();
                            List<String> tdidsTemp = idModel.getTdids();
                            fwidList = qczhList(fwidList, fwidsTemp);
                            tdisList = qczhList(tdisList, tdidsTemp);
                        }
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(fwidList)) {
                for (String fwid : fwidList) {
                    List<String> fwzhList = gdXmService.listCqzhByFwid(fwid);
                    gdcqzList = qczhList(gdcqzList, fwzhList);
                }
            }
            if (CollectionUtils.isNotEmpty(tdisList)) {
                for (String tdid : tdisList) {
                    if (StringUtils.isNotBlank(tdid)) {
                        List<String> tdzhList = gdXmService.listCqzhByTdid(tdid);
                        gdcqzList = qczhList(gdcqzList, tdzhList);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(bdcqzList)) {
                for (String bdcqz : bdcqzList) {
                    Map<String, Object> cqzhMap = new HashMap<String, Object>();
                    cqzhMap.put("cqzh", bdcqz);
                    cqzhMap.put("bdclx", Constants.XMLY_BDC);
                    resultList.add(cqzhMap);
                }
            }
            if (CollectionUtils.isNotEmpty(gdcqzList)) {
                for (String gdcqz : gdcqzList) {
                    Map<String, Object> cqzhMap = new HashMap<String, Object>();
                    cqzhMap.put("cqzh", gdcqz);
                    cqzhMap.put("bdclx", Constants.XMLY_FWSP);
                    resultList.add(cqzhMap);
                }
            }
        }
        return resultList;
    }

    /**
     * @param fwid 房屋id
     * @return 返回信息
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 更新证书证明查询表权利状态
     */
    @Override
    public Boolean updateZszmZtByFwid(String fwid) {
        Boolean bool = false;
        if (StringUtils.isNotBlank(fwid)) {
            List<String> cqzhList = gdXmService.listCqzhByFwid(fwid);
            if (CollectionUtils.isNotEmpty(cqzhList)) {
                for (String cqzh : cqzhList) {
                    if (StringUtils.isNotBlank(cqzh)) {
                        bool = updateZszmZtByCqzh(cqzh, Constants.XMLY_FWSP);
                    }
                }
            }
        }
        return bool;
    }

    /**
     * @param tdid
     * @return 返回信息
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 更新证书证明查询表权利状态
     */
    @Override
    public Boolean updateZszmZtByTdid(String tdid) {
        Boolean bool = false;
        if (StringUtils.isNotBlank(tdid)) {
            List<String> cqzhList = gdXmService.listCqzhByTdid(tdid);
            if (CollectionUtils.isNotEmpty(cqzhList)) {
                for (String cqzh : cqzhList) {
                    if (StringUtils.isNotBlank(cqzh)) {
                        bool = updateZszmZtByCqzh(cqzh, Constants.XMLY_TDSP);
                    }
                }
            }
        }
        return bool;
    }

    /**
     * @param bdcdyhList(不动产单元号）bdclx：不动产类型
     * @return 返回信息
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 更新不动产单元表权利状态
     */
    @Override
    public String updateBdcdyZtByBdcdyh(List<String> bdcdyhList, String bdclx) {
        String result = "faile";
        if (null != bdcdyhList && CollectionUtils.isNotEmpty(bdcdyhList)) {
            // 日志记录
            logger.info("更新不动产单元表权利状态：{}，请求时间：{}", bdcdyhList, new Date());
            result = bdcCxBdcdyZtService.updateBdcdyZtByBdcdyh(bdcdyhList, bdclx);
        }
        return result;
    }

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param:bdcdyh、ks 、ys
     * @Description:根据不动产单元号更新可售以及预售字段
     * @Date 10:49 2018/5/3
     */
    @Override
    public String updateKsYsByBdcdyh(final String json) {
        String result = "faile";
        long begintime = System.currentTimeMillis();
        ThreadPool.execute(new Runnable() {
            public void run() {
                List<BdcCxBdcdyZt> bdcCxBdcdyZtList = JSON.parseArray(json, BdcCxBdcdyZt.class);
                if (null != bdcCxBdcdyZtList && CollectionUtils.isNotEmpty(bdcCxBdcdyZtList)) {
                    for (BdcCxBdcdyZt bdcCxBdcdyZt : bdcCxBdcdyZtList) {
                        if (bdcCxBdcdyZt != null) {
                            bdcCxBdcdyZtService.updateKsYsByBdcdyh(bdcCxBdcdyZt.getBdcdyh(), bdcCxBdcdyZt.getKs(), bdcCxBdcdyZt.getYs());
                        }
                    }
                }
            }
        });
        long endtinme = System.currentTimeMillis();
        long costTime = (endtinme - begintime);
        System.out.println("updateKsYsByBdcdyh执行时间：" + costTime);
        result = "success";
        return result;
    }

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param:List<bdcZs>
     * @Description:通过参数证书删除证书证明状态管理记录
     * @Date 9:57 2018/1/2
     */
    @Override
    public Boolean updateZszmZtByDeleteEnvent(List<BdcZs> bdcZsList) {
        Boolean msg = false;
        if (CollectionUtils.isNotEmpty(bdcZsList)) {
            msg = bdcCxZszmZtService.deleteZszmZtByBdcqz(bdcZsList);
        }
        return msg;
    }

    /**
     * @param zList       主list
     * @param fList:辅list
     * @return
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 两个list去重并集
     */
    private List<String> qczhList(List<String> zList, List<String> fList) {
        if (CollectionUtils.isNotEmpty(fList)) {
            if (CollectionUtils.isEmpty(zList)) {
                zList.addAll(fList);
            } else {
                fList.removeAll(zList);
                zList.addAll(fList);
            }
        }
        return zList;
    }

    @Override
    public String bdcdySfba(String json) {
        List<BdcCxBdcdyZt> bdcCxBdcdyZtList = JSON.parseArray(json, BdcCxBdcdyZt.class);
        String result = "faile";
        if (null != bdcCxBdcdyZtList && CollectionUtils.isNotEmpty(bdcCxBdcdyZtList)) {
            for (BdcCxBdcdyZt bdcCxBdcdyZt : bdcCxBdcdyZtList) {
                if (bdcCxBdcdyZt != null) {
                    bdcCxBdcdyZtService.updateSfbaByBdcdyh(bdcCxBdcdyZt.getBdcdyh(), bdcCxBdcdyZt.getSfba());
                }
            }
            result = "success";
        }
        return result;
    }


    /**
     * @param bdcdyhList 不动产单元号
     * @param djzt       登记状态
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 保存登记状态
     */
    @Override
    public void saveBdcDjzt(List<String> bdcdyhList, String djzt) {
        if (CollectionUtils.isEmpty(bdcdyhList) || StringUtils.isBlank(djzt)) {
            throw new AppException("接口缺少参数", AppException.MISSING_ARG, new Object());
        }
        for (String bdcdyh : bdcdyhList) {
            BdcCxBdcdyZt bdcCxBdcdyZt = bdcCxBdcdyZtMapper.getBdcCxBdcdyZtByBdcdy(bdcdyh);
            if (bdcCxBdcdyZt != null) {
                bdcCxBdcdyZt.setDjzt(djzt);
                if (StringUtils.equals(bdcCxBdcdyZt.getLy(), "xs")) {
                    djsjCxBdcdyZtMapper.updateXsZt(bdcCxBdcdyZt);
                } else {
                    djsjCxBdcdyZtMapper.updateLsZt(bdcCxBdcdyZt);
                }
            } else {
                bdcCxBdcdyZt = new BdcCxBdcdyZt();
                bdcCxBdcdyZt.setZtid(UUIDGenerator.generate18());
                bdcCxBdcdyZt.setBdcdyh(bdcdyh);
                bdcCxBdcdyZt.setDjzt(djzt);
                bdcCxBdcdyZt.setLy("xs");
                djsjCxBdcdyZtMapper.insertXsZt(bdcCxBdcdyZt);
            }
        }
    }
}
