package cn.gtmap.estateplat.config.service.ztxx.impl;

import cn.gtmap.estateplat.config.core.mapper.sjgl.FwHsMapper;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.config.utils.JsonDateConvertUtil;
import cn.gtmap.estateplat.model.commodityHouse.projectManage.FcjyXjspfLjz;
import cn.gtmap.estateplat.model.commodityHouse.projectManage.FcjyXjspfh;
import cn.gtmap.estateplat.model.server.core.DjsjFwHs;
import cn.gtmap.estateplat.service.config.SynchroDjsjService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
 * @version 1.0, 2018-5-23
 * @description 同步地籍数据
 */
@Service
public class SynchroDjsjServiceImpl implements SynchroDjsjService {

    Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private FwHsMapper fwHsMapper;

    @Override
    public String synchroLjz(String json) {
        FcjyXjspfLjz fcjyXjspfLjz = (FcjyXjspfLjz)JsonDateConvertUtil.jsonDateConvert(json,FcjyXjspfLjz.class);
        String result = "fail";
        try {
            if(fcjyXjspfLjz!=null){
                fwHsMapper.updateLjz(fcjyXjspfLjz);
            }
            result = "success";
        } catch (Exception e) {
            LoggerFactory.getLogger(getClass()).error(Constants.ERROR_IN_FUNCTION, e);
        }
        return result;
    }

    @Override
    public String synchroH(String json) {
        List<FcjyXjspfh> fcjyXjspfhList = JSON.parseArray(json, FcjyXjspfh.class);
        String result = "fail";
        try {
            if (CollectionUtils.isNotEmpty(fcjyXjspfhList)) {
                for (FcjyXjspfh fcjyXjspfh : fcjyXjspfhList) {
                    String dwdm = AppConfig.getProperty("dwdm");
                    if (StringUtils.equals(dwdm, "211300")||StringUtils.equals(dwdm, "231000")||StringUtils.equals(dwdm, "210700")) {
                        fwHsMapper.updateFwHs(fcjyXjspfh);
                    } else {
                        if (StringUtils.equals(fcjyXjspfh.getYsc(), "SC")) {
                            fwHsMapper.updateFwHs(fcjyXjspfh);
                        } else {
                            fwHsMapper.updateFwYchs(fcjyXjspfh);
                        }
                    }
                }
            }
            result = "success";
        } catch (Exception e) {
            LoggerFactory.getLogger(getClass()).error(Constants.ERROR_IN_FUNCTION, e);
        }
        return result;
    }

    @Override
    public String synchroFwHsByArgs(Map args) {
        String result = "fail";
        try {
            if (MapUtils.isNotEmpty(args)) {
                if (args.get("hidList") != null || args.get("bdcdyhList") != null) {
                    fwHsMapper.updateFwHsByHidList(args);
                }
            }
            result = "success";
        } catch (Exception e) {
            LoggerFactory.getLogger(getClass()).error(Constants.ERROR_IN_FUNCTION, e);
        }
        return result;
    }

    @Override
    public String synchroFwYchsByArgs(Map args) {
        String result = "fail";
        try {
            if (MapUtils.isNotEmpty(args)) {
                if (args.get("hidList") != null || args.get("bdcdyhList") != null) {
                    fwHsMapper.updateFwYchsByHidList(args);
                }
            }
            result = "success";
        } catch (Exception e) {
            LoggerFactory.getLogger(getClass()).error(Constants.ERROR_IN_FUNCTION, e);
        }
        return result;
    }

    @Override
    public void clearFcjyXjspfLjzQybhByLjzid(String ljzid) {
        try {
            if(StringUtils.isNotBlank(ljzid)){
                fwHsMapper.clearFcjyXjspfLjzQybhByLjzid(ljzid);
            }
        }catch (Exception e){
            LoggerFactory.getLogger(getClass()).error(Constants.ERROR_IN_FUNCTION, e);
        }
    }

    @Override
    public String synchroFwHsSbjgByMap(Map args) {
        logger.info("synchroFwHsSbjgByMap.args:{}", JSONObject.toJSONString(args));
        String result = "fail";
        try {
            if (MapUtils.isNotEmpty(args)) {
                if (args.get("hidList") != null || args.get("bdcdyhList") != null) {
                    fwHsMapper.updateFwHsSbjgByHidList(args);
                }
            }
            result = "success";
        } catch (Exception e) {
            LoggerFactory.getLogger(getClass()).error(Constants.ERROR_IN_FUNCTION, e);
        }
        return result;
    }

    @Override
    public String synchroFwYchsSbjgByMap(Map args) {
        logger.info("synchroFwYchsSbjgByMap.args:{}", JSONObject.toJSONString(args));
        String result = "fail";
        try {
            if (MapUtils.isNotEmpty(args)) {
                if (args.get("hidList") != null || args.get("bdcdyhList") != null) {
                    fwHsMapper.updateFwYchsSbjgByHidList(args);
                }
            }
            result = "success";
        } catch (Exception e) {
            LoggerFactory.getLogger(getClass()).error(Constants.ERROR_IN_FUNCTION, e);
        }
        return result;
    }

    @Override
    public String synchroYxsH(String json,Integer yxs) {
        List<FcjyXjspfh> fcjyXjspfhList = JSON.parseArray(json, FcjyXjspfh.class);
        String result = "fail";
        try {
            if (CollectionUtils.isNotEmpty(fcjyXjspfhList)) {
                List<String> hidList = new ArrayList<String>();
                for (FcjyXjspfh fcjy : fcjyXjspfhList) {
                    if (StringUtils.isNotBlank(fcjy.getHid())) {
                        hidList.add(fcjy.getHid());
                    }
                }
                if (CollectionUtils.isNotEmpty(hidList) && yxs != null){
                    HashMap map = new HashMap();
                    map.put("hidList",hidList);
                    map.put("yxs",yxs);
                    fwHsMapper.updateFwhsYxsByHidList(map);
                }
            }
            result = "success";
        } catch (Exception e) {
            LoggerFactory.getLogger(getClass()).error(Constants.ERROR_IN_FUNCTION, e);
        }
        return result;
    }

    @Override
    public void insertFwHsByMap(Map args) {
        fwHsMapper.insertFwHsByMap(args);
    }

    @Override
    public void insertFwYchsByMap(Map args) {
        fwHsMapper.insertFwYchsByMap(args);
    }
}
