package cn.gtmap.estateplat.config.utils;

import cn.gtmap.estateplat.model.server.core.*;
import cn.gtmap.estateplat.utils.CalendarUtil;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.model.impl.File;
import com.gtis.fileCenter.service.NodeService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:zhaodongdong@gtmap.cn">zdd</a>
 * @version V1.0, 15-4-25
 */

public class ArchiveModel {


    public static Document createFwbdcXml(Document document, NodeService nodeService, BdcXm bdcXm, QllxVo qllxVo, BdcSpxx bdcSpxx, List<BdcQlr> bdcQlrList, List<BdcZs> bdcZsList, String archiveType, String mlh, List<BdcSjcl> bdcSjclList, String wfProid) {

        Element archivesElement=null;
        if(document!=null){
            archivesElement= document.getRootElement();
        }
        else{

            document = DocumentHelper.createDocument();
            document.setXMLEncoding("UTF-8");
            //创建根元素
            archivesElement=document.addElement("list");
        }

        //添加第一个档案节点
        Element archiveElement = archivesElement.addElement("archive");


        //添加节点的属性
        archiveElement.addAttribute("type", archiveType);

        String zl = "";
        String zdzhh = "";
        String bdcdyh = "";
        String yt = "";
        if (bdcSpxx != null) {
            if (StringUtils.isNotBlank(bdcSpxx.getZl())) {
                zl = bdcSpxx.getZl();
            }
            if (StringUtils.isNotBlank(bdcSpxx.getYt())) {
                yt = bdcSpxx.getYt();
            }
            bdcdyh = bdcSpxx.getBdcdyh();
            if (bdcdyh.length() > 19) {
                zdzhh = bdcdyh.substring(0, 19);
            }
        }

        String qlr = "";
        if (bdcQlrList != null && bdcQlrList.size() > 0) {
            for (BdcQlr bdcQlr : bdcQlrList) {
                if (qlr.equals("")) {
                    qlr = bdcQlr.getQlrmc();
                } else {
                    qlr = qlr + "/" + bdcQlr.getQlrmc();
                }
            }
        }

        String cqzh = "";
        String fzrq = "";
        if (bdcZsList != null && bdcZsList.size() > 0) {
            for (BdcZs bdcZs : bdcZsList) {
                if (cqzh.equals("")) {
                    cqzh = bdcZs.getBdcqzh();
                } else {
                    cqzh = cqzh + "/" + bdcZs.getBdcqzh();
                }
                if (bdcZs.getCzrq() != null) {
                    fzrq = CalendarUtil.formateDatetoStr(bdcZs.getCzrq());
                }
            }
        }

        String qllx = "";
        String dwdm = "";
        if (bdcXm != null) {
            if (bdcXm.getQllx() != null) {
                qllx = bdcXm.getQllx();
            }
            if (bdcXm.getDwdm() != null) {
                dwdm = bdcXm.getDwdm();
            }
        }

        //添加子节点   宗地宗海号
        Element field1 = archiveElement.addElement("field");
        field1.addAttribute("name", "zdzhh");
        field1.setText(zdzhh);

        //添加子节点   不动产单元号
        Element field2 = archiveElement.addElement("field");
        field2.addAttribute("name", "bdcdyh");
        field2.setText(bdcdyh);

        //添加子节点   目录号
        Element field8 = archiveElement.addElement("field");
        field8.addAttribute("name", "mlh");
        field8.setText(mlh);

        //添加子节点   权利人名称
        Element field3 = archiveElement.addElement("field");
        field3.addAttribute("name", "qlrmc");
        field3.setText(qlr);

        //添加子节点   坐落
        Element field4 = archiveElement.addElement("field");
        field4.addAttribute("name", "zl");
        field4.setText(zl);


        Element field5 = archiveElement.addElement("field");
        field5.addAttribute("name", "qllx");
        field5.setText(qllx);

        //添加子节点   不动产权证号
        Element field6 = archiveElement.addElement("field");
        field6.addAttribute("name", "bdcqzh");
        field6.setText(cqzh);

        //添加子节点   用途
        Element field7 = archiveElement.addElement("field");
        field7.addAttribute("name", "yt");
        field7.setText(yt);

        //添加子节点   发证日期
        Element field11 = archiveElement.addElement("field");
        field11.addAttribute("name", "fzrq");
        field11.setText(fzrq);


        //归档默认值

        Element field12 = archiveElement.addElement("field");
        field12.addAttribute("name", "bgqx");
        field12.setText("永久");

        Element field13 = archiveElement.addElement("field");
        field13.addAttribute("name", "mj");
        field13.setText("秘密");

        Element field14 = archiveElement.addElement("field");
        field14.addAttribute("name", "tm");
        field14.setText(qlr);

        //添加子节点 单位代码
        Element field15 = archiveElement.addElement("field");
        field15.addAttribute("name", "dwdm");
        field15.setText(dwdm);

        /**
         * @author bianwen
         * @description 获取案卷（即文件夹外的附件）
         */
        String fileCenterUrl = AppConfig.getFileCenterUrl();
        Space sourspace = nodeService.getWorkSpace("WORK_FLOW_STUFF", true);
        Node sournode = nodeService.getNode(sourspace.getId(), wfProid, true);
        List<Node> listNode = nodeService.getChildNodes(sournode.getId());

        if (listNode != null) {
            Integer size = listNode.size();
            for (int j = 0; j < size; j++) {
                try {
                    if (listNode.get(j) instanceof File) {
                        String url = fileCenterUrl + "/file/get.do?fid=" + listNode.get(j).getId();
                        Element field16 = archiveElement.addElement("file");
                        field16.addAttribute("url", url);
                        Element field16_1=field16.addElement("field");
                        field16_1.addAttribute("name", "relationid");
                        field16_1.setText(bdcXm.getWiid()+listNode.get(j).getId());
                    }
                } catch (Exception e) {
                    System.out.println("附件上传报错！");
                    continue;
                }
            }
        }

        /**
         * @author bianwen
         * @description  卷内附件
         */
        if(CollectionUtils.isNotEmpty(bdcSjclList)){
            for(BdcSjcl bdcSjcl : bdcSjclList){
                String sxh = bdcSjcl.getXh()+"";
                String tm = bdcSjcl.getClmc();
                Element field22 = archiveElement.addElement("doc");
                //添加子节点   顺序号
                Element field22_1 = field22.addElement("field");
                field22_1.addAttribute("name", "sxh");
                field22_1.setText(sxh);

                //添加子节点   题目
                Element field22_2 = field22.addElement("field");
                field22_2.addAttribute("name", "tm");
                field22_2.setText(tm);

                Node fileNode=  nodeService.getNode(sournode.getId(), tm, true);
                List<Node> childListNode = nodeService.getAllChildNodes(fileNode.getId());
                if (CollectionUtils.isNotEmpty(childListNode)) {
                    for (Node childNode : childListNode) {
                        String url = fileCenterUrl + "/file/get.do?fid=" + childNode.getId();
                        Element field22_5 = field22.addElement("file");
                        field22_5.addAttribute("url", url);
                        Element field22_5_1= field22_5.addElement("field");
                        field22_5_1.addAttribute("name", "relationid");
                        field22_5_1.setText(bdcXm.getWiid()+childNode.getId());
                    }
                }

            }


            Element field23 = archiveElement.addElement("field");
            field23.addAttribute("name", "proId");
            field23.setText(bdcXm.getProid());
        }

        return document;
    }
}
