package cn.gtmap.estateplat.config.utils;

import org.apache.commons.lang3.StringUtils;

import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 公共的类型
 */
public class Common {
    /**
     * 获取证书编号
     *
     * @param sqdm
     * @param bh
     * @param size
     * @return
     */
    public static String getBh(String sqdm, String bh, int size) {
        String zsbh = "";
        if (StringUtils.isNotBlank(bh) && size > 0) {
            String zero = "";
            while (size > 0) {
                zero += "0";
                size--;
            }
            DecimalFormat df = new DecimalFormat(zero);
            zsbh = sqdm + df.format(Integer.parseInt(bh));
        }
        return zsbh;
    }

    /**
     * 去除中文和括号,获取英文和数字
     * @param ordernumber1
     * @return
     */
    public static String getOrderNumber(String ordernumber1) {
        String returnValue= null;
        String regex ="[\u4e00-\u9fa5]";
        if(StringUtils.isNotBlank(ordernumber1)){
            Pattern pat = Pattern.compile(regex);
            Matcher mat = pat.matcher(ordernumber1);
            returnValue = mat.replaceAll("");
            returnValue=returnValue.replaceAll("（","").replaceAll("）","").replaceAll("\\(","").replaceAll("\\)","");
        }

        return returnValue;
    }
}
