package cn.gtmap.estateplat.config.utils;

import cn.gtmap.estateplat.utils.CommonUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.*;

/**
 * Created by user on 2016/3/10.
 */
public class PublicUtil {


    /*
   * zwq 实现类似js的join功能，即在字符中间添加分隔符
   * split（分隔符）
   * */
    public static String join(String split, List<String> list) {
        String result = "";
        StringBuffer sb = new StringBuffer();
        if (CollectionUtils.isNotEmpty(list)) {
            for (int i = 0; i != list.size(); i++) {
                if (i == 0) {
                    sb.append(list.get(i));
                } else {
                    sb.append(split).append(list.get(i));
                }
            }
            result = CommonUtil.formatEmptyValue(sb);
        }
        return result;
    }

    /*
    * zwq 实体类中一个字段的所有值用分隔符分开获得一个字符串
    * split:分隔符
    * list:装实体类的list
    * fieldName:要组织的实体类成员变量名
    * */

    public static String voJoin(String split, List<?> list, String fieldName) {
        String msg = "";
        List<String> fieldList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (Object object : list) {
                try {
                    Class objectClass = object.getClass();
                    Field field = objectClass.getDeclaredField(fieldName);
                    String firstLetter = field.getName().substring(0, 1).toUpperCase();
                    String getMethod = "get" + firstLetter + field.getName().substring(1);
                    Method method = objectClass.getMethod(getMethod);
                    Object value = method.invoke(object, new Object[]{});
                    if (value != null)
                        fieldList.add(CommonUtil.formatEmptyValue(value));
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        msg = join(split, fieldList);
        return msg;
    }

    /**
     * @author bianwen
     * @description 数组转set
     */
    public static Set arrayToSet(String[] arr) {

        //数组-->Set
        Set<String> set = new HashSet<String>(Arrays.asList(arr));
        return set;
    }

    /**
     * @param number
     * @return 百分比
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 处理权利比例百分比
     */
    public static String percentage(String number) {
        String percentage = "";
        if ((NumberUtils.isNumber(number))) {
            int qlbl = (int) (Double.parseDouble(number) * 100);
            percentage = qlbl + "%";
        }
        if (StringUtils.indexOf(number, "%") > -1) {
            percentage = number;
        }
        return percentage;
    }

    /**
     * 把 VO 中所有属性为 null 的转为 ""
     */
    public static void emptyConvertNull(Object obj) {
        if (obj != null) {
            Class classz = obj.getClass();
            // 获取所有该对象的属性值
            Field fields[] = classz.getDeclaredFields();
            // 遍历属性值，取得所有属性为 null 值的
            for (Field field : fields) {
                try {
                    Type t = field.getGenericType();
                    if (!t.toString().equals("boolean")) {
                        Method m = classz.getMethod("get" + change(field.getName()));
                        Object name = m.invoke(obj);// 调用该字段的get方法
                        if (name != null && StringUtils.isBlank(name.toString())) {
                            Method mtd = classz.getMethod("set" + change(field.getName()), new Class[]{String.class});// 取得所需类的方法对象
                            mtd.invoke(obj, new Object[]{null});// 执行相应赋值方法
                        }
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * @param src 源字符串
     * @return 字符串，将src的第一个字母转换为大写，src为空时返回null
     */
    public static String change(String src) {
        if (src != null) {
            StringBuffer sb = new StringBuffer(src);
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
            return sb.toString();
        } else {
            return null;
        }
    }

    /**
     * @author <a href="mailto:liangqing@gtmap.cn;">liangqing</a>
     * @version 1.0, 2017-06-08
     * @description 封装三目运算符转换公共方法
     */
    public static String ternaryOperator(Object object) {
        return object != null ? object.toString() : "";
    }
}
