package cn.gtmap.estateplat.config.utils;

import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/**
 * @version 1.0, 2017/6/30.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
public class ReadXmlProps {
    /**
     * zwq
     * 标准单位获取
     *
     * @return
     */
    public static HashMap<String, String> getdwYz() {
        HashMap hashMap = new HashMap();
        SAXReader sr = new SAXReader();
        Document document = null;
        try {
            document = sr.read(AppConfig.getEgovHome() + "/conf/server/dwYz-props.xml");
        } catch (DocumentException e) {
        }
        if (document != null) {
            Element root = document.getRootElement();
            Element foo;
            Iterator i = root.elementIterator("qllx");
            while (i.hasNext()) {
                foo = (Element) i.next();
                if (foo != null) {
                    hashMap.put(foo.elementText("qllxdm"), foo.elementText("dw"));
                }
            }
        }
        return hashMap;
    }

    /**
     * @param
     * @return
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 根据权利类型获取url
     */
    public static String getQllxUrl(String qllx) {
        String url = StringUtils.EMPTY;
        SAXReader sr = new SAXReader();
        Document document = null;
        try {
            document = sr.read(AppConfig.getEgovHome() + "/conf/config/qllxUrl.xml");
        } catch (DocumentException e) {
        }
        if (document != null) {
            Element root = document.getRootElement();
            List urls = root.selectNodes("//urls/qllx[@dm='" + qllx + "']/url");
            for (Object tempUrl : urls) {
                if (tempUrl instanceof Node) {
                    url = ((Node) tempUrl).getText();
                }
            }
        }
        return url;
    }

    /**
     * @param zdZhTzm
     * @param dzwTzm
     * @return qllx
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description
     */
    public static String getQllx(String zdZhTzm, String dzwTzm) {
        String qllx = StringUtils.EMPTY;
        SAXReader sr = new SAXReader();
        Document document = null;
        try {
            document = sr.read(AppConfig.getEgovHome() + "/conf/config/tzmQllx.xml");
        } catch (DocumentException e) {
            e.printStackTrace();
        }
        if (document != null) {
            Element root = document.getRootElement();
            List qllxdms = root.selectNodes("//tzms/zdZhTzm[@dm='" + zdZhTzm + "']/dzwTzm[@dm='" + dzwTzm + "']/qllxdm");
            for (Object tempQllx : qllxdms) {
                if (tempQllx instanceof Node) {
                    qllx = ((Node) tempQllx).getText();
                }
            }
        }
        return qllx;
    }

    /**
     * @param
     * @return
     * @author <a href="mailto:lijian@gtmap.cn">lijian</a>
     * @description 获取必填字段
     */
    public static String getLimitField(String name) {
        String fileds = StringUtils.EMPTY;
        SAXReader sr = new SAXReader();
        Document document = null;
        try {
            document = sr.read(AppConfig.getEgovHome() + "/conf/config/limitField.xml");
        } catch (DocumentException e) {
        }
        if (document != null) {
            Element root = document.getRootElement();
            List limitFields = root.selectNodes("//properties/file[@name='" + name + "']/field");
            if (CollectionUtils.isNotEmpty(limitFields)) {
                Node node = (Node) limitFields.get(0);
                fileds = node.getText();
            }
        }
        return fileds;
    }

    public static List<String> getUnExamineSqlxDm() {
        List<String> listAllNodeid = new ArrayList<String>();
        SAXReader sr = new SAXReader();
        Document document = null;
        try {
            document = sr.read(AppConfig.getEgovHome() + "/conf/server/unExamine-props.xml");
        } catch (DocumentException e) {

        }
        if (document != null) {
            Element root = document.getRootElement();
            List<Node> nodes = root.selectNodes("sqlxdm");
            if (nodes != null) {
                for (int i = 0; i < nodes.size(); i++) {
                    listAllNodeid.add(nodes.get(i).getText());
                }
            }
        }
        return listAllNodeid;
    }
}
