package cn.gtmap.estateplat.config.utils;


import com.gtis.config.AppConfig;
import org.apache.commons.lang3.StringUtils;

/**
 * @author <a href="mailto:zhangyiyang@gtmap.cn">zhangyiyang</a>
 * @Date 2019-07-11 15:08
 * @Description 所有有特殊需求的版本号常量.
 */
public class SysVersions {



    private SysVersions() {
    }

    /**
     * 配置中系统版本号名称
     */
    public static final String SYS_VERSION = "sys.version";

    //region 黑龙江

    /**
     * 哈尔滨
     */
    public static final String HAERBIN = "haerbin";

    /**
     * 哈尔滨整个区域
     * @return
     */
    public static boolean isHaerbin() {
        return StringUtils.equals(HAERBIN, AppConfig.getProperty("sys.version"));
    }

    /**
     * 不是哈尔滨
     * @return
     */
    public static boolean isNotHaerbin() {
        return !isHaerbin();
    }

    /**
     * 仅为哈尔滨市本级,不包含外县
     * @return
     */
    public static boolean isHaerbinSbj() {
        return StringUtils.equals(HAERBIN, AppConfig.getProperty("sys.version")) && StringUtils.equals(HAERBIN, AppConfig.getProperty("hrb.city"));
    }

    /**
     * 不是哈尔滨市本级
     * @return
     */
    public static boolean isNotHaerbinSbj(){
        return !isHaerbinSbj();
    }

    /**
     * 阿城
     */
    public static final String HAERBIN_ACHENG = "acheng";

    public static boolean isHaerbinAcheng() {
        return StringUtils.equals(HAERBIN, AppConfig.getProperty("sys.version")) && StringUtils.equals(HAERBIN_ACHENG, AppConfig.getProperty("hrb.city"));
    }

    /**
     * 松北
     */
    public static final String HAERBIN_SONGBEI = "songbei";

    public static boolean isHaerbinSongbei() {
        return StringUtils.equals(HAERBIN, AppConfig.getProperty("sys.version")) && StringUtils.equals(HAERBIN_SONGBEI, AppConfig.getProperty("hrb.city"));
    }

    /**
     * 双城
     */
    public static final String HAERBIN_SHUANGCHENG = "shuangcheng";

    public static boolean isHaerbinShuangcheng() {
        return StringUtils.equals(HAERBIN, AppConfig.getProperty("sys.version")) && StringUtils.equals(HAERBIN_SHUANGCHENG, AppConfig.getProperty("hrb.city"));
    }

    /**
     * 呼兰
     */
    public static final String HAERBIN_HULAN = "hulan";

    public static boolean isHaerbinHulan() {
        return StringUtils.equals(HAERBIN, AppConfig.getProperty("sys.version")) && StringUtils.equals(HAERBIN_HULAN, AppConfig.getProperty("hrb.city"));
    }

    /**
     * 五常
     */
    public static final String WUCHANG = "wuchang";

    public static boolean isWuchang(){
        return StringUtils.equals(WUCHANG, AppConfig.getProperty("sys.version"));

    }

    /**
     * 依兰
     */
    public static final String YILAN = "yilan";

    public static boolean isYilan(){
        return StringUtils.equals(YILAN, AppConfig.getProperty("sys.version"));
    }

    /**
     * 大庆
     */
    public static final String DAQING = "daqing";

    public static boolean isDaqing() {
        return StringUtils.equals(DAQING, AppConfig.getProperty("sys.version"));
    }

    /**
     * 佳木斯
     */
    public static final String JIAMUSI = "jiamusi";

    public static boolean isJiamusi() {
        return StringUtils.equals(JIAMUSI, AppConfig.getProperty("sys.version"));
    }

    /**
     * 牡丹江
     */
    public static final String MUDANJIANG = "mudanjiang";

    public static boolean isMudanjiang() {
        return StringUtils.equals(MUDANJIANG, AppConfig.getProperty("sys.version"));
    }

    /**
     * 绥化
     */
    public static final String SUIHUA = "suihua";

    public static boolean isSuihua() {
        return StringUtils.equals(SUIHUA, AppConfig.getProperty("sys.version"));
    }

    /**
     * 伊春
     */
    public static final String YICHUN = "yichun";

    public static boolean isYichun() {
        return StringUtils.equals(YICHUN, AppConfig.getProperty("sys.version"));
    }

    /**
     * 双鸭山
     */
    public static final String SHUANGYASHAN = "shuangyashan";

    public static boolean isShuangyashan() {
        return StringUtils.equals(SHUANGYASHAN, AppConfig.getProperty("sys.version"));
    }

    /**
     * 富锦
     */
    public static final String FUJIN = "fujin";

    public static boolean isFujin() {
        return StringUtils.equals(FUJIN, AppConfig.getProperty("sys.version"));
    }

    /**
     * 汤圆
     */
    public static final String TANGYUAN = "tangyuan";

    public static boolean isTangyuan() {
        return StringUtils.equals(TANGYUAN, AppConfig.getProperty("sys.version"));
    }

    /**
     * 七台河
     */
    public static final String QITAIHE = "qitaihe";

    public static boolean isQitaihe() {
        return StringUtils.equals(QITAIHE, AppConfig.getProperty("sys.version"));
    }

    /**
     * 绥芬河
     */
    public static final String SUIFENHE = "suifenhe";

    public static boolean isSuifenhe() {
        return StringUtils.equals(SUIFENHE, AppConfig.getProperty("sys.version"));
    }

    /**
     * 桦川
     */
    public static final String HUACHUAN = "huachuan";

    public static boolean isHuachuan() {
        return StringUtils.equals(HUACHUAN, AppConfig.getProperty("sys.version"));
    }

    /**
     * 虎林
     */
    public static final String HULIN = "hulin";

    public static boolean isHulin() {
        return StringUtils.equals(HULIN, AppConfig.getProperty("sys.version"));
    }

    /**
     * 海林
     */
    public static final String HAILIN = "hailin";

    public static boolean isHailin() {
        return StringUtils.equals(HAILIN, AppConfig.getProperty("sys.version"));
    }

    /**
     * 黑河
     */
    public static final String HEIHE = "heihe";

    public static boolean isHeihe() {
        return StringUtils.equals(HEIHE, AppConfig.getProperty("sys.version"));
    }

    /**
     * 勃力
     */
    public static final String BOLI = "boli";

    public static boolean isBoli() {
        return StringUtils.equals(BOLI, AppConfig.getProperty("sys.version"));
    }

    /**
     * 穆棱
     */
    public static final String MULING = "muling";

    public static boolean isMuling() {
        return StringUtils.equals(MULING, AppConfig.getProperty("sys.version"));
    }

    //endregion

    //region 吉林

    /**
     * 长春
     */
    public static final String CHANGCHUN = "changchun";

    public static boolean isChangchun() {
        return StringUtils.equals(CHANGCHUN, AppConfig.getProperty("sys.version"));
    }

    /**
     * 九台区
     */
    public static final String JIUTAI = "jiutai";

    public static boolean isJiutai() {
        return StringUtils.equals(JIUTAI, AppConfig.getProperty("sys.version"));
    }

    /**
     * 长春外县
     */
    public static final String CHANGCHUN_WAIXIAN = "changchunwaixian";

    public static boolean isChangchunWaixian() {
        return StringUtils.equals(CHANGCHUN_WAIXIAN, AppConfig.getProperty("sys.version"));
    }
    //endregion

    //region 辽宁

    /**
     * 锦州
     */
    public static final String JINZHOU = "jinzhou";

    public static boolean isJinzhou() {
        return StringUtils.equals(JINZHOU, AppConfig.getProperty("sys.version"));
    }
    /**
     * 大连
     */
    public static final String DALIAN = "dalian";

    public static boolean isDalian() {
        return StringUtils.equals(DALIAN, AppConfig.getProperty("sys.version"));
    }
    /**
     * 海城
     */
    public static final String HAICHENG = "haicheng";

    public static boolean isHaicheng() {
        return StringUtils.equals(HAICHENG, AppConfig.getProperty("sys.version"));
    }

    /**
     * 东丰
     */
    public static final String DONGFENG = "dongfeng";

    public static boolean isDongfeng() {
        return StringUtils.equals(DONGFENG, AppConfig.getProperty("sys.version"));
    }

    /**
     * 宽甸
     */
    public static final String KUANDIAN = "kuandian";

    public static boolean isKuandian() {
        return StringUtils.equals(KUANDIAN, AppConfig.getProperty("sys.version"));
    }

    /**
     * 伊通
     */
    public static final String YITONG = "yitong";

    public static boolean isYitong() {
        return StringUtils.equals(YITONG, AppConfig.getProperty("sys.version"));
    }

    /**
     * 青冈
     */
    public static final String QINGGANG = "qinggang";

    public static boolean isQinggang() {
        return StringUtils.equals(QINGGANG, AppConfig.getProperty("sys.version"));
    }

    /**
     * 建平
     */
    public static final String JIANPING = "jianping";

    public static boolean isJianping() {
        return StringUtils.equals(JIANPING, AppConfig.getProperty("sys.version"));
    }

    /**
     * 抚远
     */
    public static final String FUYUAN = "fuyuan";

    public static boolean isFuyuan() {
        return StringUtils.equals(FUYUAN, AppConfig.getProperty("sys.version"));
    }

    /**
     * 灯塔
     */
    public static final String DENGTA = "dengta";

    public static boolean isDengta() {
        return StringUtils.equals(DENGTA, AppConfig.getProperty("sys.version"));
    }

    /**
     * 绥滨
     */
    public static final String SUIBIN = "suibin";

    public static boolean isSuiBin() {
        return StringUtils.equals(SUIBIN, AppConfig.getProperty("sys.version"));
    }
    /**
     * 辽阳
     */
    public static final String LIAOYANG = "liaoyang";

    public static boolean isLiaoyang() {
        return StringUtils.equals(LIAOYANG, AppConfig.getProperty("sys.version"));
    }

    /**
     * 朝阳
     */
    public static final String CHAOYANG = "chaoyang";

    public static boolean isChaoYang(){
        return StringUtils.equals(CHAOYANG,AppConfig.getProperty("sys.version"));
    }

    /**
     * 桓仁
     */
    public static final String HUANREN = "huanren";

    public static boolean isHuanRen(){
        return StringUtils.equals(HUANREN,AppConfig.getProperty("sys.version"));
    }

    /**
     * 密山
     */
    public static final String MISHAN = "mishan";

    public static boolean isMishan(){
        return StringUtils.equals(MISHAN,AppConfig.getProperty("sys.version"));
    }

    public static final String JIDONG = "jidong";

    public static boolean isJidong(){
        return StringUtils.equals(JIDONG,AppConfig.getProperty("sys.version"));
    }


    //endregion


    public static String getCurrentSysVersion() {
        return AppConfig.getProperty("sys.version");
    }

}
