package cn.gtmap.estateplat.config.web.data;

import cn.gtmap.estateplat.config.core.log.BdcLog;
import cn.gtmap.estateplat.config.core.mapper.config.BdcZdGlMapper;
import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.config.core.service.DataManagerService;
import cn.gtmap.estateplat.config.core.service.QllxService;
import cn.gtmap.estateplat.config.core.service.dataManager.OrganizeArdDataService;
import cn.gtmap.estateplat.config.service.ArdExcelService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.config.utils.PlatformUtil;
import cn.gtmap.estateplat.config.utils.ReadXmlProps;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repository;
import cn.gtmap.estateplat.model.server.core.BdcSpxx;
import cn.gtmap.estateplat.model.server.core.BdcZdQllx;
import cn.gtmap.estateplat.model.server.core.QllxVo;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
 * @version 1.0, 2017/8/30
 * @description
 */
@Controller
@RequestMapping("/dataManager")
public class DataManagerController extends BaseController {

    @Autowired
    private BdcZdGlService bdcZdGlService;
    @Autowired
    private QllxService qllxService;
    @Autowired
    private DataManagerService dataManagerService;
    @Autowired
    private Repository repository;
    @Autowired
    private ArdExcelService ardExcelService;
    @Autowired
    private BdcZdGlMapper bdcZdGlMapper;
    @Autowired
    private OrganizeArdDataService organizeArdDataService;

    @RequestMapping("")
    public String dataManager(Model model) {
        List<Map> bdcZdBdclxList = bdcZdGlService.getBdcZdBdclxList();
        List<Map> bdcZdQllxList = bdcZdGlMapper.getbdcZdQllxMap(new HashMap());
        model.addAttribute("BdcZdBdclxList", bdcZdBdclxList);
        model.addAttribute("bdcZdQllxList", bdcZdQllxList);
        String sfxnbdcdyh =AppConfig.getProperty("sfsc.xnbdcdyh");
        model.addAttribute("sfxnbdcdyh",sfxnbdcdyh);
        return "data/dataManager";
    }

    @RequestMapping("editRecord")
    public String editRecord(Model model, String bdcdyh, String bdclx, String djId, String bdcdyid, String bdcdyFwlx, String addQllx) {
        bdcdyFwlx = StringUtils.isNotBlank(bdcdyFwlx) ? bdcdyFwlx : StringUtils.EMPTY;
        bdcdyid = StringUtils.isNotBlank(bdcdyid) ? bdcdyid : StringUtils.EMPTY;
        bdcdyh = StringUtils.isNotBlank(bdcdyh) ? bdcdyh : StringUtils.EMPTY;
        bdclx = StringUtils.isNotBlank(bdclx) ? bdclx : StringUtils.EMPTY;
        djId = StringUtils.isNotBlank(djId) ? djId : StringUtils.EMPTY;
        Map<String, String> propertyRight = Maps.newHashMap();
        QllxVo qllxVo = null;
        if (StringUtils.isNoneBlank(bdcdyh, bdclx, djId) && StringUtils.length(bdcdyh) == 28) {
            String qllx = ReadXmlProps.getQllx(StringUtils.substring(bdcdyh, 12, 14), StringUtils.substring(bdcdyh, 19, 20));
            if(StringUtils.isBlank(qllx)){
                qllx =qllxService.getQllxByXnbdcdyh(bdcdyh);
            }

            if (StringUtils.isNoneBlank(qllx)) {
                qllxVo = qllxService.queryQllxVoByBdcdyh(bdcdyh, qllx);
            }
            if (StringUtils.isNoneBlank(bdcdyid, addQllx)) {
                qllx = addQllx;
                qllxVo = qllxService.queryQllxVoByBdcdyid(bdcdyid, qllx);
            }
            BdcZdQllx bdcZdQllx = bdcZdGlService.getBdcZdQllxByDm(qllx);
            if (bdcZdQllx != null) {
                propertyRight.put("QLLXMC", bdcZdQllx.getMc());
                String url = StringUtils.EMPTY;
                if (qllxVo != null) {
                    url = configUrl + "/dataManager/dataInfo?proid=" + qllxVo.getProid() + "&bdcdyh=" + bdcdyh + "&qllx=" + qllx + "&bdclx=" + bdclx + "&djId=" + djId + "&bdcdyid=" + bdcdyid;
                } else if (StringUtils.isNoneBlank(qllx)) {
                    url = configUrl + "/dataManager/dataInfo?bdcdyh=" + bdcdyh + "&qllx=" + qllx + "&bdclx=" + bdclx + "&djId=" + djId + "&bdcdyid=" + bdcdyid + "&bdcdyFwlx=" + bdcdyFwlx + "&noPropertyRight=on";
                }
                propertyRight.put("URL", url);
                model.addAttribute("propertyRight", propertyRight);
            }
            model.addAttribute("bdcdyFwlx", bdcdyFwlx);
            model.addAttribute("bdcdyid", bdcdyid);
            model.addAttribute("bdcdyh", bdcdyh);
            model.addAttribute("bdclx", bdclx);
            model.addAttribute("djId", djId);
            return "data/dataRecord";
        } else {
            return "common/404";
        }
    }

    @RequestMapping("/dataInfo")
    public String dataInfo(Model model, String proid, String djId, String bdcdyh, String bdclx, String qllx, String bdcdyFwlx, String bdcdyid, String noPropertyRight) {
        model.addAttribute("qllx", qllx);
        model.addAttribute("djId", djId);
        model.addAttribute("bdcdyh", bdcdyh);
        model.addAttribute("bdclx", bdclx);
        model.addAttribute("bdcdyFwlx", bdcdyFwlx);
        noPropertyRight = StringUtils.isNotBlank(noPropertyRight) ? noPropertyRight : StringUtils.EMPTY;
        if (StringUtils.isBlank(proid)) {
            if (StringUtils.equals(qllx, Constants.QLLX_DYAQ)) {
                if (StringUtils.isNotBlank(bdcdyh)) {
                    model.addAttribute("bdcdyh", bdcdyh);
                }
                return "qlxx/bdcDyaqList";
            } else if (StringUtils.equals(qllx, Constants.QLLX_CFDJ)) {
                if (StringUtils.isNotBlank(bdcdyh)) {
                    model.addAttribute("bdcdyh", bdcdyh);
                }
                return "qlxx/bdcCflist";
            } else if (StringUtils.isNoneBlank(qllx)) {
                if (StringUtils.isNotBlank(bdcdyh)) {
                    QllxVo qllxVo = qllxService.queryQllxVoByBdcdyh(bdcdyh, qllx);
                    if (qllxVo != null && StringUtils.isNoneBlank(qllxVo.getQlid())) {
                        return "redirect:" + configUrl + "/dataManager/dataInfo?proid=" + qllxVo.getProid();
                    }
                }
                model.addAttribute("xmxxUrl", configUrl + "/bdcXm?bdcdyh=" + bdcdyh + "&qllx=" + qllx + "&bdclx=" + bdclx + "&djId=" + djId + "&bdcdyFwlx=" + bdcdyFwlx + "&noPropertyRight=" + noPropertyRight);
                model.addAttribute("ryxxUrl", configUrl + "/bdcQlrxx?bdcdyh=" + bdcdyh + "&qllx=" + qllx + "&bdclx=" + bdclx + "&djId=" + djId + "&bdcdyFwlx=" + bdcdyFwlx + "&noPropertyRight=" + noPropertyRight);
                model.addAttribute("qldjxxUrl", PlatformUtil.initOptProperties(ReadXmlProps.getQllxUrl(qllx)) + "?bdcdyh=" + bdcdyh + "&qllx=" + qllx + "&bdclx=" + bdclx + "&djId=" + djId + "&bdcdyFwlx=" + bdcdyFwlx + "&noPropertyRight=" + noPropertyRight);
                model.addAttribute("bdcqzsmxxUrl", configUrl + "/bdcdjBdcZs?bdcdyh=" + bdcdyh + "&qllx=" + qllx);
                return "data/dataInfo";
            } else {
                return null;
            }
        } else {
            model.addAttribute("proid", proid);
            model.addAttribute("xmxxUrl", configUrl + "/bdcXm?proid=" + proid + "&bdcdyh=" + bdcdyh + "&bdclx=" + bdclx + "&djId=" + djId + "&qllx=" + qllx);
            model.addAttribute("ryxxUrl", configUrl + "/bdcQlrxx?proid=" + proid + "&bdcdyh=" + bdcdyh + "&bdclx=" + bdclx + "&djId=" + djId + "&qllx=" + qllx);
            model.addAttribute("qldjxxUrl", PlatformUtil.initOptProperties(ReadXmlProps.getQllxUrl(qllx)) + "?proid=" + proid + "&bdcdyh=" + bdcdyh + "&bdclx=" + bdclx + "&djId=" + djId + "&qllx=" + qllx);
            model.addAttribute("bdcqzsmxxUrl", configUrl + "/bdcdjBdcZs?proid=" + proid + "&bdcdyh=" + bdcdyh + "&qllx=" + qllx);
            return "data/dataInfo";
        }
    }

    @ResponseBody
    @RequestMapping("/addData")
    @BdcLog(controller = "添加数据录入日志",parmjson = "添加数据录入")
    public String addData(String djId, String bdcdyh, String qllx, String bdclx, String bdcdyFwlx) {
        return dataManagerService.addData(djId, bdcdyh, qllx, bdclx, bdcdyFwlx);
    }

    @ResponseBody
    @RequestMapping("/delData")
    @BdcLog(controller = "删除数据录入日志",parmjson = "删除数据录入")
    public String delData(String proid) {
        return dataManagerService.delData(proid);
    }

    @ResponseBody
    @RequestMapping("/getBdcBlXmJson")
    public Object getBdcBlXmJson(int page, int rows, String hhSearch) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("hhSearch", StringUtils.deleteWhitespace(hhSearch));
        return repository.selectPaging("getBdcBlXmJsonByPage", map, page - 1, rows);
    }

    @RequestMapping("excelData")
    public String excelData() {
        return "data/excelData";
    }

    /**
     * @param multipartFile
     * @return
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description
     */
    @ResponseBody
    @RequestMapping("readExcel")
    public String readExcel(MultipartFile multipartFile, String type) throws IOException {
        String statue = "fail";
        Map<String, String> msgMap = Maps.newHashMap();
        Map<String, String> resultMap = Maps.newHashMap();
        //获取上传的文件的文件名
        String originalFilename = multipartFile.getOriginalFilename();
        InputStream inputStream = null;
        try {
            inputStream = multipartFile.getInputStream();
        } catch (IOException e) {
            throw new AppException("获取文件输入流出错!");
        }
        if (inputStream != null) {
            String suffix = StringUtils.substring(originalFilename, originalFilename.lastIndexOf("."));
            if (StringUtils.equals(suffix, ".xls") || StringUtils.equals(suffix, ".xlsx")) {
                try {
                    Map<String, List<Object>> map = ardExcelService.getExcelAsInputStream(inputStream, type);
                    msgMap = organizeArdDataService.initArdExcelProject(map, type);
                    statue = "success";
                } catch (Exception e) {
                    statue = "fail";
                    e.printStackTrace();
                } finally {
                    inputStream.close();
                }
            }
        }
        resultMap.put("statue", statue);
        resultMap.putAll(msgMap);
        return JSON.toJSONString(resultMap);
    }
}
