package cn.gtmap.estateplat.config.web.lpb;

import cn.gtmap.estateplat.config.service.lpb.BdcLpbService;
import cn.gtmap.estateplat.config.web.main.BaseController;
import com.gtis.config.AppConfig;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

/*
 * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
 * @version 1.0, 2017/11/23
 * @description  楼盘表
 */
@Controller
@RequestMapping("/bdcLpb")
public class BdcLpbController extends BaseController{

    @Autowired
    BdcLpbService bdcLpbService;

    /**
     * 楼盘表页面
     *
     * @param ljzId 逻辑幢id
     * @param model
     * @return "lpb/bdcLpb"楼盘表页面
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     */
    @RequestMapping(value = "/index")
    public String index(String ljzId, Model model) {
        ljzId="0378e3b4-4686-48a9-a1a1-e80349e54b70";
        bdcLpbService.layoutLpb(ljzId,model);
        return "lpb/bdcLpb";
    }
}
