package cn.gtmap.estateplat.config.web.main;

import com.gtis.plat.service.SysAuthorService;
import com.gtis.plat.vo.PfPartitionInfoVo;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.List;

/**
 * 授权修改
 */
@Controller
@RequestMapping(value = "author")
public class AuthorController extends BaseController {
    @Autowired
    SysAuthorService sysAuthorService;

    @ResponseBody
    @RequestMapping("")
    public Object getSystemResrouceAuthorList(String rid) {
        if (StringUtils.isNotBlank(rid) && StringUtils.indexOf(rid, "r:") > -1)
            rid = StringUtils.substring(rid, StringUtils.indexOf(rid, "r:") + 2, rid.length());
        List<PfPartitionInfoVo> pfPartitionInfoVoList = null;
        if (!SessionUtil.getCurrentUser().isAdmin()) {
            List<PfRoleVo> roleVoList = super.getRoleListByUser(super.getUserId());
            String roleIds = "";
            if (CollectionUtils.isNotEmpty(roleVoList)) {
                for (int i = 0; i < roleVoList.size(); i++) {
                    if (StringUtils.isBlank(roleIds))
                        roleIds += "'" + roleVoList.get(i).getRoleId() + "'";
                    else
                        roleIds += ",'" + roleVoList.get(i).getRoleId() + "'";
                }
            }
            pfPartitionInfoVoList = sysAuthorService.getSystemResrouceAuthorList(rid, roleIds);
        }
        if (CollectionUtils.isEmpty(pfPartitionInfoVoList))
            pfPartitionInfoVoList = new ArrayList<PfPartitionInfoVo>();
        return pfPartitionInfoVoList;
    }
}
