package cn.gtmap.estateplat.config.web.main;

import cn.gtmap.estateplat.config.utils.ReadXmlProps;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * @author <a href="mailto:lijian@gtmap.cn">lijian</a>
 * @version 1.0, 2017/9/11
 * @description 必填控制
 */
@Controller
@RequestMapping(value = "limitField")
public class LimitFieldController {

    @ResponseBody
    @RequestMapping(value = "getLimitFiled")
    public Object getLimitFiled(String name) {
        String[] limitField = null;
        String fileds = ReadXmlProps.getLimitField(name);
        if (StringUtils.isNotBlank(fileds)) {
            limitField = StringUtils.split(fileds, ",");
        }
        return limitField;
    }
}
