package cn.gtmap.estateplat.config.web.main;

import cn.gtmap.estateplat.config.core.mapper.config.BdcZdGlMapper;
import cn.gtmap.estateplat.config.core.service.BdcSqlxQllxRelService;
import cn.gtmap.estateplat.config.core.service.BdcXmService;
import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.config.core.service.BdcdyService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.config.utils.PlatformUtil;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.*;
import cn.gtmap.estateplat.utils.CommonUtil;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: sunchao
 * Date: 15-3-29
 * Time: 下午3:45
 * To change this template use File | Settings | File Templates.
 */
@Controller
@RequestMapping("/selectBdcdy")
public class SelectBdcdyContorller extends BaseController {
    @Autowired
    BdcZdGlService bdcZdGlService;
    @Autowired
    BdcdyService bdcdyService;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private BdcSqlxQllxRelService bdcSqlxQllxRelService;
    @Autowired
    private Repo repository;
    @Autowired
    private BdcXmService bdcXmService;


    /*审批表选择不动产单元**/
    @RequestMapping(value = "", method = RequestMethod.GET)
    public String index(Model model, String proid, @RequestParam(value = "wiid", required = false) String wiid, @RequestParam(value = "multiselect", required = false) boolean multiselect, @RequestParam(value = "joinselect", required = false) boolean joinselect, @RequestParam(value = "glbdcdy", required = false) String glbdcdy, @RequestParam(value = "glzs", required = false) String glzs) {

        List<BdcXm> bdcXmList = null;
        if (StringUtils.isNotBlank(wiid)) {
            bdcXmList = bdcXmService.getBdcXmListByWiid(wiid);
        }
        BdcXm xmxx = null;
        if (bdcXmList != null && bdcXmList.size() > 0) {
            xmxx = bdcXmList.get(0);
        } else {
            xmxx = bdcXmService.getBdcXmByProid(proid);
        }

        model.addAttribute("proid", proid);
        String str = "";
        List<Map> bdclxList = bdcZdGlService.getBdcZdBdclxList();
        List<BdcSqlxQllxRel> bdcSqlxQllxRelList = null;
        String yqllxdm = "";
        String bdclxdm = "";
        String qlxzdm = "";
        Integer bdcdyly = Constants.BDCDYLY_ALL;
        String zdtzm = "";  //宗地宗海号  或者 不动产单元  的13、14位 为zdtzm
        String workFlowDefinedId = PlatformUtil.getWorkFlowDefinedIdByProid(proid);
        String qllx = "";
        String dyfs = "";
        String ysqlxdm = "";
        if (StringUtils.isNotBlank(workFlowDefinedId)) {
            List<Map> mapList = bdcXmService.getAllLxByWdid(workFlowDefinedId);
            if (mapList != null && mapList.size() > 0) {
                Map map = mapList.get(0);
                if (map.get("QLLXDM") != null)
                    qllx = CommonUtil.formatEmptyValue(map.get("QLLXDM"));
            }
        }

        if (xmxx != null && StringUtils.isNotBlank(xmxx.getSqlx())) {

            HashMap<String, Object> queryMap = new HashMap<String, Object>();
            queryMap.put("sqlxdm", xmxx.getSqlx());
            if (StringUtils.isNotBlank(xmxx.getQllx()))
            {
                queryMap.put("qllxdm", xmxx.getQllx());
            } else {
                queryMap.put("qllxdm", qllx);
            }
            bdcSqlxQllxRelList = bdcSqlxQllxRelService.andEqualQueryBdcSqlxQllxRel(queryMap);
        }

        if (bdcSqlxQllxRelList != null && bdcSqlxQllxRelList.size() > 0) {
            BdcSqlxQllxRel bdcSqlxQllxRel = bdcSqlxQllxRelList.get(0);
            if (StringUtils.isNotBlank(bdcSqlxQllxRel.getYqllxdm()))
                yqllxdm = bdcSqlxQllxRel.getYqllxdm();
            if (bdcSqlxQllxRel.getBdcdyly() != null)
                bdcdyly = bdcSqlxQllxRel.getBdcdyly();
            if (StringUtils.isNotBlank(bdcSqlxQllxRel.getZdtzm()))
                zdtzm = bdcSqlxQllxRel.getZdtzm();
            if (StringUtils.isNotBlank(bdcSqlxQllxRel.getDyfs()))
                dyfs = bdcSqlxQllxRel.getDyfs();
            if (StringUtils.isNotBlank(bdcSqlxQllxRel.getBdclx()))
                bdclxdm = bdcSqlxQllxRel.getBdclx();
            if (StringUtils.isNotBlank(bdcSqlxQllxRel.getQlxzdm()))
                qlxzdm = bdcSqlxQllxRel.getQlxzdm();
            if (StringUtils.isNotBlank(bdcSqlxQllxRel.getYsqlxdm()))
                ysqlxdm = bdcSqlxQllxRel.getYsqlxdm();
        }
        String sqlx = "";
        if (null != xmxx) {
            String sqlxdm = xmxx.getSqlx();
            if (StringUtils.equals(sqlxdm, Constants.SQLX_JF)) {
                sqlx = "JF";
            }
            model.addAttribute("wfsqlxdm", sqlxdm);
        }
        List<BdcZdSqlx> bdcZdSqlxList = null;
        if (StringUtils.isNotBlank(xmxx.getSqlx())) {
            Example example = new Example(BdcZdSqlx.class);
            example.createCriteria().andEqualTo("dm", xmxx.getSqlx());
            bdcZdSqlxList = entityMapper.selectByExample(BdcZdSqlx.class, example);
        }


        model.addAttribute("dyfs", dyfs);
        model.addAttribute("yqllxdm", yqllxdm);
        model.addAttribute("bdclxdm", bdclxdm);
        if (StringUtils.equals(glbdcdy, "true")) {
            model.addAttribute(" glbdcdy", glbdcdy);
            model.addAttribute("bdcdyly", 0);
        } else if (StringUtils.equals(glzs, "true")) {
            model.addAttribute("glzs", glzs);
            model.addAttribute("bdcdyly", 1);
        } else {
            model.addAttribute("bdcdyly", bdcdyly);
        }
        model.addAttribute("zdtzm", zdtzm);
        model.addAttribute("qlxzdm", qlxzdm);
        model.addAttribute("bdclxList", bdclxList);
        model.addAttribute("ysqlxdm", ysqlxdm);

        model.addAttribute("sqlx", sqlx);
        model.addAttribute("qllx", qllx);
        model.addAttribute("djlx", xmxx.getDjlx());
        model.addAttribute("wiid", xmxx.getWiid());
        if (CollectionUtils.isNotEmpty(bdcZdSqlxList)) {
            model.addAttribute("sqlxmc", bdcZdSqlxList.get(0).getMc());
            model.addAttribute("workFlowDefId", bdcZdSqlxList.get(0).getWdid());
        }
        if (CommonUtil.indexOfStrs(Constants.SQLX_ZJJZW_FW_DM, xmxx.getSqlx())) {
            model.addAttribute("plChoseOne", Constants.PL_CHOSE_ONE);
        }
        //不动产单元或不动产权证多选功能
        String path = "query/djsjBdcdyList";
        if (joinselect) {
            path = "query/djsjJoinMultiselectList";
        } else if (multiselect) {
            path = "query/djsjMultiselectList";
        }
        return path;
    }

    //    @RequestMapping("/addHbXm")
//    public String toSqlxQllxRelConfig1(Model model) {
//        List<BdcZdDjlx> djlxList = bdcZdGlService.getBdcDjlx();
//        List<Map> sqlxList = bdcZdGlService.getZdSqlxList();
//        model.addAttribute("djList", djlxList);
//        model.addAttribute("sqList", sqlxList);
//        //登记类型和申请类型默认值
//        //model.addAttribute("djlx", Constants.DJLX_DYDJ_DM);
//        model.addAttribute("djlx", Constants.DJLX_CSDJ_DM);
//        return "/sjgl/addHb";
//    }
    @ResponseBody
    @RequestMapping("/getDjsjBdcdyPagesJson")
    public Object getBdcXmPagesJson(Pageable pageable, String djh, String bdcdyh, String dcxc, String qlr,
                                    String tdzl, String bdclx, String bdclxdm, String zdtzm, String wfsqlxdm,
                                    @RequestParam(value = "qlxzdm", required = false) String qlxzdm, String bdcdyhs) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(dcxc)) {
            map.put("dcxc", StringUtils.deleteWhitespace(dcxc));
            String[] djids = bdcdyService.getDjQlrIdsByQlr(dcxc, bdclx);
            if (djids != null && djids.length > 0)
                map.put("djids", djids);
            String bdcdycxFwbhZdmc = AppConfig.getProperty("bdcdycx.fwbh.zdmc");
            if (StringUtils.isNotBlank(bdcdycxFwbhZdmc)) {
                map.put("fwbh", "t." + bdcdycxFwbhZdmc + "='" + StringUtils.deleteWhitespace(dcxc) + "'");
            }
        } else {
            if (StringUtils.isNotBlank(djh)) {
                map.put("djh", djh);
            }
            if (StringUtils.isNotBlank(bdcdyh)) {
                map.put("bdcdyh", bdcdyh);
            }

            if (StringUtils.isNotBlank(qlr)) {
                map.put("qlr", qlr);

            }

            if (StringUtils.isNotBlank(bdclx)) {
                map.put("bdclx", bdclx);
            }
            if (StringUtils.isNotBlank(tdzl)) {
                map.put("tdzl", tdzl);
            }

        }
        if (StringUtils.isNotBlank(bdclxdm)) {
            map.put("bdclxdm", bdclxdm.split(","));
            String bdclxdmConfig = bdclxdm.split(",")[0];
            if (StringUtils.isBlank(bdclx) && StringUtils.equals(bdclxdmConfig, "F")) {
                map.put("bdclx", Constants.BDCLX_TDFW);
            } else if (StringUtils.isBlank(bdclx) && StringUtils.equals(bdclxdmConfig, "W")) {
                if (zdtzm.indexOf("H") > -1) {
                    map.put("bdclx", Constants.BDCLX_HY);
                } else {
                    map.put("bdclx", Constants.BDCLX_TD);
                }

            } else if (StringUtils.isBlank(bdclx) && StringUtils.equals(bdclxdmConfig, "L"))
                map.put("bdclx", Constants.BDCLX_TDSL);
            else if (StringUtils.isBlank(bdclx) && StringUtils.equals(bdclxdmConfig, "Q")) {
                if (CommonUtil.indexOfStrs(Constants.SQLXDM_GZW, wfsqlxdm)) {
                    map.put("bdclx", Constants.BDCLX_GZW);
                    bdclxdm = "F,Q";
                    map.put("bdclxdm", bdclxdm.split(","));
                } else {
                    map.put("bdclx", Constants.BDCLX_TDQT);
                }
            }
        }
        if (StringUtils.isNotBlank(bdcdyhs)) {
            List<String> bdcdyhList = new ArrayList<String>();
            for (String tempBdcdyh : bdcdyhs.split(",")) {
                if (StringUtils.isNotBlank(tempBdcdyh)) {
                    bdcdyhList.add(tempBdcdyh);
                }
            }
            map.put("bdcdyhs", bdcdyhList);
        }
        if (StringUtils.isNotBlank(zdtzm)) {
            map.put("zdtzm", zdtzm.split(","));
        }
        if (StringUtils.isNotBlank(qlxzdm)) {
            map.put("qlxzdm", qlxzdm.split(","));
        }
        //根据行政区过滤
        String userDwdm = super.getWhereXzqdm();
        if (StringUtils.isNotBlank(userDwdm))
            map.put("xzqdm", userDwdm);
        Page<HashMap> dataPaging = repository.selectPaging("getDjsjBdcdyByPage", map, pageable);
        return dataPaging;
    }

    @ResponseBody
    @RequestMapping("/getBdczsListByPage")
    public Object getBdczsListByPage(Pageable pageable, String bdcdyh, String qllx, String bdcqzh, String qlr, String zl, String bdclxdm, String dcxc, String zdtzm, @RequestParam(value = "qlxzdm", required = false) String qlxzdm, @RequestParam(value = "dyfs", required = false) String dyfs, @RequestParam(value = "ysqlxdm", required = false) String ysqlxdm, @RequestParam(value = "proid", required = false) String proid, String bdcdyhs) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BdcXm bdcXm = bdcXmService.getBdcXmByProid(proid);
        String sqlx = bdcXm != null ? bdcXm.getSqlx() : "";
        if (StringUtils.isNotBlank(dcxc)) {
            map.put("dcxc", StringUtils.deleteWhitespace(dcxc));
        } else {
            if (StringUtils.isNotBlank(bdcqzh)) {
                map.put("bdcqzh", bdcqzh);
            }
            if (StringUtils.isNotBlank(bdcdyh)) {
                map.put("bdcdyh", bdcdyh);
            }
            if (StringUtils.isNotBlank(qlr)) {
                map.put("qlr", qlr);
            }
            if (StringUtils.isNotBlank(zl)) {
                map.put("zl", zl);
            }
        }
        if (StringUtils.isNotBlank(bdclxdm)) {
            String bdclxdmConfig = bdclxdm.split(",")[0];
            if (StringUtils.equals(bdclxdmConfig, "Q")) {
                map.put("bdclx", Constants.BDCLX_GZW);
                bdclxdm = "F,Q";
                map.put("bdclxdm", bdclxdm.split(","));
            } else {
                map.put("bdclxdm", bdclxdm.split(","));
            }
        }
        /**
         * @author jiangganzhi
         * @description 异议登记不根据权利类型过滤 否则无法搜出证明
         */
        if (StringUtils.isNotBlank(sqlx) && !StringUtils.equals(sqlx, Constants.SQLX_YYDJ_DM)) {
            if (StringUtils.isNotBlank(qllx)) {
                map.put("qllx", qllx.split(","));
            }
        }
        if (StringUtils.isNotBlank(zdtzm)) {
            map.put("zdtzm", zdtzm.split(","));
        }
        if (StringUtils.isNotBlank(dyfs)) {
            map.put("dyfs", dyfs);
        }
        if (StringUtils.isNotBlank(qlxzdm)) {
            map.put("qlxzdm", qlxzdm.split(","));
        }
        if (StringUtils.isNotBlank(ysqlxdm)) {
            map.put("ysqlxdm", ysqlxdm.split(","));
        }
        if (StringUtils.isNotBlank(sqlx) && (Constants.SQLX_SPFSCKFSZC_DM.equals(sqlx) || Constants.SQLX_SPFXZBG_DM.equals(sqlx))) {
            String zstype = AppConfig.getProperty("spfscdj.zstype");
            if (StringUtils.isNotBlank(zstype)) {
                map.put("zstype", zstype);
            }
        }
        if (StringUtils.isNotBlank(bdcdyhs)) {
            List<String> bdcdyhList = new ArrayList<String>();
            for (String tempBdcdyh : bdcdyhs.split(",")) {
                if (StringUtils.isNotBlank(tempBdcdyh)) {
                    bdcdyhList.add(tempBdcdyh);
                }
            }
            map.put("bdcdyhs", bdcdyhList);
        }
//        //根据行政区过滤 查封的无不动产权证号的无法查出
        String userDwdm = super.getWhereXzqdm();
        if (StringUtils.isNotBlank(userDwdm))
            map.put("xzqdm", userDwdm);
        //sc 需要展示不生成证书的权力信息
        map.put("filterNullBdcqzh", true);
        /**
         * @author bianwen
         * @description 将权利已注销的证书过滤掉
         */
        map.put("qszt", Constants.QLLX_QSZT_HR);

        /**
         * @author bianwen
         * @description 在建工程选择不动产单元页面显示一条信息
         */
        String pageStr = "";
        pageStr = "getBdcZsByPage";
        Page<HashMap> dataPaging = repository.selectPaging(pageStr, map, pageable);
        return dataPaging;
    }

    @ResponseBody
    @RequestMapping("/getGdfczListByPage")
    public Object getGdfczListByPage(Pageable pageable, String bdcdyh, String fczh, String qlr, String fwzl, String dcxc) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(dcxc)) {
            map.put("dcxc", StringUtils.deleteWhitespace(dcxc));
        } else {
            if (StringUtils.isNotBlank(fczh)) {
                map.put("fczh", fczh);
            }
            if (StringUtils.isNotBlank(bdcdyh)) {
                map.put("bdcdyh", bdcdyh);
            }
            if (StringUtils.isNotBlank(qlr)) {
                map.put("qlr", qlr);
            }
            if (StringUtils.isNotBlank(fwzl)) {
                map.put("fwzl", fwzl);
            }
        }
        Page<HashMap> dataPaging = repository.selectPaging("getGdfczByPage", map, pageable);
        return dataPaging;
    }

    @ResponseBody
    @RequestMapping("/getGdtdzListByPage")
    public Object getGdtdzListByPage(Pageable pageable, String bdcdyh, String tdzh, String qlr, String dcxc, String tdzl) {
        HashMap<String, Object> map = new HashMap<String, Object>();

        if (StringUtils.isNotBlank(dcxc)) {
            map.put("dcxc", StringUtils.deleteWhitespace(dcxc));
        } else {
            if (StringUtils.isNotBlank(tdzh)) {
                map.put("tdzh", tdzh);
            }
            if (StringUtils.isNotBlank(bdcdyh)) {
                map.put("bdcdyh", bdcdyh);
            }
            if (StringUtils.isNotBlank(qlr)) {
                map.put("qlr", qlr);
            }
            if (StringUtils.isNotBlank(tdzl)) {
                map.put("tdzl", tdzl);
            }
        }
        Page<HashMap> dataPaging = repository.selectPaging("getGdtdzByPage", map, pageable);
        return dataPaging;
    }

    @ResponseBody
    @RequestMapping("/getQlxxListByPage")
    public Object getQlxxListByPage(Pageable pageable, String bdcdyh, String qllx, String bdcqzh, String qlr, String zl, String bdclxdm, String dcxc, String zdtzm, @RequestParam(value = "qlxzdm", required = false) String qlxzdm, @RequestParam(value = "dyfs", required = false) String dyfs, @RequestParam(value = "ysqlxdm", required = false) String ysqlxdm, @RequestParam(value = "proid", required = false) String proid) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(dcxc)) {
            map.put("dcxc", StringUtils.deleteWhitespace(dcxc));
        }
        if (StringUtils.isNotBlank(ysqlxdm)) {
            map.put("ysqlxdm", ysqlxdm.split(","));
        }
        //根据行政区过滤
        String userDwdm = super.getWhereXzqdm();
        if (StringUtils.isNotBlank(userDwdm))
            map.put("xzqdm", userDwdm);
        //sc 需要展示不生成证书的权力信息
        map.put("filterNullBdcqzh", true);
        Page<HashMap> dataPaging = repository.selectPaging("getQlxxByPage", map, pageable);
        return dataPaging;
    }

    /**
     * 获取数据
     *
     * @param model
     * @param bdcid,qlid
     * @return
     */
    @ResponseBody
    @RequestMapping("/getdateByBdcid")
    public HashMap<String, Object> getdateByBdcid(Model model, String bdcid, String bdclx, String qlid) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String zl = "";
        String qlr = "";

        List<GdFw> gdFwlList = null;
        if (StringUtils.isNotBlank(bdcid) && !StringUtils.equals("TD", bdclx)) {
            Example example = new Example(GdFw.class);
            example.createCriteria().andEqualTo("fwid", bdcid);
            gdFwlList = entityMapper.selectByExample(GdFw.class, example);
        }

        List<GdTd> gdTdlList = null;
        if (StringUtils.isNotBlank(bdcid) && StringUtils.equals("TD", bdclx)) {
            Example example = new Example(GdTd.class);
            example.createCriteria().andEqualTo("tdid", bdcid);
            gdTdlList = entityMapper.selectByExample(GdTd.class, example);
        }

        if (StringUtils.isNotBlank(qlid)) {
//            List<GdQlr> gdQlrlList=gdXmService.getGdqlrByQlid(qlid, "qlr");
//            if(gdQlrlList!=null&&gdQlrlList.size()>0){
//                for(int i=0;i<gdQlrlList.size();i++){
//                    if(StringUtils.isNotBlank(qlr)){
//                        qlr=qlr+"/"+gdQlrlList.get(i).getQlr();
//                    }else if(!StringUtils.isNotBlank(qlr)){
//                        qlr=gdQlrlList.get(i).getQlr();
//                    }
//                }
//            }
        }

        if (gdFwlList != null && gdFwlList.size() > 0) {
            zl = gdFwlList.get(0).getFwzl();
        }
        if (gdTdlList != null && gdTdlList.size() > 0) {
            zl = gdTdlList.get(0).getZl();
        }

        resultMap.put("zl", zl);
        resultMap.put("qlr", qlr);
        return resultMap;
    }


    /**
     * 获取权利人
     *
     * @param model
     * @param djid
     * @return
     */
    @ResponseBody
    @RequestMapping("/getQlrByDjid")
    public HashMap<String, Object> getQlrByDjid(Model model, String djid, String bdclxdm, String wfsqlxdm) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String qlr = "";
        if (StringUtils.isNotBlank(djid))
            qlr = bdcdyService.getDjQlrByDjid(djid, bdclxdm, null, wfsqlxdm);
        resultMap.put("qlr", qlr);
        return resultMap;
    }
}
