package cn.gtmap.estateplat.config.web.main;

import cn.gtmap.estateplat.config.core.service.BdcXmService;
import cn.gtmap.estateplat.config.service.core.ProjectLifeManageService;
import cn.gtmap.estateplat.model.server.core.*;

import com.google.common.collect.Lists;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.util.*;

/**
 * Created with IntelliJ IDEA.
 * User: zx
 * Date: 15-3-17
 * Time: 下午6:23
 * Des:工作流项目方法
 * To change this template use File | Settings | File Templates.
 */
@Controller
@RequestMapping("/wfProject")
public class WfProjectController extends BaseController {

    @Autowired
    private BdcXmService bdcXmService;
    @Autowired
    private SysWorkFlowInstanceService sysWorkFlowInstanceService;

    @Autowired
    private ProjectLifeManageService projectLifeManageService;
    /**
     * zdd
     *
     * @param project
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/initVoFromOldData")
    public String createWfProject(Project project) {
        String msg = "失败";
        if (project != null && StringUtils.isNotBlank(project.getProid())) {
            project.setUserId(super.getUserId());
            TaskInfo taskInfo =new TaskInfo();
            bdcXmService.getTaskInfoFromProject(taskInfo,project);
            projectLifeManageService.initializeProject(taskInfo);

            msg = "成功";
        }
        return msg;
    }

    /**
     * zx 创建项目
     *
     * @param proid
     * @param userid
     */
    @RequestMapping(value = "/creatProjectEvent", method = RequestMethod.GET)
    public String creatProjectEvent(@RequestParam(value = "proid", required = false) String proid,
                                    @RequestParam(value = "wfid", required = false) String wiid,
                                    @RequestParam(value = "userid", required = false) String userid,
                                    @RequestParam(value = "wdid", required = false) String wdid) {
        Project project = new Project();
        project.setProid(proid);
        project.setWorkFlowDefId(wdid);
        project.setWiid(wiid);
        project.setUserId(userid);
        projectLifeManageService.createProject(project);
        return null;
    }

    @RequestMapping(value = "/turnProjectEvent", method = RequestMethod.GET)
    public void turnProjectEvent(@RequestParam(value = "proid", required = false) String proid,
                                 @RequestParam(value = "activityid", required = false) String activityid,
                                 @RequestParam(value = "userid", required = false) String userid,
                                 @RequestParam(value = "taskid", required = false) String taskid,
                                 @RequestParam(value = "targetActivityDefids", required = false) String targetActivityDefids) throws Exception {
        BdcXm bdcXm = bdcXmService.getBdcXmByProid(proid);
        projectLifeManageService.transmitProject(proid,bdcXm.getWiid(),taskid,targetActivityDefids,userid,activityid);
    }


    @ResponseBody
    @RequestMapping(value = "/beforeTurnProjectEvent", method = RequestMethod.GET)
    public void beforeTurnProjectEvent(@RequestParam(value = "proid", required = false) String proid,
                                       @RequestParam(value = "activityid", required = false) String activityid,
                                       @RequestParam(value = "userid", required = false) String userid,
                                       @RequestParam(value = "taskid", required = false) String taskid, HttpServletResponse response) throws Exception {
        String str = "";
        try {
            BdcXm bdcXm = bdcXmService.getBdcXmByProid(proid);
            str =projectLifeManageService.validateProject(bdcXm.getWiid(),taskid,activityid);
        } catch (Exception e) {
            str=e.getMessage();
        }
        response.setContentType("text/xml;charset=GBK");
        PrintWriter out = response.getWriter();
        out.println(str);
        out.flush();
        out.close();
    }

    @RequestMapping(value = "/endProjectEvent", method = RequestMethod.GET)
    public void endProjectEvent(@RequestParam(value = "proid", required = false) String proid,
                                @RequestParam(value = "activityid", required = false) String activityid,
                                @RequestParam(value = "userid", required = false) String userid,
                                @RequestParam(value = "taskid", required = false) String taskid) throws Exception {

        PfWorkFlowInstanceVo pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstanceByProId(proid);
        String wiid = "";
        if (pfWorkFlowInstanceVo != null) {
            wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
        }
        projectLifeManageService.completeProject(wiid,userid);
    }

    @RequestMapping(value = "/delProjectEvent", method = RequestMethod.GET)
    public void workFlowDel(@RequestParam(value = "proid", required = false) String proid) {
//        PfWorkFlowInstanceVo pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstanceByProId(proid);
        String wiid = "";
        BdcXm bdcXm =bdcXmService.getBdcXmByProid(proid);
        if(bdcXm != null){
            wiid =bdcXm.getWiid();
        }

//        if (pfWorkFlowInstanceVo != null)
//            wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
        projectLifeManageService.deleteProject(wiid);
    }
    //退回
    @RequestMapping(value = "/turnBackProjectEvent", method = RequestMethod.GET)
    public void turnBackProjectEvent(@RequestParam(value = "proid", required = false) String proid,
                                     @RequestParam(value = "activityid", required = false) String activityid,
                                     @RequestParam(value = "userid", required = false) String userid,
                                     @RequestParam(value = "taskid", required = false) String taskid,
                                     @RequestParam(value = "targetActivityDefids", required = false) String targetActivityDefids) throws Exception {

        PfWorkFlowInstanceVo pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstanceByProId(proid);
        String wiid = "";
        if (pfWorkFlowInstanceVo != null) {
            wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
        }
        projectLifeManageService.retreatProject(wiid,activityid,taskid,userid,targetActivityDefids);
    }

    @RequestMapping(value = "/updateWorkFlow")
    public void updateWorkFlow(@RequestParam(value = "proid", required = false) String proid, @RequestParam(value = "wiid", required = false) String wiid) {

        BdcXm bdcXm =bdcXmService.getBdcXmByProid(proid);
        projectLifeManageService.updateWorkFlow(bdcXm);
    }

    /**
     * 验证不动产项目
     *
     * @param model
     * @return
     * @throws Exception
     */
    @ResponseBody
    @RequestMapping(value = "/checkBdcXm")
    public List<Map<String, Object>> checkBdcXm(Model model, Project project) {
        List<Map<String, Object>> resultList = Lists.newArrayList();
        try {
            resultList =projectLifeManageService.validateBdcXm(project);
        } catch (Exception e) {
            logger.error(e.getMessage());
        }

        return resultList;
    }


    /**
     * liujie: 查看原项目时获取原项目信息
     *
     * @param proid
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "toGetYxmxx", method = RequestMethod.POST)
    public HashMap toGetYxmxx(@RequestParam(value = "proid", required = false) String proid) {
        HashMap map = new HashMap();
        BdcXm bdcXm = bdcXmService.getBdcXmByProid(proid);
        if (bdcXm != null) {
            map.put("WIID", bdcXm.getWiid());
            map.put("SQLX", bdcXm.getSqlx());
            map.put("BDCDYID", bdcXm.getBdcdyid());
        }
        return map;
    }


}
