package cn.gtmap.estateplat.config.web.qlxx;

import cn.gtmap.estateplat.config.core.service.BdcdyService;
import cn.gtmap.estateplat.config.core.service.QllxService;
import cn.gtmap.estateplat.config.utils.ReadXmlProps;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.page.model.PageImpl;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.QllxVo;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
 * @version 1.0, 2017/8/30
 * @description
 */
@Controller
@RequestMapping("/bdcBdcdy")
public class BdcBdcdyController extends BaseController {

    @Autowired
    private Repo repository;

    @Autowired
    private BdcdyService bdcdyService;

    @Autowired
    private QllxService qllxService;

    @ResponseBody
    @RequestMapping("/getDjBdcdyListByPage")
    public Object getDjBdcdyListByPage(Pageable pageable, String bdclx, String bdcdyh, String djh, String qlr, String zl, String qlrzjh, String sfxnbdcdyh) {
        Map<String, Object> paramaMap = Maps.newHashMap();
        paramaMap.put("bdclx", bdclx);
        if (StringUtils.isNoneBlank(bdcdyh)) {
            paramaMap.put("bdcdyh", StringUtils.deleteWhitespace(bdcdyh));
        }
        if (StringUtils.isNoneBlank(djh)) {
            paramaMap.put("djh", StringUtils.deleteWhitespace(djh));
        }
        if (StringUtils.isNoneBlank(zl)) {
            paramaMap.put("zl", StringUtils.deleteWhitespace(zl));
        }
        // 通过权利人名称或权利人证件号查询地籍ids
        if (StringUtils.isNoneBlank(qlr) || StringUtils.isNoneBlank(qlrzjh)) {
            String[] djids = bdcdyService.getDjidsByQlr(bdclx, qlr, qlrzjh);
            if (null != djids && djids.length > 0) {
                paramaMap.put("ids", djids);
            } else {
                return new PageImpl(new ArrayList(), 0, pageable);
            }
        }
        if(StringUtils.isNotBlank(sfxnbdcdyh) &&StringUtils.equals(sfxnbdcdyh,"1")){
            return repository.selectPaging("getXnBdcdyListByPage", paramaMap, pageable);
        }else {
            return repository.selectPaging("getDjBdcdyListByPage", paramaMap, pageable);
        }
    }

    @ResponseBody
    @RequestMapping("/initBdcdy")
    public String initBdcdy(String djId, String bdcdyh, String bdclx, String bdcdyFwlx) {
        String result = "success";
        try {
            QllxVo qllxVo = null;
            if (StringUtils.isNoneBlank(bdcdyh, bdclx, djId) && StringUtils.length(bdcdyh) == 28) {
                String qllx = ReadXmlProps.getQllx(StringUtils.substring(bdcdyh, 12, 14), StringUtils.substring(bdcdyh, 19, 20));
                if (StringUtils.isNoneBlank(qllx)) {
                    qllxVo = qllxService.queryQllxVoByBdcdyh(bdcdyh, qllx);
                    if (qllxVo != null) {
                        bdcdyService.initDjBdcdy(djId, bdcdyh, bdclx, bdcdyFwlx);
                    }
                }
            }
        } catch (Exception e) {
            result = "fail";
            e.printStackTrace();
        }
        return result;
    }

}
