package cn.gtmap.estateplat.config.web.qlxx;/*
 * @author <a href="mailto:liubin@gtmap.cn">liubin</a>
 * @version 1.0, 2017/8/31
 * @description
 */

import cn.gtmap.estateplat.config.core.service.*;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.config.utils.PublicUtil;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.*;
import cn.gtmap.estateplat.utils.CalendarUtil;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/bdcCf")
public class BdcCfController extends BaseController {
    @Autowired
    private BdcZdGlService bdcZdGlService;
    @Autowired
    private BdcCfService bdcCfService;
    @Autowired
    private BdcQlrService bdcQlrService;
    @Autowired
    private DataManagerService dataManagerService;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private Repo repository;
    @Autowired
    private LogService logService;

    @RequestMapping("")
    public String index(Model model, String djId, String bdcdyh, String qllx, String bdclx) {
        if (StringUtils.isNotBlank(bdcdyh)) {
            model.addAttribute("djId", djId);
            model.addAttribute("bdcdyh", bdcdyh);
            model.addAttribute("qllx", qllx);
            model.addAttribute("bdclx", bdclx);
        }
        return "qlxx/bdcCflist";
    }

    @RequestMapping("addBdcCf")
    public String toOpinionConfig(Model model, String proid) {
        String cfksqx = "";
        String cfjsqx = "";
        String djsj = "";
        String jfdjsj = "";
        String bdcdyh = "";
        String bcfqlr = "";
        BdcCf bdcCf = new BdcCf();
        BdcXm bdcXm = new BdcXm();
        List<BdcZdDjlx> djlxList = bdcZdGlService.getBdcZdDjlxList();
        List<HashMap> cflxList = bdcZdGlService.getBdcZdCflx(new HashMap());
        List<BdcZdFy> bdcZdFyList = bdcZdGlService.getBdcZdFy();
        if (StringUtils.isNoneBlank(proid)) {
            bdcXm = entityMapper.selectByPrimaryKey(BdcXm.class, proid);
            if (bdcXm != null && bdcXm.getBdcdyid() != null) {
                BdcBdcdy bdcbdcdy = entityMapper.selectByPrimaryKey(BdcBdcdy.class, bdcXm.getBdcdyid());
                if (bdcbdcdy != null) {
                    bdcdyh = bdcbdcdy.getBdcdyh();
                }
            }
            Example example = new Example(BdcCf.class);
            example.createCriteria().andEqualTo("proid", proid);
            List<BdcCf> bdcCfList = entityMapper.selectByExample(example);
            if (bdcCfList != null) {
                bdcCf = bdcCfList.get(0);
            }
        }
        if (bdcCf != null) {
            if (bdcCf.getCfksqx() != null) {
                cfksqx = CalendarUtil.sdf.format(bdcCf.getCfksqx());
            }
            if (bdcCf.getCfjsqx() != null) {
                cfjsqx = CalendarUtil.sdf.format(bdcCf.getCfjsqx());
            }
            if (bdcCf.getDjsj() != null) {
                djsj = CalendarUtil.sdf.format(bdcCf.getDjsj());
            }
            if (bdcCf.getJfdjsj() != null) {
                jfdjsj = CalendarUtil.sdf.format(bdcCf.getJfdjsj());
            }
        }

        List<BdcQlr> bdcQlrList = bdcQlrService.getBdcQlrListByProidAndQlrlx(proid, Constants.QLRLX_QLR);
        if (CollectionUtils.isNotEmpty(bdcQlrList)) {
            for (int j = 0; j < bdcQlrList.size(); j++) {
                if (StringUtils.isNotBlank(bdcQlrList.get(j).getQlrmc())) {
                    if (j == 0) {
                        bcfqlr = bdcQlrList.get(j).getQlrmc();
                    } else {
                        if (bcfqlr.indexOf(bdcQlrList.get(j).getQlrmc()) < 0) {
                            bcfqlr = bcfqlr + " " + bdcQlrList.get(j).getQlrmc();
                        }
                    }
                }
            }
        }
        model.addAttribute("cfksqx", cfksqx);
        model.addAttribute("cfjsqx", cfjsqx);
        model.addAttribute("djsj", djsj);
        model.addAttribute("jfdjsj", jfdjsj);
        model.addAttribute("bdcdyh", bdcdyh);
        model.addAttribute("bdcCf", bdcCf);
        model.addAttribute("bcfqlr", bcfqlr);
        model.addAttribute("bdcXm", bdcXm);
        model.addAttribute("djlxList", djlxList);
        model.addAttribute("cflxList", cflxList);
        model.addAttribute("bdcZdFyList", bdcZdFyList);
        return "qlxx/bdcCf";
    }

    @ResponseBody
    @RequestMapping(value = "/saveBdcCf", method = RequestMethod.POST)
    public Map saveBdcCf(Model model, BdcCf bdcCf, String cfFyjg) {
        Map<String, String> map = Maps.newHashMap();
        String returnValue = "fail";
        if (bdcCf != null && StringUtils.isNotBlank(bdcCf.getQlid())) {
            bdcCf.setCfjg(cfFyjg);
            logService.saveOrUpdateLog(bdcCf);
            entityMapper.saveOrUpdate(bdcCf, bdcCf.getQlid());
            returnValue = "success";
        }
        map.put("msg", returnValue);
        return map;
    }

    @ResponseBody
    @RequestMapping("/delBdcCf")
    public HashMap delBdcCf(Model model, String ids) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        String[] qlidList = null;
        if (StringUtils.isNoneBlank(ids)) {
            qlidList = ids.split(",");
        }
        try {
            if (StringUtils.isNoneBlank(qlidList)) {
                for (String qlid : qlidList) {
                    BdcCf bdcCf = entityMapper.selectByPrimaryKey(BdcCf.class, qlid);
                    if (bdcCf != null && bdcCf.getProid() != null) {
                        dataManagerService.delData(bdcCf.getProid());
                    }
                }
            }
        } catch (Exception e) {
            result = "删除失败！";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }

    @ResponseBody
    @RequestMapping("/getCfJsonByPage")
    public Object getBdcCfList(Pageable pageable, String bdcdyh) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(bdcdyh))
            map.put("bdcdyh", bdcdyh);
        return repository.selectPaging("getCfJsonByPage", map, pageable);
    }
}
