package cn.gtmap.estateplat.config.web.qlxx;/* 
 * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
 * @version 1.0, 2017/9/1
 * @description
 */

import cn.gtmap.estateplat.config.core.service.*;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcDyaq;
import cn.gtmap.estateplat.model.server.core.BdcQlr;
import cn.gtmap.estateplat.model.server.core.BdcZdZjlx;
import cn.gtmap.estateplat.model.server.core.BdcZs;
import cn.gtmap.estateplat.utils.CalendarUtil;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/bdcDyaq")
public class BdcDyaqController extends BaseController {
    @Autowired
    private BdcdyService bdcdyService;
    @Autowired
    private BdcZdGlService bdcZdGlService;
    @Autowired
    private BdcQlrService bdcQlrService;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private BdcZsService bdcZsService;
    @Autowired
    private Repo repository;
    @Autowired
    private DataManagerService dataManagerService;
    @Autowired
    private LogService logService;


    @RequestMapping("")
    public String index(Model model, String bdcdyh, String proid) {
        if (StringUtils.isNotBlank(bdcdyh)) {
            model.addAttribute("bdcdyh", bdcdyh);
        }
        if (StringUtils.isNotBlank(proid)) {
            model.addAttribute("proid", proid);
        }
        List<BdcZdZjlx> bdcZdZjlxList = bdcZdGlService.getBdcZdZjlxList();
        model.addAttribute("bdcZdZjlxList", bdcZdZjlxList);
        return "qlxx/bdcDyaqList";
    }


    @ResponseBody
    @RequestMapping("/getDyaqPagesJson")
    public Object getDyaqPagesJson(Pageable pageable, String bdcdyh) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(bdcdyh))
            map.put("bdcdyh", bdcdyh);
        return repository.selectPaging("getDyaqListByPage", map, pageable);
    }


    @RequestMapping("updateDyaq")
    public String addDyaq(Model model, String proid, String bdcdyh, String bdclx) {
        BdcDyaq bdcDyaq = null;
        String bdcYwr = StringUtils.EMPTY;
        String zwlxksqx = StringUtils.EMPTY;
        String zwlxjsqx = StringUtils.EMPTY;
        String djsj = StringUtils.EMPTY;
        String zxsj = StringUtils.EMPTY;
        if (StringUtils.isNotBlank(proid)) {
            List<BdcZs> bdcZsList = bdcZsService.getBdcZsByProid(proid);
            StringBuilder bdcdjzmh = new StringBuilder();
            if (CollectionUtils.isNotEmpty(bdcZsList)) {
                for (BdcZs bdcZs : bdcZsList) {
                    if (StringUtils.isNoneBlank(bdcZs.getBdcqzh())) {
                        bdcdjzmh.append(bdcZs.getBdcqzh());
                        bdcdjzmh.append(",");
                    }
                }
            }
            if (StringUtils.isNoneBlank(bdcdjzmh)) {
                model.addAttribute("bdcdjzmh", StringUtils.substring(bdcdjzmh.toString(), 0, bdcdjzmh.length() - 1));
            }
            Example example = new Example(BdcDyaq.class);
            example.createCriteria().andEqualTo("proid", proid);
            List<BdcDyaq> bdcDyaqList = entityMapper.selectByExampleNotNull(example);
            if (CollectionUtils.isNotEmpty(bdcDyaqList)) {
                bdcDyaq = bdcDyaqList.get(0);
                if (bdcDyaq != null) {
                    if (bdcDyaq.getZwlxksqx() != null) {
                        zwlxksqx = CalendarUtil.sdf.format(bdcDyaq.getZwlxksqx());
                    }
                    if (bdcDyaq.getZwlxjsqx() != null) {
                        zwlxjsqx = CalendarUtil.sdf.format(bdcDyaq.getZwlxjsqx());
                    }
                    if (bdcDyaq.getZxsj() != null) {
                        zxsj = CalendarUtil.sdf.format(bdcDyaq.getZxsj());
                    }
                    if (bdcDyaq.getDjsj() != null) {
                        djsj = CalendarUtil.sdf.format(bdcDyaq.getDjsj());
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    List<BdcQlr> bdcYwrList = bdcQlrService.queryBdcYwrByProid(bdcDyaq.getProid());
                    if (CollectionUtils.isNotEmpty(bdcYwrList)) {
                        for (BdcQlr tempBdcYwr : bdcYwrList) {
                            if (StringUtils.isNotBlank(tempBdcYwr.getQlrmc())) {
                                stringBuilder.append(tempBdcYwr.getQlrmc()).append(StringUtils.SPACE);
                            }
                        }
                        if (StringUtils.isNoneBlank(stringBuilder)) {
                            bdcYwr = StringUtils.substring(stringBuilder.toString(), 0, stringBuilder.length() - 1);
                        }
                    }
                }
            }
        }
        List<Map> dyfsList = bdcZdGlService.getBdcZdDyfsList();
        model.addAttribute("bdcYwr", bdcYwr);
        model.addAttribute("bdclx", bdcZdGlService.parseCodeToName(bdclx, "BDCLX"));
        model.addAttribute("bdcdyh", bdcdyh);
        model.addAttribute("dyfsList", dyfsList);
        model.addAttribute("bdcDyaq", bdcDyaq);
        model.addAttribute("zwlxksqx", zwlxksqx);
        model.addAttribute("zwlxjsqx", zwlxjsqx);
        model.addAttribute("zxsj", zxsj);
        model.addAttribute("djsj", djsj);
        return "qlxx/bdcDyaq";
    }

    @ResponseBody
    @RequestMapping(value = "/saveBdcDyaq", method = RequestMethod.POST)
    public Map saveBdcHysyq(Model model, BdcDyaq bdcDyaq) {
        Map<String, String> map = Maps.newHashMap();
        String returnValue = "fail";
        if (bdcDyaq != null && StringUtils.isNotBlank(bdcDyaq.getQlid())) {
            logService.saveOrUpdateLog(bdcDyaq);
            entityMapper.saveOrUpdate(bdcDyaq, bdcDyaq.getQlid());
            returnValue = "success";
        }
        map.put("msg", returnValue);
        return map;
    }

    @ResponseBody
    @RequestMapping("delDyaq")
    public Map<String, String> delDyaq(Model model, String qlids) {
        Map<String, String> map = Maps.newHashMap();
        String msg = "删除成功！";
        if (StringUtils.isNotBlank(qlids)) {
            String[] qlidList = qlids.split(",");
            try {
                for (String qlid : qlidList) {
                    if (StringUtils.isNotBlank(qlid)) {
                        Example example = new Example(BdcDyaq.class);
                        example.createCriteria().andEqualTo("qlid", qlid);
                        List<BdcDyaq> bdcDyaqList = entityMapper.selectByExample(example);
                        if (CollectionUtils.isNotEmpty(bdcDyaqList)) {
                            BdcDyaq bdcDyaq = bdcDyaqList.get(0);
                            if (StringUtils.isNotBlank(bdcDyaq.getProid())) {
                                dataManagerService.delData(bdcDyaq.getProid());
                            }
                        }
                    }
                }
            } catch (Exception e) {
                msg = "删除失败！";
                e.printStackTrace();
            } finally {
                map.put("result", msg);
            }
        }
        return map;
    }
}
