package cn.gtmap.estateplat.config.web.qlxx;/* 
 * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
 * @version 1.0, 2017/9/13
 * @description
 */

import cn.gtmap.estateplat.config.core.mapper.config.BdcFdcqDzMapper;
import cn.gtmap.estateplat.config.core.service.*;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.*;
import cn.gtmap.estateplat.utils.CalendarUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Controller
@RequestMapping("/bdcFdcq")
public class BdcFdcqController extends BaseController {
    @Autowired
    private BdcXmService bdcXmService;
    @Autowired
    private BdcFdcqDzMapper bdcFdcqDzMapper;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private BdcZdGlService bdcZdGlService;
    @Autowired
    private BdcFdcqService bdcFdcqService;
    @Autowired
    private BdcdyService bdcdyService;
    @Autowired
    private BdcSpxxService bdcSpxxService;
    @Autowired
    private LogService logService;
    @Autowired
    private BdcZsService bdcZsService;
    @Autowired
    private BdcFdcqDzService bdcFdcqDzService;

    @RequestMapping()
    public String toOpinionConfig(Model model, String proid) {
        BdcFdcq bdcFdcq = new BdcFdcq();
        BdcFdcqDz bdcFdcqDz = new BdcFdcqDz();
        BdcBdcdy bdcBdcdy = new BdcBdcdy();
        BdcSpxx bdcSpxx = new BdcSpxx();
        BdcXm bdcXm = new BdcXm();
        String tdsyksqx = "";
        String tdsyjsqx = "";
        String jgsj = "";
        String htqdsj = "";
        String djsj = "";
        String szcc = "";
        String zcss = "";
        String qlid = "";
        String gyqk = "";
        String bdcqzh = "";
        List<BdcFwfzxx> fwfzxxList = null;
        if (StringUtils.isNotBlank(proid)) {
            List<BdcFdcq> fdcqList = bdcFdcqService.getBdcFdcqListByProid(proid);
            bdcSpxx = bdcSpxxService.getBdcSpxxByProid(proid);
            bdcXm = bdcXmService.getBdcXmByProid(proid);
            if (CollectionUtils.isNotEmpty(fdcqList)) {
                //独幢参数
                bdcFdcq = fdcqList.get(0);
                if (StringUtils.isNotBlank(bdcFdcq.getBdcdyid())) {
                    bdcBdcdy = bdcdyService.queryBdcdyById(bdcFdcq.getBdcdyid());
                }
                if (bdcFdcq != null && bdcFdcq.getTdsyksqx() != null)
                    tdsyksqx = CalendarUtil.sdf.format(bdcFdcq.getTdsyksqx());
                if (bdcFdcq != null && bdcFdcq.getTdsyjsqx() != null)
                    tdsyjsqx = CalendarUtil.sdf.format(bdcFdcq.getTdsyjsqx());
                if (bdcFdcq != null && bdcFdcq.getHtqdsj() != null)
                    htqdsj = CalendarUtil.sdf.format(bdcFdcq.getHtqdsj());
                if (bdcFdcq != null && bdcFdcq.getDjsj() != null)
                    djsj = CalendarUtil.sdf.format(bdcFdcq.getDjsj());
                if (bdcFdcq != null && bdcFdcq.getJgsj() != null)
                    jgsj = CalendarUtil.sdf.format(bdcFdcq.getJgsj());
                if (bdcFdcq.getSzc() != null) {
                    szcc = String.valueOf(bdcFdcq.getSzc());
                    model.addAttribute("szcc", szcc);
                } else {
                    szcc = bdcFdcq.getSzmyc();
                    model.addAttribute("szcc", szcc);
                }
                if (bdcFdcq.getZcs() != null) {
                    zcss = String.valueOf(bdcFdcq.getZcs());
                    model.addAttribute("zcss", zcss);
                } else {
                    zcss = bdcFdcq.getMyzcs();
                    model.addAttribute("zcss", zcss);
                }
                List<HashMap> gyfsList = bdcFdcqService.getFdcqGyfsByProid(proid);
                if (CollectionUtils.isNotEmpty(gyfsList)) {
                    HashMap hashMap = gyfsList.get(0);
                    if (hashMap.get("GYFS") != null) {
                        model.addAttribute("gyqk", hashMap.get("GYFS").toString());
                    } else if (hashMap.get("GYQK") != null) {
                        model.addAttribute("gyqk", hashMap.get("GYQK").toString());
                    }
                }
            } else {
                //多幢参数
                bdcFdcqDz = bdcFdcqDzService.getBdcFdcqDzByProid(proid);
                if (StringUtils.isNotBlank(bdcFdcqDz.getBdcdyid())) {
                    bdcBdcdy = bdcdyService.queryBdcdyById(bdcFdcqDz.getBdcdyid());
                }
                if (bdcFdcqDz != null && bdcFdcqDz.getTdsyksqx() != null)
                    tdsyksqx = CalendarUtil.sdf.format(bdcFdcqDz.getTdsyksqx());
                if (bdcFdcqDz != null && bdcFdcqDz.getTdsyjsqx() != null)
                    tdsyjsqx = CalendarUtil.sdf.format(bdcFdcqDz.getTdsyjsqx());
                if (bdcFdcqDz != null && bdcFdcqDz.getHtqdsj() != null)
                    htqdsj = CalendarUtil.sdf.format(bdcFdcqDz.getHtqdsj());
                if (bdcFdcqDz != null && bdcFdcqDz.getDjsj() != null)
                    djsj = CalendarUtil.sdf.format(bdcFdcqDz.getDjsj());
                if (bdcFdcqDz != null && bdcFdcqDz.getJgsj() != null)
                    jgsj = CalendarUtil.sdf.format(bdcFdcqDz.getJgsj());
                if (bdcFdcqDz != null && bdcFdcqDz.getQlid() != null)
                    qlid = bdcFdcqDz.getQlid();
                fwfzxxList = bdcFdcqDzMapper.queryBdcFwfzxxlstByQlid(qlid);
            }
            List<Map> BdcZdGyqk = bdcZdGlService.getZdGyfs();
            if (StringUtils.isNotBlank(bdcFdcqDz.getGyqk())) {
                for (Map dzGyqk : BdcZdGyqk) {
                    if (dzGyqk.get("DM") != null) {
                        if (StringUtils.equals(bdcFdcqDz.getGyqk(), dzGyqk.get("DM").toString())) {
                            gyqk = dzGyqk.get("MC").toString();
                        }
                    }
                }
            }
            //不动产权证号
            List<BdcZs> bdcZsList = bdcZsService.getBdcZsByProid(bdcXm.getProid());
            if (CollectionUtils.isNotEmpty(bdcZsList)) {
                for (BdcZs bdcZs : bdcZsList) {
                    if (StringUtils.isNotBlank(bdcZs.getBdcqzh()))
                        if (StringUtils.isBlank(bdcqzh)) {
                            bdcqzh = bdcZs.getBdcqzh();
                        } else {
                            bdcqzh = bdcqzh + "/" + bdcZs.getBdcqzh();
                        }
                }
            }
        }
        List<HashMap> djlxList = bdcZdGlService.getBdcZdDjlx(new HashMap());
        List<HashMap> fwlxList = bdcZdGlService.getBdcZdBdcdyFwlx();
        List<HashMap> fwxzList = bdcZdGlService.getDjsjZdFwxz(new HashMap());
        List<HashMap> fwjgList = bdcZdGlService.getDjsjZdFwjg(new HashMap());
        List<BdcZdFwyt> fwytList = bdcZdGlService.getBdcZdFwyt();

        model.addAttribute("bdcFdcq", bdcFdcq);
        model.addAttribute("bdcFdcqDz", bdcFdcqDz);
        model.addAttribute("bdcBdcdy", bdcBdcdy);
        model.addAttribute("bdcSpxx", bdcSpxx);
        model.addAttribute("bdcXm", bdcXm);
        model.addAttribute("bdcqzh", bdcqzh);
        model.addAttribute("djlxList", djlxList);
        model.addAttribute("fwlxList", fwlxList);
        model.addAttribute("fwxzList", fwxzList);
        model.addAttribute("fwjgList", fwjgList);
        model.addAttribute("fwjgListJson", JSONObject.toJSONString(fwjgList));
        model.addAttribute("fwytList", fwytList);
        model.addAttribute("fwytListJson", JSONObject.toJSONString(fwytList));
        model.addAttribute("tdsyjsqx", tdsyjsqx);
        model.addAttribute("tdsyksqx", tdsyksqx);
        model.addAttribute("gyqk", gyqk);
        model.addAttribute("htqdsj", htqdsj);
        model.addAttribute("djsj", djsj);
        model.addAttribute("jgsj", jgsj);
        model.addAttribute("fwfzxxList", fwfzxxList);
        if (StringUtils.isNotBlank(bdcFdcq.getQlid())) {
            return "qlxx/bdcFdcq";
        } else if (StringUtils.isNotBlank(bdcFdcqDz.getQlid())) {
            return "qlxx/bdcFdcqDz";
        }
        return null;
    }

    @ResponseBody
    @RequestMapping(value = "/saveBdcFdcq", method = RequestMethod.POST)
    public Map saveBdcHysyq(Model model, BdcFdcq bdcFdcq, String szcc, String zcss) {
        logService.saveOrUpdateLog(bdcFdcq);
        Map map = Maps.newHashMap();
        String returnvalue = "fail";
        if (bdcFdcq != null && StringUtils.isNotBlank(bdcFdcq.getQlid())) {
            //是否为数字
            Pattern pattern = Pattern.compile("^(-)?[1-9][0-9]*$");
            if (StringUtils.isNotBlank(szcc)) {
                Matcher isNum = pattern.matcher(szcc);
                if (isNum.matches()) {
                    bdcFdcq.setSzc(Integer.parseInt(szcc));
                } else {
                    bdcFdcq.setSzmyc(szcc);
                }
            }
            if (StringUtils.isNotBlank(zcss)) {
                Matcher isNum = pattern.matcher(zcss);
                if (isNum.matches()) {
                    bdcFdcq.setZcs(Integer.parseInt(zcss));
                } else {
                    bdcFdcq.setMyzcs(zcss);
                }
            }
            entityMapper.saveOrUpdate(bdcFdcq, bdcFdcq.getQlid());
            returnvalue = "success";
        }
        map.put("msg", returnvalue);

        return map;
    }

    /**
     * @param
     * @author <a href="mailto:liubin@gtmap.cn">liubin</a>
     * @rerutn
     * @description 保存房地产权多幢信息
     */
    @ResponseBody
    @RequestMapping(value = "/saveBdcFdcqDzxx", method = RequestMethod.POST)
    public Map saveBdcFdcqDzxx(Model model, BdcFdcqDz bdcFdcqDz, BdcSpxx bdcSpxx, BdcXm bdcXm, String s) {
        //logService.saveOrUpdateLog(bdcFdcqDz);
        Map map = Maps.newHashMap();
        String returnvalue = "fail";
        if (bdcFdcqDz != null && StringUtils.isNotBlank(bdcFdcqDz.getQlid()) && bdcSpxx != null && StringUtils.isNotBlank(bdcSpxx.getSpxxid()) && bdcXm != null && StringUtils.isNotBlank(bdcXm.getProid())) {
            bdcFdcqDzService.saveBdcFdcqDz(bdcFdcqDz);
            bdcSpxxService.saveBdcSpxx(bdcSpxx);
            bdcXmService.saveBdcXm(bdcXm);
            returnvalue = "success";
        }
        if (StringUtils.isNotBlank(s)) {
            List<BdcFwfzxx> bdcFwfzxxList = JSON.parseArray(s, BdcFwfzxx.class);
            model.addAttribute("bdcFwfzxxList", bdcFwfzxxList);
            if (bdcFwfzxxList != null && CollectionUtils.isNotEmpty(bdcFwfzxxList) && bdcFwfzxxList.size() > 0) {
                for (BdcFwfzxx bdcFwfzxx : bdcFwfzxxList) {
                    //判断是否是新增的项目信息
                    if (bdcFwfzxx.getFzid().length() < 10) {
                        bdcFwfzxx.setFzid(UUIDGenerator.generate18());
                        bdcFwfzxx.setQlid(null != bdcFdcqDz ? bdcFdcqDz.getQlid() : null);
                    }
                    bdcFdcqDzService.saveBdcFwfzxx(bdcFwfzxx);
                }
            }
        }
        map.put("msg", returnvalue);
        return map;
    }

    /**
     * @param
     * @author
     * @rerutn
     * @description 删除房屋分幢信息
     */
    @ResponseBody
    @RequestMapping(value = "/delFwFzxx", method = RequestMethod.POST)
    public Map delFwFzxx(Model model, String fzid) {
        Map map = Maps.newHashMap();
        String returnvalue = "fail";
        if (StringUtils.isNotBlank(fzid)) {
            entityMapper.deleteByPrimaryKey(BdcFwfzxx.class, fzid);
            returnvalue = "success";
        }
        map.put("msg", returnvalue);
        return map;
    }

    @ResponseBody
    @RequestMapping(value = "/getFdcqDzJgsj", method = RequestMethod.POST)
    public Map getFdcqDzJgsj(String fzid) {
        Map map = Maps.newHashMap();
        String jgsj = "";
        List<BdcFwfzxx> bdcFwfzxxList = bdcFdcqDzService.getBdcFwfzxxByFzid(fzid);
        if (CollectionUtils.isNotEmpty(bdcFwfzxxList)) {
            BdcFwfzxx bdcFwfzxx = bdcFwfzxxList.get(0);
            if (bdcFwfzxx.getJgsj() != null) {
                jgsj = CalendarUtil.sdf.format(bdcFwfzxx.getJgsj());
            }
        }
        map.put("msg", jgsj);
        return map;
    }

    @ResponseBody
    @RequestMapping(value = "/changeFjGhytAndJzmj", method = RequestMethod.POST)
    public Map changeFjGhytAndJzmj(String fzid, String qlid, String ghyt, String jzmj) {
        Map map = Maps.newHashMap();
        String fj = "";
        if (StringUtils.isNotBlank(fzid)) {
            List<BdcFwfzxx> bdcFwfzxxList = bdcFdcqDzService.getBdcFwfzxxByFzid(fzid);
            if (CollectionUtils.isNotEmpty(bdcFwfzxxList)) {
                BdcFwfzxx bdcFwfzxx = bdcFwfzxxList.get(0);
                bdcFwfzxx.setGhyt(ghyt);
                bdcFwfzxx.setJzmj(Double.parseDouble(jzmj));
                bdcFdcqDzService.saveBdcFwfzxx(bdcFwfzxx);
            }
        }
        fj = bdcFdcqDzService.getBdcFdcqDzFj(qlid);
        map.put("msg", fj);
        return map;
    }


    @ResponseBody
    @RequestMapping(value = "/updateFjGhytAndJzmj", method = RequestMethod.POST)
    public Map updateFjGhytAndJzmj(String proid) {
        Map map = Maps.newHashMap();
        String fj = "";
        if (StringUtils.isNotBlank(proid)) {
            Example example = new Example(BdcFdcqDz.class);
            example.createCriteria().andEqualTo("proid", proid);
            List<BdcFdcqDz> bdcFdcqDzList = entityMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(bdcFdcqDzList)) {
                BdcFdcqDz bdcFdcqDz = bdcFdcqDzList.get(0);
                String dzXx = "";
                dzXx = bdcZsService.getFj(bdcFdcqDz.getProid());
                if (StringUtils.isNotBlank(dzXx)) {
                    if (StringUtils.isNotBlank(fj)) {
                        fj = fj + "\n" + dzXx;
                    } else {
                        fj = dzXx;
                    }
                }
                bdcFdcqDz.setFj(fj);
                bdcFdcqDzService.saveBdcFdcqDz(bdcFdcqDz);
            }
        }
        map.put("msg", fj);
        return map;
    }
}
