package cn.gtmap.estateplat.config.web.qlxx;/* 
 * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
 * @version 1.0, 2017/8/31
 * @description
 */

import cn.gtmap.estateplat.config.core.mapper.config.BdcHyMapper;
import cn.gtmap.estateplat.config.core.mapper.config.DjsjMapper;
import cn.gtmap.estateplat.config.core.service.BdcDjbService;
import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.model.server.core.*;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/bdcHy")
public class BdcHyController extends BaseController {
    @Autowired
    private BdcZdGlService bdcZdGlService;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private DjsjMapper djsjMapper;
    @Autowired
    private BdcHyMapper bdcHyMapper;
    @Autowired
    private BdcDjbService bdcDjbService;


    @RequestMapping("")
    public String toOpinionConfig(Model model, String bdcdyh, String bdclx) {
        List<BdcHyYhydzb> bdcHyYhydzbList = Lists.newArrayList();
        List<BdcHyFlxx> bdcHyFlxxList = Lists.newArrayList();
        List<Map> zhJzbsbs = Lists.newArrayList();
        List<Map> zhJnbdyjlbs = Lists.newArrayList();
        DjsjZhxx djsjZhxx = new DjsjZhxx();
        String xmxzMc = StringUtils.EMPTY;
        String yhlxaMc = StringUtils.EMPTY;
        String yhlxbMc = StringUtils.EMPTY;
        String hydbMc = StringUtils.EMPTY;
        String hdyt = StringUtils.EMPTY;
        if (StringUtils.isNotBlank(bdcdyh)) {
            String zdzhh = StringUtils.substring(bdcdyh, 0, 19);
            if (StringUtils.isNotBlank(zdzhh)) {
                List<DjsjZhxx> djsjZhxxList = djsjMapper.getDjsjZhxxForDjh(zdzhh);
                if (CollectionUtils.isNotEmpty(djsjZhxxList)) {
                    djsjZhxx = djsjZhxxList.get(0);
                }
                if(djsjZhxx != null && StringUtils.isNoneBlank(djsjZhxx.getZhdm())){
                    zhJzbsbs = bdcHyMapper.getZhJzbsb(djsjZhxx.getZhdm());
                    zhJnbdyjlbs = bdcHyMapper.getFlxx(djsjZhxx.getZhdm());
                }
                if (CollectionUtils.isNotEmpty(zhJnbdyjlbs)) {
                    for (Map map : zhJnbdyjlbs) {
                        if (map.get("YHFS") != null && StringUtils.isNotBlank(map.get("YHFS").toString())) {
                            map.put("YHFS", bdcZdGlService.parseCodeToName(map.get("YHFS").toString(), "YHFS"));
                        }
                    }
                }
                xmxzMc = bdcZdGlService.parseCodeToName(djsjZhxx.getXmxz(),"XMXZ");
                yhlxaMc = bdcZdGlService.parseCodeToName(djsjZhxx.getYhlxa(),"YHLX");
                yhlxbMc = bdcZdGlService.parseCodeToName(djsjZhxx.getYhlxb(),"YHLXB");
                hydbMc = bdcZdGlService.parseCodeToName(djsjZhxx.getDb(),"HYDB");
                hdyt = bdcZdGlService.parseCodeToName(djsjZhxx.getHdyt(),"HDYT");
            }
            model.addAttribute("zdzhh", zdzhh);
        }
        if (StringUtils.isNotBlank(bdclx)) {
            model.addAttribute("bdclxMc", bdcZdGlService.parseCodeToName(bdclx, "BDCLX"));
        }
        model.addAttribute("bdcHyYhydzbList", zhJzbsbs);
        model.addAttribute("bdcHyFlxxList", zhJnbdyjlbs);
        model.addAttribute("djsjZhxx", djsjZhxx);
        model.addAttribute("xmxzMc", xmxzMc);
        model.addAttribute("yhlxa", yhlxaMc);
        model.addAttribute("yhlxb", yhlxbMc);
        model.addAttribute("hydb", hydbMc);
        model.addAttribute("hdyt", hdyt);
        return "qlxx/bdcHy";
    }

    @ResponseBody
    @RequestMapping(value = "/saveBdcHyxx", method = RequestMethod.POST)
    public Map saveBdcHyxx(Model model, BdcHy bdcHy, BdcHyFlxx bdcHyFlxx, BdcHyYhydzb bdcHyYhydzb, String zdzhh) {
        Map map = Maps.newHashMap();
        String returnvalue = "fail";
        if (bdcHy != null && StringUtils.isNotBlank(bdcHy.getHyid())) {
            entityMapper.saveOrUpdate(bdcHy, bdcHy.getHyid());
            if (StringUtils.isNotBlank(bdcHyYhydzb.getYhydzbid())) {
                entityMapper.saveOrUpdate(bdcHyYhydzb, bdcHyYhydzb.getYhydzbid());
            } else {
                bdcHyYhydzb.setYhydzbid(UUIDGenerator.generate18());
                entityMapper.saveOrUpdate(bdcHyYhydzb, bdcHyYhydzb.getYhydzbid());
            }
            if (StringUtils.isNotBlank(bdcHyFlxx.getHyflxxid())) {
                entityMapper.saveOrUpdate(bdcHyFlxx, bdcHyFlxx.getHyflxxid());
            } else {
                bdcHyFlxx.setHyflxxid(UUIDGenerator.generate18());
                entityMapper.saveOrUpdate(bdcHyFlxx, bdcHyFlxx.getHyflxxid());
            }
            returnvalue = "success";
        } else {
            String hyid = UUIDGenerator.generate18();
            if (bdcHy != null) {
                bdcHy.setHyid(hyid);
                bdcHy.setZdzhh(zdzhh);
                entityMapper.saveOrUpdate(bdcHy, bdcHy.getHyid());
            }
            if (StringUtils.isNotBlank(bdcHyYhydzb.getYhydzbid())) {
                bdcHyYhydzb.setHyid(hyid);
                entityMapper.saveOrUpdate(bdcHyYhydzb, bdcHyYhydzb.getYhydzbid());
            } else {
                bdcHyYhydzb.setYhydzbid(UUIDGenerator.generate18());
                bdcHyYhydzb.setHyid(hyid);
                entityMapper.saveOrUpdate(bdcHyYhydzb, bdcHyYhydzb.getYhydzbid());
            }
            if (StringUtils.isNotBlank(bdcHyFlxx.getHyflxxid())) {
                bdcHyFlxx.setHyid(hyid);
                entityMapper.saveOrUpdate(bdcHyFlxx, bdcHyFlxx.getHyflxxid());
            } else {
                bdcHyFlxx.setHyflxxid(UUIDGenerator.generate18());
                bdcHyFlxx.setHyid(hyid);
                entityMapper.saveOrUpdate(bdcHyFlxx, bdcHyFlxx.getHyflxxid());
            }
            returnvalue = "success";
        }
        map.put("msg", returnvalue);
        return map;
    }

}
