package cn.gtmap.estateplat.config.web.qlxx;/*
 * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
 * @version 1.0, 2017/8/29
 * @description
 */

import cn.gtmap.estateplat.config.core.service.*;
import cn.gtmap.estateplat.config.utils.PublicUtil;
import cn.gtmap.estateplat.config.utils.ReadXmlProps;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.*;
import cn.gtmap.estateplat.utils.CalendarUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/bdcHysyq")
public class BdcHysyqController extends BaseController {
    @Autowired
    private BdcZdGlService bdcZdGlService;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private Repo repository;
    @Autowired
    private QllxService qllxService;
    @Autowired
    private BdcXmService bdcXmService;
    @Autowired
    private BdcQlrService bdcQlrService;
    @Autowired
    private LogService logService;

    @RequestMapping("")
    public String toOpinionConfig(Model model, String proid, String djId, String bdcdyh, String bdclx, String qllx, String bdcdyFwlx, String noPropertyRight) {
        List<BdcHysyq> bdcHysyqList = new ArrayList<BdcHysyq>();
        String syksqx = "";
        String syjsqx = "";
        String djsj = "";
        String gyqk = "";
        List<BdcQlr> bdcQlrList = Lists.newArrayList();
        BdcHysyq bdcHysyq = new BdcHysyq();
        BdcBdcdy bdcBdcdy = new BdcBdcdy();
        List<BdcHyFlxx> bdcHyFlxxList = new ArrayList<BdcHyFlxx>();
        BdcXm bdcXm = new BdcXm();
        if (StringUtils.isNotBlank(proid)) {
            Example example = new Example(BdcHysyq.class);
            example.createCriteria().andEqualTo("proid", proid).andEqualTo("qszt", 1);
            bdcHysyqList = entityMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(bdcHysyqList)) {
                bdcHysyq = bdcHysyqList.get(0);
                if (bdcHysyq != null && bdcHysyq.getSyksqx() != null)
                    syksqx = CalendarUtil.sdf.format(bdcHysyq.getSyksqx());
                if (bdcHysyq != null && bdcHysyq.getSyjsqx() != null)
                    syjsqx = CalendarUtil.sdf.format(bdcHysyq.getSyjsqx());
                if (bdcHysyq != null && bdcHysyq.getDjsj() != null)
                    djsj = CalendarUtil.sdf.format(bdcHysyq.getDjsj());
                if (bdcHysyq.getProid() != null) {
                    bdcQlrList = bdcQlrService.queryBdcQlrByProid(bdcHysyq.getProid());
                    if (CollectionUtils.isNotEmpty(bdcQlrList)) {
                        if (bdcQlrList.size() > 1) {
                            BdcQlr bdcQlr = bdcQlrList.get(0);
                            if (StringUtils.isNotBlank(bdcQlr.getGyfs())) {
                                gyqk = bdcQlr.getGyfs();
                            }
                        } else {
                            gyqk = "0";
                        }
                    }
                }
            }
            model.addAttribute("proid", proid);
            bdcXm = bdcXmService.getBdcXmByProid(proid);
            if (bdcXm != null && StringUtils.isNotBlank(bdcXm.getBdcdyid())) {
                Example example1 = new Example(BdcBdcdy.class);
                example1.createCriteria().andEqualTo("bdcdyid", bdcXm.getBdcdyid());
                List<BdcBdcdy> bdcdyList = entityMapper.selectByExample(example1);
                if (CollectionUtils.isNotEmpty(bdcdyList)) {
                    bdcBdcdy = bdcdyList.get(0);
                    if (bdcBdcdy != null && StringUtils.isNotBlank(bdcBdcdy.getBdcdyh())) {
                        Example example2 = new Example(BdcHy.class);
                        example2.createCriteria().andEqualTo("zdzhh", StringUtils.substring(bdcBdcdy.getBdcdyh(), 0, 19));
                        List<BdcHy> bdcHyList = entityMapper.selectByExample(example2);
                        if (CollectionUtils.isNotEmpty(bdcHyList)) {
                            BdcHy bdcHy = bdcHyList.get(0);
                            if (StringUtils.isNotBlank(bdcHy.getHyid())) {
                                Example example3 = new Example(BdcHyFlxx.class);
                                example3.createCriteria().andEqualTo("hyid", bdcHy.getHyid());
                                bdcHyFlxxList = entityMapper.selectByExample(example3);
                                if (CollectionUtils.isNotEmpty(bdcHyFlxxList)) {
                                    for (int i = 0; i < bdcHyFlxxList.size(); i++) {
                                        if (StringUtils.isNotBlank(bdcHyFlxxList.get(i).getSyfs())) {
                                            HashMap map = new HashMap();
                                            map.put("dm", bdcHyFlxxList.get(i).getSyfs());
                                            List<HashMap> bdcZdYhfsList = bdcZdGlService.getBdcZdYhfs(map);
                                            if (CollectionUtils.isNotEmpty(bdcZdYhfsList)) {
                                                if (bdcZdYhfsList.get(0).get("MC") != null) {
                                                    bdcHyFlxxList.get(i).setSyfs(bdcZdYhfsList.get(0).get("MC").toString());
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (CollectionUtils.isEmpty(bdcHyFlxxList)) {
            bdcHyFlxxList = new ArrayList<BdcHyFlxx>();
        }
        List<BdcZdDjlx> bdcZdDjlxList = bdcZdGlService.getBdcZdDjlxList();
        List<HashMap> bdcZdYhfsList = bdcZdGlService.getBdcZdYhfs(new HashMap());
        model.addAttribute("djlxList", bdcZdDjlxList);
        model.addAttribute("yhfsList", bdcZdYhfsList);
        model.addAttribute("syksqx", syksqx);
        model.addAttribute("syjsqx", syjsqx);
        model.addAttribute("djsj", djsj);
        model.addAttribute("bdcHysyq", bdcHysyq);
        model.addAttribute("bdcBdcdy", bdcBdcdy);
        model.addAttribute("bdcXm", bdcXm);
        model.addAttribute("bdcHyFlxxList", bdcHyFlxxList);
        model.addAttribute("qllx", qllx);
        model.addAttribute("djId", djId);
        model.addAttribute("bdcdyh", bdcdyh);
        model.addAttribute("bdclx", bdclx);
        model.addAttribute("bdcdyFwlx", bdcdyFwlx);
        model.addAttribute("gyqk", gyqk);
        model.addAttribute("bdcQlrList", bdcQlrList);
        model.addAttribute("noPropertyRight", noPropertyRight);
        return "qlxx/bdcHysyq";
    }


    @ResponseBody
    @RequestMapping("/getHysyqPagesJson")
    public Object getHysyqPagesJson(Pageable pageable, String bdcdyh) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(bdcdyh))
            map.put("bdcdyh", bdcdyh);
        return repository.selectPaging("getHysyqListByPage", map, pageable);
    }

    @ResponseBody
    @RequestMapping(value = "/saveBdcHysyq", method = RequestMethod.POST)
    public Map saveBdcHysyq(Model model, BdcHysyq bdcHysyq, BdcXm bdcXm, String djId, String bdcdyh, String bdclx, String qllx, String bdcdyFwlx) {
        Map map = Maps.newHashMap();
        String returnValue = "fail";
        if (bdcHysyq != null) {
            String proid = bdcHysyq.getProid();
            String qlid = bdcHysyq.getQlid();
            if (StringUtils.isBlank(proid) && StringUtils.isBlank(qlid)) {
                String cqQllx = ReadXmlProps.getQllx(StringUtils.substring(bdcdyh, 12, 14), StringUtils.substring(bdcdyh, 19, 20));
                if (StringUtils.equals(cqQllx, qllx)) {
                    QllxVo qllxVo = qllxService.initPropertyRight(bdcdyh, bdclx, djId, bdcdyFwlx);
                    if (qllxVo != null) {
                        proid = qllxVo.getProid();
                        qlid = qllxVo.getQlid();
                        PublicUtil.emptyConvertNull(bdcHysyq);
                    }
                }
            }
            if (StringUtils.isNoneBlank(qlid, proid)) {
                bdcHysyq.setProid(proid);
                bdcHysyq.setQlid(qlid);
                logService.saveOrUpdateLog(bdcHysyq);
                entityMapper.saveOrUpdate(bdcHysyq, bdcHysyq.getQlid());
                returnValue = "success";
            }
        }
        map.put("msg", returnValue);
        return map;
    }
}
