package cn.gtmap.estateplat.config.web.qlxx;/*
 * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
 * @version 1.0, 2017/8/30
 * @description
 */

import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.config.core.service.LogService;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.model.server.core.BdcJzwsyq;
import cn.gtmap.estateplat.model.server.core.BdcZdDjlx;
import cn.gtmap.estateplat.model.server.core.BdcZdFwyt;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/bdcJzwsyq")
public class BdcJzwsyqController extends BaseController {
    @Autowired
    private BdcZdGlService bdcZdGlService;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private LogService logService;

    @RequestMapping("")
    public String toOpinionConfig(Model model) {
        List<BdcZdDjlx> djlxList = bdcZdGlService.getBdcZdDjlxList();
        List<BdcZdFwyt> fwytList = bdcZdGlService.getBdcZdFwyt();

        model.addAttribute("djlxList", djlxList);
        model.addAttribute("fwytList", fwytList);
        return "qlxx/bdcJzwsyq";
    }

    @ResponseBody
    @RequestMapping(value = "/saveBdcJzwsyqxx", method = RequestMethod.POST)
    public Map saveBdcJzwsyqxx(Model model, BdcJzwsyq bdcJzwsyq) {
        logService.saveOrUpdateLog(bdcJzwsyq);
        Map map = Maps.newHashMap();
        String returnvalue = "fail";
        if (bdcJzwsyq != null && StringUtils.isNotBlank(bdcJzwsyq.getQlid())) {
            entityMapper.saveOrUpdate(bdcJzwsyq, bdcJzwsyq.getQlid());
            returnvalue = "success";
        }
        map.put("msg", returnvalue);
        return map;
    }

}
