package cn.gtmap.estateplat.config.web.qlxx;/*
 * @author <a href="mailto:liubin@gtmap.cn">liubin</a>
 * @version 1.0, 2017/8/31
 * @description
 */

import cn.gtmap.estateplat.config.core.service.*;
import cn.gtmap.estateplat.config.utils.PublicUtil;
import cn.gtmap.estateplat.config.utils.ReadXmlProps;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.model.server.core.BdcLq;
import cn.gtmap.estateplat.model.server.core.BdcQlr;
import cn.gtmap.estateplat.model.server.core.QllxVo;
import cn.gtmap.estateplat.utils.CalendarUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/bdcLq")
public class BdcLqController extends BaseController {

    @Autowired
    BdcQlrService bdcQlrService;
    @Autowired
    private BdcLqService bdcLqService;
    @Autowired
    private BdcZdGlService bdcZdGlService;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private LogService logService;
    @Autowired
    private QllxService qllxService;

    @RequestMapping("")
    public String toOpinionConfig(Model model, String djId, String bdcdyh, String bdclx, String qllx, String bdcdyFwlx, String proid, String noPropertyRight) {
        String ldsyksqx = "";
        String ldsyjsqx = "";
        String djsj = "";
        String zxdbsj = "";
        String gyqk = "";
        List<BdcQlr> bdcQlrList = Lists.newArrayList();
        BdcLq bdcLq = new BdcLq();
        if (StringUtils.isNoneBlank(proid)) {
            bdcLq = bdcLqService.getBdcLqByProid(proid);
        }
        if (bdcLq != null) {
            if (bdcLq.getLdsyksqx() != null) {
                ldsyksqx = CalendarUtil.sdf.format(bdcLq.getLdsyksqx());
            }
            if (bdcLq.getLdsyjsqx() != null) {
                ldsyjsqx = CalendarUtil.sdf.format(bdcLq.getLdsyjsqx());
            }
            if (bdcLq.getDjsj() != null) {
                djsj = CalendarUtil.sdf.format(bdcLq.getDjsj());
            }
            if (bdcLq.getZxdbsj() != null) {
                zxdbsj = CalendarUtil.sdf.format(bdcLq.getZxdbsj());
            }
            if (bdcLq.getProid() != null) {
                bdcQlrList = bdcQlrService.queryBdcQlrByProid(bdcLq.getProid());
                if (CollectionUtils.isNotEmpty(bdcQlrList)) {
                    if (bdcQlrList.size() > 1) {
                        BdcQlr bdcQlr = bdcQlrList.get(0);
                        if (StringUtils.isNotBlank(bdcQlr.getGyfs())) {
                            gyqk = bdcQlr.getGyfs();
                        }
                    } else {
                        gyqk = "0";
                    }
                }
            }
        } else {
            bdcLq = new BdcLq();
        }
        if (StringUtils.isNoneBlank(qllx)) {
            bdcLq.setQllx(qllx);
        }
        model.addAttribute("ldsyksqx", ldsyksqx);
        model.addAttribute("ldsyjsqx", ldsyjsqx);
        model.addAttribute("djsj", djsj);
        model.addAttribute("zxdbsj", zxdbsj);
        model.addAttribute("gyqk", gyqk);
        model.addAttribute("proid", proid);
        model.addAttribute("qllx", qllx);
        model.addAttribute("djId", djId);
        model.addAttribute("bdcdyh", bdcdyh);
        model.addAttribute("bdclx", bdclx);
        model.addAttribute("bdcdyFwlx", bdcdyFwlx);
        model.addAttribute("bdcQlrList", bdcQlrList);
        model.addAttribute("gyfsList", bdcZdGlService.getZdGyfs());
        model.addAttribute("lzList", bdcZdGlService.getBdcZdLz(new HashMap()));
        model.addAttribute("qyList", bdcZdGlService.getDjsjZdLdqy(new HashMap()));
        model.addAttribute("bdcLq", bdcLq);
        model.addAttribute("noPropertyRight", noPropertyRight);
        return "qlxx/bdcLq";
    }

    @ResponseBody
    @RequestMapping(value = "/saveBdcLq", method = RequestMethod.POST)
    public Map saveBdcLq(Model model, BdcLq bdcLq, String gyqk, String djId, String bdcdyh, String bdclx, String qllx, String bdcdyFwlx) {
        Map map = Maps.newHashMap();
        String returnValue = "fail";
        if (bdcLq != null) {
            String proid = bdcLq.getProid();
            String qlid = bdcLq.getQlid();
            if (StringUtils.isBlank(proid) && StringUtils.isBlank(qlid)) {
                String cqQllx = ReadXmlProps.getQllx(StringUtils.substring(bdcdyh, 12, 14), StringUtils.substring(bdcdyh, 19, 20));
                if (StringUtils.equals(cqQllx, qllx)) {
                    QllxVo qllxVo = qllxService.initPropertyRight(bdcdyh, bdclx, djId, bdcdyFwlx);
                    if (qllxVo != null) {
                        proid = qllxVo.getProid();
                        qlid = qllxVo.getQlid();
                        PublicUtil.emptyConvertNull(bdcLq);
                    }
                }
            }
            if (StringUtils.isNoneBlank(proid, qlid)) {
                bdcLq.setProid(proid);
                bdcLq.setQlid(qlid);
                logService.saveOrUpdateLog(bdcLq);
                if (StringUtils.isNotBlank(bdcLq.getQlid())) {
                    entityMapper.saveOrUpdate(bdcLq, bdcLq.getQlid());
                    returnValue = "success";
                    // 为了 林地使用开始时间 林地使用结束时间 这两个字段可以保存空的特殊处理,因为直接使用这种保存会导致其他字段也为空，后续有更好的办法再修改
                    if (null == bdcLq.getLdsyksqx() || null == bdcLq.getLdsyjsqx()) {
                        BdcLq bdcLq1 = entityMapper.selectByPrimaryKey(BdcLq.class, bdcLq.getQlid());
                        bdcLq1.setLdsyksqx(bdcLq.getLdsyksqx());
                        bdcLq1.setLdsyjsqx(bdcLq.getLdsyjsqx());
                        entityMapper.updateByPrimaryKeyNull(bdcLq1);
                    }
                }
            }
        }
        map.put("msg", returnValue);
        return map;
    }
}






