package cn.gtmap.estateplat.config.web.qlxx;/*
 * @author <a href="mailto:liubin@gtmap.cn">liubin</a>
 * @version 1.0, 2017/8/31
 * @description
 */

import cn.gtmap.estateplat.config.core.mapper.config.BdcZdGlMapper;
import cn.gtmap.estateplat.config.core.mapper.config.DwxxMapper;
import cn.gtmap.estateplat.config.core.service.*;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.model.server.core.*;
import cn.gtmap.estateplat.utils.CalendarUtil;
import com.google.common.collect.Maps;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/bdcTd")
public class BdcTdController extends BaseController {
    @Autowired
    private BdcZdGlService bdcZdGlService;
    @Autowired
    private BdcTdService bdcTdService;
    @Autowired
    private BdcdyService bdcdyService;
    @Autowired
    private DwxxMapper dwxxMapper;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private LogService logService;
    @Autowired
    private BdcZdGlMapper bdcZdGlMapper;
    @Autowired
    private DjsjService djsjService;

    @RequestMapping("/toList")
    public String toList(Model model, String bdcdyh, String bdclx) {
        model.addAttribute("bdcdyh", bdcdyh);
        model.addAttribute("bdclx", bdclx);
        return "qlxx/dcxx";
    }

    @RequestMapping("/zdxx")
    public String toOpinionConfig(Model model, String bdcdyh, String bdclx) {
        DjsjNydDcb djsjNydDcb = null;
        List<DjsjNydDcb> djsjNydDcbList = null;
        BdcBdcdy bdcbdcdy = null;
        BdcBdcdjb bdcBdcdjb = null;
        String djsj = "";
        String yt = "";
        String qlsdfs = "";
        String tddj = "";
        Double zdmj = null;
        if (StringUtils.isNotBlank(bdclx)) {
            HashMap map = new HashMap();
            map.put("dm", bdclx);
            List<Map> bdclxList = bdcZdGlMapper.getBdcZdBdclxList(map);
            if (CollectionUtils.isNotEmpty(bdclxList)) {
                Map map1 = bdclxList.get(0);
                if (map1 != null && map1.get("MC") != null) {
                    String bdclxMc = map1.get("MC").toString();
                    model.addAttribute("bdclxMc", bdclxMc);
                }
            }
        }
        List<BdcTd> bdcTdList = null;
        if (StringUtils.isNoneBlank(bdcdyh)) {
            String djh = bdcdyh.substring(0, 19);
            djsjNydDcbList = djsjService.getDjsjNydDcbByDjh(djh);
            if (CollectionUtils.isNotEmpty(djsjNydDcbList)) {
                djsjNydDcb = djsjNydDcbList.get(0);
                yt = bdcZdGlService.parseCodeToName(djsjNydDcb.getTdyt(),"DLDM");
                qlsdfs = bdcZdGlService.parseCodeToName(djsjNydDcb.getQlsdfs(),"QLSDFS");
                //tddj = bdcZdGlService.parseCodeToName(djsjNydDcb.getDj(),"TDDJ");
                if (djsjNydDcb.getFzmj() != null) {
                    zdmj = djsjNydDcb.getFzmj();
                } else if (djsjNydDcb.getScmj() != null) {
                    zdmj = djsjNydDcb.getScmj();
                }
            }
            bdcbdcdy = bdcdyService.getBdcdyByBdcdyh(bdcdyh);
        }
        if (bdcbdcdy != null && bdcbdcdy.getDjbid() != null)
            bdcBdcdjb = entityMapper.selectByPrimaryKey(BdcBdcdjb.class, bdcbdcdy.getDjbid());
        if (bdcBdcdjb != null && bdcBdcdjb.getDjsj() != null)
            djsj = CalendarUtil.sdf.format(bdcBdcdjb.getDjsj());
        if (zdmj != null) {
            model.addAttribute("zdmj", zdmj);
        } else {
            model.addAttribute("zdmj", "");
        }
        model.addAttribute("djsjNydDcb", djsjNydDcb == null ?new DjsjNydDcb() :djsjNydDcb);
        model.addAttribute("djsj", djsj);
        model.addAttribute("yt", yt);
        model.addAttribute("qlsdfs", qlsdfs);
        model.addAttribute("tddj", tddj);
        model.addAttribute("bdcbdcdy", bdcbdcdy);
        model.addAttribute("bdcBdcdjb", bdcBdcdjb);
        return "qlxx/bdcZdxx";
    }

    @RequestMapping("/lqDcb")
    public String lqDcb(Model model, String bdcdyh, String bdclx) {
        List<DjsjLqxx> djsjLqxxList = null;
        DjsjLqxx djsjLqxx = null;
        String dzwdm = StringUtils.EMPTY;
        String lz = StringUtils.EMPTY;
        if (StringUtils.isNotBlank(bdcdyh)) {
            String djh = bdcdyh.substring(0, 19);
            dzwdm = bdcdyh.substring(19, bdcdyh.length());
            djsjLqxxList = djsjService.getDjsjLqxxByDjh(djh);
            if (CollectionUtils.isNotEmpty(djsjLqxxList)) {
                djsjLqxx = djsjLqxxList.get(0);
                if (StringUtils.isNotBlank(djsjLqxx.getLz())) {
                    HashMap map = new HashMap();
                    map.put("dm", djsjLqxx.getLz());
                    List<HashMap> lzList = bdcZdGlService.getBdcZdLz(map);
                    if (CollectionUtils.isNotEmpty(lzList)) {
                        HashMap lzMap = lzList.get(0);
                        if (lzMap.get("MC") != null) {
                            lz = lzMap.get("MC").toString();
                        }
                    }
                }
            }
        }
        model.addAttribute("djsjLdqy", bdcZdGlService.getDjsjZdLdqy(new HashMap()));
        model.addAttribute("bdczdlz", bdcZdGlService.getBdcZdLz(new HashMap()));
        model.addAttribute("djsjLqxx", djsjLqxx == null ?new DjsjLqxx():djsjLqxx);
        model.addAttribute("dzwdm", dzwdm);
        if(djsjLqxx != null &&StringUtils.isNotBlank(djsjLqxx.getQy())){
            model.addAttribute("qy", bdcZdGlService.parseCodeToName(djsjLqxx.getQy(),"LDQY"));
        }
        model.addAttribute("lz", lz);
        return "qlxx/lqDcb";
    }

    @RequestMapping("/tdcbNydDcxx")
    public String tdcbNydDcxx(Model model, String bdcdyh, String bdclx) {
        List<DjsjCbzdDcb> djsjCbzdDcbList = null;
        DjsjCbzdDcb djsjCbzdDcb = null;
        String yt = "";
        if (StringUtils.isNotBlank(bdcdyh)) {
            String djh = bdcdyh.substring(0, 19);
            djsjCbzdDcbList = djsjService.getDjsjCbzdDcbByDjh(djh);
            if (CollectionUtils.isNotEmpty(djsjCbzdDcbList)) {
                djsjCbzdDcb = djsjCbzdDcbList.get(0);
                if (StringUtils.isNotBlank(djsjCbzdDcb.getTdyt())) {
                    HashMap map = new HashMap();
                    map.put("dm", djsjCbzdDcb.getTdyt());
                    List<HashMap> dldmfsList = bdcZdGlService.getDjsjZdDldm(map);
                    if (CollectionUtils.isNotEmpty(dldmfsList)) {
                        Map dldmMap = dldmfsList.get(0);
                        if (dldmMap.get("MC") != null) {
                            yt = dldmMap.get("MC").toString();
                        }
                    }
                }
            }
        }
        model.addAttribute("djsjCbzdDcb", djsjCbzdDcb);
        if(djsjCbzdDcb != null){
            model.addAttribute("yt", bdcZdGlService.parseCodeToName(djsjCbzdDcb.getTdyt(), "CBTDYT"));
            model.addAttribute("syttlx", bdcZdGlService.parseCodeToName(djsjCbzdDcb.getSyttlx(),"CBSYTTLX"));
            model.addAttribute("yzyfs", bdcZdGlService.parseCodeToName(djsjCbzdDcb.getYzyfs(), "CBYZFS"));
            model.addAttribute("sfjbnt", StringUtils.equals(djsjCbzdDcb.getSfjbnt(),"0") ? "否" : "是");
            model.addAttribute("dldj", bdcZdGlService.parseCodeToName(djsjCbzdDcb.getDldj(), "CBDLDJ"));
        }
        return "qlxx/tdcbNydDcxx";
    }

    @ResponseBody
    @RequestMapping(value = "/saveBdcTd", method = RequestMethod.POST)
    public Map saveBdcTd(Model model, BdcTd bdcTd, String bdcdyh) {
        logService.saveOrUpdateLog(bdcTd);
        Map map = Maps.newHashMap();
        String returnvalue = "fail";
        if (StringUtils.isBlank(bdcTd.getTdid())) {
            bdcTd.setTdid(UUIDGenerator.generate18());
        }
        bdcTd.setZdzhh(bdcdyh.substring(0, 19));
        entityMapper.saveOrUpdate(bdcTd, bdcTd.getTdid());
        returnvalue = "success";
        map.put("msg", returnvalue);
        return map;
    }
}
