package cn.gtmap.estateplat.config.web.qlxx;

import cn.gtmap.estateplat.config.core.service.*;
import cn.gtmap.estateplat.config.utils.PublicUtil;
import cn.gtmap.estateplat.config.utils.ReadXmlProps;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.model.server.core.BdcQlr;
import cn.gtmap.estateplat.model.server.core.BdcTdcbnydsyq;
import cn.gtmap.estateplat.model.server.core.QllxVo;
import cn.gtmap.estateplat.utils.CalendarUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;
import java.util.Map;

/**
 * Created by LB on 2017/9/5.
 */
@Controller
@RequestMapping("/bdcTdcbnydsyq")
public class BdcTdcbnydsyqController {
    @Autowired
    BdcQlrService bdcQlrService;
    @Autowired
    private BdcZdGlService bdcZdGlService;
    @Autowired
    private BdcTdcbnydsyqService bdcTdcbnydsyqService;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private LogService logService;
    @Autowired
    private QllxService qllxService;

    @RequestMapping("")
    public String toOpinionConfig(Model model, String djId, String bdcdyh, String bdclx, String qllx, String bdcdyFwlx, String proid, String noPropertyRight) {
        String syksqx = "";
        String syjsqx = "";
        String djsj = "";
        String zxdbsj = "";
        String gyqk = "";
        List<BdcQlr> bdcQlrList = Lists.newArrayList();
        BdcTdcbnydsyq bdcTdcbnydsyq = new BdcTdcbnydsyq();
        if (StringUtils.isNoneBlank(proid)) {
            bdcTdcbnydsyq = bdcTdcbnydsyqService.getBdcTdcbnydsyqByProid(proid);
        }
        if (bdcTdcbnydsyq != null) {
            if (bdcTdcbnydsyq.getDjsj() != null) {
                djsj = CalendarUtil.sdf.format(bdcTdcbnydsyq.getDjsj());
            }
            if (bdcTdcbnydsyq.getZxdbsj() != null) {
                zxdbsj = CalendarUtil.sdf.format(bdcTdcbnydsyq.getZxdbsj());
            }
            if (bdcTdcbnydsyq.getSyksqx() != null) {
                syksqx = CalendarUtil.sdf.format(bdcTdcbnydsyq.getSyksqx());
            }
            if (bdcTdcbnydsyq.getSyjsqx() != null) {
                syjsqx = CalendarUtil.sdf.format(bdcTdcbnydsyq.getSyjsqx());
            }
            if (bdcTdcbnydsyq.getProid() != null) {
                bdcQlrList = bdcQlrService.queryBdcQlrByProid(bdcTdcbnydsyq.getProid());
                if (CollectionUtils.isNotEmpty(bdcQlrList)) {
                    if (bdcQlrList.size() > 1) {
                        BdcQlr bdcQlr = bdcQlrList.get(0);
                        if (StringUtils.isNotBlank(bdcQlr.getGyfs())) {
                            gyqk = bdcQlr.getGyfs();
                        }
                    } else {
                        gyqk = "0";
                    }
                }
            }
        } else {
            bdcTdcbnydsyq = new BdcTdcbnydsyq();
        }
        if (StringUtils.isNoneBlank(qllx)) {
            bdcTdcbnydsyq.setQllx(qllx);
        }
        model.addAttribute("gyqk", gyqk);
        model.addAttribute("syksqx", syksqx);
        model.addAttribute("syjsqx", syjsqx);
        model.addAttribute("djsj", djsj);
        model.addAttribute("zxdbsj", zxdbsj);
        model.addAttribute("proid", proid);
        model.addAttribute("qllx", qllx);
        model.addAttribute("djId", djId);
        model.addAttribute("bdcdyh", bdcdyh);
        model.addAttribute("bdclx", bdclx);
        model.addAttribute("bdcdyFwlx", bdcdyFwlx);
        model.addAttribute("bdcQlrList", bdcQlrList);
        model.addAttribute("gyfsList", bdcZdGlService.getZdGyfs());
        model.addAttribute("syttlxList", bdcZdGlService.getBdcZdSyttlx(null));
        model.addAttribute("yzyfsList", bdcZdGlService.getBdcZdYzfs(null));
        model.addAttribute("cbfsList", bdcZdGlService.getBdcZdCbjyqqdfs(null));
        model.addAttribute("bdcTdcbnydsyq", bdcTdcbnydsyq);
        model.addAttribute("noPropertyRight", noPropertyRight);
        return "qlxx/bdcTdcbnydsyq";
    }

    @ResponseBody
    @RequestMapping(value = "/saveBdcTdcbnydsyq", method = RequestMethod.POST)
    public Map saveBdcTdcbnydsyq(Model model, BdcTdcbnydsyq bdcTdcbnydsyq, String gyqk, String djId, String bdcdyh, String bdclx, String qllx, String bdcdyFwlx) {
        Map<String, String> map = Maps.newHashMap();
        String returnValue = "fail";
        if (bdcTdcbnydsyq != null) {
            String proid = bdcTdcbnydsyq.getProid();
            String qlid = bdcTdcbnydsyq.getQlid();
            if (StringUtils.isBlank(proid) && StringUtils.isBlank(qlid)) {
                String cqQllx = ReadXmlProps.getQllx(StringUtils.substring(bdcdyh, 12, 14), StringUtils.substring(bdcdyh, 19, 20));
                if (StringUtils.equals(cqQllx, qllx)) {
                    QllxVo qllxVo = qllxService.initPropertyRight(bdcdyh, bdclx, djId, bdcdyFwlx);
                    if (qllxVo != null) {
                        proid = qllxVo.getProid();
                        qlid = qllxVo.getQlid();
                        PublicUtil.emptyConvertNull(bdcTdcbnydsyq);
                    }
                }
            }
            if (StringUtils.isNoneBlank(proid, qlid)) {
                bdcTdcbnydsyq.setProid(proid);
                bdcTdcbnydsyq.setQlid(qlid);
                logService.saveOrUpdateLog(bdcTdcbnydsyq);
                if (StringUtils.isNotBlank(bdcTdcbnydsyq.getQlid())) {
                    entityMapper.saveOrUpdate(bdcTdcbnydsyq, bdcTdcbnydsyq.getQlid());
                    returnValue = "success";
                }
            }
        }
        map.put("msg", returnValue);
        return map;
    }
}
