package cn.gtmap.estateplat.config.web.qlxx;/* 
 * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
 * @version 1.0, 2017/9/6
 * @description
 */

import cn.gtmap.estateplat.config.core.service.*;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.config.utils.PublicUtil;
import cn.gtmap.estateplat.config.utils.ReadXmlProps;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.*;
import cn.gtmap.estateplat.utils.CalendarUtil;
import cn.gtmap.estateplat.utils.CommonUtil;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/bdcXm")
public class BdcXmController extends BaseController {
    @Autowired
    private BdcXmService bdcXmService;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private BdcSpxxService bdcSpxxService;
    @Autowired
    private BdcZdGlService bdcZdGlService;
    @Autowired
    private LogService logService;
    @Autowired
    private QllxService qllxService;

    @RequestMapping("")
    public String toOpinionConfig(Model model, String proid, String djId, String bdcdyh, String bdclx, String qllx, String bdcdyFwlx, String noPropertyRight) {
        String cjsj = "";
        String bjsj = "";
        BdcXm bdcXm = new BdcXm();
        BdcSpxx bdcSpxx = new BdcSpxx();
        if (StringUtils.isNotBlank(proid)) {
            bdcXm = bdcXmService.getBdcXmByProid(proid);
            bdcSpxx = bdcSpxxService.getBdcSpxxByProid(proid);
            if (bdcXm.getCjsj() != null) {
                cjsj = CalendarUtil.sdf.format(bdcXm.getCjsj());
            }
            if (bdcXm.getBjsj() != null) {
                bjsj = CalendarUtil.sdf.format(bdcXm.getBjsj());
            }
            model.addAttribute("proid", proid);
        } else {
            model.addAttribute("proid", "");
        }
        List<Map> qlxzList = bdcZdGlService.getBdcZdQlxzList(null);
        if (StringUtils.contains(bdcXm.getBdclx(), "HY")) {
            Map<String, String> map = Maps.newHashMap();
            if (StringUtils.equals(StringUtils.substring(bdcdyh, 12, 14), "GH")) {
                map.put("parentDm", "500");
            } else {
                map.put("parentDm", "600");
            }
            qlxzList = bdcZdGlService.getBdcZdQlxzList(map);
        }
        List<HashMap> gzwlxList = bdcZdGlService.getBdcZdGzwlx(new HashMap());
        List<HashMap> zdzhytList = bdcZdGlService.getBdcZdzhyt(new HashMap());
        List<HashMap> djsyList = bdcZdGlService.getBdcZdDjsyList();
        List<HashMap> wjmhdytList = bdcZdGlService.getBdcWjmhdyt(new HashMap());
        List<HashMap> yhlxList = bdcZdGlService.getBdcZdYhlx(new HashMap());
        List<HashMap> yhlxbList = bdcZdGlService.getBdcZdYhlxb(new HashMap());
        List<BdcZdFwyt> fwytList = bdcZdGlService.getBdcZdFwyt();
        List<BdcZdSqlx> sqlxList = bdcZdGlService.getBdcZdSqlxList();
        List<HashMap> djlxList = bdcZdGlService.getBdcZdDjlx(new HashMap());
        List<Map> bdclxList = bdcZdGlService.getBdcZdBdclxList();
        model.addAttribute("cjsj", cjsj);
        model.addAttribute("bjsj", bjsj);
        model.addAttribute("bdcXm", bdcXm);
        model.addAttribute("bdcSpxx", bdcSpxx == null ? new BdcSpxx() : bdcSpxx);
        model.addAttribute("qlxzList", qlxzList);
        model.addAttribute("gzwlxList", gzwlxList);
        model.addAttribute("zdzhytList", zdzhytList);
        model.addAttribute("djsyList", djsyList);
        model.addAttribute("wjmhdytList", wjmhdytList);
        model.addAttribute("yhlxList", yhlxList);
        model.addAttribute("yhlxbList", yhlxbList);
        model.addAttribute("fwytList", fwytList);
        model.addAttribute("sqlxList", sqlxList);
        model.addAttribute("djlxList", djlxList);
        model.addAttribute("bdclxList", bdclxList);
        model.addAttribute("qllx", qllx);
        model.addAttribute("djId", djId);
        model.addAttribute("bdcdyh", bdcdyh);
        model.addAttribute("bdclx", bdclx);
        model.addAttribute("bdcdyFwlx", bdcdyFwlx);
        model.addAttribute("noPropertyRight", noPropertyRight);
        model.addAttribute("bdclxMc", bdcZdGlService.parseCodeToName(bdclx, "BDCLX"));
        if (StringUtils.equals(bdclx, Constants.BDCLX_HY) || StringUtils.equals(bdclx, Constants.BDCLX_HYWJM)) {
            return "qlxx/bdcHyXm";
        } else if (StringUtils.equals(bdclx, Constants.BDCLX_TDSL)) {
            return "qlxx/bdcLdXm";
        } else if (StringUtils.equals(bdclx, Constants.BDCLX_TDQT)) {
            return "qlxx/bdcCdXm";
        } else {
            return "qlxx/bdcXm";
        }
    }

    @ResponseBody
    @RequestMapping(value = "/saveBdcXm", method = RequestMethod.POST)
    public Map saveBdcXm(Model model, BdcXm bdcXm, BdcSpxx bdcSpxx, String djId, String bdcdyh, String bdclx, String qllx, String bdcdyFwlx) {
        Map<String, String> map = Maps.newHashMap();
        String returnValue = "fail";
        if (bdcXm != null && bdcSpxx != null) {
            if (StringUtils.isNotBlank(bdcXm.getSqlx())) {
                String dydjlx = StringUtils.EMPTY;
                if (StringUtils.isNoneBlank(AppConfig.getProperty("dydjlx_scdj")) && CommonUtil.indexOfStrs(StringUtils.split(AppConfig.getProperty("dydjlx_scdj"), ","), bdcXm.getSqlx())) {
                    dydjlx = Constants.DJLX_CSDJ_DM;
                } else if (StringUtils.isNoneBlank(AppConfig.getProperty("dydjlx_zydj")) && CommonUtil.indexOfStrs(StringUtils.split(AppConfig.getProperty("dydjlx_zydj"), ","), bdcXm.getSqlx())) {
                    dydjlx = Constants.DJLX_ZYDJ_DM;
                } else if (StringUtils.isNoneBlank(AppConfig.getProperty("dydjlx_bgdj")) && CommonUtil.indexOfStrs(StringUtils.split(AppConfig.getProperty("dydjlx_bgdj"), ","), bdcXm.getSqlx())) {
                    dydjlx = Constants.DJLX_BGDJ_DM;
                } else if (StringUtils.isNoneBlank(AppConfig.getProperty("dydjlx_zxdj")) && CommonUtil.indexOfStrs(StringUtils.split(AppConfig.getProperty("dydjlx_zxdj"), ","), bdcXm.getSqlx())) {
                    dydjlx = Constants.DJLX_ZXDJ_DM;
                }
                bdcXm.setDydjlx(dydjlx);
            }
            if (StringUtils.isBlank(bdcXm.getProid()) && StringUtils.isBlank(bdcSpxx.getProid())) {
                String cqQllx = ReadXmlProps.getQllx(StringUtils.substring(bdcdyh, 12, 14), StringUtils.substring(bdcdyh, 19, 20));
                if (StringUtils.equals(cqQllx, qllx)) {
                    QllxVo qllxVo = qllxService.initPropertyRight(bdcdyh, bdclx, djId, bdcdyFwlx);
                    if (qllxVo != null) {
                        String proid = qllxVo.getProid();
                        if (StringUtils.isNoneBlank(proid)) {
                            BdcXm tempBdcXm = bdcXmService.getBdcXmByProid(proid);
                            if (tempBdcXm != null) {
                                bdcXm.setProid(proid);
                                PublicUtil.emptyConvertNull(bdcXm);
                                bdcSpxx.setProid(proid);
                                BdcSpxx tempBdcSpxx = bdcSpxxService.getBdcSpxxByProid(proid);
                                if (tempBdcSpxx != null && StringUtils.isNoneBlank(tempBdcSpxx.getSpxxid())) {
                                    bdcSpxx.setSpxxid(tempBdcSpxx.getSpxxid());
                                    PublicUtil.emptyConvertNull(bdcSpxx);
                                }
                            }
                        }
                    }
                }
            }
            if (StringUtils.isNotBlank(bdcXm.getProid()) && StringUtils.isNoneBlank(bdcSpxx.getSpxxid(), bdcSpxx.getProid())) {
                logService.saveOrUpdateLog(bdcXm, bdcSpxx);
                entityMapper.updateByPrimaryKeySelective(bdcXm);
                entityMapper.updateByPrimaryKeySelective(bdcSpxx);
                returnValue = "success";
            }
        }
        map.put("msg", returnValue);
        return map;
    }

    @ResponseBody
    @RequestMapping(value = "getSqlxByDjlx")
    public Object getSqlxByBdclxDjlx(String djlx, String bdclx) {
        List<Map> sqlxList = new ArrayList<Map>();
        if (StringUtils.isNotBlank(djlx)) {
            Example example = new Example(BdcZdDjlx.class);
            example.createCriteria().andEqualTo("mc", djlx);
            List<BdcZdDjlx> djlxList = entityMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(djlxList)) {
                sqlxList = bdcZdGlService.getSqlxByDjlx(djlxList.get(0).getDm());
            }
        }
        return sqlxList;
    }
}
