package cn.gtmap.estateplat.config.web.qlxx;

import cn.gtmap.estateplat.config.core.mapper.config.BdcXtZsQlqtzkMapper;
import cn.gtmap.estateplat.config.core.service.*;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.config.utils.PlatformUtil;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.*;
import cn.gtmap.estateplat.utils.CalendarUtil;
import cn.gtmap.estateplat.utils.CommonUtil;
import com.alibaba.fastjson.JSON;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * @author <a href="mailto:liubin@gtmap.cn">liubin</a>
 * @version 1.0, ${date}
 * @description 不动产登记服务
 */
@Controller
@RequestMapping("/bdcdjBdcZs")
public class BdcdjBdcZsController extends BaseController {
    @Autowired
    PlatformUtil platformUtil;
    @Autowired
    BdcQlrService bdcQlrService;
    @Autowired
    BdcZsService bdcZsService;
    @Autowired
    BdcZdGlService bdcZdGlService;
    @Autowired
    QllxService qllxService;
    @Autowired
    BdcZsbhService bdcZsbhService;
    @Autowired
    BdcXtZsQlqtzkMapper bdcXtZsQlqtzkMapper;
    @Autowired
    SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    private Repo repository;
    @Autowired
    private BdcXmService bdcXmService;
    @Autowired
    private BdcdyService bdcdyService;
    @Autowired
    private BdcSpxxService bdcSpxxService;
    @Autowired
    private EntityMapper entityMapper;

    @RequestMapping("")
    public String index(Model model, String qllx, String proid) {
        if (StringUtils.isNotBlank(proid)) {
            model.addAttribute("proid", proid);
            model.addAttribute("qllx", qllx);
        }
        return "djxx/bdcZslist";
    }

    @RequestMapping(value = "/bdcqzms")
    public String bdcqzms(Model model, String zsid, String proid, @RequestParam(value = "wiid", required = false) String wiid) {
        List<HashMap<String, Object>> resultList = new ArrayList<HashMap<String, Object>>();
        List<BdcZs> bdcZsList = null;
        String fzrq = "";
        String bdcdyh = "";
        String dwdm = AppConfig.getProperty("dwdm");
        BdcXm bdcXm = bdcXmService.getBdcXmByProid(proid);
        BdcBdcdy bdcBdcdy = bdcdyService.queryBdcBdcdyByProid(proid);
        if (bdcBdcdy != null) {
            bdcdyh = bdcBdcdy.getBdcdyh();
        }
        int qlqtzkLength = 3;
        if (StringUtils.isNotBlank(zsid)) {
            BdcZs bdcZs = entityMapper.selectByPrimaryKey(BdcZs.class, zsid);
            if (bdcZs != null) {
                bdcZsList = new ArrayList<BdcZs>(1);
                bdcZsList.add(bdcZs);
            }
        }
        if (CollectionUtils.isEmpty(bdcZsList) && StringUtils.isNotBlank(proid)) {
            bdcZsList = bdcZsService.getBdcZsByProid(proid);
        }
        if (CollectionUtils.isNotEmpty(bdcZsList)) {
            for (BdcZs bdcZs : bdcZsList) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("zsid", bdcZs.getZsid());
                map.put("qlrlx", Constants.QLRLX_QLR);
                List<BdcQlr> bdcQlrList = bdcQlrService.findQlrByZsInfo(map);
                String qlr = bdcQlrService.combinationQlr(bdcQlrList);
                map.put("qlrlx", Constants.QLRLX_YWR);
                List<BdcQlr> bdcYwrList = bdcQlrService.queryBdcYwrByProid(proid);
                String ywr = bdcQlrService.combinationYwr(bdcYwrList);
                map.put("proid", proid);
                map.put("dm", bdcZs.getQllx());
                List<BdcZdQllx> qllx = bdcZdGlService.getBdcZdQllx(map);
                map.clear();
                if (CollectionUtils.isNotEmpty(qllx)) {
                    map.put("qllx", qllx.get(0).getMc());
                }
                Integer bdcdyCount = 0;
                if (StringUtils.isNotBlank(bdcZs.getZsid())) {
                    bdcdyCount = bdcZsService.getBdcdyCountByZsid(bdcZs.getZsid());
                }
                if (bdcdyCount > 1) {
                    bdcZs.setBdcdyh(bdcdyh + "等");
                    bdcZs.setZl(bdcZs.getZl() + "等");
                }
                if (bdcZs.getFzrq() != null) {
                    fzrq = CalendarUtil.sdf_China.format(bdcZs.getFzrq());
                } else {
                    fzrq = CalendarUtil.sdf_China.format(new Date());
                }

                qlqtzkLength = getLengthOfQlqtzk(bdcZs, qlqtzkLength);
                map.put("qlqtzkLength", qlqtzkLength);
                map.put("height", qlqtzkLength * 28);
                map.put("bdcZs", bdcZs);
                map.put("fzrq", fzrq);
                map.put("qlr", qlr);
                map.put("ywr", ywr);
                map.put("zsid", bdcZs.getZsid());
                map.put("bh", bdcZs.getBh());
                map.put("fj", bdcZs.getFj());
                resultList.add(map);
            }
        }
        model.addAttribute("resultList", resultList);
        model.addAttribute("bdcXm", bdcXm);
        model.addAttribute("zsid", zsid);
        model.addAttribute("bdcdyh", bdcdyh);
        model.addAttribute("rowList", getRowList(qlqtzkLength));
        model.addAttribute("wiid", wiid);
        model.addAttribute("bdcXm", bdcXm);
        model.addAttribute("dwdm", dwdm);
        return "djxx/bdcqzms";
    }

    @RequestMapping(value = "/ylZs")
    public String ylZs(Model model, String proid, String wiid) {
        String zsFont = "";
        String gyfs = "";
        String ywr = "";
        String fj = "";
        String path = "";
        Integer bdcdyCount = 0;
        List<HashMap<String, Object>> resultList = new ArrayList<HashMap<String, Object>>();
        List<BdcXm> bdcXmList = new ArrayList<BdcXm>();
        BdcXm bdcXm = bdcXmService.getBdcXmByProid(proid);
        if (StringUtils.isNotBlank(wiid)) {
            bdcXmList = bdcXmService.getBdcXmListByWiid(wiid);
        }
        if (CollectionUtils.isNotEmpty(bdcXmList) && bdcXmList.size() > 1 && !CommonUtil.indexOfStrs(Constants.PLDY_YBZS_DM, bdcXm.getSqlx())) {
            model.addAttribute("workflowProid", proid);
            model.addAttribute("wiid", wiid);
            List<String> proidList = new ArrayList<String>();
            for (int i = 0; i < bdcXmList.size(); i++) {
                proidList.add(bdcXmList.get(i).getProid());
            }
            model.addAttribute("proidList", proidList);
            path = "djxx/bdcZsOrZmViewList";
        } else {
            if (StringUtils.isNotBlank(proid)) {
                if (StringUtils.isNotBlank(wiid)) {
                    bdcdyCount = bdcXmService.getBdcdyCountByWiid(bdcXm.getWiid());
                }
                if (bdcXm != null) {
                    QllxVo qlvo = qllxService.makeSureQllx(bdcXm);
                    if (qlvo != null) {
                        zsFont = qllxService.makeSureBdcqzlx(qlvo);
                        qlvo = qllxService.queryQllxVo(bdcXm);
                        if (qlvo != null) {
                            fj = qlvo.getFj();
                        }
                        List<BdcQlr> bdcQlrList = bdcQlrService.queryBdcQlrByProid(proid);
                        gyfs = getGyfs(bdcQlrList);
                        BdcSpxx bdcSpxx = bdcSpxxService.getBdcSpxxByProid(proid);
                        if (bdcSpxx == null) {
                            bdcSpxx = new BdcSpxx();
                        }
                        //处理批量的不动产单元号、坐落
                        if (bdcdyCount > 1) {
                            if (StringUtils.isNotBlank(bdcSpxx.getBdcdyh())) {
                                bdcSpxx.setBdcdyh(bdcSpxx.getBdcdyh() + "等");
                            }
                            if (StringUtils.isNotBlank(bdcSpxx.getZl())) {
                                bdcSpxx.setZl(bdcSpxx.getZl() + "等");
                            }
                        }
                        HashMap querymap = new HashMap();
                        querymap.put("proid", proid);
                        List<HashMap> zsView = bdcZsService.getViewBdcqzList(querymap);
                        querymap.clear();
                        if (StringUtils.isNotBlank(bdcXm.getQllx()))
                            querymap.put("dm", bdcXm.getQllx());
                        List<BdcZdQllx> qllx = bdcZdGlService.getBdcZdQllx(querymap);
                        if (Constants.BDCQZM_BH_FONT.equals(zsFont)) {
                            List<BdcQlr> bdcYwrList = bdcQlrService.queryBdcYwrByProid(proid);
                            if (bdcYwrList != null && bdcYwrList.size() > 0) {
                                for (BdcQlr bdcYwr : bdcYwrList) {
                                    if (StringUtils.isBlank(ywr)) {
                                        ywr = bdcYwr.getQlrmc();
                                    } else {
                                        ywr = ywr + "、" + bdcYwr.getQlrmc();
                                    }
                                }
                            }
                        }
                        if (StringUtils.equals(bdcXm.getSqfbcz(), "是")) {
                            //分别持证
                            if (bdcQlrList != null && bdcQlrList.size() > 0) {
                                for (BdcQlr bdcQlr : bdcQlrList) {
                                    HashMap<String, Object> map = new HashMap<String, Object>();
                                    String qlqtzk = "";
                                    qlqtzk = bdcZsService.getQlqtzk(proid);
                                    map.put("qlr", bdcQlr.getQlrmc());
                                    //其余共有人
                                    String qygyr = "";
                                    for (BdcQlr bdcQlr1 : bdcQlrList) {
                                        if (!StringUtils.equals(bdcQlr1.getQlrmc(), bdcQlr.getQlrmc())) {
                                            qygyr += bdcQlr1.getQlrmc() + " ";
                                        }
                                    }
                                    HashMap mapxt = new HashMap();
                                    List<BdcXtZsQlqtzk> bdcXtZsQlqtzkList = bdcXtZsQlqtzkMapper.getBdcXtZsQlqtzk(mapxt);
                                    if (CollectionUtils.isNotEmpty(bdcXtZsQlqtzkList)) {
                                        for (int i = 0; i < bdcXtZsQlqtzkList.size(); i++) {
                                            String qlqtzkTemp = bdcXtZsQlqtzkList.get(i).getQlqtzkmb();
                                            if (qlqtzkTemp.indexOf("qygyr") > -1) {
                                                if (StringUtils.isNotBlank(qygyr)) {
                                                    qlqtzk = qlqtzkTemp.replace("qygyr", qygyr) + "\n" + qlqtzk;
                                                    break;
                                                }
                                            }
                                        }
                                    }
                                    map.put("qlqtzk", qlqtzk);
                                    resultList.add(map);
                                }
                            }
                        } else {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            String czr = "";
                            String qlqtzk = "";
                            qlqtzk = bdcZsService.getQlqtzk(proid);
                            if (bdcQlrList != null) {
                                if (bdcQlrList.size() == 1) {
                                    czr = bdcQlrList.get(0).getQlrmc();
                                } else if (bdcQlrList.size() > 1) {
                                    for (BdcQlr bdcQlr : bdcQlrList) {
                                        if (czr.equals("")) {
                                            if (StringUtils.isNotBlank(bdcQlr.getQlrmc()))
                                                czr = bdcQlr.getQlrmc();
                                        } else {
                                            if (StringUtils.isNotBlank(bdcQlr.getQlrmc()))
                                                czr = czr + "、" + bdcQlr.getQlrmc();
                                        }
                                    }
                                }
                            }
                            map.put("qlr", czr);
                            map.put("qlqtzk", qlqtzk);
                            resultList.add(map);
                        }
                        model.addAttribute("ywr", ywr);
                        model.addAttribute("bdcSpxx", bdcSpxx);
                        model.addAttribute("gyfs", gyfs);
                        if (CollectionUtils.isNotEmpty(zsView)) {
                            model.addAttribute("zsView", bdcZsService.getSyqx(zsView.get(0)));
                        } else {
                            model.addAttribute("zsView", zsView);
                        }
                        if (CollectionUtils.isNotEmpty(qllx)) {
                            model.addAttribute("qllx", qllx.get(0).getMc());
                        }
                    }
                }
            }
            model.addAttribute("bdcXm", bdcXm);
            model.addAttribute("fj", fj);
            model.addAttribute("resultList", resultList);
            if (Constants.BDCQZM_BH_FONT.equals(zsFont)) {
                path = "djxx/bdcqzmsYl";
            } else {
                model.addAttribute("gyfsList", bdcZdGlService.getZdGyfs());
                path = "djxx/bdcqzYl";
            }
        }
        return path;
    }

    /**
     * 获取权利其他状况的长度
     *
     * @param bdcZs
     * @param qlqtzkLength
     * @return
     */
    public int getLengthOfQlqtzk(BdcZs bdcZs, int qlqtzkLength) {
        if (StringUtils.isNotBlank(bdcZs.getQlqtzk())) {
            int rows = bdcZs.getQlqtzk().split("\n").length;
            if (rows > qlqtzkLength) {
                qlqtzkLength = rows;
            }
        }
        return qlqtzkLength;
    }


    /**
     * @param qlqtzkLength
     * @return
     */
    public List<Integer> getRowList(int qlqtzkLength) {
        List<Integer> rowList = new ArrayList<Integer>(qlqtzkLength);
        for (int x = qlqtzkLength - 1; x > 0; x--) {
            rowList.add(x);
        }
        return rowList;
    }

    /**
     * 获取共有方式
     *
     * @param bdcQlrList
     * @return
     */
    public String getGyfs(List<BdcQlr> bdcQlrList) {
        String gyfs = null;
        if (CollectionUtils.isNotEmpty(bdcQlrList)) {
            BdcQlr bdcQlr = bdcQlrList.get(0);
            if (StringUtils.isBlank(bdcQlr.getGyfs())) {
                gyfs = Constants.GYFS_DDGY_MC;
            } else {
                HashMap map = new HashMap();
                map.put("dm", bdcQlr.getGyfs());
                List<HashMap> gyfsList = bdcZdGlService.getBdcZdGyfsByDm(map);
                if (gyfsList.get(0).get("MC") != null) {
                    gyfs = gyfsList.get(0).get("MC").toString();
                }
            }
        }
        return gyfs;
    }

    @RequestMapping(value = "/bdcqz")
    public String bdcqz(Model model, String zsid, String proid, @RequestParam(value = "wiid", required = false) String wiid) {
        String gyfs = "";
        List<HashMap<String, Object>> resultList = new ArrayList<HashMap<String, Object>>();
        List<BdcZs> bdcZsList = null;
        BdcXm bdcXm = bdcXmService.getBdcXmByProid(proid);
        if (StringUtils.isNotBlank(zsid)) {
            BdcZs bdcZs = entityMapper.selectByPrimaryKey(BdcZs.class, zsid);
            if (bdcZs != null) {
                bdcZsList = new ArrayList<BdcZs>(1);
                bdcZsList.add(bdcZs);
            }
        }
        if (CollectionUtils.isNotEmpty(bdcZsList)) {
            for (BdcZs bdcZs : bdcZsList) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String fzrq = "";
                if (bdcZs.getFzrq() != null) {
                    fzrq = CalendarUtil.sdf_China.format(bdcZs.getFzrq());
                } else {
                    fzrq = CalendarUtil.sdf_China.format(new Date());
                }
                map.put("zsid", bdcZs.getZsid());
                map.put("qlrlx", Constants.QLRLX_QLR);
                List<BdcQlr> bdcQlrList = bdcQlrService.findQlrByZsInfo(map);
                if (CollectionUtils.isNotEmpty(bdcQlrList)) {
                    BdcQlr bdcQlr = bdcQlrList.get(0);
                    if (StringUtils.isBlank(bdcQlr.getGyfs())) {
                        gyfs = Constants.GYFS_DDGY_MC;
                    } else {
                        gyfs = bdcZdGlService.getGyfsByDm(bdcQlr.getGyfs());
                    }
                }
                String qlr = bdcQlrService.combinationQlr(bdcQlrList);
                map.put("qlrlx", Constants.QLRLX_YWR);
                List<BdcQlr> bdcYwrList = bdcQlrService.findQlrByZsInfo(map);
                String ywr = bdcQlrService.combinationYwr(bdcYwrList);
                map.put("proid", proid);
                List<HashMap> zsView = bdcZsService.getViewBdcqzList(map);
                List<BdcZdQllx> qllx = null;
                if (StringUtils.isNotBlank(bdcXm.getQllx())) {
                    map.put("dm", bdcXm.getQllx());
                    qllx = bdcZdGlService.getBdcZdQllx(map);
                }
                map.clear();
                if (qllx != null && CollectionUtils.isNotEmpty(qllx)) {
                    map.put("qllx", qllx.get(0).getMc());
                }
                if (CollectionUtils.isNotEmpty(zsView)) {
                    map.put("zsView", bdcZsService.getSyqx(zsView.get(0)));
                }
                if (StringUtils.isBlank(bdcZs.getBdcdyh())) {
                    if (zsView.get(0).get("BDCDYH") != null) {
                        bdcZs.setBdcdyh(zsView.get(0).get("BDCDYH").toString());
                    }
                }
                if (StringUtils.isBlank(bdcZs.getZl())) {
                    if (zsView.get(0).get("ZL") != null) {
                        bdcZs.setZl(zsView.get(0).get("ZL").toString());
                    }
                }
                if (CollectionUtils.isNotEmpty(zsView)) {
                    if (zsView.get(0).get("FJ") != null && StringUtils.contains(StringUtils.deleteWhitespace(zsView.get(0).get("FJ").toString()), StringUtils.deleteWhitespace(StringUtils.isNotBlank(bdcZs.getFj()) ? bdcZs.getFj() : StringUtils.EMPTY))) {
                        map.put("fj", zsView.get(0).get("FJ"));
                    } else {
                        map.put("fj", bdcZs.getFj());
                    }
                }
                map.put("gyfs", gyfs);
                map.put("bdcZs", bdcZs);
                map.put("qlr", qlr);
                map.put("ywr", ywr);
                map.put("zsid", bdcZs.getZsid());
                map.put("bh", bdcZs.getBh());
                map.put("fzrq", fzrq);
                resultList.add(map);
            }
        }
        model.addAttribute("bdcXm", bdcXm);
        model.addAttribute("resultList", resultList);
        model.addAttribute("zsid", zsid);
        model.addAttribute("gyfsList", bdcZdGlService.getZdGyfs());
        model.addAttribute("wiid", wiid);
        model.addAttribute("proid", proid);
        return "djxx/bdcqz";
    }

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 证书证明重定向
     */
    @RequestMapping("/bdcqzBdcqzm")
    public void bdcqzBdcqzm(HttpServletResponse response, String proid, String qllx, String zsid) throws Exception {
        String url = "";
        String wiid = "";
        if (StringUtils.isNotBlank(proid) && StringUtils.isBlank(zsid)) {
            List<BdcZs> bdcZsList = bdcZsService.getBdcZsByProid(proid);
            BdcXm bdcxm = bdcXmService.getBdcXmByProid(proid);
            wiid = bdcxm.getWiid();
            if (CollectionUtils.isNotEmpty(bdcZsList)) {
                BdcZs bdcZs = bdcZsList.get(0);
                if (StringUtils.isNotBlank(bdcZs.getZsid())) {
                    zsid = bdcZs.getZsid();
                }
            }
        }
        if (qllx.equals(Constants.QLLX_DYAQ)) {
            url = configUrl + "/bdcdjBdcZs/bdcqzms?proid=" + proid + "&wiid=" + wiid + "&zsid=" + zsid;
        } else {
            url = configUrl + "/bdcdjBdcZs/bdcqz?proid=" + proid + "&wiid=" + wiid + "&zsid=" + zsid;
        }
        response.sendRedirect(url);
    }

    @ResponseBody
    @RequestMapping(value = "/saveBdcqzs", method = RequestMethod.POST)
    public Map saveBdcqzs(Model model, String zs) {
        Map map = new HashMap();
        String result = "fail";
        if (StringUtils.isNotBlank(zs)) {
            List<BdcZs> bdcZsList = JSON.parseArray(zs, BdcZs.class);
            model.addAttribute("bdcZsList", bdcZsList);
            if (CollectionUtils.isNotEmpty(bdcZsList)) {
                String msg = bdcZsService.checkBdcqzh(bdcZsList);
                if (StringUtils.isNotBlank(msg)) {
                    result = msg;
                } else {
                    for (BdcZs bdcZs : bdcZsList) {
                        if (bdcZs.getZsid() != null && bdcZs.getZsid().length() > 10) {
                            try {
                                bdcZsService.saveZs(bdcZs);
                                result = "success";
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        }
        map.put("msg", result);
        return map;
    }

    @ResponseBody
    @RequestMapping("/getZsJsonByPage")
    public Object getBdcZfList(Pageable pageable, String proid) {
        BdcXm bdcXm = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNoneBlank(proid)) {
            map.put("proid", proid);
            return repository.selectPaging("getZsJsonByPage", map, pageable);
        } else {
            return null;
        }
    }

    @ResponseBody
    @RequestMapping("/getZsQlr")
    public String getZsQlr(String zsid) {
        StringBuilder stringBuilder = new StringBuilder();
        Example example = new Example(BdcZsQlrRel.class);
        example.createCriteria().andEqualTo("zsid", zsid);
        List<BdcZsQlrRel> bdcZsQlrRelList = entityMapper.selectByExampleNotNull(example);
        if (CollectionUtils.isNotEmpty(bdcZsQlrRelList)) {
            for (BdcZsQlrRel bdcZsQlrRel : bdcZsQlrRelList) {
                if (StringUtils.isNoneBlank(bdcZsQlrRel.getQlrid())) {
                    BdcQlr bdcQlr = entityMapper.selectByPrimaryKey(BdcQlr.class, bdcZsQlrRel.getQlrid());
                    if (bdcQlr != null && StringUtils.isNoneBlank(bdcQlr.getQlrmc())) {
                        stringBuilder.append(bdcQlr.getQlrmc()).append("、");
                    }
                }
            }
            if (StringUtils.isNoneBlank(stringBuilder)) {
                return StringUtils.substring(stringBuilder.toString(), 0, stringBuilder.length() - 1);
            }
        }
        return stringBuilder.toString();
    }
}

