package cn.gtmap.estateplat.config.web.valite;

import cn.gtmap.estateplat.config.core.log.BdcLog;
import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcXtCheckinfo;
import cn.gtmap.estateplat.model.server.core.BdcZdCheck;
import cn.gtmap.estateplat.model.server.core.BdcZdQllx;
import cn.gtmap.estateplat.model.server.core.BdcZdSqlx;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/6/27.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Controller
@RequestMapping(value = "bdcXtCheckConfig")
public class BdcXtCheckConfigController extends BaseController {
    @Autowired
    BdcZdGlService bdcZdGlService;
    @Autowired
    Repo repository;
    @Autowired
    EntityMapper entityMapper;

    //跳转验证配置页面
    @RequestMapping("")
    public String toCheckConfig(Model model) {
        List<BdcZdSqlx> sqlxList = bdcZdGlService.getBdcZdSqlxList();
        List<BdcZdQllx> qllxList = bdcZdGlService.getBdcZdQllxList();
        List<BdcZdCheck> zdCheckList = bdcZdGlService.getBdcZdCheckList();
        model.addAttribute("sqList", sqlxList);
        model.addAttribute("qlList", qllxList);
        model.addAttribute("checkList", zdCheckList);
        return "valite/bdcXtCheck";
    }

    //查询验证配置项
    @ResponseBody
    @RequestMapping("/getBdcXtCheckinfoPagesJson")
    public Object getBdcXtCheckinfoPagesJson(Pageable pageable, BdcXtCheckinfo bdcXtCheckinfo) {
        if (bdcXtCheckinfo != null && StringUtils.isNotBlank(bdcXtCheckinfo.getCheckMsg()))
            bdcXtCheckinfo.setCheckMsg("%" + bdcXtCheckinfo.getCheckMsg() + "%");
        return repository.selectPaging("getBdcXtCheckinfoJsonByPage", bdcXtCheckinfo, pageable);
    }

    //增加配置
    @ResponseBody
    @RequestMapping("/addCheckinfo")
    @BdcLog(controller = "保存转发验证配置日志",parmjson = "保存转发验证配置")
    public HashMap addCheckinfo(Model model, BdcXtCheckinfo bdcXtCheckinfo) {
        HashMap map = new HashMap();
        String result = "保存成功！";
        try {
            if (StringUtils.isBlank(bdcXtCheckinfo.getId()))
                bdcXtCheckinfo.setId(UUIDGenerator.generate18());
            entityMapper.saveOrUpdate(bdcXtCheckinfo, bdcXtCheckinfo.getId());
        } catch (Exception e) {
            e.printStackTrace();
            result = "保存失败！";
        } finally {
            map.put("result", result);
        }
        return map;
    }

    @ResponseBody
    @RequestMapping(value = "valite")
    public String valite(BdcXtCheckinfo bdcXtCheckinfo, String valiteType) {
        String msg = "";
        List<BdcXtCheckinfo> bdcXtCheckinfoList = null;
        if (bdcXtCheckinfo != null) {
            Example example = new Example(BdcXtCheckinfo.class);
            Example.Criteria criteria = example.createCriteria();
            if (StringUtils.isNotBlank(bdcXtCheckinfo.getSqlxdm()))
                criteria.andEqualTo("sqlxdm", bdcXtCheckinfo.getSqlxdm());
            else
                criteria.andIsNull("sqlxdm");
            if (StringUtils.isNotBlank(bdcXtCheckinfo.getQllxdm()))
                criteria.andEqualTo("qllxdm", bdcXtCheckinfo.getQllxdm());
            else
                criteria.andIsNull("qllxdm");
            if (bdcXtCheckinfo.getCheckCode() != null)
                criteria.andEqualTo("checkCode", bdcXtCheckinfo.getCheckCode());
            else
                criteria.andIsNull("checkCode");
            if (StringUtils.isNotBlank(bdcXtCheckinfo.getCheckModel()))
                criteria.andEqualTo("checkModel", bdcXtCheckinfo.getCheckModel());
            else
                criteria.andIsNull("checkModel");
            if (StringUtils.isNotBlank(bdcXtCheckinfo.getCheckType()))
                criteria.andEqualTo("checkType", bdcXtCheckinfo.getCheckType());
            else
                criteria.andIsNull("checkType");
            if (StringUtils.isNotBlank(bdcXtCheckinfo.getYsqlxdm()))
                criteria.andEqualTo("ysqlxdm", bdcXtCheckinfo.getYsqlxdm());
            else
                criteria.andIsNull("ysqlxdm");
            bdcXtCheckinfoList = entityMapper.selectByExample(example);
            if (StringUtils.equals(valiteType, "update")) {
                if (CollectionUtils.isNotEmpty(bdcXtCheckinfoList) && !StringUtils.equals(bdcXtCheckinfo.getId(), bdcXtCheckinfoList.get(0).getId()))
                    msg = "表中存在该数据";
            } else {

                if (CollectionUtils.isNotEmpty(bdcXtCheckinfoList))
                    msg = "表中存在该数据";
            }
        }
        return msg;
    }

    //删除配置
    @ResponseBody
    @RequestMapping("/delYz")
    @BdcLog(controller = "删除转发验证配置日志",parmjson = "删除转发验证配置")
    public HashMap delYz(Model model, String ids) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            String id[] = ids.split(",");
            for (int i = 0; i < id.length; i++)
                entityMapper.deleteByPrimaryKey(BdcXtCheckinfo.class, id[i]);
        } catch (Exception e) {
            e.printStackTrace();
            result = "删除失败！";
        } finally {
            map.put("result", result);
        }
        return map;
    }

}
