package cn.gtmap.estateplat.config.web.valite;

import cn.gtmap.estateplat.config.core.log.BdcLog;
import cn.gtmap.estateplat.config.core.mapper.config.BdcZdGlMapper;
import cn.gtmap.estateplat.config.core.service.BdcSqlxQllxRelService;
import cn.gtmap.estateplat.config.core.service.BdcXtQlqtzkConfigService;
import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcXtQlqtzkConfig;
import cn.gtmap.estateplat.model.server.core.BdcZdDjsy;
import cn.gtmap.estateplat.model.server.core.BdcZdDjzx;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/27.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Controller
@RequestMapping(value = "bdcXtQlqtzkConfig")
public class BdcXtQlqtzkConfigController extends BaseController {

    @Autowired
    BdcZdGlService bdcZdGlService;
    @Autowired
    BdcSqlxQllxRelService bdcSqlxQllxRelService;
    @Autowired
    BdcXtQlqtzkConfigService bdcXtQlqtzkConfigService;
    @Autowired
    Repo repository;
    @Autowired
    private BdcZdGlMapper bdcZdGlMapper;


    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 权利其他状况台帐
     **/
    @RequestMapping(value = "")
    public String toQlqtzkConfig(Model model) {
        model.addAttribute("sqlxList", bdcZdGlService.getBdcZdSqlxList());
        model.addAttribute("fwlxList", bdcZdGlService.getBdcZdBdcdyFwlx());
        model.addAttribute("qllxList", bdcZdGlService.getBdcZdQllxList());
        model.addAttribute("djzxList", bdcZdGlService.getBdcZdDjzxList());
        return "valite/bdcXtQlqtzk";
    }


    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 台帐展示
     **/
    @ResponseBody
    @RequestMapping("/getBdcXtQlqtzkConfigPagesJson")
    public Object getBankFieldPagesJson(Pageable pageable, String sqlx, String qllx, String fwlx,String djzx) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(sqlx)) {
            map.put("sqlx", sqlx);
        }
        if (StringUtils.isNotBlank(qllx)) {
            map.put("qllx", qllx);
        }
        if (StringUtils.isNotBlank(fwlx)) {
            map.put("fwlx", fwlx);
        }
        if (StringUtils.isNotBlank(djzx)) {
            map.put("djzx", djzx);
        }
        //对登记事由处理
        return repository.selectPaging("getBdcXtQlqtzkConfigByPage", map, pageable);
    }


    /**
     * lst
     * 跳转权利其他状况模板配置文件展示页面
     */
    @RequestMapping("viewQlqtzk")
    public String displayQlqtzk(Model model, String type, String sqlx, String qllx, String qllxzlx, String djzx,String ids) {
        String qlqtzkmb = "";
        String qtdb = "";
        String fjmb = "";
        String fjdb = "";
        BdcXtQlqtzkConfig bdcXtQlqtzkConfigQuery = new BdcXtQlqtzkConfig();
        bdcXtQlqtzkConfigQuery.setQllxzlx(qllxzlx);
        bdcXtQlqtzkConfigQuery.setQllxdm(qllx);
        bdcXtQlqtzkConfigQuery.setSqlxdm(sqlx);
        bdcXtQlqtzkConfigQuery.setDjzxdm(djzx);
        List<BdcXtQlqtzkConfig> bdcXtQlqtzkConfigList = bdcXtQlqtzkConfigService.getQlqtzk(bdcXtQlqtzkConfigQuery);
        BdcXtQlqtzkConfig bdcXtQlqtzkConfig = null;
        if (CollectionUtils.isNotEmpty(bdcXtQlqtzkConfigList)) {
            bdcXtQlqtzkConfig = bdcXtQlqtzkConfigList.get(0);
        }
        if (bdcXtQlqtzkConfig == null) {
            bdcXtQlqtzkConfig = new BdcXtQlqtzkConfig();
        }
        model.addAttribute("sqlxList", bdcZdGlService.getBdcZdSqlxList());
        model.addAttribute("fwlxList", bdcZdGlService.getBdcZdBdcdyFwlx());
        model.addAttribute("qllxList", bdcZdGlService.getBdcZdQllxList());
        model.addAttribute("djzxList", bdcZdGlService.getBdcZdDjzxList());
        model.addAttribute("type", type);
        model.addAttribute("sqlx", sqlx);
        model.addAttribute("qllx", qllx);
        model.addAttribute("qllxzlx", qllxzlx);
        model.addAttribute("bdcXtQlqtzkConfig", bdcXtQlqtzkConfig);

        return "valite/viewBdcXtQlqtzk";
    }


    /**
     * @author:<a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @data:2016/3/29
     * @param:sqlxdm
     * @return:String
     * @description: 通过申请类型查询权利类型
     */
    @ResponseBody
    @RequestMapping(value = "getQllxBySqlx")
    public String getQllxBySqlx(String sqlxdm) {
        return bdcSqlxQllxRelService.getQllxBySqlx(sqlxdm);
    }


    /**
     * lst
     * 根据申请类型和子类型
     * 获取对应的模板内容和sql语句
     *
     * @param model
     * @param bdcXtQlqtzkConfig
     * @return
     */
    @ResponseBody
    @RequestMapping("/getQlqtzkData")
    public List<BdcXtQlqtzkConfig> getQlqtzkData(Model model, BdcXtQlqtzkConfig bdcXtQlqtzkConfig) {
        List<BdcXtQlqtzkConfig> list = null;
        list = bdcXtQlqtzkConfigService.getQlqtzk(bdcXtQlqtzkConfig);
        return list;
    }


    /*
    * lst
    * 根据申请类型和子类型
    * 新增或修改模板内容和sql语句
    * @param model
    * @param bdcXtQlqtzkConfig
    * @return
    * */
    @ResponseBody
    @RequestMapping("/saveOrUpdateQlqtzk")
    @BdcLog(controller = "保存权利其他状况配置日志",parmjson = "保存权利其他状况配置")
    public boolean saveOrUpdateQlqtzk(Model model, BdcXtQlqtzkConfig bdcXtQlqtzkConfig) {
        boolean result = true;
        try {
            bdcXtQlqtzkConfigService.saveOrUpdateQlqtzk(bdcXtQlqtzkConfig);
        } catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    /**
     * lst
     * 根据申请类型和子类型
     * 删除模板内容和sql语句
     *
     * @param
     * @param
     * @return
     */
    @ResponseBody
    @RequestMapping("/deleteQlqtzk")
    @BdcLog(controller = "删除权利其他状况配置日志",parmjson = "删除权利其他状况配置")
    public String deleteQlqtzk(String data) {
        String result = "";
        if (StringUtils.isNotBlank(data)) {
            try {
                if (data.contains("/")) {
                    String[] datas = data.split("/");
                    for (String s : datas) {
                        BdcXtQlqtzkConfig bdcXtQlqtzkConfig = getBdcXtQlqtzk(s);
                        bdcXtQlqtzkConfigService.deleteQlqtzk(bdcXtQlqtzkConfig);
                    }
                } else {
                    BdcXtQlqtzkConfig bdcXtQlqtzkConfig = getBdcXtQlqtzk(data);
                    bdcXtQlqtzkConfigService.deleteQlqtzk(bdcXtQlqtzkConfig);
                }
                result = "删除成功";
            } catch (Exception e) {
                e.printStackTrace();
                result = "删除失败";
            }
        } else {
            result = "参数不能为空";
        }
        return result;
    }

    public BdcXtQlqtzkConfig getBdcXtQlqtzk(String data) {
        BdcXtQlqtzkConfig bdcXtQlqtzkConfig = null;
        String[] dataArrays = data.split(",", -1);
        if (dataArrays.length == 3) {
            bdcXtQlqtzkConfig = new BdcXtQlqtzkConfig();
            if (StringUtils.isNotBlank(dataArrays[0])) {
                bdcXtQlqtzkConfig.setSqlxdm(dataArrays[0]);
            }
            if (StringUtils.isNotBlank(dataArrays[1])) {
                bdcXtQlqtzkConfig.setQllxdm(dataArrays[1]);
            }
            if (StringUtils.isNotBlank(dataArrays[2])) {
                bdcXtQlqtzkConfig.setQllxzlx(dataArrays[2]);
            }

        }
        return bdcXtQlqtzkConfig;
    }

    @ResponseBody
    @RequestMapping(value = "valite")
    public Map valite(BdcXtQlqtzkConfig bdcXtQlqtzkConfig, String valiteType) {
        HashMap map = new HashMap();
        List<BdcZdDjsy> djsyList = null;
        if (bdcXtQlqtzkConfig != null && StringUtils.equals(valiteType, "save")) {
            List<BdcXtQlqtzkConfig> bdcXtQlqtzkConfigList = bdcXtQlqtzkConfigService.getQlqtzk(bdcXtQlqtzkConfig);
            if (CollectionUtils.isNotEmpty(bdcXtQlqtzkConfigList)) {
                for (BdcXtQlqtzkConfig bdcXtQlqtzkConfig1 : bdcXtQlqtzkConfigList) {
                    if ((StringUtils.isBlank(bdcXtQlqtzkConfig1.getQllxzlx()) && StringUtils.isBlank(bdcXtQlqtzkConfig.getQllxzlx())) || (StringUtils.equals(bdcXtQlqtzkConfig1.getQllxzlx(), bdcXtQlqtzkConfig.getQllxzlx()))) {
                        map.put("msg", "表中已存在该数据");
                    }
                }

            }

        }
        return map;
    }

    /**
     * @param
     * @return
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description
     */
    @ResponseBody
    @RequestMapping(value = "getDjzxBySqlx")
    public Object getDjzxBySqlx(Model model, String sqlx) {
        List<BdcZdDjzx> djzxList = null;
        if (StringUtils.isNotBlank(sqlx)) {
            String sqlxdm = bdcZdGlService.parseNameToCode(sqlx, "SQLX");
            HashMap map =new HashMap();
            map.put("sqlxdm",sqlxdm);
            djzxList =bdcZdGlMapper.getBdcZdDjzxList(map);
        }
        return djzxList;
    }


}
