package cn.gtmap.estateplat.config.web.value;

import cn.gtmap.estateplat.config.core.log.BdcLog;
import cn.gtmap.estateplat.config.core.service.BdcXtYhService;
import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcXtYh;
import cn.gtmap.estateplat.model.server.core.BdcZdZjlx;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: liujie
 * Date: 15-9-18
 * Time: 下午2:55
 * To change this template use File | Settings | File Templates.
 */
@Controller
@RequestMapping("/bdcXtYh")
public class BankConfigController extends BaseController {

    @Autowired
    BdcZdGlService bdcZdGlService;
    @Autowired
    BdcXtYhService bdcXtYhService;
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    private Repo repository;

    @RequestMapping("")
    public String toOpinionConfig(Model model) {
        List<BdcZdZjlx> bdcZdZjlxList = bdcZdGlService.getBdcZdZjlxList();
        List<HashMap> bdcZdQlrxzList = bdcZdGlService.getQlrxzList();
        List<HashMap> yhMapList = bdcXtYhService.getBdcXtYhMapList();
        model.addAttribute("bdcZdZjlxListJson", JSONObject.toJSONString(bdcZdZjlxList));
        model.addAttribute("bdcZdZjlxList", bdcZdZjlxList);
        model.addAttribute("bdcZdQlrxzList", bdcZdQlrxzList);
        model.addAttribute("yhMapList", yhMapList);
        return "value/bank";
    }

    @ResponseBody
    @RequestMapping("/getBankPagesJson")
    public Object getBankFieldPagesJson(Pageable pageable, String yhmc, String sjyhmc) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(yhmc))
            map.put("yhmc", yhmc);
        if (StringUtils.isNotBlank(sjyhmc))
            map.put("sjyhmc", sjyhmc);
        return repository.selectPaging("getBankListByPage", map, pageable);
    }

    @ResponseBody
    @RequestMapping("/saveBank")
    @BdcLog(controller = "保存银行配置日志", parmjson = "保存银行配置")
    public HashMap saveBank(Model model, BdcXtYh bdcBank) {
        HashMap map = new HashMap();
        String result = "保存成功";
        try {
            bdcXtYhService.insertOrUpdateByPrimaryKey(bdcBank);
        } catch (Exception e) {
            e.printStackTrace();
            result = "保存失败";
        }
        map.put("result", result);
        return map;
    }

    @ResponseBody
    @RequestMapping("/delBank")
    @BdcLog(controller = "删除银行配置日志", parmjson = "删除银行配置")
    public HashMap delBank(Model model, String ids) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            bdcXtYhService.deleteBankByPrimaryKey(ids);
        } catch (Exception e) {
            result = "删除失败！";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }

    @ResponseBody
    @RequestMapping(value = "valite")
    public String valite(BdcXtYh bdcXtYh, String valiteType) {
        String msg = "";
        List<BdcXtYh> bdcXtYhList = null;
        if (bdcXtYh != null) {
            HashMap hashMap = new HashMap();
            hashMap.put("yhmc", bdcXtYh.getYhmc());
            hashMap.put("zjbh", bdcXtYh.getZjbh());
            bdcXtYhList = bdcXtYhService.getBdcXtYhListByMap(hashMap);
            if (StringUtils.equals(valiteType, "update")) {
                if (CollectionUtils.isNotEmpty(bdcXtYhList) && !StringUtils.equals(bdcXtYh.getYhid(), bdcXtYhList.get(0).getYhid())) {
                    msg = "表中存在相应的数据";
                }
            } else if (CollectionUtils.isNotEmpty(bdcXtYhList)) {
                msg = "表中存在相应的数据";
            }

            //单独判断银行编号
            if (StringUtils.isBlank(msg) && StringUtils.isNotBlank(bdcXtYh.getYhbh())) {
                hashMap.clear();
                hashMap.put("yhbh", bdcXtYh.getYhbh());
                bdcXtYhList = bdcXtYhService.getBdcXtYhListByMap(hashMap);
                if (CollectionUtils.isNotEmpty(bdcXtYhList) && !StringUtils.equals(bdcXtYh.getYhid(), bdcXtYhList.get(0).getYhid())) {
                    msg = "银行编号重复";
                }
            }

        }
        return msg;
    }

    @RequestMapping(value = "/scfj", method = RequestMethod.GET)
    public String scfj(Model model, String yhid) {
        String fileCenterUrl = "fcm";
        Integer project_fileId = null;
        if (super.fileCenterUrl != null && super.fileCenterUrl.length() > 4) {
            fileCenterUrl = fileCenterUrl + super.fileCenterUrl.substring(4);
        }
        if (StringUtils.isNotBlank(yhid)) {
            project_fileId = platformUtil.getProjectFileId(yhid);
        }
        model.addAttribute("fileCenterUrl", fileCenterUrl);
        model.addAttribute("nodeId", project_fileId);
        return "main/sjd";
    }
}
