package cn.gtmap.estateplat.config.web.value;

import cn.gtmap.estateplat.config.core.log.BdcLog;
import cn.gtmap.estateplat.config.core.service.BdcRelService;
import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcBdclxSqlxRel;
import cn.gtmap.estateplat.model.server.core.BdcZdDjlx;
import cn.gtmap.estateplat.model.server.core.BdcZdSqlx;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/7/6.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Controller
@RequestMapping(value = "bdcBdclxSqlxRel")
public class BdcBdclxSqlxRelController extends BaseController {


    @Autowired
    Repo repository;
    @Autowired
    BdcRelService bdcRelService;
    @Autowired
    BdcZdGlService bdcZdGlService;
    @Autowired
    EntityMapper entityMapper;

    @RequestMapping(value = "")
    public String displayBdcBdclxSqlxRelPage(Model model) {
        List<BdcZdDjlx> bdcZdDjlxList = bdcZdGlService.getBdcZdDjlxList();
        List<BdcZdSqlx> bdcZdSqlxList = bdcZdGlService.getBdcZdSqlxByDjlx(bdcZdDjlxList.get(0).getDm());
        List<Map> bdcZdBdclxList = bdcZdGlService.getBdcZdBdclxList();
        model.addAttribute("BdcZdDjlxList", bdcZdDjlxList);
        model.addAttribute("BdcZdSqlxList", bdcZdSqlxList);
        model.addAttribute("BdcZdBdclxList", bdcZdBdclxList);
        return "value/bdcBdclxSqlxRel";
    }


    @ResponseBody
    @RequestMapping("/getBdcBdclxSqlxRelPagesJson")
    public Object getBdclxSqlxPagesJson(Pageable pageable, String sqlx, String djlx, String bdclx) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(sqlx))
            map.put("sqlx", sqlx);
        if (StringUtils.isNotBlank(djlx))
            map.put("djlx", djlx);
        if (StringUtils.isNotBlank(bdclx))
            map.put("bdclx", bdclx);
        //对登记事由处理
        return repository.selectPaging("getBdcBdclxSqlxRelByPage", map, pageable);
    }


    @ResponseBody
    @RequestMapping(value = "saveBdcBdclxSqlxRel")
    @BdcLog(controller = "保存不动产类型、登记类型和申请类型关系配置日志",parmjson = "保存不动产类型、登记类型和申请类型关系配置")
    public HashMap saveBdcBdclxSqlxRel(BdcBdclxSqlxRel bdcBdclxSqlxRel) {
        HashMap map = new HashMap();
        String result = "保存成功";
        try {
            if (StringUtils.isBlank(bdcBdclxSqlxRel.getId()))
                bdcBdclxSqlxRel.setId(UUIDGenerator.generate());
            entityMapper.saveOrUpdate(bdcBdclxSqlxRel, bdcBdclxSqlxRel.getId());
        } catch (Exception e) {
            e.printStackTrace();
            result = "保存失败";
        }
        map.put("result", result);
        return map;
    }


    @ResponseBody
    @RequestMapping(value = "delBdcBdclxSqlxRel")
    @BdcLog(controller = "删除不动产类型、登记类型和申请类型关系配置日志",parmjson = "删除不动产类型、登记类型和申请类型关系配置")
    public HashMap delBdcBdclxSqlxRel(String ids) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            if (StringUtils.isNotBlank(ids)) {
                if (ids.contains(",")) {
                    for (String id : ids.split(","))
                        entityMapper.deleteByPrimaryKey(BdcBdclxSqlxRel.class, id);
                } else
                    entityMapper.deleteByPrimaryKey(BdcBdclxSqlxRel.class, ids);
            }

        } catch (Exception e) {
            result = "删除失败！";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }

    @ResponseBody
    @RequestMapping(value = "valite")
    public String valite(BdcBdclxSqlxRel bdcBdclxSqlxRel, String valiteType) {
        String msg = "";
        List<BdcBdclxSqlxRel> bdcBdclxSqlxRelList = null;
        if (bdcBdclxSqlxRel != null) {
            Example example = new Example(BdcBdclxSqlxRel.class);
            Example.Criteria criteria = example.createCriteria();
            if (StringUtils.isNotBlank(bdcBdclxSqlxRel.getDjlxdm()))
                criteria.andEqualTo("djlxdm", bdcBdclxSqlxRel.getDjlxdm());
            if (StringUtils.isNotBlank(bdcBdclxSqlxRel.getSqlxdm()))
                criteria.andEqualTo("sqlxdm", bdcBdclxSqlxRel.getSqlxdm());
            else
                criteria.andIsNull("sqlxdm");
            if (StringUtils.isNotBlank(bdcBdclxSqlxRel.getBdclxdm()))
                criteria.andEqualTo("bdclxdm", bdcBdclxSqlxRel.getBdclxdm());
            else
                criteria.andIsNull("bdclxdm");
            bdcBdclxSqlxRelList = entityMapper.selectByExample(example);
            if (StringUtils.equals(valiteType, "update")) {
                if (CollectionUtils.isNotEmpty(bdcBdclxSqlxRelList) && !StringUtils.equals(bdcBdclxSqlxRel.getId(), bdcBdclxSqlxRelList.get(0).getId()))
                    msg = "表中已存在该数据";
            } else if (CollectionUtils.isNotEmpty(bdcBdclxSqlxRelList)) {
                msg = "表中已存在该数据";
            }
        }
        return msg;
    }

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 根据登记类型获取申请类型，方便下拉框选择
     **/
    @ResponseBody
    @RequestMapping(value = "getBdcZdSqlxListByDjlx")
    public List<BdcZdSqlx> getBdcZdSqlxListByDjlx(String djlx) {
        List<BdcZdSqlx> bdcZdSqlxList = bdcZdGlService.getBdcZdSqlxByDjlx(djlx);
        return bdcZdSqlxList;
    }
}
