package cn.gtmap.estateplat.config.web.value;

import cn.gtmap.estateplat.config.core.log.BdcLog;
import cn.gtmap.estateplat.config.core.service.BdcRelService;
import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcDjlxQllxRel;
import cn.gtmap.estateplat.model.server.core.BdcZdDjlx;
import cn.gtmap.estateplat.model.server.core.BdcZdQllx;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/7/6.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Controller
@RequestMapping(value = "bdcDjlxQllxRel")
public class BdcDjlxQllxRelController extends BaseController {


    @Autowired
    Repo repository;
    @Autowired
    BdcRelService bdcRelService;
    @Autowired
    BdcZdGlService bdcZdGlService;
    @Autowired
    EntityMapper entityMapper;

    @RequestMapping(value = "")
    public String displayBdcQllxDjsyRelPage(Model model) {
        List<BdcZdDjlx> bdcZdDjlxList = bdcZdGlService.getBdcZdDjlxList();
        List<BdcZdQllx> bdcZdQllxList = bdcZdGlService.getBdcZdQllxList();
        model.addAttribute("BdcZdDjlxList", bdcZdDjlxList);
        model.addAttribute("BdcZdQllxList", bdcZdQllxList);
        return "value/bdcDjlxQllxRel";
    }


    @ResponseBody
    @RequestMapping("/getBdcDjlxQllxRelPagesJson")
    public Object getBankFieldPagesJson(Pageable pageable, String djlx, String qllx) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(djlx)) {
            map.put("djlx", djlx);
        }
        if (StringUtils.isNotBlank(qllx)) {
            map.put("qllx", qllx);
        }
        //对登记事由处理
        return repository.selectPaging("getBdcDjlxQllxRelByPage", map, pageable);
    }


    @ResponseBody
    @RequestMapping(value = "saveBdcDjlxQllxRel")
    @BdcLog(controller = "保存登记类型和权利类型关系配置日志",parmjson = "保存登记类型和权利类型关系配置")
    public HashMap saveBdcQllxDjsyRel(BdcDjlxQllxRel bdcDjlxQllxRel) {
        HashMap map = new HashMap();
        String result = "保存成功";
        try {
            if (StringUtils.isBlank(bdcDjlxQllxRel.getId()))
                bdcDjlxQllxRel.setId(UUIDGenerator.generate());
            entityMapper.saveOrUpdate(bdcDjlxQllxRel, bdcDjlxQllxRel.getId());
        } catch (Exception e) {
            e.printStackTrace();
            result = "保存失败";
        }
        map.put("result", result);
        return map;
    }


    @ResponseBody
    @RequestMapping(value = "delBdcDjlxQllxRel")
    @BdcLog(controller = "删除登记类型和权利类型关系配置日志",parmjson = "删除登记类型和权利类型关系配置")
    public HashMap delBdcQllxDjsyRel(String ids) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            if (StringUtils.isNotBlank(ids)) {
                if (ids.contains(",")) {
                    for (String id : ids.split(","))
                        entityMapper.deleteByPrimaryKey(BdcDjlxQllxRel.class, id);
                } else
                    entityMapper.deleteByPrimaryKey(BdcDjlxQllxRel.class, ids);
            }

        } catch (Exception e) {
            result = "删除失败！";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }

    @ResponseBody
    @RequestMapping(value = "valite")
    public String valite(BdcDjlxQllxRel bdcDjlxQllxRel, String valiteType) {
        String msg = "";
        List<BdcDjlxQllxRel> bdcDjlxQllxRelList = null;
        if (bdcDjlxQllxRel != null) {
            Example example = new Example(BdcDjlxQllxRel.class);
            example.createCriteria().andEqualTo("djlxdm", bdcDjlxQllxRel.getDjlxdm()).andEqualTo("qllxdm", bdcDjlxQllxRel.getQllxdm());
            bdcDjlxQllxRelList = entityMapper.selectByExample(example);
            if (StringUtils.equals(valiteType, "update")) {
                if (CollectionUtils.isNotEmpty(bdcDjlxQllxRelList) && !StringUtils.equals(bdcDjlxQllxRel.getId(), bdcDjlxQllxRelList.get(0).getId())) {
                    msg = "表中已存在该数据";
                }
            } else if (CollectionUtils.isNotEmpty(bdcDjlxQllxRelList)) {
                msg = "表中已存在该数据";
            }
        }
        return msg;
    }
}
