package cn.gtmap.estateplat.config.web.value;

import cn.gtmap.estateplat.config.service.BdcJtcyService;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.model.server.core.BdcJtcy;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

/*
 * @author <a href="mailto:gln@gtmap.cn">gln</a>
 * @version 1.0, 2017/11/27
 * @description
 */
@Controller
@RequestMapping(value = "bdcJtcy", method = RequestMethod.GET)
public class BdcJtcyController extends BaseController{
    @Autowired
    private BdcJtcyService bdcJtcyService;

    @RequestMapping(value = "")
    public String displayBdcJtcyPage(Model model) {
        return "value/bdcJtcy";
    }


    @ResponseBody
    @RequestMapping("/getBdcJtcyPagesJson")
    public Object getBdcJtcyPagesJson(Pageable pageable, String mc) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(mc)){
            map.put("mc", mc.trim());
        }
        return bdcJtcyService.getBdcJtcy(map ,pageable);
    }


    @ResponseBody
    @RequestMapping(value = "delBdcJtcy")
    public HashMap delBdcJtcy(String ids) {
        HashMap map = new HashMap();
        String result = "0";
        try {
            if (StringUtils.isNotBlank(ids)) {
                bdcJtcyService.deleteBdcJtcy(ids);
            }
        } catch (Exception e) {
            result = "1";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }

    @ResponseBody
    @RequestMapping(value = "valite",method = RequestMethod.GET)
    public String valite(BdcJtcy bdcJtcy, String valiteType) {
        String msg = "0";
        if (bdcJtcy != null) {
            if (StringUtils.isNotBlank(bdcJtcy.getJtcyid())) {
                if (StringUtils.equals(valiteType, "update")) {
                    msg = "0";
                } else {
                    msg = bdcJtcyService.valiteBdcJtcy(bdcJtcy);
                }
            } else {
                msg = "1";
            }
        }
        return msg;
    }
    @ResponseBody
    @RequestMapping(value = "saveBdcJtcy",method = RequestMethod.POST)
    public HashMap saveBdcSqr(BdcJtcy bdcJtcy) {
        HashMap map = new HashMap();
        String result = "1";
        try {
            bdcJtcyService.saveBdcJtcy(bdcJtcy, bdcJtcy.getJtcyid());
        } catch (Exception e) {
            e.printStackTrace();
            result = "0";
        }
        map.put("result", result);
        return map;
    }

    @RequestMapping("addJtcy")
    public String addJtcy (BdcJtcy bdcJtcy, Model model,String type){
        String gxsj="";
        Date date = bdcJtcy.getGxsj();
        model.addAttribute("bdcJtcy",bdcJtcy);
        model.addAttribute("type",type);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (date!=null) {
        gxsj= sdf.format(bdcJtcy.getGxsj());
        }
        model.addAttribute("gxsj",gxsj);
//        System.out.println(gxsj);
        return "value/addJtcy";
    }
}
