package cn.gtmap.estateplat.config.web.value;

import cn.gtmap.estateplat.config.core.log.BdcLog;
import cn.gtmap.estateplat.config.core.service.BdcRelService;
import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcQllxDjsyRel;
import cn.gtmap.estateplat.model.server.core.BdcZdQllx;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/7/6.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Controller
@RequestMapping(value = "bdcQllxDjsyRel")
public class BdcQllxDjsyRelController extends BaseController {

    @Autowired
    Repo repository;
    @Autowired
    BdcRelService bdcRelService;
    @Autowired
    BdcZdGlService bdcZdGlService;
    @Autowired
    EntityMapper entityMapper;

    @RequestMapping(value = "")
    public String displayBdcQllxDjsyRelPage(Model model) {
        List<HashMap> hashMapList = bdcZdGlService.getBdcZdDjsyList();
        List<BdcZdQllx> bdcZdQllxList = bdcZdGlService.getBdcZdQllxList();
        model.addAttribute("BdcZdDjsyList", hashMapList);
        model.addAttribute("BdcZdQllxList", bdcZdQllxList);
        return "value/bdcQllxDjsyRel";
    }


    @ResponseBody
    @RequestMapping("/getBdcQllxDjsyRelPagesJson")
    public Object getBankFieldPagesJson(Pageable pageable, String qllx, String djsy) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(qllx))
            map.put("qllx", qllx);
        if (StringUtils.isNotBlank(djsy))
            map.put("djsy", djsy);
        //对登记事由处理
        return repository.selectPaging("getBdcQllxDjsyRelByPage", map, pageable);
    }


    @ResponseBody
    @RequestMapping(value = "getDjsyMc")
    public String getDjsyMc(String djsydm) {
        String djsymc = bdcRelService.getDjsyMcByDjsy(djsydm);
        return djsymc;
    }


    @ResponseBody
    @RequestMapping(value = "saveBdcQllxDjsyRel")
    @BdcLog(controller = "保存权利类型和登记事由关系配置日志",parmjson = "保存权利类型和登记事由关系配置")
    public HashMap saveBdcQllxDjsyRel(BdcQllxDjsyRel bdcQllxDjsyRel, String type) {
        HashMap map = new HashMap();
        String result = "保存成功";
        try {
            if (StringUtils.equals(type, "replace"))
                entityMapper.updateByPrimaryKeySelective(bdcQllxDjsyRel);
            else {
                bdcRelService.saveOrUpdateBdcQllxDjsyRel(bdcQllxDjsyRel);
            }
        } catch (Exception e) {
            e.printStackTrace();
            result = "保存失败";
        }
        map.put("result", result);
        return map;
    }


    @ResponseBody
    @RequestMapping(value = "delBdcQllxDjsyRel")
    @BdcLog(controller = "删除权利类型和登记事由关系配置日志",parmjson = "删除权利类型和登记事由关系配置")
    public HashMap delBdcQllxDjsyRel(String ids) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            if (StringUtils.isNotBlank(ids)) {
                if (ids.contains(",")) {
                    for (String id : ids.split(",")) {
                        bdcRelService.delBdcQllxDjsyRelById(id);
                    }
                } else
                    bdcRelService.delBdcQllxDjsyRelById(ids);
            }

        } catch (Exception e) {
            result = "删除失败！";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }

    @ResponseBody
    @RequestMapping(value = "valite")
    public String valite(BdcQllxDjsyRel bdcQllxDjsyRel, String valiteType, String type) {
        String msg = "";
        List<BdcQllxDjsyRel> bdcQllxDjsyRelList = null;
        if (bdcQllxDjsyRel != null) {
            bdcQllxDjsyRelList = bdcRelService.getBdcQllxDjsyRelByQllxAndDjsy(bdcQllxDjsyRel.getQllxdm(), null);
            if (StringUtils.equals(valiteType, "update")) {
                if (CollectionUtils.isNotEmpty(bdcQllxDjsyRelList) && !StringUtils.equals(bdcQllxDjsyRel.getId(), bdcQllxDjsyRelList.get(0).getId())) {
                    msg = "表中已存在该数据";
                }
            } else {
                if (CollectionUtils.isNotEmpty(bdcQllxDjsyRelList)) {
                    msg = "表中已存在该数据";
                }
            }
        }
        return msg;
    }

    @ResponseBody
    @RequestMapping(value = "getDjsy")
    public Object getDjsy(String ids) {
        BdcQllxDjsyRel bdcQllxDjsyRel = null;
        if (StringUtils.isNotBlank(ids)) {
            bdcQllxDjsyRel = entityMapper.selectByPrimaryKey(BdcQllxDjsyRel.class, ids);
        }
        if (bdcQllxDjsyRel == null)
            bdcQllxDjsyRel = new BdcQllxDjsyRel();
        return bdcQllxDjsyRel;
    }
}
