package cn.gtmap.estateplat.config.web.value;

import cn.gtmap.estateplat.config.core.service.BdcQlrService;
import cn.gtmap.estateplat.config.core.service.BdcQlrbqhService;
import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcQlrbqh;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

/**
 * @version 1.0, 2019/8/23.
 * @auto <a href="mailto:zhuwei@gtmap.cn">zhuwei</a>
 * @description 移民搬迁户
 */
@Controller
@RequestMapping(value = "bdcQlrbqh")
public class BdcQlrbqhController {
    @Autowired
    Repo repository;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private BdcQlrbqhService bdcQlrbqhService;


    @RequestMapping(value = "/viewQlrbqh")
    public String viewQlrbqh(Model model) {
        return "value/bdcQlrbqh";
    }

    @ResponseBody
    @RequestMapping(value = "/queryBdcQlrbqh")
    public Object queryBdcQlrbqh(Pageable pageable, String qlrmc, String sfzjh, String qrd) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(qlrmc)) {
            map.put("qlrmc", qlrmc);
        }
        if (StringUtils.isNotBlank(sfzjh)) {
            map.put("sfzjh", sfzjh);
        }
        if (StringUtils.isNotBlank(qrd)) {
            map.put("qrd", qrd);
        }
        return repository.selectPaging("getBdcQlrbqhByPage", map, pageable);
    }

    @ResponseBody
    @RequestMapping(value = "/addQlrbqh")
    public void addQlrbqh(BdcQlrbqh bdcQlrbqh) {
        if (bdcQlrbqh != null) {
            if (StringUtils.isBlank(bdcQlrbqh.getQlrid())) {
                bdcQlrbqh.setQlrid(UUIDGenerator.generate18());
            }
            entityMapper.saveOrUpdate(bdcQlrbqh, bdcQlrbqh.getQlrid());
        }
    }

    @ResponseBody
    @RequestMapping(value = "/delQlrbqh")
    public void delQlrbqh(String qlrids) {
        if (StringUtils.isNotBlank(qlrids)) {
            String[] qlridArr = qlrids.split(",");
            for (String qlrid : qlridArr) {
                entityMapper.deleteByPrimaryKey(BdcQlrbqh.class, qlrid);
            }
        }
    }

    @ResponseBody
    @RequestMapping(value = "/addKey")
    public void addKey(String qlrids, String zlgjz, String zlgjz2, String zlgjz3) {
        if (StringUtils.isNotBlank(qlrids)) {
            String[] qlridArr = qlrids.split(",");
            if (StringUtils.isNotBlank(zlgjz) || StringUtils.isNotBlank(zlgjz2) || StringUtils.isNotBlank(zlgjz3)) {
                for (String qlrid : qlridArr) {
                    BdcQlrbqh bdcQlrbqh = entityMapper.selectByPrimaryKey(BdcQlrbqh.class, qlrid);
                    if (bdcQlrbqh != null) {
                        bdcQlrbqh.setZlgjz(zlgjz);
                        bdcQlrbqh.setZlgjz2(zlgjz2);
                        bdcQlrbqh.setZlgjz3(zlgjz3);
                        entityMapper.saveOrUpdate(bdcQlrbqh, bdcQlrbqh.getQlrid());
                    }
                }
            }
        }
    }

    /**
     * @author <a href="mailto:zhuwei@gtmap.cn">zhuwei</a>
     * @param multipartFile
     * @description  导入excel
     */
    @ResponseBody
    @RequestMapping("readExcel")
    public String readExcel(MultipartFile multipartFile) throws IOException {
        String statue = "fail";
//        Map<String, String> resultMap = Maps.newHashMap();
        Map resultMap = new HashMap();

        //获取上传的文件的文件名
        String originalFilename = multipartFile.getOriginalFilename();
        InputStream inputStream = null;
        try {
            inputStream = multipartFile.getInputStream();
        } catch (IOException e) {
            throw new AppException("获取文件输入流出错!");
        }
        if (inputStream != null) {
            String suffix = StringUtils.substring(originalFilename, originalFilename.lastIndexOf("."));
            if (StringUtils.equals(suffix, ".xls") || StringUtils.equals(suffix, ".xlsx")) {
                try {
                    resultMap = bdcQlrbqhService.getExcelAsInputStream(inputStream);
                    resultMap.put("statue", "success");
                } catch (Exception e) {
                    resultMap.put("statue", "fail");
                    e.printStackTrace();
                } finally {
                    inputStream.close();
                }
            }
        }
        return JSON.toJSONString(resultMap);
    }
}
