package cn.gtmap.estateplat.config.web.value;

import cn.gtmap.estateplat.config.core.log.BdcLog;
import cn.gtmap.estateplat.config.core.service.BdcRelService;
import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcSqlxDjsyRel;
import cn.gtmap.estateplat.model.server.core.BdcZdSqlx;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/7/6.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Controller
@RequestMapping(value = "bdcSqlxDjsyRel")
public class BdcSqlxDjsyRelController extends BaseController {


    @Autowired
    Repo repository;
    @Autowired
    BdcRelService bdcRelService;
    @Autowired
    BdcZdGlService bdcZdGlService;
    @Autowired
    EntityMapper entityMapper;

    @RequestMapping(value = "")
    public String displayBdcQllxDjsyRelPage(Model model) {
        List<HashMap> hashMapList = bdcZdGlService.getBdcZdDjsyList();
        List<BdcZdSqlx> bdcZdSqlxList = bdcZdGlService.getBdcZdSqlxList();
        model.addAttribute("BdcZdDjsyList", hashMapList);
        model.addAttribute("BdcZdSqlxList", bdcZdSqlxList);
        return "value/bdcSqlxDjsyRel";
    }


    @ResponseBody
    @RequestMapping("/getBdcSqlxDjsyRelPagesJson")
    public Object getBankFieldPagesJson(Pageable pageable, String sqlx, String djsy) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(sqlx))
            map.put("sqlx", sqlx);
        if (StringUtils.isNotBlank(djsy))
            map.put("djsy", djsy);
        //对登记事由处理
        return repository.selectPaging("getBdcSqlxDjsyRelByPage", map, pageable);
    }


    @ResponseBody
    @RequestMapping(value = "getDjsyMc")
    public String getDjsyMc(String id) {
        String djsymc = "";
        if (StringUtils.isNotBlank(id)) {
            BdcSqlxDjsyRel bdcSqlxDjsyRel = entityMapper.selectByPrimaryKey(BdcSqlxDjsyRel.class, id);
            if (bdcSqlxDjsyRel != null && StringUtils.isNotBlank(bdcSqlxDjsyRel.getDjsy()))
                djsymc = bdcRelService.getDjsyMcByDjsy(bdcSqlxDjsyRel.getDjsy());
        }
        return djsymc;
    }


    @ResponseBody
    @RequestMapping(value = "saveBdcSqlxDjsyRel")
    @BdcLog(controller = "保存申请类型和登记事由关系配置日志",parmjson = "保存申请类型和登记事由关系配置")
    public HashMap saveBdcQllxDjsyRel(BdcSqlxDjsyRel bdcSqlxDjsyRel, String type) {
        HashMap map = new HashMap();
        String result = "保存成功";
        try {
            if (StringUtils.equals(type, "update")) {
                entityMapper.updateByPrimaryKeySelective(bdcSqlxDjsyRel);
            } else
                bdcRelService.saveOrUpdateBdcSqlxDjsyRel(bdcSqlxDjsyRel);
        } catch (Exception e) {
            e.printStackTrace();
            result = "保存失败";
        }
        map.put("result", result);
        return map;
    }


    @ResponseBody
    @RequestMapping(value = "delBdcSqlxDjsyRel")
    @BdcLog(controller = "删除申请类型和登记事由关系配置日志",parmjson = "删除申请类型和登记事由关系配置")
    public HashMap delBdcQllxDjsyRel(String ids) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            if (StringUtils.isNotBlank(ids)) {
                if (ids.contains(",")) {
                    for (String id : ids.split(","))
                        entityMapper.deleteByPrimaryKey(BdcSqlxDjsyRel.class, id);
                } else
                    entityMapper.deleteByPrimaryKey(BdcSqlxDjsyRel.class, ids);
            }

        } catch (Exception e) {
            result = "删除失败！";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }

    @ResponseBody
    @RequestMapping(value = "valite")
    public String valite(BdcSqlxDjsyRel bdcSqlxDjsyRel, String valiteType, String type) {
        String msg = "";
        List<BdcSqlxDjsyRel> bdcSqlxDjsyRelList = null;
        if (bdcSqlxDjsyRel != null) {
            bdcSqlxDjsyRelList = bdcRelService.getBdcSqlxDjsyRelListBySqlxAndDjsy(bdcSqlxDjsyRel.getSqlx(), "");
            if (StringUtils.equals(valiteType, "update")) {
                if (CollectionUtils.isNotEmpty(bdcSqlxDjsyRelList) && !StringUtils.equals(bdcSqlxDjsyRel.getId(), bdcSqlxDjsyRelList.get(0).getId())) {
                    msg = "表中已存在该数据";
                }
            } else {
                if (CollectionUtils.isNotEmpty(bdcSqlxDjsyRelList)) {
                    msg = "表中已存在该关系数据";
                }
            }
        }
        return msg;
    }


    @ResponseBody
    @RequestMapping(value = "getDjsy")
    public Object getDjsy(String ids) {
        BdcSqlxDjsyRel bdcSqlxDjsyRel = null;
        if (StringUtils.isNotBlank(ids)) {
            bdcSqlxDjsyRel = entityMapper.selectByPrimaryKey(BdcSqlxDjsyRel.class, ids);
        }
        if (bdcSqlxDjsyRel == null)
            bdcSqlxDjsyRel = new BdcSqlxDjsyRel();
        return bdcSqlxDjsyRel;
    }

}
