package cn.gtmap.estateplat.config.web.value;

import cn.gtmap.estateplat.config.core.log.BdcLog;
import cn.gtmap.estateplat.config.core.service.BdcRelService;
import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcSqlxDjyyRel;
import cn.gtmap.estateplat.model.server.core.BdcZdSqlx;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/7/6.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Controller
@RequestMapping(value = "bdcSqlxDjyyRel")
public class BdcSqlxDjyyRelController extends BaseController {


    @Autowired
    Repo repository;
    @Autowired
    BdcRelService bdcRelService;
    @Autowired
    BdcZdGlService bdcZdGlService;
    @Autowired
    EntityMapper entityMapper;

    @RequestMapping(value = "")
    public String displayBdcQllxDjyyRelPage(Model model) {
        List<BdcZdSqlx> bdcZdSqlxList = bdcZdGlService.getBdcZdSqlxList();
        model.addAttribute("BdcZdSqlxList", bdcZdSqlxList);
        return "value/bdcSqlxDjyyRel";
    }


    @ResponseBody
    @RequestMapping("/getBdcSqlxDjyyRelPagesJson")
    public Object getBankFieldPagesJson(Pageable pageable, String sqlx) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(sqlx))
            map.put("sqlx", sqlx);
        //对登记事由处理
        return repository.selectPaging("getBdcSqlxDjyyRelByPage", map, pageable);
    }


    @ResponseBody
    @RequestMapping(value = "saveBdcSqlxDjyyRel")
    @BdcLog(controller = "保存申请类型和登记原因关系配置日志",parmjson = "保存申请类型和登记原因关系配置")
    public HashMap saveBdcQllxDjyyRel(BdcSqlxDjyyRel bdcSqlxDjyyRel) {
        HashMap map = new HashMap();
        String result = "保存成功";
        try {
            if (StringUtils.isBlank(bdcSqlxDjyyRel.getId()))
                bdcSqlxDjyyRel.setId(UUIDGenerator.generate());
            entityMapper.saveOrUpdate(bdcSqlxDjyyRel, bdcSqlxDjyyRel.getId());
        } catch (Exception e) {
            e.printStackTrace();
            result = "保存失败";
        }
        map.put("result", result);
        return map;
    }


    @ResponseBody
    @RequestMapping(value = "delBdcSqlxDjyyRel")
    @BdcLog(controller = "删除申请类型和登记原因关系配置日志",parmjson = "删除申请类型和登记原因关系配置")
    public HashMap delBdcQllxDjyyRel(String ids) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            if (StringUtils.isNotBlank(ids)) {
                if (ids.contains(",")) {
                    for (String id : ids.split(","))
                        entityMapper.deleteByPrimaryKey(BdcSqlxDjyyRel.class, id);
                } else
                    entityMapper.deleteByPrimaryKey(BdcSqlxDjyyRel.class, ids);
            }

        } catch (Exception e) {
            result = "删除失败！";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }

    @ResponseBody
    @RequestMapping(value = "valite")
    public String valite(BdcSqlxDjyyRel bdcSqlxDjyyRel, String valiteType) {
        String msg = "";
        List<BdcSqlxDjyyRel> bdcSqlxDjyyRelList = null;
        if (bdcSqlxDjyyRel != null) {
            Example example = new Example(BdcSqlxDjyyRel.class);
            example.createCriteria().andEqualTo("sqlxdm", bdcSqlxDjyyRel.getSqlxdm());
            bdcSqlxDjyyRelList = entityMapper.selectByExample(example);
            if (StringUtils.equals(valiteType, "update")) {
                if (CollectionUtils.isNotEmpty(bdcSqlxDjyyRelList) && !StringUtils.equals(bdcSqlxDjyyRel.getId(), bdcSqlxDjyyRelList.get(0).getId())) {
                    msg = "表中已存在该数据";
                }
            } else {
                if (CollectionUtils.isNotEmpty(bdcSqlxDjyyRelList)) {
                    msg = "表中已存在该数据";
                }
            }
        }

        return msg;
    }
}
