package cn.gtmap.estateplat.config.web.value;

import cn.gtmap.estateplat.config.core.log.BdcLog;
import cn.gtmap.estateplat.config.core.service.BdcRelService;
import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcSqlxDjzxRel;
import cn.gtmap.estateplat.model.server.core.BdcZdDjzx;
import cn.gtmap.estateplat.model.server.core.BdcZdSqlx;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/7/6.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Controller
@RequestMapping(value = "bdcSqlxDjzxRel")
public class BdcSqlxDjzxRelController extends BaseController {


    @Autowired
    Repo repository;
    @Autowired
    BdcRelService bdcRelService;
    @Autowired
    BdcZdGlService bdcZdGlService;
    @Autowired
    EntityMapper entityMapper;

    @RequestMapping(value = "")
    public String displayBdcQllxDjsyRelPage(Model model) {
        List<BdcZdDjzx> bdcZdDjzxList = bdcZdGlService.getBdcZdDjzxList();
        List<BdcZdSqlx> bdcZdSqlxList = bdcZdGlService.getBdcZdSqlxList();
        model.addAttribute("BdcZdDjzxList", bdcZdDjzxList);
        model.addAttribute("BdcZdSqlxList", bdcZdSqlxList);
        return "value/bdcSqlxDjzxRel";
    }


    @ResponseBody
    @RequestMapping("/getBdcSqlxDjzxRelPagesJson")
    public Object getBankFieldPagesJson(Pageable pageable, String sqlx, String djzx) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(sqlx))
            map.put("sqlx", sqlx);
        if (StringUtils.isNotBlank(djzx))
            map.put("djzx", djzx);
        //对登记事由处理
        return repository.selectPaging("getBdcSqlxDjzxRelByPage", map, pageable);
    }


    @ResponseBody
    @RequestMapping(value = "saveBdcSqlxDjzxRel")
    @BdcLog(controller = "保存申请类型和登记子项关系配置日志",parmjson = "保存申请类型和登记子项关系配置")
    public HashMap saveBdcQllxDjsyRel(BdcSqlxDjzxRel bdcSqlxDjzxRel) {
        HashMap map = new HashMap();
        String result = "保存成功";
        try {
            if (StringUtils.isBlank(bdcSqlxDjzxRel.getId()))
                bdcSqlxDjzxRel.setId(UUIDGenerator.generate());
            entityMapper.saveOrUpdate(bdcSqlxDjzxRel, bdcSqlxDjzxRel.getId());
        } catch (Exception e) {
            e.printStackTrace();
            result = "保存失败";
        }
        map.put("result", result);
        return map;
    }


    @ResponseBody
    @RequestMapping(value = "delBdcSqlxDjzxRel")
    @BdcLog(controller = "删除申请类型和登记子项关系配置日志",parmjson = "删除申请类型和登记子项关系配置")
    public HashMap delBdcQllxDjsyRel(String ids) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            if (StringUtils.isNotBlank(ids)) {
                if (ids.contains(",")) {
                    for (String id : ids.split(","))
                        entityMapper.deleteByPrimaryKey(BdcSqlxDjzxRel.class, id);
                } else
                    entityMapper.deleteByPrimaryKey(BdcSqlxDjzxRel.class, ids);
            }

        } catch (Exception e) {
            result = "删除失败！";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }

    @ResponseBody
    @RequestMapping(value = "valite")
    public String valite(BdcSqlxDjzxRel bdcSqlxDjzxRel, String valiteType) {
        String msg = "";
        List<BdcSqlxDjzxRel> bdcSqlxDjzxRelList = null;
        if (bdcSqlxDjzxRel != null) {
            bdcSqlxDjzxRelList = bdcRelService.getBdcSqlxDjzxRelBySqlxOrDjzx(bdcSqlxDjzxRel.getSqlxdm(), bdcSqlxDjzxRel.getDjzxdm());
            if (StringUtils.equals(valiteType, "update")) {
                if (CollectionUtils.isNotEmpty(bdcSqlxDjzxRelList) && !StringUtils.equals(bdcSqlxDjzxRel.getId(), bdcSqlxDjzxRelList.get(0).getId()))
                    msg = "表中存在相应数据";
            } else if (CollectionUtils.isNotEmpty(bdcSqlxDjzxRelList)) {
                msg = "表中存在相应数据";
            }
        }
        return msg;
    }
}
