package cn.gtmap.estateplat.config.web.value;

import cn.gtmap.estateplat.config.core.log.BdcLog;
import cn.gtmap.estateplat.config.core.service.BdcRelService;
import cn.gtmap.estateplat.config.core.service.BdcSqlxQllxRelService;
import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcSqlxQllxRel;
import cn.gtmap.estateplat.model.server.core.BdcZdDjlx;
import cn.gtmap.estateplat.model.server.core.BdcZdQllx;
import cn.gtmap.estateplat.model.server.core.BdcZdSqlx;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/28.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Controller
@RequestMapping(value = "/bdcSqlxQllxRel")
public class BdcSqlxQllxRelController extends BaseController {

    @Autowired
    BdcZdGlService bdcZdGlService;
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    BdcSqlxQllxRelService bdcSqlxQllxRelService;
    @Autowired
    Repo repository;
    @Autowired
    BdcRelService bdcRelService;


    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description
     **/
    @RequestMapping(value = "")
    public String toSqlxQllxRelConfig(Model model) {
        List<BdcZdSqlx> bdcZdSqlxList = bdcZdGlService.getBdcZdSqlxList();
        List<BdcZdQllx> bdcZdQllxList = bdcZdGlService.getBdcZdQllxList();
        model.addAttribute("BdcZdSqlxList", bdcZdSqlxList);
        model.addAttribute("BdcZdQllxList", bdcZdQllxList);
        return "value/bdcSqlxQllxRel";
    }


    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取台帐
     **/
    @ResponseBody
    @RequestMapping("/getBdcSqlxQllxRelPagesJson")
    public Object getBankFieldPagesJson(Pageable pageable, String sqlx, String qllx) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(sqlx))
            map.put("sqlx", sqlx);
        if (StringUtils.isNotBlank(qllx))
            map.put("qllx", qllx);
        //对登记事由处理
        return repository.selectPaging("getBdcSqlxQllxRelByPage", map, pageable);
    }

    /**
     * 跳转申请类型和权利类型关系表配置页面
     *
     * @param model
     * @return
     */
    @RequestMapping("viewSqlxQllxRelConfig")
    public String viewSqlxQllxRelConfig(Model model, String type, String sqlx, String id, String djlx) {
        List<BdcZdDjlx> djlxList = bdcZdGlService.getBdcZdDjlxList();
        List<BdcZdSqlx> sqlxList = bdcZdGlService.getBdcZdSqlxList();
        if (StringUtils.isNotBlank(djlx))
            sqlxList = bdcZdGlService.getBdcZdSqlxByDjlx(djlx);
        List<BdcZdQllx> qllxList = bdcZdGlService.getBdcZdQllxList();
        List<Map> bdclxList = bdcZdGlService.getBdcZdBdclxList();
        List<Map> qlxzList = bdcZdGlService.getBdcZdQlxzList(null);
        List<Map> dyfsList = bdcZdGlService.getBdcZdDyfsList();
        List<Map> zdtzmList = bdcZdGlService.getBdcZdZdtzmList();
        List<Map> dzwtzmList = bdcZdGlService.getBdcZdDzwtzmList();
        model.addAttribute("djList", djlxList);
        model.addAttribute("sqList", sqlxList);
        model.addAttribute("qlList", qllxList);
        model.addAttribute("bdcList", bdclxList);
        model.addAttribute("qlxzList", qlxzList);
        model.addAttribute("dyfsList", dyfsList);
        model.addAttribute("zdtzmList", zdtzmList);
        model.addAttribute("dzwtzmList", dzwtzmList);
        model.addAttribute("type", type);
        //登记类型和申请类型默认值
        model.addAttribute("id", id);
        if (StringUtils.isBlank(sqlx))
            sqlx = "";
        model.addAttribute("sqlx", sqlx);
        if (StringUtils.isBlank(djlx))
            djlx = "";
        model.addAttribute("djlx", djlx);
        return "value/ViewBdcSqlxQllxRel";
    }

    @RequestMapping(value = "bdcSqlxQllxRelFrame")
    public String bdcSqlxQllxRelFrame(Model model, String type, String sqlx, String id) {
        List<BdcZdDjlx> bdcZdDjlxList = bdcZdGlService.getBdcZdDjlxList();
        List<BdcZdSqlx> bdcZdSqlxList = bdcZdGlService.getBdcZdSqlxList();
        model.addAttribute("BdcZdDjlxList", bdcZdDjlxList);

        model.addAttribute("type", type);
        model.addAttribute("id", id);
        String djlx = "";
        if (StringUtils.isNotBlank(sqlx)) {
            BdcZdDjlx bdcZdDjlx = bdcZdGlService.getBdcZdDjlxBySqlx(sqlx);
            if (bdcZdDjlx != null)
                djlx = bdcZdDjlx.getDm();
            model.addAttribute("sqlx", sqlx);
            bdcZdSqlxList = bdcZdGlService.getBdcZdSqlxByDjlx(djlx);
        }
        model.addAttribute("BdcZdSqlxList", bdcZdSqlxList);
        model.addAttribute("djlx", djlx);
        return "value/bdcSqlxQllxRelFrame";
    }

    /**
     * 保存系统日志配置页面
     *
     * @param model
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "saveSqlxQllxRel")
    @BdcLog(controller = "保存申请类型和权利类型关系配置日志",parmjson = "保存申请类型和权利类型关系配置")
    public HashMap saveSqlxQllxRel(Model model, BdcSqlxQllxRel bdcSqlxQllxRel, String type) {
        HashMap map = new HashMap();
        String result = "保存成功";
        try {
            if (StringUtils.equals(type, "update")) {
                entityMapper.updateByPrimaryKeySelective(bdcSqlxQllxRel);
            } else {
                bdcSqlxQllxRel.setId(UUIDGenerator.generate());
                entityMapper.insertSelective(bdcSqlxQllxRel);
            }
        } catch (Exception e) {
            e.printStackTrace();
            result = "保存失败";
        }
        map.put("result", result);
        return map;
    }

    /**
     * 关系表配置页面
     * 根据登记类型获取申请类型
     *
     * @param model
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "getSqlxByDjlx")
    public List<BdcZdSqlx> getSqlxByDjlx(Model model, String djlx) {
        List<BdcZdSqlx> list = new ArrayList<BdcZdSqlx>();
        if (StringUtils.isNotBlank(djlx)) {
            list = bdcZdGlService.getBdcZdSqlxByDjlx(djlx);
        } else
            list = bdcZdGlService.getBdcZdSqlxList();
        return list;
    }


    /**
     * 关系表配置页面
     * 根据申请类型获其他数据
     *
     * @param model
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "getOthersBySqlx")
    public BdcSqlxQllxRel getOthersBySqlx(Model model, String sqlx) {
        BdcSqlxQllxRel bdcSqlxQllxRel = new BdcSqlxQllxRel();
        if (StringUtils.isNotBlank(sqlx)) {
            List<BdcSqlxQllxRel> list = bdcSqlxQllxRelService.getOthersBySqlx(sqlx);
            if (list != null) {
                bdcSqlxQllxRel = list.get(0);
            }
        }
        return bdcSqlxQllxRel;
    }

    @ResponseBody
    @RequestMapping(value = "delBdcSqlxQllxRel")
    @BdcLog(controller = "删除申请类型和权利类型关系配置日志",parmjson = "删除申请类型和权利类型关系配置")
    public HashMap delBdcQllxDjsyRel(String ids) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            if (StringUtils.isNotBlank(ids)) {
                if (ids.contains(",")) {
                    for (String id : ids.split(","))
                        entityMapper.deleteByPrimaryKey(BdcSqlxQllxRel.class, id);
                } else
                    entityMapper.deleteByPrimaryKey(BdcSqlxQllxRel.class, ids);
            }

        } catch (Exception e) {
            result = "删除失败！";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }

    @ResponseBody
    @RequestMapping(value = "changeYqllxDmToMc")
    public String changeYqllxDmToMc(String dm) {
        String mc = "";
        if (StringUtils.isNotBlank(dm)) {
            String[] qllxdm = dm.split(",", -1);
            for (String qllx : qllxdm) {
                BdcZdQllx bdcZdQllx = bdcZdGlService.getBdcZdQllxByDm(qllx);
                if (bdcZdQllx != null) {
                    if (StringUtils.isBlank(mc))
                        mc = bdcZdQllx.getMc();
                    else
                        mc += "," + bdcZdQllx.getMc();
                }
            }
        }
        return mc;
    }

    @ResponseBody
    @RequestMapping(value = "valite")
    public String valite(BdcSqlxQllxRel bdcSqlxQllxRel, String type) {
        String msg = "";
        Example example = new Example(BdcSqlxQllxRel.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotBlank(bdcSqlxQllxRel.getSqlxdm()))
            criteria.andEqualTo("sqlxdm", bdcSqlxQllxRel.getSqlxdm());
        List<BdcSqlxQllxRel> bdcSqlxQllxRelList = entityMapper.selectByExample(example);
        if (StringUtils.equals(type, "update")) {
            if (CollectionUtils.isNotEmpty(bdcSqlxQllxRelList) && !StringUtils.equals(bdcSqlxQllxRelList.get(0).getId(), bdcSqlxQllxRel.getId()))
                msg = "表中已存在该数据";
        } else if (CollectionUtils.isNotEmpty(bdcSqlxQllxRelList)) {
            msg = "表中已存在该数据";
        }
        return msg;
    }

    @ResponseBody
    @RequestMapping(value = "getBdcZdQllxListBySqlx")
    public List<BdcZdQllx> getBdcZdQllxListBySqlx(String sqlxdm) {
        List<BdcZdQllx> bdcZdQllxList = null;
        if (StringUtils.isNotBlank(sqlxdm)) {
            bdcZdQllxList = bdcZdGlService.getBdcZdQllxBySqlx(sqlxdm);
        }
        return bdcZdQllxList;
    }

}
