package cn.gtmap.estateplat.config.web.value;

import cn.gtmap.estateplat.config.core.log.BdcLog;
import cn.gtmap.estateplat.config.core.service.BdcRelService;
import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcZdSqlx;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/7/6.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Controller
@RequestMapping(value = "bdcSqlxYhRel")
public class BdcSqlxYhRelController extends BaseController {


    @Autowired
    Repo repository;
    @Autowired
    BdcRelService bdcRelService;
    @Autowired
    BdcZdGlService bdcZdGlService;
    @Autowired
    EntityMapper entityMapper;

    @RequestMapping(value = "")
    public String displayBdcSqlxYhRelPage(Model model) {
        List<BdcZdSqlx> bdcZdSqlxList = bdcZdGlService.getBdcZdSqlxList();
        model.addAttribute("BdcZdSqlxList", bdcZdSqlxList);
        return "value/bdcSqlxYhRel";
    }


    @ResponseBody
    @RequestMapping("/getBdcSqlxYhRelPagesJson")
    public Object getBdcSqlxYhRelPagesJson(Pageable pageable, String sqlx) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(sqlx))
            map.put("sqlx", sqlx);
        //对登记事由处理
        return repository.selectPaging("getBdcSqlxYhRelByPage", map, pageable);
    }


    @ResponseBody
    @RequestMapping(value = "saveBdcSqlxYhRel")
    @BdcLog(controller = "保存申请类型和银行关系配置日志",parmjson = "保存申请类型和银行关系配置")
    public HashMap saveBdcBdclxSqlxRel(String id, String sqlx) {
        HashMap map = new HashMap();
        String result = "保存成功";
        try {
            bdcRelService.saveOrUpdateBdcSqlxYhRel(id, sqlx);
        } catch (Exception e) {
            e.printStackTrace();
            result = "保存失败";
        }
        map.put("result", result);
        return map;
    }


    @ResponseBody
    @RequestMapping(value = "delBdcSqlxYhRel")
    @BdcLog(controller = "删除申请类型和银行关系配置日志",parmjson = "删除申请类型和银行关系配置")
    public HashMap delBdcSqlxYhRel(String ids) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            if (StringUtils.isNotBlank(ids)) {
                if (ids.contains(",")) {
                    for (String id : ids.split(","))
                        bdcRelService.delBdcSqlxYhRel(id);
                } else
                    bdcRelService.delBdcSqlxYhRel(ids);
            }

        } catch (Exception e) {
            result = "删除失败！";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }

    @ResponseBody
    @RequestMapping(value = "valite")
    public String valite(String sqlx, String valiteType, String id) {
        String msg = "";
        if (StringUtils.isNotBlank(sqlx)) {
            List<HashMap> hashMapList = bdcRelService.getBdcSqlxYhRelBySqlx(sqlx);
            if (CollectionUtils.isNotEmpty(hashMapList) && hashMapList.get(0).get("ID") != null && !StringUtils.equals(id, hashMapList.get(0).get("ID").toString())) {
                msg = "表中已存在该数据";
            }
        }
        return msg;
    }

}
