package cn.gtmap.estateplat.config.web.value;/*
 * @author <a href="mailto:gln@gtmap.cn">gln</a>
 * @version 1.0, 2017/11/21
 * @description
 */

import cn.gtmap.estateplat.config.service.BdcSqrService;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.model.server.core.BdcSqr;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;

@Controller
@RequestMapping(value = "bdcSqr", method = RequestMethod.GET)
public class BdcSqrController extends BaseController {
    @Autowired
    private BdcSqrService bdcSqrService;

    @RequestMapping(value = "")
    public String displayBdcSqrPage(Model model) {
        return "value/bdcSqr";
    }

    @ResponseBody
    @RequestMapping("/getBdcSqrPagesJson")
    public Object getBdcSqrPagesJson(Pageable pageable, String mc) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(mc)){
            map.put("mc", mc.trim());
        }
        return bdcSqrService.getBdcSqr(map ,pageable);
    }

    @ResponseBody
    @RequestMapping(value = "delBdcSqr")
    public HashMap delBdcSqr(String ids) {
        HashMap map = new HashMap();
        String result = "0";
        try {
            if (StringUtils.isNotBlank(ids)) {
                bdcSqrService.deleteBdcSqr(ids);
            }
        } catch (Exception e) {
            result = "1";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }

    @ResponseBody
    @RequestMapping(value = "valite",method = RequestMethod.GET)
    public String valite(BdcSqr bdcSqr, String valiteType) {
        String msg = "0";
        if (bdcSqr != null) {
            if (StringUtils.isNotBlank(bdcSqr.getSqrid())) {
                if (StringUtils.equals(valiteType, "update")) {
                    msg = "0";
                } else {
                 msg = bdcSqrService.valiteBdcSqr(bdcSqr);
                }
            } else {
                msg = "1";
            }
        }
        return msg;
    }

    @ResponseBody
    @RequestMapping(value = "saveBdcSqr",method = RequestMethod.POST)
    public HashMap saveBdcSqr(BdcSqr bdcSqr) {
        HashMap map = new HashMap();
        String result = "1";
        try {
            bdcSqrService.saveBdcSqr(bdcSqr, bdcSqr.getSqrid());
        } catch (Exception e) {
            e.printStackTrace();
            result = "0";
        }
        map.put("result", result);
        return map;
    }


    @RequestMapping("addSqr")
    public String addSqr (BdcSqr bdcSqr, Model model,String type){
        model.addAttribute("bdcSqr",bdcSqr);
        model.addAttribute("type",type);
        return "value/addSqr";
    }
}
