package cn.gtmap.estateplat.config.web.value;

import cn.gtmap.estateplat.config.core.log.BdcLog;
import cn.gtmap.estateplat.config.core.service.BdcRelService;
import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.config.core.service.DwdmService;
import cn.gtmap.estateplat.config.core.service.DwxxService;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcXtConfig;
import cn.gtmap.estateplat.model.server.core.BdcZdQllx;
import cn.gtmap.estateplat.model.server.core.Dwxx;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/7/7.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Controller
@RequestMapping(value = "bdcXtConfig")
public class BdcXtConfigController extends BaseController {


    @Autowired
    BdcZdGlService bdcZdGlService;
    @Autowired
    Repo repository;
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    BdcRelService bdcRelService;
    @Autowired
    DwdmService dwdmService;
    @Autowired
    DwxxService dwxxService;

    @RequestMapping(value = "")
    public String getBdcXtConfigPage(Model model, String userid) {
        List<BdcZdQllx> bdcZdQllxList = bdcZdGlService.getBdcZdQllxList();
        String userDwdm = dwdmService.getDwdmByUserid(userid);
        List<Dwxx> dwxxList = dwxxService.getDwxxList(userDwdm, 9);
        model.addAttribute("BdcZdQllxList", bdcZdQllxList);
        model.addAttribute("DwxxList", dwxxList);
        return "value/bdcXtConfig";
    }


    @ResponseBody
    @RequestMapping("/getBdcXtConfigPagesJson")
    public Object getBdcXtConfigPagesJson(Pageable pageable, String nf, String dwdm, String qllx, String djjg, String szsxqc) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(nf))
            map.put("nf", nf);
        if (StringUtils.isNotBlank(dwdm))
            map.put("dwdm", dwdm);
        if (StringUtils.isNotBlank(qllx))
            map.put("qllx", qllx);
        if (StringUtils.isNotBlank(djjg))
            map.put("djjg", djjg);
        if (StringUtils.isNotBlank(szsxqc))
            map.put("szsxqc", szsxqc);

        //对登记事由处理
        return repository.selectPaging("getBdcXtConfigByPage", map, pageable);
    }

    @ResponseBody
    @RequestMapping(value = "saveBdcXtConfig")
    @BdcLog(controller = "保存系统配置日志",parmjson = "保存系统配置")
    public HashMap saveBdcQllxDjyyRel(BdcXtConfig bdcXtConfig) {
        HashMap map = new HashMap();
        String result = "保存成功";
        try {
            if (StringUtils.isBlank(bdcXtConfig.getXtid()))
                bdcXtConfig.setXtid(UUIDGenerator.generate());
            entityMapper.saveOrUpdate(bdcXtConfig, bdcXtConfig.getXtid());
        } catch (Exception e) {
            e.printStackTrace();
            result = "保存失败";
        }
        map.put("result", result);
        return map;
    }


    @ResponseBody
    @RequestMapping(value = "delBdcXtConfig")
    @BdcLog(controller = "删除系统配置日志",parmjson = "删除系统配置")
    public HashMap delBdcQllxDjyyRel(String ids) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            if (StringUtils.isNotBlank(ids)) {
                if (ids.contains(",")) {
                    for (String id : ids.split(","))
                        entityMapper.deleteByPrimaryKey(BdcXtConfig.class, id);
                } else
                    entityMapper.deleteByPrimaryKey(BdcXtConfig.class, ids);
            }

        } catch (Exception e) {
            result = "删除失败！";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }


    @ResponseBody
    @RequestMapping(value = "valite")
    public String valite(BdcXtConfig bdcXtConfig, String valiteType) {
        String msg = "";
        List<BdcXtConfig> bdcXtConfigList = null;
        if (bdcXtConfig != null) {
            Example example = new Example(BdcXtConfig.class);
            Example.Criteria criteria = example.createCriteria();
            if (StringUtils.isNotBlank(bdcXtConfig.getNf()))
                criteria.andEqualTo("nf", bdcXtConfig.getNf());
            else
                criteria.andIsNull("nf");
            if (StringUtils.isNotBlank(bdcXtConfig.getDwdm()))
                criteria.andEqualTo("dwdm", bdcXtConfig.getDwdm());
            else
                criteria.andIsNull("dwdm");

            if (StringUtils.isNotBlank(bdcXtConfig.getQllx()))
                criteria.andEqualTo("qllx", bdcXtConfig.getQllx());
            else
                criteria.andIsNull("qllx");
            bdcXtConfigList = entityMapper.selectByExample(example);
            if (StringUtils.equals(valiteType, "update")) {
                if (CollectionUtils.isNotEmpty(bdcXtConfigList) && !StringUtils.equals(bdcXtConfig.getXtid(), bdcXtConfigList.get(0).getXtid())) {
                    msg = "表中已存在该数据";
                }
            } else if (CollectionUtils.isNotEmpty(bdcXtConfigList)) {
                msg = "表中已存在该数据";
            }
        }
        return msg;
    }

}
