package cn.gtmap.estateplat.config.web.value;

import cn.gtmap.estateplat.config.core.log.BdcLog;
import cn.gtmap.estateplat.config.core.service.*;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcXtDamlh;
import cn.gtmap.estateplat.model.server.core.BdcZdDjlx;
import cn.gtmap.estateplat.model.server.core.Dwxx;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/7/6.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Controller
@RequestMapping(value = "bdcXtDamlh")
public class BdcXtDamlhController extends BaseController {


    @Autowired
    Repo repository;
    @Autowired
    BdcRelService bdcRelService;
    @Autowired
    BdcZdGlService bdcZdGlService;
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    BdcXtDamlhService bdcXtDamlhService;
    @Autowired
    DwdmService dwdmService;
    @Autowired
    DwxxService dwxxService;

    @RequestMapping(value = "")
    public String displayBdcXtDamlhPage(Model model, String userid) {
        List<BdcZdDjlx> bdcZdDjlxList = bdcZdGlService.getBdcZdDjlxList();
        List<Map> bdcZdBdclxList = bdcZdGlService.getBdcZdBdclxList();
        String userDwdm = dwdmService.getDwdmByUserid(userid);
        List<Dwxx> dwxxList = dwxxService.getDwxxList(userDwdm, 9);
        model.addAttribute("DwxxList", dwxxList);
        model.addAttribute("BdcZdDjlxList", bdcZdDjlxList);
        model.addAttribute("BdcZdBdclxList", bdcZdBdclxList);
        return "value/bdcXtDamlh";
    }


    @ResponseBody
    @RequestMapping("/getBdcXtDamlhPagesJson")
    public Object getBdcXtDamlhPagesJson(Pageable pageable, BdcXtDamlh bdcXtDamlh) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(bdcXtDamlh.getDjlx()))
            map.put("djlx", bdcXtDamlh.getDjlx());
        if (StringUtils.isNotBlank(bdcXtDamlh.getBdclx()))
            map.put("bdclx", bdcXtDamlh.getBdclx());
        if (StringUtils.isNotBlank(bdcXtDamlh.getDwdm()))
            map.put("dwdm", bdcXtDamlh.getDwdm());
        if (StringUtils.isNotBlank(bdcXtDamlh.getMlh()))
            map.put("mlh", bdcXtDamlh.getMlh());
        //对登记事由处理
        return repository.selectPaging("getBdcXtDamlhByPage", map, pageable);
    }


    @ResponseBody
    @RequestMapping(value = "saveBdcXtDamlh")
    @BdcLog(controller = "保存档案目录号配置日志",parmjson = "保存档案目录号配置")
    public HashMap saveBdcXtDamlh(BdcXtDamlh bdcXtDamlh) {
        HashMap map = new HashMap();
        String result = "保存成功";
        try {
            if (StringUtils.isBlank(bdcXtDamlh.getId()))
                bdcXtDamlh.setId(UUIDGenerator.generate());
            entityMapper.saveOrUpdate(bdcXtDamlh, bdcXtDamlh.getId());
        } catch (Exception e) {
            e.printStackTrace();
            result = "保存失败";
        }
        map.put("result", result);
        return map;
    }


    @ResponseBody
    @RequestMapping(value = "delBdcXtDamlh")
    @BdcLog(controller = "删除档案目录号配置日志",parmjson = "删除档案目录号配置")
    public HashMap delBdcXtDamlh(String ids) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            if (StringUtils.isNotBlank(ids)) {
                if (ids.contains(",")) {
                    for (String id : ids.split(","))
                        entityMapper.deleteByPrimaryKey(BdcXtDamlh.class, id);
                } else
                    entityMapper.deleteByPrimaryKey(BdcXtDamlh.class, ids);
            }

        } catch (Exception e) {
            result = "删除失败！";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }

    @ResponseBody
    @RequestMapping(value = "valite")
    public String valite(BdcXtDamlh bdcXtDamlh, String valiteType) {
        String msg = "";
        List<BdcXtDamlh> bdcXtDamlhList = null;
        if (bdcXtDamlh != null) {
            bdcXtDamlhList = bdcXtDamlhService.getBdcXtDamlh(bdcXtDamlh);
            if (StringUtils.equals(valiteType, "update")) {
                if (CollectionUtils.isNotEmpty(bdcXtDamlhList) && !StringUtils.equals(bdcXtDamlh.getId(), bdcXtDamlhList.get(0).getId())) {
                    msg = "表中已存在该数据";
                }
            } else {
                if (CollectionUtils.isNotEmpty(bdcXtDamlhList)) {
                    msg = "表中已存在该数据";
                }
            }
        }

        return msg;
    }
}
