package cn.gtmap.estateplat.config.web.value;

import cn.gtmap.estateplat.config.core.log.BdcLog;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcZdLogController;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.net.URLDecoder;
import java.util.HashMap;

/**
 * @version 1.0, 2017/6/27.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Controller
@RequestMapping(value = "bdcXtLogConfig")
public class BdcXtLogConfigController extends BaseController {

    @Autowired
    EntityMapper entityMapper;
    @Autowired
    Repo repository;

    /**
     * 跳转拦截方法记录日志配置页面
     *
     * @param model
     * @return
     */
    @RequestMapping("")
    public String toZdLogConfig(Model model) {
        return "value/BdcXtLogConfig";
    }

    @ResponseBody
    @RequestMapping("/getBdcXtLogConfigPagesJson")
    public Object getBdcXtLogConfigPagesJson(Pageable pageable, String ffms) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isNotBlank(ffms))
            map.put("ffms", URLDecoder.decode(ffms));
        Page<HashMap> dataPaging = repository.selectPaging("getBdcXtLogConfigByPage", map, pageable);
        return dataPaging;
    }


    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 添加日志配置
     **/
    @ResponseBody
    @RequestMapping(value = "saveLogConfig")
    @BdcLog(controller = "保存日志配置日志",parmjson = "保存日志配置")
    public HashMap saveLogConfig(BdcZdLogController bdcZdLogController) {
        HashMap map = new HashMap();
        String result = "保存成功！";
        try {
            entityMapper.saveOrUpdate(bdcZdLogController, bdcZdLogController.getControllerPath());
        } catch (Exception e) {
            e.printStackTrace();
            result = "保存失败！";
        } finally {
            map.put("result", result);
        }
        return map;
    }


    /**
     * 删除系统日志配置
     *
     * @param model
     * @param ids
     * @return
     */
    @ResponseBody
    @RequestMapping("/delLogConfig")
    @BdcLog(controller = "删除日志配置日志",parmjson = "删除日志配置")
    public HashMap delLogConfig(Model model, String ids) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            String id[] = ids.split(",");
            for (int i = 0; i < id.length; i++) {
                entityMapper.deleteByPrimaryKey(BdcZdLogController.class, id[i]);
            }
        } catch (Exception e) {
            e.printStackTrace();
            result = "删除失败！";
        } finally {
            map.put("result", result);
        }
        return map;
    }

    @ResponseBody
    @RequestMapping(value = "valite")
    public String valite(BdcZdLogController bdcZdLogController, String valiteType) {
        String msg = "";
        BdcZdLogController logController = null;
        if (bdcZdLogController != null && StringUtils.isNotBlank(bdcZdLogController.getControllerPath())) {
            logController = entityMapper.selectByPrimaryKey(BdcZdLogController.class, bdcZdLogController.getControllerPath());
            if (StringUtils.equals(valiteType, "update")) {
                if (logController == null) {
                    msg = "更新不存在该方法路径数据项";
                }
            } else {
                if (logController != null) {
                    msg = "表中已存在该数据";
                }
            }
        }
        return msg;
    }
}
