package cn.gtmap.estateplat.config.web.value;

import cn.gtmap.estateplat.config.core.log.BdcLog;
import cn.gtmap.estateplat.config.core.service.BdcRelService;
import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.config.utils.PlatformUtil;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcSqlxDjzxRel;
import cn.gtmap.estateplat.model.server.core.BdcXtOpinion;
import cn.gtmap.estateplat.model.server.core.BdcZdDjzx;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/6/27.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Controller
@RequestMapping(value = "/bdcXtOpinion")
public class BdcXtOpinionController extends BaseController {

    @Autowired
    PlatformUtil platformUtil;
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    Repo repository;
    @Autowired
    BdcZdGlService bdcZdGlService;
    @Autowired
    BdcRelService bdcRelService;

    private String userid;

    public String getUserid() {
        return userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    /**
     * sc 默认意见配置入口
     */
    @RequestMapping("")
    public String toOpinionConfig(Model model, String userid) {
        if (StringUtils.isBlank(userid))
            userid = "0";
        setUserid(userid);
        List<PfWorkFlowDefineVo> workFlowList = PlatformUtil.getWorkFlowDefineService().getWorkFlowDefineList();
        model.addAttribute("workFlowList", workFlowList);
        List<PfUserVo> pfUserVoList = sysUserService.getAllUsers();
        model.addAttribute("pfUserVoList", pfUserVoList);
        List<BdcZdDjzx> bdcZdDjzxList = bdcZdGlService.getBdcZdDjzxList();
        model.addAttribute("BdcZdDjzxList", bdcZdDjzxList);
        return "value/bdcXtOpinion";
    }

    //默认意见台帐
    @ResponseBody
    @RequestMapping("/getOpinionPagesJson")
    public Object getOpinionFieldPagesJson(Pageable pageable, BdcXtOpinion bdcXtOpinion) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(bdcXtOpinion.getWorkflowid()))
            map.put("workflowid", bdcXtOpinion.getWorkflowid());
        if (StringUtils.isNotBlank(bdcXtOpinion.getActivitytype()))
            map.put("activitytype", bdcXtOpinion.getActivitytype());
        if (StringUtils.isNotBlank(bdcXtOpinion.getDjzxdm()))
            map.put("djzxdm", bdcXtOpinion.getDjzxdm());
        return repository.selectPaging("getOpinionByPage", bdcXtOpinion, pageable);
    }

    /**
     * 保存必填字段表格配置页面
     *
     * @param model
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "saveOpinion")
    @BdcLog(controller = "保存默认意见配置日志",parmjson = "保存默认意见配置")
    public HashMap saveOpinion(Model model, BdcXtOpinion bdcXtOpinion) {
        HashMap map = new HashMap();
        String result = "保存成功";
        try {
            if (StringUtils.isNotBlank(bdcXtOpinion.getOpinid())) {
                if (StringUtils.isBlank(bdcXtOpinion.getUserid()))
                    bdcXtOpinion.setUserid(getUserid());
                entityMapper.updateByPrimaryKeySelective(bdcXtOpinion);
            } else {
                bdcXtOpinion.setOpinid(UUIDGenerator.generate18());
                if (StringUtils.isBlank(bdcXtOpinion.getUserid()))
                    bdcXtOpinion.setUserid(getUserid());
                entityMapper.insertSelective(bdcXtOpinion);
            }
        } catch (Exception e) {
            e.printStackTrace();
            result = "保存失败";
        }
        map.put("result", result);
        return map;
    }

    /**
     * 删除必填字段配置
     *
     * @param model
     * @param ids
     * @return
     */
    @ResponseBody
    @RequestMapping("/delOpinion")
    @BdcLog(controller = "删除默认意见配置日志",parmjson = "删除默认意见配置")
    public HashMap delOpinion(Model model, String ids) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            String id[] = ids.split(",");
            for (int i = 0; i < id.length; i++) {
                entityMapper.deleteByPrimaryKey(BdcXtOpinion.class, id[i]);
            }
        } catch (Exception e) {
            result = "删除失败！";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取登记子项
     **/
    @ResponseBody
    @RequestMapping(value = "getDjzxDmByWdid")
    public List<BdcZdDjzx> getDjzxDmByWdid(String wdid) {
        List<BdcZdDjzx> bdcZdDjzxList = null;
        if (StringUtils.isNotBlank(wdid)) {
            String sqlxdm = bdcZdGlService.getSqlxDmByWdid(wdid);
            if (StringUtils.isNotBlank(sqlxdm)) {
                List<BdcSqlxDjzxRel> bdcSqlxDjzxRelList = bdcRelService.getDjzxDmBySqlxDm(sqlxdm);
                if (CollectionUtils.isNotEmpty(bdcSqlxDjzxRelList)) {
                    bdcZdDjzxList = new ArrayList<BdcZdDjzx>();
                    for (BdcSqlxDjzxRel bdcSqlxDjzxRel : bdcSqlxDjzxRelList) {
                        BdcZdDjzx bdcZdDjzx1 = bdcZdGlService.getBdcZdDjzxByDjzxdm(bdcSqlxDjzxRel.getDjzxdm());
                        if (bdcZdDjzx1 != null) {
                            BdcZdDjzx bdcZdDjzx = new BdcZdDjzx();
                            bdcZdDjzx.setDm(bdcSqlxDjzxRel.getDjzxdm());

                            bdcZdDjzx.setMc(bdcZdDjzx1.getMc());
                            bdcZdDjzxList.add(bdcZdDjzx);
                        }
                    }
                }
            }
        }
        return bdcZdDjzxList;
    }

    @ResponseBody
    @RequestMapping(value = "valite")
    public String valite(BdcXtOpinion bdcXtOpinion, String valiteType) {
        String msg = "";
        Example example = new Example(BdcXtOpinion.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotBlank(bdcXtOpinion.getWorkflowid()))
            criteria.andEqualTo("workflowid", bdcXtOpinion.getWorkflowid());
        if (StringUtils.isNotBlank(bdcXtOpinion.getUserid()))
            criteria.andEqualTo("userid", bdcXtOpinion.getUserid());
        else
            criteria.andIsNull("userid");
        if (StringUtils.isNotBlank(bdcXtOpinion.getActivitytype()))
            criteria.andEqualTo("activitytype", bdcXtOpinion.getActivitytype());
        else
            criteria.andIsNull("activitytype");
        if (StringUtils.isNotBlank(bdcXtOpinion.getIsrightclick()))
            criteria.andEqualTo("isrightclick", bdcXtOpinion.getIsrightclick());
        else
            criteria.andIsNull("isrightclick");
        if (StringUtils.isNotBlank(bdcXtOpinion.getDjzxdm()))
            criteria.andEqualTo("djzxdm", bdcXtOpinion.getDjzxdm());
        else
            criteria.andIsNull("djzxdm");
        if (StringUtils.isNotBlank(bdcXtOpinion.getIsuse()))
            criteria.andEqualTo("isuse", bdcXtOpinion.getIsuse());
        else
            criteria.andIsNull("isuse");
        List<BdcXtOpinion> bdcXtOpinionList = entityMapper.selectByExample(example);
        if (StringUtils.equals(valiteType, "update")) {
            if (CollectionUtils.isNotEmpty(bdcXtOpinionList) && !StringUtils.equals(bdcXtOpinionList.get(0).getOpinid(), bdcXtOpinion.getOpinid()))
                msg = "表中已存在该数据";
        } else if (CollectionUtils.isNotEmpty(bdcXtOpinionList)) {
            msg = "表中已存在该数据";
        }
        return msg;
    }
}
