package cn.gtmap.estateplat.config.web.value;

import cn.gtmap.estateplat.config.core.log.BdcLog;
import cn.gtmap.estateplat.config.core.service.BdcRelService;
import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcXtSfxm;
import cn.gtmap.estateplat.model.server.core.BdcZdSqlx;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/7/7.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Controller
@RequestMapping(value = "BdcXtSfxm")
public class BdcXtSfxmController extends BaseController {

    @Autowired
    BdcZdGlService bdcZdGlService;
    @Autowired
    Repo repository;
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    BdcRelService bdcRelService;

    @RequestMapping(value = "")
    public String getBdcXtSfxmPage(Model model) {
        List<BdcZdSqlx> bdcZdSqlxList = bdcZdGlService.getBdcZdSqlxList();
        model.addAttribute("BdcZdSqlxList", bdcZdSqlxList);
        return "value/bdcXtSfxm";
    }


    @ResponseBody
    @RequestMapping("/getBdcXtSfxmPagesJson")
    public Object getBankFieldPagesJson(Pageable pageable, String sqlx, String sfxmmc, String sfxmbz, String je, String qlrlx) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(sqlx))
            map.put("sqlx", sqlx);
        if (StringUtils.isNotBlank(sfxmmc))
            map.put("sfxmmc", sfxmmc);
        if (StringUtils.isNotBlank(sfxmbz))
            map.put("sfxmbz", sfxmbz);
        if (StringUtils.isNotBlank(je))
            map.put("je", je);
        if (StringUtils.isNotBlank(qlrlx))
            map.put("qlrlx", qlrlx);
        //对登记事由处理
        return repository.selectPaging("getBdcXtSfxmByPage", map, pageable);
    }

    @ResponseBody
    @RequestMapping(value = "saveBdcXtSfxm")
    @BdcLog(controller = "保存收费项目配置日志",parmjson = "保存收费项目配置")
    public HashMap saveBdcQllxDjyyRel(BdcXtSfxm BdcXtSfxm) {
        HashMap map = new HashMap();
        String result = "保存成功";
        try {
            if (StringUtils.isBlank(BdcXtSfxm.getSfxmid()))
                BdcXtSfxm.setSfxmid(UUIDGenerator.generate());
            entityMapper.saveOrUpdate(BdcXtSfxm, BdcXtSfxm.getSfxmid());
        } catch (Exception e) {
            e.printStackTrace();
            result = "保存失败";
        }
        map.put("result", result);
        return map;
    }


    @ResponseBody
    @RequestMapping(value = "delBdcXtSfxm")
    @BdcLog(controller = "删除收费项目配置日志",parmjson = "删除收费项目配置")
    public HashMap delBdcQllxDjyyRel(String ids) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            if (StringUtils.isNotBlank(ids)) {
                if (ids.contains(",")) {
                    for (String id : ids.split(","))
                        entityMapper.deleteByPrimaryKey(BdcXtSfxm.class, id);
                } else
                    entityMapper.deleteByPrimaryKey(BdcXtSfxm.class, ids);
            }

        } catch (Exception e) {
            result = "删除失败！";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }

    @ResponseBody
    @RequestMapping(value = "valite")
    public String valite(BdcXtSfxm bdcXtSfxm, String valiteType) {
        String msg = "";
        if (bdcXtSfxm != null) {
            boolean hasdata = false;
            if (StringUtils.equals(valiteType, "update")) {
                String[] fileds = {"sqlxdm", "sfxmmc", "sfxmbz", "qlrlx", "dw", "je", "mrsl", "sfmrsz"};
                hasdata = bdcRelService.getDataByClass(bdcXtSfxm, fileds);
            } else {
                String[] fileds = {"sqlxdm", "sfxmmc", "sfxmbz", "qlrlx"};
                hasdata = bdcRelService.getDataByClass(bdcXtSfxm, fileds);
            }
            if (hasdata) {
                msg = "数据库存在数据";
            }
        }
        return msg;
    }
}
